/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.filter;

import ca.mcgill.mcb.pcingola.filter.Filter;
import ca.mcgill.mcb.pcingola.interval.SeqChange;

public class SeqChangeFilter
implements Filter<SeqChange> {
    Integer minQuality;
    Integer maxQuality;
    Integer minCoverage;
    Integer maxCoverage;
    Boolean heterozygous;
    SeqChange.ChangeType changeType;

    public SeqChangeFilter() {
        this.maxQuality = null;
        this.minQuality = null;
        this.maxCoverage = null;
        this.minCoverage = null;
        this.heterozygous = null;
        this.changeType = null;
    }

    public SeqChangeFilter(Integer minQuality, Integer maxQuality, Integer minCoverage, Integer maxCoverage) {
        this.minCoverage = minCoverage;
        this.maxCoverage = maxCoverage;
        this.minQuality = minQuality;
        this.maxQuality = maxQuality;
    }

    @Override
    public boolean anythingSet() {
        return this.minQuality != null || this.maxQuality != null || this.minCoverage != null || this.maxCoverage != null || this.heterozygous != null || this.changeType != null;
    }

    @Override
    public boolean filter(SeqChange seqChange) {
        if (this.minQuality != null && seqChange.getQuality() < (double)this.minQuality.intValue()) {
            return false;
        }
        if (this.maxQuality != null && seqChange.getQuality() > (double)this.maxQuality.intValue()) {
            return false;
        }
        if (this.minCoverage != null && seqChange.getCoverage() < this.minCoverage) {
            return false;
        }
        if (this.maxCoverage != null && seqChange.getCoverage() > this.maxCoverage) {
            return false;
        }
        if (this.heterozygous != null && seqChange.isHeterozygous() != this.heterozygous.booleanValue()) {
            return false;
        }
        return this.changeType == null || seqChange.getChangeType() == this.changeType;
    }

    public SeqChange.ChangeType getChangeType() {
        return this.changeType;
    }

    public void setChangeType(SeqChange.ChangeType changeType) {
        this.changeType = changeType;
    }

    public void setHeterozygous(Boolean heterozygous) {
        this.heterozygous = heterozygous;
    }

    public void setMaxCoverage(Integer maxCoverage) {
        this.maxCoverage = maxCoverage;
    }

    public void setMaxQuality(Integer maxQuality) {
        this.maxQuality = maxQuality;
    }

    public void setMinCoverage(Integer minCoverage) {
        this.minCoverage = minCoverage;
    }

    public void setMinQuality(Integer minQuality) {
        this.minQuality = minQuality;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.minQuality != null) {
            sb.append((sb.length() > 0 ? " AND " : "") + "( Quality >= " + this.minQuality + ")");
        }
        if (this.maxQuality != null) {
            sb.append((sb.length() > 0 ? " AND " : "") + "( Quality < " + this.maxQuality + ")");
        }
        if (this.minCoverage != null) {
            sb.append((sb.length() > 0 ? " AND " : "") + "( Coverage >= " + this.minCoverage + ")");
        }
        if (this.maxCoverage != null) {
            sb.append((sb.length() > 0 ? " AND " : "") + "( Coverage >= " + this.maxCoverage + ")");
        }
        if (this.heterozygous != null) {
            sb.append((sb.length() > 0 ? " AND " : "") + "( Heterozygous = true ) ");
        }
        if (this.changeType != null) {
            sb.append((sb.length() > 0 ? " AND " : "") + "( ChangeType >= " + (Object)((Object)this.changeType) + ")");
        }
        return sb.toString();
    }
}

