/*
 * Decompiled with CFR 0.152.
 */
package flanagan.physchem;

import flanagan.analysis.Regression;
import flanagan.analysis.RegressionFunction;
import flanagan.analysis.Stat;
import flanagan.interpolation.CubicInterpolation;
import flanagan.interpolation.CubicSpline;
import flanagan.interpolation.LinearInterpolation;
import flanagan.io.Db;
import flanagan.io.FileChooser;
import flanagan.io.FileInput;
import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.physchem.Amersham;
import flanagan.physchem.ImmunoChemistry;
import flanagan.plot.Plot;
import flanagan.plot.PlotGraph;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class ImmunoAssay
extends Regression {
    private double[] analyteConcns = null;
    private double[] log10AnalyteConcns = null;
    private double[] logeAnalyteConcns = null;
    private boolean analyteEntered = false;
    private int analyteConcnFlag = 0;
    private int nAnalyteConcns = 0;
    private double[] responses = null;
    private double[] log10Responses = null;
    private double[] logeResponses = null;
    private boolean responsesEntered = false;
    private int nResponses = 0;
    private int responsesFlag = 0;
    private boolean responsesPlot = true;
    private double responsesMax = 0.0;
    private double responsesMin = 0.0;
    private double responsesRange = 0.0;
    private double[] weights = null;
    private boolean weightsEntered = false;
    private int nWeights = 0;
    private double weightsMean = 0.0;
    private double weightsSD = 0.0;
    private int weightOption = 0;
    private boolean setDataOneDone = false;
    private double[] interpolationConcns = null;
    private double[] calculatedResponses = null;
    private String[] propagatedErrors = null;
    private int nInterp = 1000;
    private CubicSpline interp = null;
    private LinearInterpolation linterp = null;
    private CubicSpline errorp = null;
    private CubicSpline cs = null;
    private CubicInterpolation ci = null;
    private LinearInterpolation li = null;
    private String titleZero = null;
    private String titleOne = null;
    private String filename = "ImmunoAssayOutput.txt";
    private String dataFilename = null;
    private boolean dataRead = false;
    private double interpAnalyteStart = 0.0;
    private double interpAnalyteEnd = 0.0;
    private double interpResponseStart = 0.0;
    private double interpResponseEnd = 0.0;
    private int interpStartIndex = 0;
    private int interpEndIndex = 0;
    private boolean ambigCheck = false;
    private boolean curveDirection = true;
    private double workingResponseMin = 0.0;
    private double workingResponseMax = 0.0;
    private double minimumAerror = 0.0;
    private double maximumAerror = 0.0;
    private double meanAerror = 0.0;
    private double sdAerror = 0.0;
    private int nTurningPoints = 0;
    private int[] turnIndices = null;
    private int nWorking = 0;
    private int polyDegree = 0;
    private int bestPolyDegree = 0;
    private int polyNterms = 0;
    private String compFilename = "ImmunoAssayComparison.txt";
    private int resultFlag = -1;
    private double significance = 0.05;
    private double sampleResponse = 0.0;
    private double sampleConcn = 0.0;
    private double sampleError = 0.0;
    private int nPlot = 0;
    private int plotOptions = 0;
    private boolean supressPlot = false;
    private int nMethods = 15;
    private String[] methodNames = new String[this.nMethods];
    private int[] methodIndices = new int[this.nMethods];
    private int methodUsed = 8;
    private boolean sampleErrorFlag = true;
    private boolean amershamFlag1 = true;
    private double bottom = 0.0;
    private double top = 0.0;
    private boolean compWindow = false;
    private String[] outliers = null;
    private double residualsMean = 0.0;
    private double residualsSD = 0.0;
    private double confidenceLevel = 0.95;
    private double[] critSize = new double[]{3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 12.0, 14.0, 15.0, 16.0, 18.0, 20.0, 30.0, 40.0, 50.0, 60.0, 100.0, 120.0};
    private double[] critValuesOne = new double[]{1.15, 1.49, 1.75, 1.94, 2.1, 2.22, 2.32, 2.41, 2.55, 2.66, 2.71, 2.75, 2.82, 2.88, 3.1, 3.24, 3.34, 3.41, 3.6, 3.66};
    private double[] critValuesFive = new double[]{1.15, 1.46, 1.67, 1.82, 1.94, 2.03, 2.11, 2.18, 2.29, 2.37, 2.41, 2.44, 2.5, 2.56, 2.74, 2.87, 2.96, 3.03, 3.21, 3.27};
    private CubicSpline critValues = null;
    private double anscombeC = 0.0;
    private boolean outlierFlag = false;
    private boolean degSet = false;
    private boolean nTermsSet = false;
    private boolean fourBotTopSet = false;
    private boolean fiveBotTopSet = false;

    public ImmunoAssay() {
        this.titleZero = "Program ImmunoAssay";
        this.supressErrorMessages = true;
        this.methodList();
    }

    public ImmunoAssay(String title) {
        this.titleZero = "Program ImmunoAssay: " + title;
        this.supressErrorMessages = true;
        this.methodList();
    }

    public ImmunoAssay(double[] analytes, double[] responses) {
        this.titleZero = "Program ImmunoAssay";
        this.nAnalyteConcns = analytes.length;
        this.analyteConcns = Conv.copy(analytes);
        this.analyteConcnFlag = 0;
        this.analyteEntered = true;
        this.nResponses = responses.length;
        this.responses = Conv.copy(responses);
        this.responsesFlag = 0;
        this.responsesEntered = true;
        this.supressErrorMessages = true;
        this.methodList();
    }

    public ImmunoAssay(double[] analytes, double[] responses, double[] weights) {
        this.titleZero = "Program ImmunoAssay";
        this.nAnalyteConcns = analytes.length;
        this.analyteConcns = Conv.copy(analytes);
        this.analyteConcnFlag = 0;
        this.analyteEntered = true;
        this.nResponses = responses.length;
        this.responses = Conv.copy(responses);
        this.responsesFlag = 0;
        this.responsesEntered = true;
        this.nWeights = weights.length;
        this.weights = this.checkWeights(Conv.copy(weights));
        this.weightsEntered = true;
        this.supressErrorMessages = true;
        this.methodList();
    }

    public ImmunoAssay(double[] analytes, double[] responses, String title) {
        this.titleZero = "Program ImmunoAssay: " + title;
        this.nAnalyteConcns = analytes.length;
        this.analyteConcns = Conv.copy(analytes);
        this.analyteConcnFlag = 0;
        this.analyteEntered = true;
        this.nResponses = responses.length;
        this.responses = Conv.copy(responses);
        this.responsesFlag = 0;
        this.responsesEntered = true;
        this.supressErrorMessages = true;
        this.methodList();
    }

    public ImmunoAssay(double[] analytes, double[] responses, double[] weights, String title) {
        this.titleZero = "Program ImmunoAssay: " + title;
        this.nAnalyteConcns = analytes.length;
        this.analyteConcns = Conv.copy(analytes);
        this.analyteEntered = true;
        this.analyteConcnFlag = 0;
        this.nResponses = responses.length;
        this.responses = Conv.copy(responses);
        this.responsesFlag = 0;
        this.responsesEntered = true;
        this.nWeights = weights.length;
        this.weights = this.checkWeights(Conv.copy(weights));
        this.weightsEntered = true;
        this.supressErrorMessages = true;
        this.methodList();
    }

    private void methodList() {
        this.methodNames[0] = "CubicSpline";
        this.methodIndices[0] = 0;
        this.methodNames[1] = "Five parameter logistic function";
        this.methodIndices[1] = 13;
        this.methodNames[2] = "Five parameter logistic function (top and bottom fixed)";
        this.methodIndices[2] = 6;
        this.methodNames[3] = "Four parameter logistic function";
        this.methodIndices[3] = 5;
        this.methodNames[4] = "Four parameter logistic function (top and bottom fixed)";
        this.methodIndices[4] = 7;
        this.methodNames[5] = "Best fit polynomial";
        this.methodIndices[5] = 8;
        this.methodNames[6] = "Polynomial of user supplied degree ";
        this.methodIndices[6] = 9;
        this.methodNames[7] = "Non-integer polynomial";
        this.methodIndices[7] = 3;
        this.methodNames[8] = "Sigmoid threshold function";
        this.methodIndices[8] = 1;
        this.methodNames[9] = "Sips sigmoid function";
        this.methodIndices[9] = 10;
        this.methodNames[10] = "Shifted rectangular hyperbola";
        this.methodIndices[10] = 11;
        this.methodNames[11] = "Rectangular hyperbola";
        this.methodIndices[11] = 12;
        this.methodNames[12] = "Amersham equation";
        this.methodIndices[12] = 4;
        this.methodNames[13] = "Cubic interpolation";
        this.methodIndices[13] = 2;
        this.methodNames[14] = "Linear interpolation";
        this.methodIndices[14] = 14;
    }

    public void enterAnalyteConcns(double[] concn) {
        this.setDataOneDone = false;
        this.nAnalyteConcns = concn.length;
        this.analyteConcns = Conv.copy(concn);
        this.analyteConcnFlag = 0;
        this.analyteEntered = true;
    }

    public void enterAnalyteConcnsAsLog10(double[] logconcn) {
        this.setDataOneDone = false;
        this.nAnalyteConcns = logconcn.length;
        this.log10AnalyteConcns = Conv.copy(logconcn);
        this.analyteConcns = this.antiLog10(logconcn);
        this.analyteConcnFlag = 1;
        this.analyteEntered = true;
    }

    public void enterAnalyteConcnsAsLogE(double[] logconcn) {
        this.setDataOneDone = false;
        this.nAnalyteConcns = logconcn.length;
        this.logeAnalyteConcns = Conv.copy(logconcn);
        this.analyteConcns = this.antiLoge(logconcn);
        this.analyteConcnFlag = 2;
        this.analyteEntered = true;
    }

    public void enterResponses(double[] responses) {
        this.setDataOneDone = false;
        this.nResponses = responses.length;
        this.responses = Conv.copy(responses);
        this.responsesFlag = 0;
        this.responsesEntered = true;
    }

    public void enterResponsesAsLog10(double[] responses) {
        this.setDataOneDone = false;
        this.nResponses = responses.length;
        this.log10Responses = Conv.copy(responses);
        this.responses = this.antiLog10(responses);
        this.responsesFlag = 1;
        this.responsesEntered = true;
    }

    public void enterResponsesAsLogE(double[] responses) {
        this.setDataOneDone = false;
        this.nResponses = responses.length;
        this.logeResponses = Conv.copy(responses);
        this.responses = this.antiLoge(responses);
        this.responsesFlag = 2;
        this.responsesEntered = true;
    }

    public void enterWeights(double[] weights) {
        this.setDataOneDone = false;
        this.nWeights = weights.length;
        this.weights = this.checkWeights(Conv.copy(weights));
        this.weightsEntered = true;
    }

    public void enterWeightsAslog10(double[] weights) {
        this.setDataOneDone = false;
        this.nWeights = weights.length;
        this.weights = this.checkWeights(Conv.copy(weights));
        this.weights = this.antiLog10(this.weights);
        this.weightsEntered = true;
    }

    public void enterWeightsAslogE(double[] weights) {
        this.setDataOneDone = false;
        this.nWeights = weights.length;
        this.weights = this.antiLoge(this.checkWeights(Conv.copy(weights)));
        this.weightsEntered = true;
    }

    public void enterMultiplicativeWeights(double[] weights) {
        this.setDataOneDone = false;
        this.nWeights = weights.length;
        this.weights = Conv.copy(this.checkWeights(Conv.copy(weights)));
        for (int i = 0; i < this.nWeights; ++i) {
            this.weights[i] = 1.0 / Math.abs(this.weights[i]);
        }
        this.weightsEntered = true;
    }

    public void enterMultiplicativeWeightsAsLog10(double[] weights) {
        this.setDataOneDone = false;
        this.nWeights = weights.length;
        this.weights = this.antiLog10(this.checkWeights(Conv.copy(weights)));
        for (int i = 0; i < this.nWeights; ++i) {
            this.weights[i] = 1.0 / Math.abs(this.weights[i]);
        }
        this.weightsEntered = true;
    }

    public void enterMultiplicativeWeightsAsLogE(double[] weights) {
        this.setDataOneDone = false;
        this.nWeights = weights.length;
        this.weights = this.antiLoge(this.checkWeights(Conv.copy(weights)));
        for (int i = 0; i < this.nWeights; ++i) {
            this.weights[i] = 1.0 / Math.abs(this.weights[i]);
        }
        this.weightsEntered = true;
    }

    public void setWeightsAsResponses() {
        this.weightsEntered = false;
        this.weightOption = 1;
        if (this.nResponses > 0) {
            this.weights = new double[this.nResponses];
            for (int i = 0; i < this.nResponses; ++i) {
                this.weights[i] = Math.abs(this.responses[i]);
                this.weightsEntered = true;
            }
        }
    }

    public void setWeightsAsSqrtResponses() {
        this.weightsEntered = false;
        this.weightOption = 2;
        if (this.nResponses > 0) {
            this.weights = new double[this.nResponses];
            for (int i = 0; i < this.nResponses; ++i) {
                this.weights[i] = Math.sqrt(Math.abs(this.responses[i]));
                this.weightsEntered = true;
            }
        }
    }

    public void enterTitle(String title) {
        this.titleZero = title;
    }

    public void readFromFile() {
        this.setDataOneDone = false;
        FileChooser fin = new FileChooser();
        this.dataFilename = fin.selectFile();
        this.read(fin);
    }

    public void readFromFile(String filename) {
        this.setDataOneDone = false;
        this.dataFilename = filename;
        FileInput fin = new FileInput(filename);
        this.read(fin);
    }

    private int separatorPosition(String line) {
        int pos = (line = line.trim()).indexOf(58);
        if (pos == -1) {
            pos = line.indexOf(59);
        }
        if (pos == -1) {
            pos = line.indexOf(44);
        }
        if (pos == -1) {
            pos = line.indexOf(9);
        }
        if (pos == -1) {
            line.indexOf(32);
        }
        return pos;
    }

    private void read(FileInput fin) {
        this.nAnalyteConcns = fin.numberOfLines() - 1;
        this.titleZero = fin.readLine();
        this.nResponses = this.nAnalyteConcns;
        this.analyteConcns = new double[this.nAnalyteConcns];
        this.responses = new double[this.nAnalyteConcns];
        this.weights = new double[this.nAnalyteConcns];
        int weightCheck = 0;
        String line = null;
        String word = null;
        int wL = 0;
        int pos1 = -1;
        int pos2 = -1;
        int pos3 = -1;
        for (int i = 0; i < this.nAnalyteConcns; ++i) {
            line = fin.readLine().trim();
            pos1 = this.separatorPosition(line);
            if (pos1 == -1) {
                throw new IllegalArgumentException("Input file line " + (i + 1) + ": analyte concentration and response value required for all data points");
            }
            word = line.substring(0, pos1);
            this.analyteConcns[i] = Double.parseDouble(word);
            wL = (line = line.substring(pos1 + 1).trim()).length();
            if (wL < 1) {
                throw new IllegalArgumentException("Input file line " + (i + 1) + ": response value required for all data points");
            }
            pos2 = this.separatorPosition(line);
            word = pos2 == -1 ? line : line.substring(0, pos2);
            this.responses[i] = Double.parseDouble(word);
            if (pos2 == -1 || (wL = (line = line.substring(pos2 + 1).trim()).length()) <= 0) continue;
            pos3 = this.separatorPosition(line);
            word = pos3 == -1 ? line.trim() : line.substring(0, pos3).trim();
            this.weights[i] = Double.parseDouble(word);
            if (this.weights[i] != 1.0) continue;
            ++weightCheck;
        }
        this.analyteConcnFlag = 0;
        this.analyteEntered = true;
        this.responsesEntered = true;
        if (weightCheck != this.nAnalyteConcns) {
            this.nWeights = this.nAnalyteConcns;
            this.weights = this.checkWeights(Conv.copy(this.weights));
            this.weightsEntered = true;
        }
        this.dataRead = true;
    }

    private double[] checkWeights(double[] weights) {
        int i;
        int nZeros = 0;
        for (i = 0; i < this.nWeights; ++i) {
            weights[i] = Math.abs(weights[i]);
            if (weights[i] != 0.0) continue;
            ++nZeros;
        }
        if (nZeros == this.nWeights) {
            for (i = 0; i < this.nWeights; ++i) {
                weights[i] = 1.0;
            }
        }
        Stat stat = new Stat(weights);
        this.weightsMean = stat.mean();
        this.weightsSD = stat.standardDeviation();
        for (int i2 = 0; i2 < this.nWeights; ++i2) {
            if (weights[i2] != 0.0) continue;
            weights[i2] = this.weightsMean / 100.0;
            System.out.println("Weight at point " + i2 + " is zero; replaced by a value " + this.weightsMean / 100.0);
        }
        return weights;
    }

    public double[] getAnalyteConcns() {
        return this.analyteConcns;
    }

    public double[] getResponses() {
        return this.responses;
    }

    public double[] getWeights() {
        if (!this.weightsEntered && this.weightOption > 0 && this.nResponses > 0) {
            switch (this.weightOption) {
                case 1: {
                    for (int i = 0; i < this.nResponses; ++i) {
                        this.weights[i] = Math.abs(this.responses[i]);
                    }
                    this.weightsEntered = true;
                    break;
                }
                case 2: {
                    for (int i = 0; i < this.nResponses; ++i) {
                        this.weights[i] = Math.sqrt(Math.abs(this.responses[i]));
                    }
                    this.weightsEntered = true;
                }
            }
        }
        return this.weights;
    }

    public String getTitle() {
        return this.titleZero;
    }

    public void cubicSpline() {
        if (this.nAnalyteConcns < 3) {
            throw new IllegalArgumentException("Method cubicSpline requres at least 3 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 0;
        this.sampleErrorFlag = false;
        this.titleOne = "Cubic spline ";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        this.cs = new CubicSpline(this.analyteConcns, this.responses);
        for (int i = 0; i < this.nInterp; ++i) {
            this.calculatedResponses[i] = this.cs.interpolate(this.interpolationConcns[i]);
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void cubicInterpolation() {
        if (this.nAnalyteConcns < 2) {
            throw new IllegalArgumentException("Method cubicInterpolation requres at least 2 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 1;
        this.sampleErrorFlag = false;
        this.titleOne = "Cubic interpolation ";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        this.ci = new CubicInterpolation(this.analyteConcns, this.responses, 0);
        for (int i = 0; i < this.nInterp; ++i) {
            this.calculatedResponses[i] = this.ci.interpolate(this.interpolationConcns[i]);
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void linearInterpolation() {
        if (this.nAnalyteConcns < 2) {
            throw new IllegalArgumentException("Method cubicInterpolation requres at least 2 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 14;
        this.sampleErrorFlag = false;
        this.titleOne = "Linear interpolation ";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        this.li = new LinearInterpolation(this.analyteConcns, this.responses);
        for (int i = 0; i < this.nInterp; ++i) {
            this.calculatedResponses[i] = this.li.interpolate(this.interpolationConcns[i]);
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void polynomialFit(int n) {
        if (this.nAnalyteConcns < n + 2) {
            throw new IllegalArgumentException("Method polynomialFit(" + n + ") requres at least " + (n + 2) + " data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 2;
        this.sampleErrorFlag = true;
        this.degSet = true;
        this.polyDegree = n;
        this.titleOne = "Polynomial fitting: r = c[0] + c[1].a +  c[1].a^2 + ... + c[n].a^n; degree (n) = " + n;
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        super.polynomial(n);
        for (int i = 0; i < this.nInterp; ++i) {
            this.calculatedResponses[i] = 0.0;
            for (int j = 0; j <= n; ++j) {
                int n2 = i;
                this.calculatedResponses[n2] = this.calculatedResponses[n2] + this.best[j] * Math.pow(this.interpolationConcns[i], j);
            }
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public int bestPolynomialFit() {
        this.methodUsed = 3;
        this.sampleErrorFlag = true;
        this.titleOne = "Best polynomial fitting: r = c[0] + c[1].a +  c[1].a^2 + ... + c[n].a^n; best fit degree (n) = ";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        ArrayList<Object> al = super.bestPolynomial();
        this.bestPolyDegree = (Integer)al.get(0);
        this.titleOne = this.titleOne + " " + this.bestPolyDegree;
        for (int i = 0; i < this.nInterp; ++i) {
            this.calculatedResponses[i] = 0.0;
            for (int j = 0; j <= this.bestPolyDegree; ++j) {
                int n = i;
                this.calculatedResponses[n] = this.calculatedResponses[n] + this.best[j] * Math.pow(this.interpolationConcns[i], j);
            }
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
        return this.bestPolynomialDegree;
    }

    public void nonIntegerPolynomialFit(int polyNterms) {
        if (this.nAnalyteConcns < polyNterms + 1) {
            throw new IllegalArgumentException("Method nonIntegerPolynomial requres at least " + (polyNterms + 1) + " data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 4;
        this.polyNterms = polyNterms;
        this.nTermsSet = true;
        this.sampleErrorFlag = true;
        this.titleOne = "Non-integer polynomial fitting: r = c[0] + c[1].a^c[n] + c[2].a^c[n+1] + ... + c[n].a^c[2n-1]";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        super.nonIntegerPolynomial(polyNterms);
        for (int i = 0; i < this.nInterp; ++i) {
            this.calculatedResponses[i] = this.best[0];
            for (int j = 1; j < this.polyNterms; ++j) {
                int n = i;
                this.calculatedResponses[n] = this.calculatedResponses[n] + this.best[j] * Math.pow(this.interpolationConcns[i], this.best[polyNterms + j - 1]);
            }
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void nonIntegerPolynomialFit() {
        this.nonIntegerPolynomialFit(3);
    }

    public void sigmoidThresholdFit() {
        if (this.nAnalyteConcns < 4) {
            throw new IllegalArgumentException("Method sigmoidThresholdFit requres at least 4 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 5;
        this.sampleErrorFlag = true;
        this.titleOne = "Sigmoid threshold fitting: r = A/(1 + exp(-alpha(a - theta)))";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        super.sigmoidThreshold();
        for (int i = 0; i < this.nInterp; ++i) {
            this.calculatedResponses[i] = this.best[2] / (1.0 + Math.exp(-this.best[0] * (this.interpolationConcns[i] - this.best[1])));
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void sipsSigmoidFit() {
        if (this.nAnalyteConcns < 4) {
            throw new IllegalArgumentException("Method sipsSigmoidFit requres at least 4 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 6;
        this.sampleErrorFlag = true;
        this.titleOne = "Sips sigmoid fitting: r = Aa^n/(theta^n + a^n)";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        super.addConstraint(0, -1, 0.0);
        super.sigmoidHillSips();
        super.removeConstraints();
        for (int i = 0; i < this.nInterp; ++i) {
            this.calculatedResponses[i] = this.best[2] * Math.pow(this.interpolationConcns[i], this.best[1]) / (Math.pow(this.best[0], this.best[1]) + Math.pow(this.interpolationConcns[i], this.best[1]));
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void fourParameterLogisticFit() {
        if (this.nAnalyteConcns < 5) {
            throw new IllegalArgumentException("Method fourParameterLogisticFit requres at least 5 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 7;
        this.sampleErrorFlag = true;
        this.titleOne = "Four parameter logistic fitting: r = top + (bottom - top)/(1 + (a/C50)^HillSlope)";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        super.addConstraint(2, -1, 0.0);
        super.ec50();
        super.removeConstraints();
        for (int i = 0; i < this.nInterp; ++i) {
            this.calculatedResponses[i] = this.best[0] + (this.best[1] - this.best[0]) / (1.0 + Math.pow(this.interpolationConcns[i] / this.best[2], this.best[3]));
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void ec50Fit() {
        this.fourParameterLogisticFit();
    }

    public void fourParameterLogisticFit(double bottom, double top) {
        if (this.nAnalyteConcns < 3) {
            throw new IllegalArgumentException("Method fourParameterLogisticFit requres at least 3 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.bottom = bottom;
        this.top = top;
        this.methodUsed = 13;
        this.fourBotTopSet = true;
        this.sampleErrorFlag = true;
        this.titleOne = "Four parameter logistic fitting: r = top + (bottom - top)/(1 + (a/C50)^HillSlope) [top and bottom fixed]";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        super.addConstraint(0, -1, 0.0);
        super.ec50(bottom, top);
        super.removeConstraints();
        for (int i = 0; i < this.nInterp; ++i) {
            this.calculatedResponses[i] = top + (bottom - top) / (1.0 + Math.pow(this.interpolationConcns[i] / this.best[0], this.best[1]));
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void ec50Fit(double bottom, double top) {
        this.fourParameterLogisticFit(bottom, top);
    }

    public void fiveParameterLogisticFit() {
        if (this.nAnalyteConcns < 6) {
            throw new IllegalArgumentException("Method fiveParameterLogisticFit requres at least 6 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 8;
        this.sampleErrorFlag = true;
        this.titleOne = "Five parameter logistic fitting: r = top + (bottom - top)/((1 + (a/C50)^HillSlope)^asymm)";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        super.addConstraint(2, -1, 0.0);
        super.fiveParameterLogistic();
        super.removeConstraints();
        for (int i = 0; i < this.nInterp; ++i) {
            this.calculatedResponses[i] = this.best[0] + (this.best[1] - this.best[0]) / Math.pow(1.0 + Math.pow(this.interpolationConcns[i] / this.best[2], this.best[3]), this.best[4]);
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void fiveParameterLogisticFit(double bottom, double top) {
        if (this.nAnalyteConcns < 5) {
            throw new IllegalArgumentException("Method fiveParameterLogisticFit requres at least 5 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 13;
        this.sampleErrorFlag = true;
        this.bottom = bottom;
        this.top = top;
        this.fiveBotTopSet = true;
        this.titleOne = "Five parameter logistic fitting: r = top + (bottom - top)/((1 + (a/C50)^HillSlope)^asymm) [top and bottom fixed]";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        super.addConstraint(0, -1, 0.0);
        super.fiveParameterLogistic(bottom, top);
        super.removeConstraints();
        for (int i = 0; i < this.nInterp; ++i) {
            this.calculatedResponses[i] = top + (bottom - top) / Math.pow(1.0 + Math.pow(this.interpolationConcns[i] / this.best[0], this.best[1]), this.best[2]);
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void shiftedRectangularHyperbolaFit() {
        if (this.nAnalyteConcns < 4) {
            throw new IllegalArgumentException("Method shiftedRectangularHyperbolaFit requres at least 4 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 9;
        this.sampleErrorFlag = true;
        this.titleOne = "Rectangular hyperbola fitting: r = A.a/(theta + a) + alpha)";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        super.shiftedRectangularHyperbola();
        for (int i = 0; i < this.nInterp; ++i) {
            this.calculatedResponses[i] = this.best[2] * this.interpolationConcns[i] / (this.best[0] + this.interpolationConcns[i]) + this.best[1];
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void rectangularHyperbolaFit() {
        if (this.nAnalyteConcns < 3) {
            throw new IllegalArgumentException("Method rectangularHyperbolaFit requres at least 3 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.methodUsed = 10;
        this.sampleErrorFlag = true;
        this.titleOne = "Rectangular hyperbola fitting: r = A.a/(theta + a))";
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        super.rectangularHyperbola();
        for (int i = 0; i < this.nInterp; ++i) {
            this.calculatedResponses[i] = this.best[1] * this.interpolationConcns[i] / (this.best[0] + this.interpolationConcns[i]);
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    public void amershamFit() {
        this.methodUsed = 11;
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        this.isCompetitive();
        this.amershamFlag1 = true;
        double[] initEst = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        this.fitAmersham(initEst);
    }

    public void amershamFit(double[] estimates) {
        this.methodUsed = 11;
        if (!this.setDataOneDone) {
            this.setDataOne();
        }
        this.isCompetitive();
        this.amershamFlag1 = false;
        this.fitAmersham(estimates);
    }

    private void fitAmersham(double[] estimates) {
        int i;
        if (this.nAnalyteConcns < 6) {
            throw new IllegalArgumentException("Method amershamFit requres at least 6 data points; only " + this.nAnalyteConcns + " were supplied");
        }
        this.sampleErrorFlag = true;
        this.titleOne = "Amersham equation fitting: r = S(2.P(1-N/L)/(K+P+L+a+[(K-P+L+a)^2+4KP]^0.5)+N/L)";
        Amersham am = new Amersham();
        double[] start = new double[5];
        double[] step = new double[5];
        double kGuess = 0.0;
        double labelGuess = 0.0;
        double pGuess = 0.0;
        double nsbGuess = 0.0;
        double amScaleGuess = this.responsesMax;
        if (this.amershamFlag1) {
            int i2;
            boolean foundFlag = false;
            for (i2 = 0; i2 < this.nAnalyteConcns; ++i2) {
                if (this.responses[i2] < this.responsesMax / 2.0) {
                    labelGuess = i2 != this.nAnalyteConcns - 1 ? (this.analyteConcns[i2] + this.analyteConcns[i2 + 1]) / 2.0 : this.analyteConcns[i2];
                    foundFlag = true;
                }
                if (foundFlag) break;
            }
            if (!foundFlag) {
                labelGuess = this.analyteConcns[this.nAnalyteConcns - 1];
            }
            kGuess = labelGuess / 100.0;
            pGuess = labelGuess / 1000.0;
            start[0] = kGuess;
            start[1] = labelGuess;
            start[2] = pGuess;
            start[3] = nsbGuess;
            start[4] = amScaleGuess;
            for (i2 = 0; i2 < 5; ++i2) {
                step[i2] = 0.1 * start[i2];
            }
            step[3] = pGuess / 100.0;
        } else {
            start[0] = estimates[0];
            start[1] = estimates[1];
            start[2] = estimates[2];
            start[3] = estimates[3];
            start[4] = estimates[4];
            for (i = 0; i < 5; ++i) {
                step[i] = 0.1 * start[i];
            }
            if (step[3] == 0.0) {
                step[3] = step[2] / 100.0;
            }
        }
        for (i = 0; i < 5; ++i) {
            super.addConstraint(i, -1, 0.0);
        }
        super.simplex((RegressionFunction)am, start, step);
        super.removeConstraints();
        for (i = 0; i < this.nInterp; ++i) {
            this.calculatedResponses[i] = am.calcResponse(this.best[0], this.best[1], this.best[2], this.best[3], this.interpolationConcns[i], this.best[4]);
        }
        if (!this.supressPlot) {
            this.plott();
        }
        this.curveCheck(this.methodIndices[this.methodUsed]);
    }

    private void isCompetitive() {
        int wrongWay = 0;
        for (int i = 1; i < this.nAnalyteConcns; ++i) {
            if (this.responses[i - 1] < this.responses[i]) {
                ++wrongWay;
            }
            if (wrongWay < this.nAnalyteConcns / 2) continue;
            if (this.responses[this.nAnalyteConcns] >= this.responses[0]) {
                throw new IllegalArgumentException("The data appears incompatible with a competitive assay");
            }
            System.out.println("The data has been queried as that of a competitive assay but the fitting has not been aborted");
        }
    }

    public void selectEquation() {
        ArrayList<Object> choice = this.chooseEquation(0);
        int choice0 = (Integer)choice.get(0);
        int choice1 = (Integer)choice.get(1);
        double choice2 = (Double)choice.get(2);
        double choice3 = (Double)choice.get(3);
        switch (choice0) {
            case 1: {
                this.fiveParameterLogisticFit();
                break;
            }
            case 2: {
                this.fiveParameterLogisticFit(choice2, choice3);
                break;
            }
            case 3: {
                this.fourParameterLogisticFit();
                break;
            }
            case 4: {
                this.fourParameterLogisticFit(choice2, choice3);
                break;
            }
            case 5: {
                this.bestPolynomialFit();
                break;
            }
            case 6: {
                this.polynomialFit(choice1);
                break;
            }
            case 7: {
                this.nonIntegerPolynomialFit(choice1);
                break;
            }
            case 8: {
                this.sigmoidThresholdFit();
                break;
            }
            case 9: {
                this.sipsSigmoidFit();
                break;
            }
            case 10: {
                this.shiftedRectangularHyperbolaFit();
                break;
            }
            case 11: {
                this.rectangularHyperbolaFit();
                break;
            }
            case 12: {
                this.amershamFit();
                break;
            }
            case 13: {
                this.cubicSpline();
                break;
            }
            case 14: {
                this.linearInterpolation();
            }
        }
    }

    private ArrayList<Object> chooseEquation(int flag) {
        ArrayList<Object> ret = new ArrayList<Object>();
        String headerCommentP = null;
        String[] commentsP = null;
        Object[] boxTitlesP = null;
        switch (flag) {
            case 0: {
                headerCommentP = "Choose a fitting equation";
                commentsP = new String[15];
                break;
            }
            case 1: {
                headerCommentP = "Choose the first equation of the comparison";
                commentsP = new String[13];
                break;
            }
            case 2: {
                headerCommentP = "Choose the second equation of the comparison";
                commentsP = new String[13];
            }
        }
        commentsP[0] = "1.  Five paramater logistic equation";
        commentsP[1] = "2.  Five paramater logistic equation (top & bottom fixed)";
        commentsP[2] = "3.  Four paramater logistic equation";
        commentsP[3] = "4.  Four paramater logistic equation (top & bottom fixed)";
        commentsP[4] = "5.  Best fit polynomial";
        commentsP[5] = "6.  Polynomial of user supplied degree";
        commentsP[6] = "7.  Non-integer polynomial";
        commentsP[7] = "8.  Sigmoid threshold function";
        commentsP[8] = "9.  Sips sigmoid function";
        commentsP[9] = "10.  Shifted rectangular hyperbola";
        commentsP[10] = "11.  Rectangular hyperbola";
        commentsP[11] = "12.  Amersham mass action model";
        if (flag == 0) {
            commentsP[12] = "13.  Cubic spline";
            commentsP[13] = "14.  Linear interpolation\n\n";
            commentsP[14] = "Click on the appropriate button below";
            String[] hold1 = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14"};
            boxTitlesP = hold1;
        } else {
            Object[] hold2;
            commentsP[12] = "\nClick on the appropriate button below";
            boxTitlesP = hold2 = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
        }
        int defaultBoxP = 0;
        int ret0 = 1 + JOptionPane.showOptionDialog(null, commentsP, headerCommentP, 1, 3, null, boxTitlesP, boxTitlesP[defaultBoxP]);
        ret.add(new Integer(ret0));
        int ret1 = 0;
        if (ret0 == 6) {
            ret1 = Db.readInt("enter polynomial degree");
        }
        if (ret0 == 7) {
            ret1 = Db.readInt("enter non-integer polynomial number of terms");
        }
        ret.add(new Integer(ret1));
        double ret2 = 0.0;
        double ret3 = 0.0;
        if (ret0 == 2) {
            ret2 = Db.readDouble("Enter five parameter logistic fixed bottom value");
            ret3 = Db.readDouble("Enter five parameter logistic fixed top value");
        }
        if (ret0 == 4) {
            ret2 = Db.readDouble("Enter four parameter logistic fixed bottom value");
            ret3 = Db.readDouble("Enter four parameter logistic fixed top value");
        }
        ret.add(new Double(ret2));
        ret.add(new Double(ret3));
        return ret;
    }

    private double[] log10(double[] array) {
        int n = array.length;
        double[] ret = new double[n];
        this.nPlot = this.nAnalyteConcns;
        for (int i = 0; i < n; ++i) {
            if (array[i] == 0.0) {
                ret[i] = Double.NaN;
                --this.nPlot;
                continue;
            }
            ret[i] = Math.log10(array[i]);
        }
        return ret;
    }

    private double[] loge(double[] array) {
        int n = array.length;
        double[] ret = new double[n];
        this.nPlot = 0;
        this.nPlot = this.nAnalyteConcns;
        for (int i = 0; i < n; ++i) {
            if (array[i] == 0.0) {
                ret[i] = Double.NaN;
                --this.nPlot;
                continue;
            }
            ret[i] = Math.log(array[i]);
        }
        return ret;
    }

    private double[] antiLog10(double[] array) {
        int n = array.length;
        double[] ret = new double[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = Math.pow(10.0, array[i]);
        }
        return ret;
    }

    private double[] antiLoge(double[] array) {
        int n = array.length;
        double[] ret = new double[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = Math.exp(array[i]);
        }
        return ret;
    }

    public void setData() {
        this.setDataOne();
    }

    private void setDataOne() {
        int i;
        int i2;
        if (!this.analyteEntered) {
            throw new IllegalArgumentException("No analyte concentrations have been entered");
        }
        if (!this.responsesEntered) {
            throw new IllegalArgumentException("No standard curve responses have been entered");
        }
        if (this.nAnalyteConcns != this.nResponses) {
            throw new IllegalArgumentException("The number of analyte concentrations entered, " + this.nAnalyteConcns + ", must equal the number of standard curve responses entered, " + this.nResponses);
        }
        if (!this.weightsEntered && this.weightOption > 0) {
            switch (this.weightOption) {
                case 1: {
                    int i3;
                    for (i3 = 0; i3 < this.nResponses; ++i3) {
                        this.weights[i3] = Math.abs(this.responses[i3]);
                    }
                    this.weightsEntered = true;
                    break;
                }
                case 2: {
                    int i3;
                    for (i3 = 0; i3 < this.nResponses; ++i3) {
                        this.weights[i3] = Math.sqrt(Math.abs(this.responses[i3]));
                    }
                    this.weightsEntered = true;
                }
            }
        }
        this.nData = this.nAnalyteConcns;
        this.nData0 = this.nAnalyteConcns;
        this.nXarrays = 1;
        this.nYarrays = 1;
        ArrayMaths am = new ArrayMaths(this.analyteConcns);
        am = am.sort();
        int[] indices = am.originalIndices();
        double[] hold = new double[this.nAnalyteConcns];
        hold = Conv.copy(this.analyteConcns);
        for (i2 = 0; i2 < this.nAnalyteConcns; ++i2) {
            this.analyteConcns[i2] = hold[indices[i2]];
        }
        hold = Conv.copy(this.responses);
        for (i2 = 0; i2 < this.nAnalyteConcns; ++i2) {
            this.responses[i2] = hold[indices[i2]];
        }
        if (this.weightsEntered) {
            hold = Conv.copy(this.weights);
            for (i2 = 0; i2 < this.nAnalyteConcns; ++i2) {
                this.weights[i2] = hold[indices[i2]];
            }
        }
        if (this.analyteConcnFlag == 1) {
            hold = Conv.copy(this.log10AnalyteConcns);
            for (i2 = 0; i2 < this.nAnalyteConcns; ++i2) {
                this.log10AnalyteConcns[i2] = hold[indices[i2]];
            }
        }
        if (this.analyteConcnFlag == 2) {
            hold = Conv.copy(this.logeAnalyteConcns);
            for (i2 = 0; i2 < this.nAnalyteConcns; ++i2) {
                this.logeAnalyteConcns[i2] = hold[indices[i2]];
            }
        }
        for (i2 = 0; i2 < this.nAnalyteConcns - 1; ++i2) {
            int j;
            int nIdent = 1;
            int iFirst = 0;
            ArrayList al = new ArrayList();
            for (int j2 = i2 + 1; j2 < this.nAnalyteConcns; ++j2) {
                if (this.analyteConcns[i2] != this.analyteConcns[j2]) continue;
                ++nIdent;
                iFirst = i2;
            }
            if (nIdent <= true) continue;
            double sum = 0.0;
            for (j = iFirst; j < iFirst + nIdent; ++j) {
                sum += this.responses[j];
            }
            this.responses[iFirst] = sum / (double)nIdent;
            for (j = iFirst + 1; j < this.nAnalyteConcns - nIdent + 1; ++j) {
                this.analyteConcns[j] = this.analyteConcns[j + nIdent - 1];
                this.responses[j] = this.responses[j + nIdent - 1];
                if (this.weightsEntered) {
                    this.weights[j] = this.weights[j + nIdent - 1];
                }
                if (this.analyteConcnFlag == 1) {
                    this.log10AnalyteConcns[j] = this.log10AnalyteConcns[j + nIdent - 1];
                }
                if (this.analyteConcnFlag != 2) continue;
                this.logeAnalyteConcns[j] = this.logeAnalyteConcns[j + nIdent - 1];
            }
            this.nAnalyteConcns = this.nAnalyteConcns - nIdent + 1;
        }
        this.nPlot = this.nAnalyteConcns;
        switch (this.analyteConcnFlag) {
            case 0: {
                this.log10AnalyteConcns = this.log10(this.analyteConcns);
                this.logeAnalyteConcns = this.loge(this.analyteConcns);
                break;
            }
            case 1: {
                this.logeAnalyteConcns = this.loge(this.analyteConcns);
                break;
            }
            case 2: {
                this.log10AnalyteConcns = this.log10(this.analyteConcns);
            }
        }
        int nNonPos = 0;
        this.responsesPlot = true;
        for (i = 0; i < this.nAnalyteConcns; ++i) {
            if (!(this.responses[i] <= 0.0)) continue;
            ++nNonPos;
        }
        if (nNonPos == 1) {
            if (this.responses[0] <= 0.0) {
                --this.nPlot;
                this.responsesPlot = true;
            } else {
                this.responsesPlot = false;
            }
        } else if (nNonPos > 1) {
            this.responsesPlot = false;
        }
        if (this.responsesPlot) {
            switch (this.responsesFlag) {
                case 0: {
                    this.log10Responses = this.log10(this.responses);
                    this.logeResponses = this.loge(this.analyteConcns);
                    break;
                }
                case 1: {
                    this.logeResponses = this.loge(this.responses);
                    break;
                }
                case 2: {
                    this.log10Responses = this.log10(this.responses);
                }
            }
        }
        CubicSpline.supress();
        if (this.weightsEntered) {
            if (this.nAnalyteConcns != this.nWeights) {
                throw new IllegalArgumentException("The number of analyte concentrations entered, " + this.nAnalyteConcns + ", must equal the number of standard curve weights entered, " + this.nWeights);
            }
            this.weightOpt = true;
            this.weightFlag = 0;
            this.weights = this.checkForZeroWeights(this.weights);
            if (this.weightOpt) {
                this.weightFlag = 1;
            }
        } else {
            this.weightOpt = false;
            this.weightFlag = 0;
            this.nWeights = this.nResponses;
            this.weights = new double[this.nWeights];
            for (i = 0; i < this.nWeights; ++i) {
                this.weights[i] = 1.0;
            }
        }
        double[][] xData = new double[1][this.nResponses];
        xData[0] = this.analyteConcns;
        super.setDefaultValues(xData, this.responses, this.weights);
        this.responsesMax = Fmath.maximum(this.responses);
        this.responsesMin = Fmath.minimum(this.responses);
        this.responsesRange = this.responsesMax - this.responsesMin;
        this.setInterpolationData();
        if (this.nAnalyteConcns <= 3) {
            this.anscombeC = this.critValuesFive[0];
        } else if (this.nAnalyteConcns >= 120) {
            this.anscombeC = this.critValuesFive[19];
        } else {
            this.critValues = this.confidenceLevel == 0.95 ? new CubicSpline(this.critSize, this.critValuesFive) : new CubicSpline(this.critSize, this.critValuesOne);
            this.anscombeC = this.critValues.interpolate(this.nAnalyteConcns);
        }
        this.setDataOneDone = true;
    }

    public void setNintyNineLevel() {
        this.confidenceLevel = 0.99;
    }

    public void setNintyFiveLevel() {
        this.confidenceLevel = 0.95;
    }

    private void setInterpolationData() {
        this.interpolationConcns = new double[this.nInterp];
        this.calculatedResponses = new double[this.nInterp];
        double incr = (this.analyteConcns[this.nAnalyteConcns - 1] - this.analyteConcns[0]) / (double)(this.nInterp - 1);
        this.interpolationConcns[0] = this.analyteConcns[0];
        for (int i = 1; i < this.nInterp - 1; ++i) {
            this.interpolationConcns[i] = this.interpolationConcns[i - 1] + incr;
        }
        this.interpolationConcns[this.nInterp - 1] = this.analyteConcns[this.nAnalyteConcns - 1];
    }

    public void resetPlotOption(int opt) {
        if (opt < 0 || opt > 4) {
            throw new IllegalArgumentException("The plot option, " + opt + ", must be greater than or equal to 0 and less than 5");
        }
        this.plotOptions = opt;
    }

    private void supressPlot() {
        this.supressPlot = true;
    }

    private void unsupressPlot() {
        this.supressPlot = false;
    }

    private int plott() {
        int returnFlag = 1;
        double[][] plotData = new double[4][];
        Plot pg = null;
        switch (this.plotOptions) {
            case 0: {
                plotData[0] = this.analyteConcns;
                plotData[1] = this.responses;
                plotData[2] = this.interpolationConcns;
                plotData[3] = this.calculatedResponses;
                pg = new PlotGraph(plotData);
                pg.setXaxisLegend("Analyte concentration (a)");
                pg.setYaxisLegend("Assay response (r) ");
                break;
            }
            case 1: {
                int nLen1 = this.nAnalyteConcns;
                int nLen2 = this.nInterp;
                if (nLen1 != this.nPlot) {
                    nLen1 = this.nPlot;
                    nLen2 = this.nInterp - 1;
                }
                plotData[0] = new double[nLen1];
                plotData[1] = new double[nLen1];
                plotData[2] = new double[nLen2];
                plotData[3] = new double[nLen2];
                if (nLen1 != this.nAnalyteConcns) {
                    int i;
                    for (i = 1; i < this.nAnalyteConcns; ++i) {
                        plotData[0][i - 1] = this.log10AnalyteConcns[i];
                        plotData[1][i - 1] = this.responses[i];
                    }
                    for (i = 1; i < this.nInterp; ++i) {
                        plotData[2][i - 1] = Math.log10(this.interpolationConcns[i]);
                        plotData[3][i - 1] = this.calculatedResponses[i];
                    }
                } else {
                    plotData[0] = this.log10AnalyteConcns;
                    plotData[1] = this.responses;
                    plotData[3] = this.calculatedResponses;
                    plotData[2] = new double[this.nInterp];
                    for (int i = 0; i < this.nInterp; ++i) {
                        plotData[2][i] = Math.log10(this.interpolationConcns[i]);
                    }
                }
                pg = new PlotGraph(plotData);
                pg.setXaxisLegend("Log10[ Analyte concentration (a) ]");
                pg.setYaxisLegend("Assay response (r) ");
                break;
            }
            case 2: {
                int nLen1 = this.nAnalyteConcns;
                int nLen2 = this.nInterp;
                if (nLen1 != this.nPlot) {
                    nLen1 = this.nPlot;
                    nLen2 = this.nInterp - 1;
                }
                plotData[0] = new double[nLen1];
                plotData[1] = new double[nLen1];
                plotData[2] = new double[nLen2];
                plotData[3] = new double[nLen2];
                if (nLen1 != this.nAnalyteConcns) {
                    int i;
                    for (i = 1; i < this.nAnalyteConcns; ++i) {
                        plotData[0][i - 1] = this.logeAnalyteConcns[i];
                        plotData[1][i - 1] = this.responses[i];
                    }
                    for (i = 1; i < this.nInterp; ++i) {
                        plotData[2][i - 1] = Math.log(this.interpolationConcns[i]);
                        plotData[3][i - 1] = this.calculatedResponses[i];
                    }
                } else {
                    plotData[0] = this.logeAnalyteConcns;
                    plotData[1] = this.responses;
                    plotData[3] = this.calculatedResponses;
                    plotData[2] = new double[this.nInterp];
                    for (int i = 0; i < this.nInterp; ++i) {
                        plotData[2][i] = Math.log(this.interpolationConcns[i]);
                    }
                }
                pg = new PlotGraph(plotData);
                pg.setXaxisLegend("Loge[ Analyte concentration (a) ]");
                pg.setYaxisLegend("Assay response (r) ");
                break;
            }
            case 3: {
                if (!this.responsesPlot) {
                    System.out.println("A log(concentration) v. log(responses) plot is not possible; zero or negative responses");
                    return -1;
                }
                int nLen1 = this.nAnalyteConcns;
                int nLen2 = this.nInterp;
                if (nLen1 != this.nPlot) {
                    nLen1 = this.nPlot;
                    nLen2 = this.nInterp - 1;
                }
                plotData[0] = new double[nLen1];
                plotData[1] = new double[nLen1];
                plotData[2] = new double[nLen2];
                plotData[3] = new double[nLen2];
                if (nLen1 != this.nAnalyteConcns) {
                    int i;
                    for (i = 1; i < this.nAnalyteConcns; ++i) {
                        plotData[0][i - 1] = this.log10AnalyteConcns[i];
                        plotData[1][i - 1] = this.log10Responses[i];
                    }
                    for (i = 1; i < this.nInterp; ++i) {
                        plotData[2][i - 1] = Math.log10(this.interpolationConcns[i]);
                        plotData[3][i - 1] = Math.log10(this.calculatedResponses[i]);
                    }
                } else {
                    plotData[0] = this.log10AnalyteConcns;
                    plotData[1] = this.log10Responses;
                    plotData[2] = new double[this.nInterp];
                    plotData[3] = new double[this.nInterp];
                    for (int i = 0; i < this.nInterp; ++i) {
                        plotData[2][i] = Math.log10(this.interpolationConcns[i]);
                        plotData[3][i] = Math.log10(this.calculatedResponses[i]);
                    }
                }
                pg = new PlotGraph(plotData);
                pg.setXaxisLegend("Log10[ Analyte concentration (a) ]");
                pg.setYaxisLegend("Log10[ Assay response (r) ]");
                break;
            }
            case 4: {
                if (!this.responsesPlot) {
                    System.out.println("A log(concentration) v. log(responses) plot is not possible; zero or negative responses");
                    return -1;
                }
                int nLen1 = this.nAnalyteConcns;
                int nLen2 = this.nInterp;
                if (nLen1 != this.nPlot) {
                    nLen1 = this.nPlot;
                    nLen2 = this.nInterp - 1;
                }
                plotData[0] = new double[nLen1];
                plotData[1] = new double[nLen1];
                plotData[2] = new double[nLen2];
                plotData[3] = new double[nLen2];
                if (nLen1 != this.nAnalyteConcns) {
                    int i;
                    for (i = 1; i < this.nAnalyteConcns; ++i) {
                        plotData[0][i - 1] = this.logeAnalyteConcns[i];
                        plotData[1][i - 1] = this.logeResponses[i];
                    }
                    for (i = 1; i < this.nInterp; ++i) {
                        plotData[2][i - 1] = Math.log(this.interpolationConcns[i]);
                        plotData[3][i - 1] = Math.log(this.calculatedResponses[i]);
                    }
                } else {
                    plotData[0] = this.logeAnalyteConcns;
                    plotData[1] = this.logeResponses;
                    plotData[2] = new double[this.nInterp];
                    plotData[3] = new double[this.nInterp];
                    for (int i = 0; i < this.nInterp; ++i) {
                        plotData[2][i] = Math.log(this.interpolationConcns[i]);
                        plotData[3][i] = Math.log(this.calculatedResponses[i]);
                    }
                }
                pg = new PlotGraph(plotData);
                pg.setXaxisLegend("Loge[ Analyte concentration (a) ]");
                pg.setYaxisLegend("Loge[ Assay response (r) ]");
            }
        }
        int[] points = new int[]{1, 0};
        pg.setPoint(points);
        int[] lines = new int[]{0, 3};
        pg.setLine(lines);
        pg.setGraphTitle(this.titleZero);
        pg.setGraphTitle2(this.titleOne);
        ((PlotGraph)pg).plot();
        return returnFlag;
    }

    private void curveCheck(int mFlag) {
        int i;
        int i2;
        this.interpStartIndex = 0;
        this.interpEndIndex = this.nInterp - 1;
        this.outlierFlag = false;
        this.outliers = new String[this.nAnalyteConcns];
        this.residualsMean = Stat.mean(this.residual);
        this.residualsSD = Stat.standardDeviation(this.residual);
        int maxOutlierIndex = 0;
        double maxAbsResidual = Math.abs(this.residual[0]);
        for (i2 = 0; i2 < this.nAnalyteConcns; ++i2) {
            if (!(Math.abs(this.residual[i2]) > maxAbsResidual)) continue;
            maxAbsResidual = Math.abs(this.residual[i2]);
            maxOutlierIndex = i2;
        }
        for (i2 = 0; i2 < this.nAnalyteConcns; ++i2) {
            this.outliers[i2] = "   ";
            if (!(Math.abs(this.residual[i2] - this.residualsMean) > this.anscombeC * this.residualsSD)) continue;
            this.outliers[i2] = "possible outlier";
            if (i2 == maxOutlierIndex) {
                int n = i2;
                this.outliers[n] = this.outliers[n] + " (***)";
            }
            this.outlierFlag = true;
        }
        int direction = 1;
        this.nTurningPoints = 0;
        boolean checkFlag = false;
        ArrayList<Integer> turns = new ArrayList<Integer>();
        double gap = this.calculatedResponses[1] - this.calculatedResponses[0];
        if (gap < 0.0) {
            direction = -1;
        }
        if (gap == 0.0) {
            checkFlag = true;
        }
        for (i = 2; i < this.nInterp; ++i) {
            if (direction == 1) {
                if (this.calculatedResponses[i] <= this.calculatedResponses[i - 1]) {
                    checkFlag = true;
                }
            } else if (this.calculatedResponses[i] >= this.calculatedResponses[i - 1]) {
                checkFlag = true;
            }
            if (!checkFlag) continue;
            ++this.nTurningPoints;
            turns.add(new Integer(i));
            direction = -direction;
            this.ambigCheck = true;
            checkFlag = false;
        }
        if (this.nTurningPoints == 1) {
            this.turnIndices = new int[1];
            this.turnIndices[0] = (Integer)turns.get(0);
            if (this.turnIndices[0] <= this.nInterp / 2) {
                this.interpStartIndex = this.turnIndices[0];
            } else {
                this.interpEndIndex = this.turnIndices[0];
            }
            System.out.println(this.methodNames[mFlag]);
            System.out.println("The fitted or interpolated standard curve is not monotonic");
            System.out.println("The useable analyte concentration range is " + this.interpolationConcns[this.interpStartIndex] + " to " + this.interpolationConcns[this.interpEndIndex]);
        }
        if (this.nTurningPoints > 1) {
            this.turnIndices = new int[this.nTurningPoints];
            for (i = 0; i < this.nTurningPoints; ++i) {
                this.turnIndices[i] = (Integer)turns.get(i);
            }
            int[] nts = new int[this.nTurningPoints + 1];
            int[] nte = new int[this.nTurningPoints + 1];
            int[] ntd = new int[this.nTurningPoints + 1];
            ntd[0] = this.turnIndices[0];
            nts[0] = 0;
            nte[0] = this.turnIndices[0];
            for (int i3 = 1; i3 < this.nTurningPoints; ++i3) {
                ntd[i3] = this.turnIndices[i3] - this.turnIndices[i3 - 1];
                nts[i3] = this.turnIndices[i3 - 1];
                nte[i3] = this.turnIndices[i3];
            }
            ntd[this.nTurningPoints] = this.nInterp - 1 - this.turnIndices[this.nTurningPoints - 1];
            nts[this.nTurningPoints] = this.turnIndices[this.nTurningPoints - 1];
            nte[this.nTurningPoints] = this.nInterp - 1;
            int testMax = 0;
            for (int i4 = 0; i4 <= this.nTurningPoints; ++i4) {
                for (int j = 0; j <= this.nTurningPoints; ++j) {
                    if (i4 == j || ntd[i4] < ntd[j]) continue;
                    ++testMax;
                }
                if (testMax == this.nTurningPoints) {
                    this.interpStartIndex = nts[i4];
                    this.interpEndIndex = nte[i4];
                } else {
                    testMax = 0;
                }
                if (testMax != 0) break;
            }
            System.out.println(this.methodNames[mFlag]);
            System.out.println("The fitted or interpolated standard curve is not monotonic");
            System.out.println("The useable analyte concentration range is " + this.interpolationConcns[this.interpStartIndex] + " to " + this.interpolationConcns[this.interpEndIndex]);
        }
        this.interpAnalyteStart = this.interpolationConcns[this.interpStartIndex];
        this.interpAnalyteEnd = this.interpolationConcns[this.interpEndIndex];
        this.interpResponseStart = this.calculatedResponses[this.interpStartIndex];
        this.interpResponseEnd = this.calculatedResponses[this.interpEndIndex];
        this.nWorking = this.interpEndIndex - this.interpStartIndex + 1;
        double[] xx = new double[this.nWorking];
        double[] yy = new double[this.nWorking];
        for (int i5 = 0; i5 < this.nWorking; ++i5) {
            xx[i5] = this.interpolationConcns[this.interpStartIndex + i5];
            yy[i5] = this.calculatedResponses[this.interpStartIndex + i5];
        }
        if (this.methodUsed == 14) {
            this.linterp = new LinearInterpolation(yy, xx);
        } else {
            this.interp = new CubicSpline(yy, xx);
        }
        this.curveDirection = true;
        if (this.interpResponseStart > this.interpResponseEnd) {
            this.curveDirection = false;
        }
        this.workingResponseMin = Fmath.minimum(this.calculatedResponses);
        if (this.curveDirection) {
            if (this.workingResponseMin < this.interpResponseStart) {
                this.workingResponseMin = this.interpResponseStart;
            }
        } else if (this.workingResponseMin < this.interpResponseEnd) {
            this.workingResponseMin = this.interpResponseEnd;
        }
        this.workingResponseMax = Fmath.maximum(this.calculatedResponses);
        if (this.curveDirection) {
            if (this.workingResponseMax > this.interpResponseEnd) {
                this.workingResponseMax = this.interpResponseEnd;
            }
        } else if (this.workingResponseMax > this.interpResponseStart) {
            this.workingResponseMax = this.interpResponseStart;
        }
        double[] ee = new double[this.nWorking];
        double yError = Math.sqrt(this.sumOfSquaresError / (double)(this.nAnalyteConcns - this.nParam));
        if (this.sampleErrorFlag) {
            int i6;
            if (!this.weightsEntered) {
                for (int i7 = 0; i7 < this.nWorking; ++i7) {
                    ee[i7] = yError;
                }
            } else {
                int i8;
                boolean monoCheck = true;
                int iS = 0;
                int iF = this.nAnalyteConcns - 1;
                boolean breakFlag = false;
                if (this.ambigCheck) {
                    int i9;
                    for (i9 = 0; i9 < this.nAnalyteConcns; ++i9) {
                        if (this.interpAnalyteStart >= this.analyteConcns[i9]) {
                            iS = i9;
                            breakFlag = true;
                        }
                        if (breakFlag) break;
                    }
                    breakFlag = false;
                    for (i9 = this.nAnalyteConcns - 1; i9 >= 0; --i9) {
                        if (this.interpAnalyteEnd <= this.analyteConcns[i9]) {
                            iF = i9;
                            breakFlag = true;
                        }
                        if (breakFlag) break;
                    }
                }
                int nwe = iF - iS + 1;
                double[] ew = new double[nwe];
                for (int i10 = 0; i10 < nwe; ++i10) {
                    ew[i10] = this.weights[i10 + iS];
                }
                monoCheck = ImmunoAssay.isMonotonic(ew);
                if (monoCheck) {
                    double gap1;
                    double gap0 = gap1 = Math.abs(ew[1] - ew[0]);
                    for (i8 = 2; i8 < nwe; ++i8) {
                        gap1 = Math.abs(ew[i8] - ew[i8 - 1]);
                        if (!(gap1 > gap0)) continue;
                        gap0 = gap1;
                    }
                    if (gap0 > 0.6 * Math.abs(Fmath.maximum(ew) - Fmath.minimum(ew))) {
                        monoCheck = false;
                    }
                }
                double[] sWeights = new double[this.nAnalyteConcns];
                double scale = yError / this.weightsMean;
                for (int i11 = 0; i11 < this.nAnalyteConcns; ++i11) {
                    sWeights[i11] = this.weights[i11] * scale;
                }
                if (this.weightsEntered && !monoCheck) {
                    LinearInterpolation liee = new LinearInterpolation(this.analyteConcns, sWeights);
                    for (i8 = 0; i8 < this.nWorking; ++i8) {
                        ee[i8] = Math.abs(liee.interpolate(xx[i8]));
                    }
                } else {
                    CubicSpline csee = new CubicSpline(this.analyteConcns, sWeights);
                    for (i8 = 0; i8 < this.nWorking; ++i8) {
                        ee[i8] = Math.abs(csee.interpolate(xx[i8]));
                    }
                }
            }
            this.errorp = new CubicSpline(yy, ee);
            this.propagatedErrors = new String[this.nAnalyteConcns];
            double temp = 0.0;
            ArrayList<Double> alpe = new ArrayList<Double>();
            for (int i12 = 0; i12 < this.nAnalyteConcns; ++i12) {
                boolean checkFlag2 = false;
                if (this.curveDirection) {
                    if (this.responses[i12] < this.interpResponseStart || this.responses[i12] > this.interpResponseEnd) {
                        checkFlag2 = true;
                    }
                } else if (this.responses[i12] > this.interpResponseStart || this.responses[i12] < this.interpResponseEnd) {
                    checkFlag2 = true;
                }
                if (checkFlag2) {
                    this.propagatedErrors[i12] = "**";
                    continue;
                }
                alpe.add(new Double(this.responses[i12]));
                temp = this.getSampleConcn(this.responses[i12]);
                temp = this.getSampleConcnError();
                alpe.add(new Double(temp));
                temp = Fmath.truncate(temp, this.prec);
                this.propagatedErrors[i12] = new Double(temp).toString();
            }
            int npe = alpe.size() / 2;
            double[] resp = new double[npe];
            double[] xerr = new double[npe];
            for (int i13 = 0; i13 < npe; ++i13) {
                resp[i13] = (Double)alpe.get(2 * i13);
                xerr[i13] = (Double)alpe.get(2 * i13 + 1);
            }
            CubicSpline cspe = new CubicSpline(resp, xerr);
            double[] respe = new double[1001];
            double[] xerre = new double[1001];
            respe[0] = resp[0];
            respe[1000] = resp[npe - 1];
            double incr = (resp[npe - 1] - resp[0]) / 1000.0;
            for (i6 = 1; i6 < 1000; ++i6) {
                respe[i6] = respe[i6 - 1] + incr;
            }
            for (i6 = 0; i6 < 1001; ++i6) {
                xerre[i6] = cspe.interpolate(respe[i6]);
            }
            Stat stat = new Stat(xerre);
            this.minimumAerror = stat.minimum();
            this.maximumAerror = stat.maximum();
            this.meanAerror = stat.mean();
            this.sdAerror = stat.standardDeviation();
        }
    }

    public double getSampleConcn(double response) {
        this.sampleResponse = response;
        double concn = Double.NaN;
        boolean checkFlag = false;
        if (this.curveDirection) {
            if (response < this.interpResponseStart || response > this.interpResponseEnd) {
                checkFlag = true;
            }
        } else if (response > this.interpResponseStart || response < this.interpResponseEnd) {
            checkFlag = true;
        }
        if (checkFlag) {
            if (this.ambigCheck) {
                System.out.println("The sample response, " + response + ", is outside the useable part of the standard curve:");
            } else {
                System.out.println("The sample response, " + response + ", is outside the limits of the standard curve:");
            }
            System.out.println(this.interpResponseStart + " to " + this.interpResponseEnd);
            System.out.println("NaN returned");
            return concn;
        }
        concn = this.methodUsed == 14 ? this.linterp.interpolate(response) : this.interp.interpolate(response);
        this.sampleConcn = concn;
        this.sampleError = Double.NaN;
        if (this.sampleErrorFlag) {
            double yError = this.errorp.interpolate(response);
            double yErrorMinus = response - yError;
            if (yErrorMinus < this.workingResponseMin) {
                yErrorMinus = this.workingResponseMin;
            }
            double fac = (response - yErrorMinus) / yError;
            double xErrorMinus = this.interp.interpolate(yErrorMinus);
            double yErrorPlus = response + yError;
            if (yErrorPlus > this.workingResponseMax) {
                yErrorPlus = this.workingResponseMax;
            }
            double xErrorPlus = this.interp.interpolate(yErrorPlus);
            this.sampleError = Math.abs(xErrorPlus - xErrorMinus) / (fac += (yErrorPlus - response) / yError);
        }
        return concn;
    }

    public double getSampleConcnError() {
        if (this.methodUsed == 0) {
            System.out.println("ImmunoAssay method: getSampleConcnError()");
            System.out.println("A sample concentration error is not meaningful in the case of a cubic spline interpolation");
            System.out.println("NaN returned");
        }
        if (this.methodUsed == 1) {
            System.out.println("ImmunoAssay method: getSampleConcnError()");
            System.out.println("A sample concentration error is not meaningful in the case of a cubic interpolation");
            System.out.println("NaN returned");
        }
        if (this.methodUsed == 14) {
            System.out.println("ImmunoAssay method: getSampleConcnError()");
            System.out.println("A sample concentration error is not meaningful in the case of a linear interpolation");
            System.out.println("NaN returned");
        }
        return this.sampleError;
    }

    public void resetNfittedCurve(int nInterp) {
        this.nInterp = nInterp;
    }

    public double[] getFittedStandardCurveConcns() {
        return Conv.copy(this.interpolationConcns);
    }

    public double[] getFittedStandardCurveResponses() {
        return Conv.copy(this.calculatedResponses);
    }

    public double[] getWorkingConcentrationRange() {
        double[] ret = new double[]{this.interpAnalyteStart, this.interpAnalyteEnd};
        return ret;
    }

    public double[] getWorkingResponseRange() {
        double[] ret = new double[]{this.interpResponseStart, this.interpResponseEnd};
        return ret;
    }

    public double[] getModelParameterValues() {
        return Conv.copy(this.best);
    }

    public double[] getModelParameterErrors() {
        return Conv.copy(this.bestSd);
    }

    public int getNumberOfTurningPoints() {
        return this.nTurningPoints;
    }

    @Override
    public double getSumOfSquares() {
        return this.sumOfSquaresError;
    }

    public double getUnWeightedSumOfSquares() {
        return this.sumOfSquaresError;
    }

    public double getWeightedSumOfSquares() {
        return this.chiSquare;
    }

    public double[] getTurningPointConcns() {
        double[] ret = null;
        if (this.nTurningPoints > 0) {
            ret = new double[this.nTurningPoints];
            for (int i = 0; i < this.nTurningPoints; ++i) {
                ret[i] = this.interpolationConcns[this.turnIndices[i]];
            }
        }
        return ret;
    }

    public double[] getTurningPointResponses() {
        double[] ret = null;
        if (this.nTurningPoints > 0) {
            ret = new double[this.nTurningPoints];
            for (int i = 0; i < this.nTurningPoints; ++i) {
                ret[i] = this.calculatedResponses[this.turnIndices[i]];
            }
        }
        return ret;
    }

    @Override
    public void print() {
        this.print(this.filename);
    }

    @Override
    public void print(String filename) {
        boolean printFlag = true;
        switch (this.methodUsed) {
            case 0: {
                System.out.println("There is no text file associated with the cubic spline interpolation method");
                printFlag = false;
                break;
            }
            case 1: {
                System.out.println("There is no text file associated with the cubic interpolation method");
                printFlag = false;
                break;
            }
            case 14: {
                System.out.println("There is no text file associated with the linear interpolation method");
                printFlag = false;
            }
        }
        if (printFlag) {
            int pos = filename.indexOf(".");
            if (pos == -1) {
                filename = filename + ".txt";
            }
            this.filename = filename;
            FileOutput fout = new FileOutput(filename);
            fout.println(this.titleZero);
            if (this.dataRead) {
                fout.println("Data input file name:   " + this.dataFilename);
            }
            fout.dateAndTimeln(filename);
            this.commonPrint(fout);
            fout.println();
            fout.println("End of file");
            fout.close();
        }
    }

    public void commonPrint(FileOutput fout) {
        int j;
        int i;
        int i2;
        fout.println();
        fout.println(this.titleOne);
        fout.println("r = assay response;  a = analyte concentration");
        boolean logLin = false;
        String[] param = null;
        Object paramT = null;
        switch (this.methodUsed) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                param = new String[this.polyDegree + 1];
                for (i2 = 0; i2 <= this.polyDegree; ++i2) {
                    param[i2] = "c[" + i2 + "]";
                }
                logLin = false;
                break;
            }
            case 3: {
                param = new String[this.bestPolyDegree + 1];
                for (i2 = 0; i2 <= this.bestPolyDegree; ++i2) {
                    param[i2] = "c[" + i2 + "]";
                }
                logLin = false;
                break;
            }
            case 4: {
                fout.println("n = " + (this.polyNterms - 1));
                param = new String[2 * this.polyNterms - 1];
                for (i2 = 0; i2 < 2 * this.polyNterms - 1; ++i2) {
                    param[i2] = "c[" + i2 + "]";
                }
                logLin = true;
                break;
            }
            case 5: {
                param = new String[]{"alpha", "theta", "A"};
                logLin = true;
                break;
            }
            case 6: {
                param = new String[]{"theta", "n", "A"};
                logLin = true;
                break;
            }
            case 7: {
                param = new String[]{"top", "bottom", "C50", "Hill Slope"};
                logLin = true;
                break;
            }
            case 8: {
                param = new String[]{"top", "bottom", "C50", "HillSlope", "Asymm"};
                logLin = true;
                break;
            }
            case 9: {
                param = new String[]{"theta", "alpha", "A"};
                logLin = true;
                break;
            }
            case 10: {
                param = new String[]{"theta", "A"};
                logLin = true;
                break;
            }
            case 11: {
                param = new String[]{"K", "L", "P", "N", "S"};
                logLin = true;
                break;
            }
            case 12: {
                fout.println("top =    " + this.top);
                fout.println("bottom = " + this.bottom);
                param = new String[]{"C50", "Hill Slope"};
                logLin = true;
                break;
            }
            case 13: {
                fout.println("top =    " + this.top);
                fout.println("bottom = " + this.bottom);
                param = new String[]{"C50", "HillSlope", "Asymm"};
                logLin = true;
                break;
            }
            case 14: {
                break;
            }
            default: {
                throw new IllegalArgumentException("methodUsed " + this.methodUsed + " not recognised");
            }
        }
        if (logLin) {
            fout.println();
            fout.println("Non-linear regression (Nelder and Mead simplex procedure)");
            if (!this.nlrStatus) {
                fout.println("Convergence criterion was not satisfied");
                fout.println("The following results are, or are derived from, the current estimates on exiting the regression method");
                fout.println();
            }
            fout.println("Estimated parameters");
            fout.println("The statistics are obtained assuming that the model behaves as a linear model about the minimum.");
            fout.println("The Hessian matrix is calculated as the numerically derived second derivatives of chi square with respect to all pairs of parameters.");
            if (this.zeroCheck) {
                fout.println("The best estimate/s equal to zero were replaced by the step size in the numerical differentiation!!!");
            }
            fout.println("Consequentlty treat the statistics with great caution.");
            if (!this.posVarFlag) {
                fout.println("Covariance matrix contains at least one negative diagonal element");
                fout.println(" - all variances are dubious");
                fout.println(" - may not be at a minimum or the model may be so non-linear that the linear approximation in calculating the statisics is invalid");
            }
            if (!this.invertFlag) {
                fout.println("Hessian matrix is singular");
                fout.println(" - variances cannot be calculated");
                fout.println(" - may not be at a minimum  or the model may be so non-linear that the linear approximation in calculating the statisics is invalid");
            }
        } else {
            fout.println("Linear regression");
        }
        fout.println();
        fout.printtab(" ", this.field);
        if (this.invertFlag) {
            fout.printtab("Best", this.field);
            fout.printtab("Estimate of", this.field);
            fout.printtab("Coefficient", this.field);
            fout.printtab("t-value", this.field);
            fout.println("p-value");
        } else {
            fout.println("Best");
        }
        if (this.invertFlag) {
            fout.printtab(" ", this.field);
            fout.printtab("estimate", this.field);
            fout.printtab("the error", this.field);
            fout.printtab("of", this.field);
            fout.printtab("t", this.field);
            fout.println("P > |t|");
        } else {
            fout.printtab(" ", this.field);
            fout.println("estimate");
        }
        if (this.invertFlag) {
            fout.printtab(" ", this.field);
            fout.printtab(" ", this.field);
            fout.printtab(" ", this.field);
            fout.println("variation (%)");
        } else {
            fout.println("   ");
        }
        for (i2 = 0; i2 < this.nParam; ++i2) {
            if (this.invertFlag) {
                fout.printtab(param[i2], this.field);
                fout.printtab(Fmath.truncate(this.best[i2], this.prec), this.field);
                fout.printtab(Fmath.truncate(this.bestSd[i2], this.prec), this.field);
                fout.printtab(Fmath.truncate(Math.abs(this.bestSd[i2] * 100.0 / this.best[i2]), this.prec), this.field);
                fout.printtab(Fmath.truncate(this.tValues[i2], this.prec), this.field);
                fout.println(Fmath.truncate(this.pValues[i2], this.prec));
                continue;
            }
            fout.printtab(param[i2], this.field);
            fout.println(Fmath.truncate(this.best[i2], this.prec));
        }
        fout.println();
        if (logLin) {
            fout.printtab(" ", this.field);
            fout.printtab("Best", this.field);
            fout.printtab("Pre-minimum", this.field);
            fout.printtab("Post-minimum", this.field);
            fout.printtab("Initial", this.field);
            fout.println("Fractional");
            fout.printtab(" ", this.field);
            fout.printtab("estimate", this.field);
            fout.printtab("gradient", this.field);
            fout.printtab("gradient", this.field);
            fout.printtab("estimate", this.field);
            fout.println("step");
            for (i2 = 0; i2 < this.nParam; ++i2) {
                fout.printtab(param[i2], this.field);
                fout.printtab(Fmath.truncate(this.best[i2], this.prec), this.field);
                fout.printtab(Fmath.truncate(this.grad[i2][0], this.prec), this.field);
                fout.printtab(Fmath.truncate(this.grad[i2][1], this.prec), this.field);
                fout.printtab(Fmath.truncate(this.startH[i2], this.prec), this.field);
                fout.println(Fmath.truncate(this.stepH[i2], this.prec));
            }
            fout.println();
        }
        int kk = 0;
        fout.printtab("analyte", this.field);
        fout.printtab("observed", this.field);
        fout.printtab("calculated", this.field);
        fout.printtab("weight", this.field);
        fout.printtab("unweighted", this.field);
        fout.printtab("weighted", this.field);
        fout.printtab("estimated analyte", this.field);
        fout.println("outliers");
        fout.printtab("concn ", this.field);
        fout.printtab("response", this.field);
        fout.printtab("response", this.field);
        fout.printtab("     ", this.field);
        fout.printtab("residual", this.field);
        fout.printtab("residual", this.field);
        fout.printtab("concn error *", this.field);
        fout.println("   ");
        for (i = 0; i < this.nAnalyteConcns; ++i) {
            fout.printtab(Fmath.truncate(this.xData[0][kk], this.prec), this.field);
            fout.printtab(Fmath.truncate(this.yData[kk], this.prec), this.field);
            fout.printtab(Fmath.truncate(this.yCalc[kk], this.prec), this.field);
            fout.printtab(Fmath.truncate(this.weight[kk], this.prec), this.field);
            fout.printtab(Fmath.truncate(this.residual[kk], this.prec), this.field);
            fout.printtab(Fmath.truncate(this.residualW[kk], this.prec), this.field);
            fout.printtab(this.propagatedErrors[kk], this.field);
            fout.println(this.outliers[i]);
            ++kk;
        }
        fout.println();
        fout.println("*  The estimated error in the estimated concentration on entering this response via getSampleConcn(response)");
        fout.println("** Outside the working range");
        fout.println("Mean of the unweighted residuals =               " + Fmath.truncate(this.residualsMean, this.prec));
        fout.println("Standard deviation of the unweighted residuals = " + Fmath.truncate(this.residualsSD, this.prec));
        fout.println("Outlier critical value at the " + this.confidenceLevel * 100.0 + " confidence level = " + Fmath.truncate(this.anscombeC * this.residualsSD + this.residualsMean, this.prec));
        if (this.outlierFlag) {
            fout.println("*** the most extreme possible outlier");
        }
        fout.println();
        fout.println("Minimum estimated interpolated concentration error:                   " + Fmath.truncate(this.minimumAerror, this.prec));
        fout.println("Maximum estimated interpolated concentration error:                   " + Fmath.truncate(this.maximumAerror, this.prec));
        fout.println("Mean estimated interpolated concentration error:                      " + Fmath.truncate(this.meanAerror, this.prec));
        fout.println("Standard deviation of the estimated interpolated concentration error: " + Fmath.truncate(this.sdAerror, this.prec));
        fout.println();
        fout.printtab("Degrees of freedom");
        fout.println(this.degreesOfFreedom);
        fout.printtab("Number of data points");
        fout.println(this.nData);
        fout.printtab("Number of estimated paramaters");
        fout.println(this.nParam);
        fout.printtab("Sum of squares of the unweighted residuals");
        fout.println(Fmath.truncate(this.sumOfSquaresError, this.prec));
        if (this.weightOpt) {
            fout.printtab("Chi Square");
            fout.println(Fmath.truncate(this.chiSquare, this.prec));
            fout.printtab("Reduced Chi Square");
            fout.println(Fmath.truncate(this.reducedChiSquare, this.prec));
        }
        if (logLin) {
            fout.println("Correlation: analyte concentration and responses");
            fout.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient (R)");
            fout.println(Fmath.truncate(this.xyR, this.prec));
            if (Math.abs(this.xyR) <= 1.0) {
                fout.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient Probability");
                fout.println(Fmath.truncate(Stat.linearCorrCoeffProb(this.xyR, this.nData - 2), this.prec));
            }
            fout.println(" ");
            fout.println("Correlation: observed responses and calculated responses");
            fout.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient");
            fout.println(Fmath.truncate(this.yyR, this.prec));
            if (Math.abs(this.yyR) <= 1.0) {
                fout.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient Probability");
                fout.println(Fmath.truncate(Stat.linearCorrCoeffProb(this.yyR, this.nData - 2), this.prec));
            }
            fout.println();
            fout.printtab("Durbin-Watson d statistic");
            fout.println(Fmath.truncate(super.getDurbinWatsonD(), this.prec));
            fout.println();
            if (this.posVarFlag && this.invertFlag && this.chiSquare != 0.0) {
                fout.println("Parameter - parameter correlation coefficients");
                fout.printtab(" ", this.field);
                for (i = 0; i < this.nParam; ++i) {
                    fout.printtab(param[i], this.field);
                }
                fout.println();
                fout.println();
                for (j = 0; j < this.nParam; ++j) {
                    fout.printtab(param[j], this.field);
                    for (int i3 = 0; i3 < this.nParam; ++i3) {
                        fout.printtab(Fmath.truncate(this.corrCoeff[i3][j], this.prec), this.field);
                    }
                    fout.println();
                }
            }
            fout.println();
            fout.println("Coefficient of determination, R =                   " + Fmath.truncate(this.multR, this.prec));
            fout.println("Adjusted Coefficient of determination, R' =         " + Fmath.truncate(this.adjustedR, this.prec));
            fout.println("Coefficient of determination, F-ratio =             " + Fmath.truncate(this.multipleF, this.prec));
            fout.println("Coefficient of determination, F-ratio probability = " + Fmath.truncate(this.multipleFprob, this.prec));
            fout.println("Total (weighted) sum of squares  =                  " + Fmath.truncate(this.sumOfSquaresTotal, this.prec));
            fout.println("Regression (weighted) sum of squares  =             " + Fmath.truncate(this.sumOfSquaresRegrn, this.prec));
            fout.println("Error (weighted) sum of squares  =                  " + Fmath.truncate(this.chiSquare, this.prec));
            fout.println();
            fout.printtab("Number of iterations taken");
            fout.println(this.nIter);
            fout.printtab("Maximum number of iterations allowed");
            fout.println(this.nMax);
            fout.printtab("Number of restarts taken");
            fout.println(this.kRestart);
            fout.printtab("Maximum number of restarts allowed");
            fout.println(this.konvge);
            fout.printtab("Standard deviation of the simplex at the minimum");
            fout.println(Fmath.truncate(this.simplexSd, this.prec));
            fout.printtab("Convergence tolerance");
            fout.println(this.fTol);
            switch (this.minTest) {
                case 0: {
                    fout.println("simplex sd < the tolerance times the mean of the absolute values of the y values");
                    break;
                }
                case 1: {
                    fout.println("simplex sd < the tolerance");
                    break;
                }
                case 2: {
                    fout.println("simplex sd < the tolerance times the square root(sum of squares/degrees of freedom");
                }
            }
            fout.println("Step used in numerical differentiation to obtain Hessian matrix");
            fout.println("d(parameter) = parameter*" + this.delta);
        } else {
            fout.println(" ");
            fout.println("Correlation: analyte concentrations and responses");
            fout.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient (R)");
            fout.println(Fmath.truncate(this.xyR, this.prec));
            if (Math.abs(this.xyR) <= 1.0) {
                fout.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient Probability");
                fout.println(Fmath.truncate(Stat.linearCorrCoeffProb(this.xyR, this.nData - 2), this.prec));
            }
            fout.println(" ");
            fout.println("Correlation: observed responses and calculated responses");
            fout.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient");
            fout.println(Fmath.truncate(this.yyR, this.prec));
            if (Math.abs(this.yyR) <= 1.0) {
                fout.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient Probability");
                fout.println(Fmath.truncate(Stat.linearCorrCoeffProb(this.yyR, this.nData - 2), this.prec));
            }
            fout.println();
            fout.println();
            if (this.chiSquare != 0.0) {
                fout.println("Correlation coefficients");
                fout.printtab(" ", this.field);
                for (i = 0; i < this.nParam; ++i) {
                    fout.printtab(param[i], this.field);
                }
                fout.println();
                for (j = 0; j < this.nParam; ++j) {
                    fout.printtab(param[j], this.field);
                    for (int i4 = 0; i4 < this.nParam; ++i4) {
                        fout.printtab(Fmath.truncate(this.corrCoeff[i4][j], this.prec), this.field);
                    }
                    fout.println();
                }
            }
            fout.println();
            fout.printtab("Durbin-Watson d statistic");
            fout.println(Fmath.truncate(super.getDurbinWatsonD(), this.prec));
            fout.println();
            if (this.bestPolyFlag) {
                fout.println("Method bestPolynomial search history");
                fout.println("F-probability significance level: " + this.fProbSignificance + " (" + this.fProbSignificance * 100.0 + " %)");
                fout.println("Degree of best fit polynomial " + this.bestPolynomialDegree);
                fout.println(" ");
                fout.print("Polynomial degree", 2 * this.field);
                fout.print("chi square", 2 * this.field);
                fout.print("F-ratio", this.field);
                fout.print("F-probability", this.field + 2);
                fout.println("F-value at the");
                fout.print("comparison", 2 * this.field);
                fout.print("comparison", 2 * this.field);
                fout.print("   ", this.field);
                fout.print("   ", this.field + 2);
                fout.println("significance level");
                int nAttempts = (Integer)this.bestPolyArray.get(1);
                int[] deg0s = (int[])this.bestPolyArray.get(2);
                int[] deg1s = (int[])this.bestPolyArray.get(3);
                double[] chi0s = (double[])this.bestPolyArray.get(4);
                double[] chi1s = (double[])this.bestPolyArray.get(5);
                double[] fRatios = (double[])this.bestPolyArray.get(6);
                double[] fProbs = (double[])this.bestPolyArray.get(7);
                double[] fSigns = (double[])this.bestPolyArray.get(8);
                for (int i5 = 0; i5 < nAttempts; ++i5) {
                    fout.print(deg0s[i5], this.field);
                    fout.print(deg1s[i5], this.field);
                    fout.print(Fmath.truncate(chi0s[i5], this.prec), this.field);
                    fout.print(Fmath.truncate(chi1s[i5], this.prec), this.field);
                    fout.print(Fmath.truncate(fRatios[i5], this.prec), this.field);
                    fout.print(Fmath.truncate(fProbs[i5], this.prec), this.field + 2);
                    fout.println(Fmath.truncate(fSigns[i5], this.prec));
                }
            }
            fout.println();
            fout.println("Coefficient of determination,   =                   " + Fmath.truncate(this.multR, this.prec));
            fout.println("Adjusted Coefficient of determination,    =         " + Fmath.truncate(this.adjustedR, this.prec));
            fout.println("Coefficient of determination, F-ratio =             " + Fmath.truncate(this.multipleF, this.prec));
            fout.println("Coefficient of determination, F-ratio probability = " + Fmath.truncate(this.multipleFprob, this.prec));
            fout.println("Total (weighted) sum of squares  =                  " + Fmath.truncate(this.sumOfSquaresTotal, this.prec));
            fout.println("Regression (weighted) sum of squares  =             " + Fmath.truncate(this.sumOfSquaresRegrn, this.prec));
            fout.println("Error (weighted) sum of squares  =                  " + Fmath.truncate(this.chiSquare, this.prec));
        }
    }

    public void compare() {
        this.selectCompare(this.significance, this.compFilename);
    }

    public void compare(double significance) {
        this.selectCompare(significance, this.compFilename);
    }

    public void compare(String filename) {
        this.selectCompare(this.significance, filename);
    }

    public void compare(double significance, String filename) {
        this.selectCompare(significance, filename);
    }

    private void selectCompare(double significance, String filename) {
        this.compWindow = true;
        ArrayList<Object> choice = this.chooseEquation(1);
        int model1index = (Integer)choice.get(0);
        int degree1 = 0;
        int nTerms1 = 0;
        double bottom1 = 0.0;
        double top1 = 0.0;
        if (model1index == 6) {
            degree1 = (Integer)choice.get(1);
            this.degSet = true;
        }
        if (model1index == 7) {
            nTerms1 = (Integer)choice.get(1);
            this.nTermsSet = true;
        }
        if (model1index == 2) {
            bottom1 = (Double)choice.get(2);
            top1 = (Double)choice.get(3);
            this.fiveBotTopSet = true;
        }
        if (model1index == 4) {
            bottom1 = (Double)choice.get(2);
            top1 = (Double)choice.get(3);
            this.fourBotTopSet = true;
        }
        choice = this.chooseEquation(2);
        int model2index = (Integer)choice.get(0);
        int degree2 = 0;
        int nTerms2 = 0;
        double bottom2 = 0.0;
        double top2 = 0.0;
        if (model2index == 6) {
            degree2 = (Integer)choice.get(1);
            this.degSet = true;
        }
        if (model2index == 7) {
            nTerms2 = (Integer)choice.get(1);
            this.nTermsSet = true;
        }
        if (model2index == 2) {
            bottom2 = (Double)choice.get(2);
            top2 = (Double)choice.get(3);
            this.fiveBotTopSet = true;
        }
        if (model2index == 4) {
            bottom2 = (Double)choice.get(2);
            top2 = (Double)choice.get(3);
            this.fourBotTopSet = true;
        }
        this.compare(model1index, degree1, bottom1, top1, nTerms1, model2index, degree2, bottom2, top2, nTerms2, significance, filename);
    }

    public void compare(int model1index, int model2index) {
        this.compare(model1index, 0, 0.0, 0.0, 0, model2index, 0, 0.0, 0.0, 0, this.significance, this.compFilename);
    }

    public void compare(int model1index, int model2index, double significance) {
        this.compare(model1index, 0, 0.0, 0.0, 0, model2index, 0, 0.0, 0.0, 0, significance, this.compFilename);
    }

    public void compare(int model1index, int degree1, int model2index, int degree2, double significance) {
        this.degSet = true;
        this.compare(model1index, degree1, 0.0, 0.0, 0, model2index, degree2, 0.0, 0.0, 0, significance, this.compFilename);
    }

    public void compare(int model1index, int model2index, String filename) {
        this.compare(model1index, 0, 0.0, 0.0, 0, model2index, 0, 0.0, 0.0, 0, this.significance, filename);
    }

    public void compare(int model1index, int degree1, int model2index, int degree2, String filename) {
        this.degSet = true;
        this.compare(model1index, degree1, 0.0, 0.0, 0, model2index, degree2, 0.0, 0.0, 0, this.significance, filename);
    }

    public void compare(int model1index, int degree1, int model2index, int degree2) {
        this.degSet = true;
        this.compare(model1index, degree1, 0.0, 0.0, 0, model2index, degree2, 0.0, 0.0, 0, this.significance, this.compFilename);
    }

    public void compare(int model1index, int degree1, double bottom1, double top1, int nTerms1, int model2index, int degree2, double bottom2, double top2, int nTerms2, double significance, String filename) {
        int pos;
        if (!(this.degSet || degree1 <= 0 && degree2 <= 0)) {
            this.degSet = true;
        }
        double[] sumOfSquaresComp = new double[2];
        int[] nParamComp = new int[2];
        String[] methodNameComp = new String[2];
        int[] modelXindices = new int[]{model1index, model2index};
        if (!this.compWindow) {
            if (model1index == 2) {
                bottom1 = Db.readDouble("Enter five parameter logistic bottom value");
                top1 = Db.readDouble("Enter five parameter logistic top value");
            }
            if (model1index == 4) {
                bottom1 = Db.readDouble("Enter four parameter logistic bottom value");
                top1 = Db.readDouble("Enter four parameter logistic top value");
            }
            if (model1index == 6 && !this.degSet) {
                degree1 = Db.readInt("Enter the polynomial degree");
            }
            if (model1index == 7) {
                nTerms1 = Db.readInt("Enter the non-integer polynomial number of terms");
            }
        }
        ArrayList<Object> al1 = this.fittingForCompare(model1index, degree1, bottom1, top1, nTerms1, false);
        sumOfSquaresComp[0] = (Double)al1.get(0);
        nParamComp[0] = (Integer)al1.get(1);
        methodNameComp[0] = (String)al1.get(2);
        if (!this.compWindow) {
            if (model1index == 2) {
                bottom2 = Db.readDouble("Enter five parameter logistic bottom value");
                top2 = Db.readDouble("Enter five parameter logistic top value");
            }
            if (model1index == 4) {
                bottom2 = Db.readDouble("Enter four parameter logistic bottom value");
                top2 = Db.readDouble("Enter four parameter logistic top value");
            }
            if (model1index == 6 && !this.degSet) {
                degree2 = Db.readInt("Enter the polynomial degree");
            }
            if (model1index == 7) {
                nTerms2 = Db.readInt("Enter the non-integer polynomial number of terms");
            }
        }
        ArrayList<Object> al2 = this.fittingForCompare(model2index, degree2, bottom2, top2, nTerms2, true);
        sumOfSquaresComp[1] = (Double)al2.get(0);
        nParamComp[1] = (Integer)al2.get(1);
        methodNameComp[1] = (String)al2.get(2);
        ArrayList<Object> al3 = ImmunoAssay.comparisonTest(modelXindices, sumOfSquaresComp[0], nParamComp[0], this.nAnalyteConcns, sumOfSquaresComp[1], nParamComp[1], this.nAnalyteConcns, significance);
        int resultFlag = (Integer)al3.get(0);
        int model1indexn = (Integer)al3.get(1);
        int model2indexn = (Integer)al3.get(2);
        double fRatio = (Double)al3.get(3);
        double fProb = (Double)al3.get(4);
        double fRatioAtSignificanceLevel = (Double)al3.get(5);
        int degreesOfFreedom1 = (Integer)al3.get(6);
        int degreesOfFreedom2 = (Integer)al3.get(7);
        if (model1indexn != model1index) {
            int holdI = nParamComp[0];
            nParamComp[0] = nParamComp[1];
            nParamComp[1] = holdI;
            double holdD = sumOfSquaresComp[0];
            sumOfSquaresComp[0] = sumOfSquaresComp[1];
            sumOfSquaresComp[1] = holdD;
            String holdS = methodNameComp[0];
            methodNameComp[0] = methodNameComp[1];
            methodNameComp[1] = holdS;
        }
        if ((pos = filename.indexOf(".")) == -1) {
            filename = filename + ".txt";
        }
        FileOutput fout = new FileOutput(filename);
        fout.println(this.titleZero);
        fout.println("Comparison of two fitting procedures");
        if (this.dataRead) {
            fout.println("Data input file name " + this.dataFilename);
        }
        fout.dateAndTimeln(filename);
        fout.println();
        fout.println("Equations compared:");
        fout.println("   Equation One: " + methodNameComp[0]);
        fout.println("   Equation Two: " + methodNameComp[1]);
        fout.println();
        fout.print("                    ", this.field);
        fout.print("Eqation", this.field);
        fout.println("Eqation");
        fout.print("                    ", this.field);
        fout.print("One", this.field);
        fout.println("Two");
        fout.print("Sum of squares      ", this.field);
        fout.print(Fmath.truncate(sumOfSquaresComp[0], this.prec), this.field);
        fout.println(Fmath.truncate(sumOfSquaresComp[1], this.prec));
        fout.print("Degrees of freedom  ", this.field);
        fout.print(this.nAnalyteConcns - nParamComp[0], this.field);
        fout.println(this.nAnalyteConcns - nParamComp[1]);
        fout.println();
        switch (resultFlag) {
            case 0: {
                fout.printtab("Extra sum of squares F-ratio =                 ");
                fout.println(Fmath.truncate(fRatio, this.prec));
                fout.printtab("F-ratio probabilty =                           ");
                fout.println(Fmath.truncate(fProb, this.prec));
                fout.printtab("F value at the " + significance + " significance level = ");
                fout.println(Fmath.truncate(fRatioAtSignificanceLevel, this.prec));
                fout.println();
                if (fProb <= significance) {
                    fout.println("In terms of a best fit Equation Two is the preferred fit.");
                    if (Math.abs(nParamComp[1] - nParamComp[0]) == 1) {
                        fout.println("The additional parameter has, given a " + significance + " significance level, significantly improved the fit.");
                        break;
                    }
                    fout.println("The additional parameters have, given a " + significance + " significance level, significantly improved the fit.");
                    break;
                }
                fout.println("In terms of a best fit Equation One is the preferred fit");
                if (Math.abs(nParamComp[1] - nParamComp[0]) == 1) {
                    fout.println("The additional parameter has not, given a " + significance + " significance level, significantly improved the fit.");
                    break;
                }
                fout.println("The additional parameters have not, given a " + significance + " significance level, significantly improved the fit.");
                break;
            }
            case 1: {
                fout.println("The fittings to the two equations cannot be distinguished using an F-test analysis");
                break;
            }
            case 2: {
                fout.printtab("Variance F-ratio =                            ");
                fout.println(Fmath.truncate(fRatio, this.prec));
                fout.printtab("F-ratio probabilty =                          ");
                fout.println(Fmath.truncate(fProb, this.prec));
                fout.printtab("F value at the " + significance + " significance level = ");
                fout.println(Fmath.truncate(fRatioAtSignificanceLevel, this.prec));
                fout.println();
                if (fProb <= significance) {
                    fout.println("In terms of a best fit Equation Two is the preferred fit");
                    fout.println("as indicated by the F-ratio analysis and a given significance level of " + significance);
                    break;
                }
                fout.println("The fittings to the two equations cannot be distinguished using an F-test analysis");
            }
        }
        fout.println("However, the choice of the model to be used as a standard curve should include, along with this comparison,");
        fout.println("observation of the displayed graphs and of the detailed analyses listed below");
        fout.println();
        fout.println();
        fout.println("Details of the two compared fitting exercises");
        fout.println();
        FileInput fin = new FileInput("ImmunoAssayTemp.txt");
        int n = fin.numberOfLines();
        String line = null;
        for (int i = 0; i < n; ++i) {
            line = fin.readLine();
            fout.println(line);
        }
        fin.close();
        fout.println();
        fout.println("End of file");
        fout.close();
        this.deleteFile("ImmunoAssayTemp.txt");
    }

    private ArrayList<Object> fittingForCompare(int index, int degree, double bottom, double top, int nTerms, boolean catFlag) {
        ArrayList<Object> al = new ArrayList<Object>();
        String methodName = null;
        switch (index) {
            case 1: {
                this.fiveParameterLogisticFit();
                methodName = this.methodNames[1];
                break;
            }
            case 2: {
                this.fiveParameterLogisticFit(bottom, top);
                methodName = this.methodNames[2];
                break;
            }
            case 3: {
                this.fourParameterLogisticFit();
                methodName = this.methodNames[3];
                break;
            }
            case 4: {
                this.fourParameterLogisticFit(bottom, top);
                methodName = this.methodNames[4];
                break;
            }
            case 5: {
                this.bestPolynomialFit();
                methodName = this.methodNames[5] + ": degree = " + this.bestPolyDegree;
                break;
            }
            case 6: {
                this.polynomialFit(degree);
                methodName = this.methodNames[6] + degree;
                break;
            }
            case 7: {
                this.nonIntegerPolynomialFit(nTerms);
                methodName = this.methodNames[7];
                break;
            }
            case 8: {
                this.sigmoidThresholdFit();
                methodName = this.methodNames[8];
                break;
            }
            case 9: {
                this.sipsSigmoidFit();
                methodName = this.methodNames[9];
                break;
            }
            case 10: {
                this.shiftedRectangularHyperbolaFit();
                methodName = this.methodNames[10];
                break;
            }
            case 11: {
                this.rectangularHyperbolaFit();
                methodName = this.methodNames[11];
                break;
            }
            case 12: {
                this.amershamFit();
                methodName = this.methodNames[12];
                break;
            }
            default: {
                throw new IllegalArgumentException("Method number " + index + " not recognised");
            }
        }
        FileOutput fout = null;
        String tempFileName = "ImmunoAssayTemp.txt";
        fout = catFlag ? new FileOutput(tempFileName, 'a') : new FileOutput(tempFileName);
        this.commonPrint(fout);
        fout.println();
        fout.println();
        fout.close();
        al.add(new Double(this.chiSquare));
        al.add(new Integer(this.nParam));
        al.add(methodName);
        return al;
    }

    public static ArrayList<Object> comparisonTest(int[] modelXindices, double sumOfSquares1, int nParameters1, int nData1, double sumOfSquares2, int nParameters2, int nData2, double significance) {
        int holdI;
        double holdD;
        ArrayList<Object> al = new ArrayList<Object>();
        double fRatio = Double.NaN;
        double fProb = Double.NaN;
        double fRatioAtSignificanceLevel = Double.NaN;
        double[] sumOfSquares = new double[]{sumOfSquares1, sumOfSquares2};
        int[] nParameters = new int[]{nParameters1, nParameters2};
        int[] nData = new int[]{nData1, nData2};
        int[] degreesOfFreedom = new int[]{nData1 - nParameters1, nData2 - nParameters2};
        double[] variances = new double[2];
        double extraSumOfSquares = Double.NaN;
        int extraSumDegreesOfFreedom = 0;
        boolean extraDegreesOfFreedom = false;
        int resultFlag = -1;
        if (nParameters1 != nParameters2 && nData1 == nData2) {
            if (nParameters[0] > nParameters[1]) {
                holdD = sumOfSquares[0];
                sumOfSquares[0] = sumOfSquares[1];
                sumOfSquares[1] = holdD;
                holdI = nParameters[0];
                nParameters[0] = nParameters[1];
                nParameters[1] = holdI;
                holdI = nData[0];
                nData[0] = nData[1];
                nData[1] = holdI;
                holdI = degreesOfFreedom[0];
                degreesOfFreedom[0] = degreesOfFreedom[1];
                degreesOfFreedom[1] = holdI;
                holdI = modelXindices[0];
                modelXindices[0] = modelXindices[1];
                modelXindices[1] = holdI;
            }
            if (sumOfSquares[0] > sumOfSquares[1]) {
                extraSumOfSquares = sumOfSquares[0] - sumOfSquares[1];
                extraSumDegreesOfFreedom = degreesOfFreedom[0] - degreesOfFreedom[1];
                fRatio = extraSumOfSquares * (double)degreesOfFreedom[1] / ((double)extraSumDegreesOfFreedom * sumOfSquares[1]);
                fProb = Stat.fCompCDF(fRatio, extraSumDegreesOfFreedom, degreesOfFreedom[1]);
                fRatioAtSignificanceLevel = Stat.fTestValueGivenFprob(significance, extraSumDegreesOfFreedom, degreesOfFreedom[1]);
                resultFlag = 0;
            }
        }
        if (resultFlag == -1) {
            if (sumOfSquares[0] == sumOfSquares[1] && degreesOfFreedom[0] == degreesOfFreedom[1]) {
                resultFlag = 1;
            } else {
                variances[0] = sumOfSquares[0] / (double)degreesOfFreedom[0];
                variances[1] = sumOfSquares[1] / (double)degreesOfFreedom[1];
                if (variances[0] <= variances[1]) {
                    holdD = variances[0];
                    variances[0] = variances[1];
                    variances[1] = holdD;
                    holdD = sumOfSquares[0];
                    sumOfSquares[0] = sumOfSquares[1];
                    sumOfSquares[1] = holdD;
                    holdI = nParameters[0];
                    nParameters[0] = nParameters[1];
                    nParameters[1] = holdI;
                    holdI = nData[0];
                    nData[0] = nData[1];
                    nData[1] = holdI;
                    holdI = degreesOfFreedom[0];
                    degreesOfFreedom[0] = degreesOfFreedom[1];
                    degreesOfFreedom[1] = holdI;
                    holdI = modelXindices[0];
                    modelXindices[0] = modelXindices[1];
                    modelXindices[1] = holdI;
                }
                fRatio = variances[0] / variances[1];
                fProb = Stat.fCompCDF(fRatio, degreesOfFreedom[0], degreesOfFreedom[1]);
                fRatioAtSignificanceLevel = Stat.fTestValueGivenFprob(significance, degreesOfFreedom[0], degreesOfFreedom[1]);
                resultFlag = 2;
            }
        }
        al.add(new Integer(resultFlag));
        al.add(new Integer(modelXindices[0]));
        al.add(new Integer(modelXindices[1]));
        al.add(new Double(fRatio));
        al.add(new Double(fProb));
        al.add(new Double(fRatioAtSignificanceLevel));
        al.add(new Integer(degreesOfFreedom[0]));
        al.add(new Integer(degreesOfFreedom[1]));
        al.add(new Integer(nData[0]));
        al.add(new Integer(nData[1]));
        return al;
    }

    public void deleteFile(String fileName) {
        String[] dirFiles;
        boolean flag = true;
        File file0 = new File(fileName);
        if (!file0.exists()) {
            System.err.println("Method deleteFile: no file or directory of the name " + fileName + " found");
            flag = false;
        }
        if (flag && !file0.canWrite()) {
            System.err.println("Method deleteFile: " + fileName + " is write protected and cannot be deleted");
            flag = false;
        }
        if (flag && file0.isDirectory() && (dirFiles = file0.list()).length > 0) {
            System.err.println("Method deleteFile: " + fileName + " is a directory which is not empty; no action was taken");
            flag = false;
        }
        if (flag && !(flag = file0.delete())) {
            System.err.println("Method deleteFile: deletion of the temporary file " + fileName + " failed");
        }
    }

    public static boolean isMonotonic(double[] x) {
        double gap1;
        boolean monoFlag = true;
        int n = x.length;
        double gap0 = gap1 = x[1] - x[0];
        if (gap1 == 0.0) {
            monoFlag = false;
        } else {
            for (int i = 2; i < n; ++i) {
                gap1 = x[i] - x[i - 1];
                if (gap1 == 0.0) {
                    monoFlag = false;
                } else if (Fmath.sign(gap1) != Fmath.sign(gap0)) {
                    monoFlag = false;
                }
                if (!monoFlag) break;
            }
        }
        return monoFlag;
    }

    public static double surfaceNumberConcn(double molWt, double specVol) {
        return ImmunoChemistry.surfaceNumberConcn(molWt, specVol);
    }

    public static double surfaceNumberConcn(double effectiveRadius) {
        return ImmunoChemistry.surfaceNumberConcn(effectiveRadius);
    }

    public static double surfaceMolarConcn(double molWt, double specVol) {
        return ImmunoChemistry.surfaceMolarConcn(molWt, specVol);
    }

    public static double surfaceMolarConcn(double effectiveRadius) {
        return ImmunoChemistry.surfaceMolarConcn(effectiveRadius);
    }

    public static double equivalentVolumeConcn(double molWt, double area, double volume, double specVol) {
        return ImmunoChemistry.equivalentVolumeConcn(molWt, area, volume, specVol);
    }

    public static double equivalentVolumeConcn(double effectiveRadius, double area, double volume) {
        return ImmunoChemistry.equivalentVolumeConcn(effectiveRadius, area, volume);
    }

    public static double convertSurfaceToVolumeConcn(double surfaceConcn, double area, double volume) {
        return ImmunoChemistry.convertSurfaceToVolumeConcn(surfaceConcn, area, volume);
    }

    public static double molecularRadius(double molWt, double specVol) {
        return ImmunoChemistry.molecularRadius(molWt, specVol);
    }

    public static double molecularRadius(double molWt) {
        return ImmunoChemistry.molecularRadius(molWt, 7.4E-4);
    }

    public static double effectiveRadius(double diffusionCoefficient, double viscosity, double temperature) {
        return ImmunoChemistry.effectiveRadius(diffusionCoefficient, viscosity, temperature);
    }

    public static double getMolWeightIgG1() {
        return ImmunoChemistry.molecularWeightIgG1;
    }

    public static double getMolWeightIgG2() {
        return ImmunoChemistry.molecularWeightIgG2;
    }

    public static double getMolWeightIgG3() {
        return ImmunoChemistry.molecularWeightIgG3;
    }

    public static double getMolWeightIgG4() {
        return ImmunoChemistry.molecularWeightIgG4;
    }

    public static double getMolWeightIgM() {
        return ImmunoChemistry.molecularWeightIgM;
    }

    public static double getMolWeightIgA1() {
        return ImmunoChemistry.molecularWeightIgA1;
    }

    public static double getMolWeightIgA2() {
        return ImmunoChemistry.molecularWeightIgA2;
    }

    public static double getMolWeightIgD() {
        return ImmunoChemistry.molecularWeightIgD;
    }

    public static double getMolWeightIgE() {
        return ImmunoChemistry.molecularWeightIgE;
    }
}

