/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import com.tinkerpop.pipes.Pipe;
import edu.mayo.bior.pipeline.UnixStreamPipeline;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.JSON.tabix.OverlapPipe;
import edu.mayo.pipes.history.HistoryInPipe;
import edu.mayo.pipes.history.HistoryOutPipe;
import edu.mayo.pipes.util.metadata.Metadata;
import java.io.File;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class OverlapPipelineCommand
implements CommandPlugin {
    private static final char OPTION_TABIX_FILE = 'd';
    private static final char OPTION_COLUMN = 'c';
    private static final char OPTION_MINXTEND = 'w';
    private static final char OPTION_MAXXTEND = 'x';
    private UnixStreamPipeline mPipeline = new UnixStreamPipeline();
    private String operation;

    public void init(Properties props) throws Exception {
        this.operation = props.getProperty("command.name");
    }

    public void execute(CommandLine line, Options opts) throws Exception {
        String tabixFile = "";
        if (line.hasOption('d')) {
            tabixFile = line.getOptionValue('d');
        }
        int column = -1;
        if (line.hasOption('c')) {
            column = Integer.parseInt(line.getOptionValue('c'));
        }
        int minxtend = 0;
        if (line.hasOption('w')) {
            minxtend = Integer.parseInt(line.getOptionValue('w'));
        }
        int maxxtend = 0;
        if (line.hasOption('x')) {
            maxxtend = Integer.parseInt(line.getOptionValue('x'));
        }
        Metadata metadata = new Metadata(new File(tabixFile).getCanonicalPath(), this.operation);
        HistoryInPipe preLogic = new HistoryInPipe(metadata);
        OverlapPipe logic = new OverlapPipe(tabixFile, minxtend, maxxtend, column);
        HistoryOutPipe postLogic = new HistoryOutPipe();
        this.mPipeline.execute((Pipe)preLogic, (Pipe)logic, (Pipe)postLogic);
    }
}

