/*
 * Decompiled with CFR 0.152.
 */
package flanagan.circuits;

import flanagan.circuits.TransmissionLine;
import flanagan.complex.Complex;
import flanagan.math.Fmath;

public class SurfaceStripLine
extends TransmissionLine {
    private double trackWidth = -1.0;
    private double effectiveTrackWidth = -1.0;
    private double trackThickness = -1.0;
    private double plateSeparation = -1.0;
    private boolean widthSet = false;
    private boolean separationSet = false;
    private boolean thicknessSet = false;
    private double relativePermittivity = 1.0;
    private double effectivePermittivity = 1.0;
    private boolean permittivitySet = false;
    private double relativePermeability = 1.0;
    private int formulaOption = 0;
    private boolean z0calculated = false;

    public SurfaceStripLine() {
        this.title = "Surface Strip Line";
    }

    public SurfaceStripLine(String title) {
        this.title = title;
    }

    public void setFormulae(int opt) {
        if (opt < 1 || opt > 3) {
            throw new IllegalArgumentException("The option value, " + opt + ", must be 1,2 or 3");
        }
        this.formulaOption = opt - 1;
        if (this.permittivitySet && this.separationSet && this.widthSet) {
            if (this.formulaOption == 0) {
                this.calcIdealCharacteristicImpedance();
            } else if (this.thicknessSet) {
                this.calcIdealCharacteristicImpedance();
            }
        }
    }

    public void useEdwardsHoffmannFormulae() {
        this.formulaOption = 0;
        if (this.permittivitySet && this.separationSet && this.widthSet) {
            this.calcIdealCharacteristicImpedance();
        }
    }

    public void useWadellWheelerSchneiderFormulae() {
        this.formulaOption = 1;
        if (this.permittivitySet && this.separationSet && this.widthSet && this.thicknessSet) {
            this.calcIdealCharacteristicImpedance();
        }
    }

    public void useIPCD317AFormulae() {
        this.formulaOption = 2;
        if (this.permittivitySet && this.separationSet && this.widthSet && this.thicknessSet) {
            this.calcIdealCharacteristicImpedance();
        }
    }

    public void setSurfaceTrackWidth(double width) {
        if (width <= 0.0) {
            throw new IllegalArgumentException("The plate width, " + width + ", must be greater than zero");
        }
        this.trackWidth = width;
        this.effectiveTrackWidth = width;
        this.widthSet = true;
        if (this.permittivitySet && this.separationSet) {
            if (this.formulaOption == 0) {
                this.calcIdealCharacteristicImpedance();
            } else if (this.thicknessSet) {
                this.calcIdealCharacteristicImpedance();
            }
        }
    }

    public double getEffectiveTrackWidth() {
        if (!this.z0calculated) {
            this.calcIdealCharacteristicImpedance();
        }
        if (this.formulaOption == 2) {
            this.effectiveTrackWidth = this.trackWidth;
            System.out.println("Method: getEffectiveTrackWidth()");
            System.out.println("The effective track width is not calculated explicitely for the IPC-D-317A formula.");
            System.out.println("The unadjusted track width has been returned.");
        }
        return this.effectiveTrackWidth;
    }

    public void setSurfaceTrackThickness(double thickness) {
        if (thickness <= 0.0) {
            throw new IllegalArgumentException("The plate thickness, " + thickness + ", must be greater than zero");
        }
        this.trackThickness = thickness;
        this.thicknessSet = true;
        if (this.permittivitySet && this.separationSet && this.widthSet) {
            this.calcIdealCharacteristicImpedance();
        }
    }

    public void setPlateSeparation(double separation) {
        if (separation <= 0.0) {
            throw new IllegalArgumentException("The plate separation, " + separation + ", must be greater than zero");
        }
        this.plateSeparation = separation;
        this.separationSet = true;
        if (this.permittivitySet && this.widthSet) {
            if (this.formulaOption == 0) {
                this.calcIdealCharacteristicImpedance();
            } else if (this.thicknessSet) {
                this.calcIdealCharacteristicImpedance();
            }
        }
    }

    public void setRelativePermittivity(double epsilonR) {
        this.relativePermittivity = epsilonR;
        this.permittivitySet = true;
        if (this.widthSet && this.separationSet) {
            if (this.formulaOption == 0) {
                this.calcIdealCharacteristicImpedance();
            } else if (this.thicknessSet) {
                this.calcIdealCharacteristicImpedance();
            }
        }
    }

    public double getEffectiveRelativePermittivity() {
        if (!this.permittivitySet) {
            throw new IllegalArgumentException("The relative permittivity has not been entered");
        }
        if (!this.z0calculated) {
            this.calcIdealCharacteristicImpedance();
        }
        if (this.formulaOption == 2) {
            this.effectivePermittivity = this.relativePermittivity;
            System.out.println("Method: getEffectiveRelativePermittivity()");
            System.out.println("The effective permittivity is not calculated explicitely for the IPC-D-317A formula.");
            System.out.println("The unadjusted relative permittivity has been returned.");
        }
        return this.effectivePermittivity;
    }

    public void setRelativePermeability(double muR) {
        this.relativePermeability = muR;
        if (this.permittivitySet && this.widthSet && this.separationSet) {
            if (this.formulaOption == 0) {
                this.calcIdealCharacteristicImpedance();
            } else if (this.thicknessSet) {
                this.calcIdealCharacteristicImpedance();
            }
        }
    }

    @Override
    public void setFrequency(double frequency) {
        this.frequency = frequency;
        this.omega = this.frequency * 2.0 * Math.PI;
        if (this.permittivitySet && this.widthSet && this.separationSet) {
            if (this.formulaOption == 0) {
                this.calcIdealCharacteristicImpedance();
            } else if (this.thicknessSet) {
                this.calcIdealCharacteristicImpedance();
            }
        }
    }

    private Complex calcIdealCharacteristicImpedance() {
        if (!this.separationSet) {
            throw new IllegalArgumentException("The strip line plate separation has not been entered");
        }
        if (!this.widthSet) {
            throw new IllegalArgumentException("The strip line track width has not been entered");
        }
        if (!this.permittivitySet) {
            throw new IllegalArgumentException("The relative permittivity has not been entered");
        }
        double wOverH = this.trackWidth / this.plateSeparation;
        double hOverW = 1.0 / wOverH;
        double tOverH = this.trackThickness / this.plateSeparation;
        double eplus1 = this.relativePermittivity + 1.0;
        double eminus1 = this.relativePermittivity - 1.0;
        double fh = this.plateSeparation * this.frequency * 1.0E-6;
        switch (this.formulaOption) {
            case 2: {
                if (!this.thicknessSet) {
                    throw new IllegalArgumentException("The strip line track thickness has not been entered");
                }
                if (wOverH < 0.1 || wOverH > 3.0) {
                    System.out.println("WARNING!");
                    System.out.println("IPC-D-317A FORMULA RESTRICTION");
                    System.out.println("For this model the width over separation ratio, " + wOverH + ", must lie between 0.1 and 3.0 inclusive");
                    System.out.println("The results are likely to be inaccurate");
                }
                if (tOverH > 0.25) {
                    System.out.println("WARNING!");
                    System.out.println("IPC-D-317A FORMULA RESTRICTION");
                    System.out.println("For this model the thickness over separation ratio, " + tOverH + ", must be less than 0.25");
                    System.out.println("The results are likely to be inaccurate");
                }
                this.idealRealCharacteristicImpedance = 87.0 / Math.sqrt(this.relativePermittivity + 1.41);
                this.idealRealCharacteristicImpedance *= Math.log(5.98 * this.plateSeparation / (0.8 * this.trackWidth + this.trackThickness));
                break;
            }
            case 1: {
                if (!this.thicknessSet) {
                    throw new IllegalArgumentException("The strip line track thickness has not been entered");
                }
                double hold = 1.0 / Math.sqrt(1.0 + 12.0 * hOverW);
                if (wOverH < 1.0) {
                    hold += 0.04 * Fmath.square(1.0 - wOverH);
                }
                this.effectivePermittivity = (eplus1 + eminus1 * hold) / 2.0;
                double denom = tOverH * tOverH;
                double deltaW = this.trackThickness / Math.PI * Math.log(10.87312731383618 / Math.sqrt(denom += Fmath.square(0.3183098861837907 / (this.trackWidth / this.trackThickness + 1.1))));
                double deltaWdash = deltaW * ((1.0 + 1.0 / this.effectivePermittivity) / 2.0);
                this.effectiveTrackWidth = this.trackWidth + deltaWdash;
                this.idealRealCharacteristicImpedance = 376.73031346177066 / (Math.PI * 2 * Math.sqrt(2.0 * eplus1));
                double term1 = (1.0 + 1.0 / this.effectivePermittivity) * Math.PI * Math.PI / 2.0;
                term1 += Fmath.square(4.0 * this.plateSeparation / this.effectiveTrackWidth);
                term1 += Fmath.square((14.0 + 8.0 / this.effectivePermittivity) / 11.0);
                term1 = Math.sqrt(term1);
                term1 += (14.0 + 8.0 / this.effectivePermittivity) / 11.0 * (4.0 * this.plateSeparation / this.effectiveTrackWidth);
                term1 *= 4.0 * this.plateSeparation / this.effectiveTrackWidth;
                term1 += 1.0;
                term1 = Math.log(term1);
                this.idealRealCharacteristicImpedance *= term1;
                break;
            }
            case 0: {
                double term;
                if (!this.separationSet) {
                    throw new IllegalArgumentException("The strip line plate separation has not been entered");
                }
                if (!this.widthSet) {
                    throw new IllegalArgumentException("The strip line track width has not been entered");
                }
                if (!this.permittivitySet) {
                    throw new IllegalArgumentException("The relative permittivity has not been entered");
                }
                double staticZo = 0.0;
                if (wOverH < 3.3) {
                    staticZo = 376.73031346177066 / (Math.PI * Math.sqrt(2.0 * eplus1));
                    term = Math.log(4.0 * hOverW + Math.sqrt(16.0 * hOverW * hOverW + 2.0));
                    staticZo *= (term -= 0.5 * (eminus1 / eplus1) * (Math.log(1.5707963267948966) + Math.log(1.2732395447351628) / this.relativePermittivity));
                } else {
                    staticZo = 376.73031346177066 / (2.0 * Math.sqrt(this.relativePermittivity));
                    term = wOverH / 2.0 + Math.log(4.0) / Math.PI + Math.log(1.6767728935975386) / (Math.PI * 2) * eminus1 / (this.relativePermittivity * this.relativePermittivity);
                    staticZo /= (term += eplus1 / (Math.PI * 2 * this.relativePermittivity) * (Math.log(4.269867111336783) + Math.log(wOverH / 2.0 + 0.94)));
                }
                double staticEpsr = 0.0;
                double hdash = staticZo * Math.sqrt(2.0 * eplus1) * Math.PI / 376.73031346177066;
                staticEpsr = wOverH < 1.3 ? eplus1 / 2.0 * Math.pow(1.0 - 0.5 * (hdash += 0.5 * (eminus1 / eplus1) * (Math.log(1.5707963267948966) + Math.log(1.2732395447351628) / this.relativePermittivity)) * (eminus1 / eplus1) * (Math.log(1.5707963267948966) + Math.log(1.2732395447351628) / this.relativePermittivity), -2.0) : eplus1 / 2.0 + eminus1 / 2.0 * Math.pow(1.0 + 10.0 * hOverW, -0.555);
                double staticEffWidth = this.plateSeparation * 376.73031346177066 / (staticZo * Math.sqrt(staticEpsr));
                if (this.frequency == 0.0) {
                    this.idealRealCharacteristicImpedance = staticZo;
                    this.effectivePermittivity = staticEpsr;
                    this.effectiveTrackWidth = staticEffWidth;
                    break;
                }
                System.out.println("QQQ");
                double[] pp = new double[]{0.27488 + (0.6315 + 0.525 / Math.pow(1.0 + 0.157 * fh, 20.0)) * wOverH - 0.065683 * Math.exp(-8.7513 * wOverH), 0.33622 * (1.0 - Math.exp(-0.03442 * this.relativePermittivity)), 0.0363 * Math.exp(-4.6 * wOverH) * (1.0 - Math.exp(-Math.pow(fh / 3.87, 4.97))), 1.0 + 2.751 * (1.0 - Math.exp(-Math.pow(this.relativePermittivity / 15.916, 8.0)))};
                double pf = pp[0] * pp[1] * Math.pow((0.1844 + pp[2] * pp[3]) * 10.0 * fh, 1.5763);
                this.effectivePermittivity = this.relativePermittivity - (this.relativePermittivity - staticEpsr) / (1.0 + pf);
                double[] rr = new double[12];
                rr[0] = 4.766 * Math.exp(-3.228 * Math.pow(wOverH, 0.641));
                rr[1] = 0.016 + Math.pow(0.0514 * this.relativePermittivity, 4.524);
                rr[2] = 1.206 - 0.3144 * Math.exp(-0.0389 * Math.pow(this.relativePermittivity, 1.4)) * (1.0 - Math.exp(-0.267 * Math.pow(wOverH, 7.0)));
                rr[3] = 1.0 + 1.275 * (1.0 - Math.exp(-0.00463 * rr[0] * Math.pow(this.relativePermittivity, 1.674) * Math.pow(fh / 18.37, 2.745)));
                rr[4] = 5.086 * pp[1] * Math.pow(fh / 28.84, 12.0) / (0.384 + 0.386 * rr[1]);
                rr[4] = rr[4] * (Math.exp(-22.2 * Math.pow(wOverH, 1.92)) / (1.0 + 1.3 * Math.pow(fh / 28.84, 12.0)));
                rr[4] = rr[4] * (Math.pow(eminus1, 6.0) / (1.0 + 10.0 * Math.pow(eminus1, 6.0)));
                rr[5] = 1.0 / (0.0962 + Math.pow(19.47 / fh, 6.0));
                rr[6] = 1.0 / (1.0 + 0.00245 * Math.pow(wOverH, 2.0));
                rr[7] = 0.9408 * Math.pow(this.effectivePermittivity, rr[3]) - 0.9603;
                rr[8] = (0.9408 - rr[4]) * Math.pow(staticEpsr, rr[3]) - 0.9603;
                rr[9] = 0.707 * (4.4E-4 * Math.pow(this.relativePermittivity, 2.136) + 0.0184) * Math.pow(fh / 12.3, 1.097);
                rr[10] = 1.0 + 0.0503 * Math.pow(this.relativePermittivity, 2.0) * rr[5] * (1.0 - Math.exp(-Math.pow(wOverH / 15.0, 6.0)));
                rr[11] = rr[2] * (1.0 - 1.1241 * (rr[6] / rr[10]) * Math.exp(-0.026 * Math.pow(fh, 1.1566) - rr[9]));
                this.idealRealCharacteristicImpedance = staticZo * Math.pow(rr[7] / rr[8], rr[11]);
                System.out.println(rr[7] + " " + rr[8] + " " + rr[11]);
                this.effectiveTrackWidth = this.plateSeparation * 376.73031346177066 / (this.idealRealCharacteristicImpedance * Math.sqrt(this.effectivePermittivity));
                break;
            }
            default: {
                throw new IllegalArgumentException("Formulae option, " + this.formulaOption + ", must lie between 0 and 2 inclusive");
            }
        }
        this.idealRealCharacteristicImpedance *= Math.sqrt(this.relativePermeability);
        this.idealCharacteristicImpedance = new Complex(this.idealRealCharacteristicImpedance, 0.0);
        this.z0calculated = true;
        this.calculateDistributedCapacitanceAndInductance();
        return this.idealCharacteristicImpedance;
    }

    @Override
    public Complex getIdealCharacteristicImpedance() {
        if (!this.z0calculated) {
            this.calcIdealCharacteristicImpedance();
        }
        return this.idealCharacteristicImpedance;
    }

    @Override
    public double getIdealCharacteristicImpedanceAsReal() {
        if (!this.z0calculated) {
            this.calcIdealCharacteristicImpedance();
        }
        return this.idealRealCharacteristicImpedance;
    }

    private void calculateDistributedCapacitanceAndInductance() {
        if (!this.z0calculated) {
            this.calcIdealCharacteristicImpedance();
        }
        switch (this.formulaOption) {
            case 2: {
                double hold = Math.log(5.98 * this.plateSeparation / (0.8 * this.trackWidth + this.trackThickness));
                this.distributedCapacitance = 1.7018000000000003E-14 * (this.relativePermittivity + 1.41) / hold;
                break;
            }
            case 0: 
            case 1: {
                this.distributedCapacitance = this.effectiveTrackWidth * this.effectivePermittivity * 8.854187817E-12 / this.plateSeparation;
                break;
            }
            default: {
                throw new IllegalArgumentException("Formulae option, " + this.formulaOption + ", must lie between 0 and 2 inclusive");
            }
        }
        this.distributedInductance = this.distributedCapacitance * this.idealRealCharacteristicImpedance * this.idealRealCharacteristicImpedance;
    }

    @Override
    public SurfaceStripLine copy() {
        if (this == null) {
            return null;
        }
        SurfaceStripLine tl = new SurfaceStripLine();
        tl.formulaOption = this.formulaOption;
        tl.trackWidth = this.trackWidth;
        tl.effectiveTrackWidth = this.effectiveTrackWidth;
        tl.trackThickness = this.trackThickness;
        tl.plateSeparation = this.plateSeparation;
        tl.separationSet = this.separationSet;
        tl.thicknessSet = this.thicknessSet;
        tl.widthSet = this.widthSet;
        tl.z0calculated = this.z0calculated;
        tl.relativePermittivity = this.relativePermittivity;
        tl.effectivePermittivity = this.effectivePermittivity;
        tl.relativePermeability = this.relativePermeability;
        tl.permittivitySet = this.permittivitySet;
        tl.title = this.title;
        tl.distributedResistance = this.distributedResistance;
        tl.distributedConductance = this.distributedConductance;
        tl.distributedCapacitance = this.distributedCapacitance;
        tl.distributedInductance = this.distributedInductance;
        tl.distributedImpedance = this.distributedImpedance.copy();
        tl.distributedAdmittance = this.distributedAdmittance.copy();
        tl.loadImpedance = this.loadImpedance.copy();
        tl.lineLength = this.lineLength;
        tl.segmentLength = this.segmentLength;
        tl.frequency = this.frequency;
        tl.segmentLength = this.segmentLength;
        tl.omega = this.omega;
        tl.inputVoltage = this.inputVoltage.copy();
        tl.inputCurrent = this.inputCurrent.copy();
        tl.outputVoltage = this.outputVoltage.copy();
        tl.outputCurrent = this.outputCurrent.copy();
        tl.idealWavelength = this.idealWavelength;
        tl.generalWavelength = this.generalWavelength;
        tl.lowLossWavelength = this.lowLossWavelength;
        tl.idealPhaseVelocity = this.idealPhaseVelocity;
        tl.generalPhaseVelocity = this.generalPhaseVelocity;
        tl.lowLossPhaseVelocity = this.lowLossPhaseVelocity;
        tl.idealGroupVelocity = this.idealGroupVelocity;
        tl.generalGroupVelocity = this.generalGroupVelocity;
        tl.lowLossGroupVelocity = this.lowLossGroupVelocity;
        tl.delta = this.delta;
        tl.idealAttenuationConstant = this.idealAttenuationConstant;
        tl.generalAttenuationConstant = this.generalAttenuationConstant;
        tl.lowLossAttenuationConstant = this.lowLossAttenuationConstant;
        tl.idealPhaseConstant = this.idealPhaseConstant;
        tl.generalPhaseConstant = this.generalPhaseConstant;
        tl.lowLossPhaseConstant = this.lowLossPhaseConstant;
        tl.idealPropagationConstant = this.idealPropagationConstant.copy();
        tl.loadImpedance = this.loadImpedance.copy();
        tl.loadImpedance = this.loadImpedance.copy();
        tl.loadImpedance = this.loadImpedance.copy();
        tl.generalPropagationConstant = this.generalPropagationConstant.copy();
        tl.lowLossPropagationConstant = this.lowLossPropagationConstant.copy();
        tl.idealCharacteristicImpedance = this.idealCharacteristicImpedance.copy();
        tl.idealRealCharacteristicImpedance = this.idealRealCharacteristicImpedance;
        tl.generalCharacteristicImpedance = this.generalCharacteristicImpedance.copy();
        tl.lowLossCharacteristicImpedance = this.lowLossCharacteristicImpedance.copy();
        tl.idealInputImpedance = this.idealInputImpedance.copy();
        tl.generalInputImpedance = this.generalInputImpedance.copy();
        tl.lowLossInputImpedance = this.lowLossInputImpedance.copy();
        tl.idealShortedLineImpedance = this.idealShortedLineImpedance.copy();
        tl.generalShortedLineImpedance = this.generalShortedLineImpedance.copy();
        tl.lowLossShortedLineImpedance = this.lowLossShortedLineImpedance.copy();
        tl.idealOpenLineImpedance = this.idealOpenLineImpedance.copy();
        tl.generalOpenLineImpedance = this.generalOpenLineImpedance.copy();
        tl.lowLossOpenLineImpedance = this.lowLossOpenLineImpedance.copy();
        tl.idealQuarterWaveLineImpedance = this.idealQuarterWaveLineImpedance.copy();
        tl.generalQuarterWaveLineImpedance = this.generalQuarterWaveLineImpedance.copy();
        tl.lowLossQuarterWaveLineImpedance = this.lowLossQuarterWaveLineImpedance.copy();
        tl.idealHalfWaveLineImpedance = this.idealHalfWaveLineImpedance.copy();
        tl.generalHalfWaveLineImpedance = this.generalHalfWaveLineImpedance.copy();
        tl.lowLossHalfWaveLineImpedance = this.lowLossHalfWaveLineImpedance.copy();
        tl.idealRefectionCoefficient = this.idealRefectionCoefficient.copy();
        tl.generalRefectionCoefficient = this.generalRefectionCoefficient.copy();
        tl.lowLossRefectionCoefficient = this.lowLossRefectionCoefficient.copy();
        tl.idealStandingWaveRatio = this.idealStandingWaveRatio;
        tl.generalStandingWaveRatio = this.generalStandingWaveRatio;
        tl.lowLossStandingWaveRatio = this.lowLossStandingWaveRatio;
        tl.idealABCDmatrix = this.idealABCDmatrix.copy();
        tl.generalABCDmatrix = this.generalABCDmatrix.copy();
        tl.lowLossABCDmatrix = this.lowLossABCDmatrix.copy();
        tl.numberOfPoints = this.numberOfPoints;
        return tl;
    }

    @Override
    public Object clone() {
        SurfaceStripLine ret = null;
        if (this != null) {
            SurfaceStripLine tl = new SurfaceStripLine();
            tl.formulaOption = this.formulaOption;
            tl.trackWidth = this.trackWidth;
            tl.effectiveTrackWidth = this.effectiveTrackWidth;
            tl.trackThickness = this.trackThickness;
            tl.plateSeparation = this.plateSeparation;
            tl.separationSet = this.separationSet;
            tl.thicknessSet = this.thicknessSet;
            tl.widthSet = this.widthSet;
            tl.z0calculated = this.z0calculated;
            tl.relativePermittivity = this.relativePermittivity;
            tl.effectivePermittivity = this.effectivePermittivity;
            tl.relativePermeability = this.relativePermeability;
            tl.permittivitySet = this.permittivitySet;
            tl.title = this.title;
            tl.distributedResistance = this.distributedResistance;
            tl.distributedConductance = this.distributedConductance;
            tl.distributedCapacitance = this.distributedCapacitance;
            tl.distributedInductance = this.distributedInductance;
            tl.distributedImpedance = this.distributedImpedance.copy();
            tl.distributedAdmittance = this.distributedAdmittance.copy();
            tl.loadImpedance = this.loadImpedance.copy();
            tl.lineLength = this.lineLength;
            tl.segmentLength = this.segmentLength;
            tl.frequency = this.frequency;
            tl.segmentLength = this.segmentLength;
            tl.omega = this.omega;
            tl.inputVoltage = this.inputVoltage.copy();
            tl.inputCurrent = this.inputCurrent.copy();
            tl.outputVoltage = this.outputVoltage.copy();
            tl.outputCurrent = this.outputCurrent.copy();
            tl.idealWavelength = this.idealWavelength;
            tl.generalWavelength = this.generalWavelength;
            tl.lowLossWavelength = this.lowLossWavelength;
            tl.idealPhaseVelocity = this.idealPhaseVelocity;
            tl.generalPhaseVelocity = this.generalPhaseVelocity;
            tl.lowLossPhaseVelocity = this.lowLossPhaseVelocity;
            tl.idealGroupVelocity = this.idealGroupVelocity;
            tl.generalGroupVelocity = this.generalGroupVelocity;
            tl.lowLossGroupVelocity = this.lowLossGroupVelocity;
            tl.delta = this.delta;
            tl.idealAttenuationConstant = this.idealAttenuationConstant;
            tl.generalAttenuationConstant = this.generalAttenuationConstant;
            tl.lowLossAttenuationConstant = this.lowLossAttenuationConstant;
            tl.idealPhaseConstant = this.idealPhaseConstant;
            tl.generalPhaseConstant = this.generalPhaseConstant;
            tl.lowLossPhaseConstant = this.lowLossPhaseConstant;
            tl.idealPropagationConstant = this.idealPropagationConstant.copy();
            tl.loadImpedance = this.loadImpedance.copy();
            tl.loadImpedance = this.loadImpedance.copy();
            tl.loadImpedance = this.loadImpedance.copy();
            tl.generalPropagationConstant = this.generalPropagationConstant.copy();
            tl.lowLossPropagationConstant = this.lowLossPropagationConstant.copy();
            tl.idealCharacteristicImpedance = this.idealCharacteristicImpedance.copy();
            tl.idealRealCharacteristicImpedance = this.idealRealCharacteristicImpedance;
            tl.generalCharacteristicImpedance = this.generalCharacteristicImpedance.copy();
            tl.lowLossCharacteristicImpedance = this.lowLossCharacteristicImpedance.copy();
            tl.idealInputImpedance = this.idealInputImpedance.copy();
            tl.generalInputImpedance = this.generalInputImpedance.copy();
            tl.lowLossInputImpedance = this.lowLossInputImpedance.copy();
            tl.idealShortedLineImpedance = this.idealShortedLineImpedance.copy();
            tl.generalShortedLineImpedance = this.generalShortedLineImpedance.copy();
            tl.lowLossShortedLineImpedance = this.lowLossShortedLineImpedance.copy();
            tl.idealOpenLineImpedance = this.idealOpenLineImpedance.copy();
            tl.generalOpenLineImpedance = this.generalOpenLineImpedance.copy();
            tl.lowLossOpenLineImpedance = this.lowLossOpenLineImpedance.copy();
            tl.idealQuarterWaveLineImpedance = this.idealQuarterWaveLineImpedance.copy();
            tl.generalQuarterWaveLineImpedance = this.generalQuarterWaveLineImpedance.copy();
            tl.lowLossQuarterWaveLineImpedance = this.lowLossQuarterWaveLineImpedance.copy();
            tl.idealHalfWaveLineImpedance = this.idealHalfWaveLineImpedance.copy();
            tl.generalHalfWaveLineImpedance = this.generalHalfWaveLineImpedance.copy();
            tl.lowLossHalfWaveLineImpedance = this.lowLossHalfWaveLineImpedance.copy();
            tl.idealRefectionCoefficient = this.idealRefectionCoefficient.copy();
            tl.generalRefectionCoefficient = this.generalRefectionCoefficient.copy();
            tl.lowLossRefectionCoefficient = this.lowLossRefectionCoefficient.copy();
            tl.idealStandingWaveRatio = this.idealStandingWaveRatio;
            tl.generalStandingWaveRatio = this.generalStandingWaveRatio;
            tl.lowLossStandingWaveRatio = this.lowLossStandingWaveRatio;
            tl.idealABCDmatrix = this.idealABCDmatrix.copy();
            tl.generalABCDmatrix = this.generalABCDmatrix.copy();
            tl.lowLossABCDmatrix = this.lowLossABCDmatrix.copy();
            tl.numberOfPoints = this.numberOfPoints;
            ret = tl;
        }
        return ret;
    }
}

