/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.vcf;

import ca.mcgill.mcb.pcingola.vcf.VcfInfo;
import ca.mcgill.mcb.pcingola.vcf.VcfInfoType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class VcfHeader {
    StringBuffer header = new StringBuffer();
    HashMap<String, VcfInfo> vcfInfoById;

    public void addFormat(String formatName, String number, String type, String description) {
        String headerFormatInfo = "##FORMAT=<ID=" + formatName + ",Number=" + number + ",Type=" + type + ",Description=\"" + description + "\">";
        this.addLine(headerFormatInfo);
    }

    public void addLine(String newHeaderLine) {
        String[] headerLines = this.header.toString().split("\n");
        this.header = new StringBuffer();
        boolean added = false;
        for (String line : headerLines) {
            if (line.equals(newHeaderLine)) {
                newHeaderLine = null;
                added = true;
            } else if (line.startsWith("#CHROM") && newHeaderLine != null) {
                this.header.append(newHeaderLine + "\n");
                added = true;
            }
            if (line.isEmpty()) continue;
            this.header.append(line + "\n");
        }
        if (!added) {
            this.header.append(newHeaderLine + "\n");
        }
    }

    public List<String> getSampleNames() {
        String[] headerLines;
        for (String line : headerLines = this.header.toString().split("\n")) {
            if (!line.startsWith("#CHROM")) continue;
            String[] titles = line.split("\t");
            ArrayList<String> sampleNames = new ArrayList<String>();
            for (int i = 9; i < titles.length; ++i) {
                sampleNames.add(titles[i]);
            }
            return sampleNames;
        }
        return null;
    }

    public Collection<VcfInfo> getVcfInfo() {
        this.parseInfoLines();
        return this.vcfInfoById.values();
    }

    public VcfInfo getVcfInfo(String id) {
        this.parseInfoLines();
        return this.vcfInfoById.get(id);
    }

    public void parseInfoLines() {
        if (this.vcfInfoById == null) {
            String[] headerLines;
            this.vcfInfoById = new HashMap();
            this.vcfInfoById.put("CHROM", new VcfInfo("CHROM", VcfInfoType.String, "1", "Chromosome name"));
            this.vcfInfoById.put("POS", new VcfInfo("POS", VcfInfoType.Integer, "1", "Position in chromosome"));
            this.vcfInfoById.put("ID", new VcfInfo("ID", VcfInfoType.String, "1", "Variant ID"));
            this.vcfInfoById.put("REF", new VcfInfo("REF", VcfInfoType.String, "1", "Reference sequence"));
            this.vcfInfoById.put("ALT", new VcfInfo("ALT", VcfInfoType.String, "A", "Alternative sequence/s"));
            this.vcfInfoById.put("QUAL", new VcfInfo("QUAL", VcfInfoType.Float, "1", "Mapping quality"));
            this.vcfInfoById.put("FILTER", new VcfInfo("FILTER", VcfInfoType.String, "1", "Filter status"));
            this.vcfInfoById.put("FORMAT", new VcfInfo("FORMAT", VcfInfoType.String, "1", "Format in genotype fields"));
            this.vcfInfoById.put("AA", new VcfInfo("AA", VcfInfoType.String, "1", "Ancestral allele"));
            this.vcfInfoById.put("AC", new VcfInfo("AC", VcfInfoType.Integer, "A", "Allele Frequency"));
            this.vcfInfoById.put("AF", new VcfInfo("AF", VcfInfoType.Float, "1", "Allele Frequency"));
            this.vcfInfoById.put("AN", new VcfInfo("AN", VcfInfoType.Integer, "1", "Total number of alleles"));
            this.vcfInfoById.put("BQ", new VcfInfo("BQ", VcfInfoType.Float, "1", "RMS base quality"));
            this.vcfInfoById.put("CIGAR", new VcfInfo("CIGAR", VcfInfoType.String, "1", "Cigar string describing how to align an alternate allele to the reference allele"));
            this.vcfInfoById.put("DB", new VcfInfo("DB", VcfInfoType.Flag, "1", "dbSNP membership"));
            this.vcfInfoById.put("DP", new VcfInfo("DP", VcfInfoType.Integer, "1", "Combined depth across samples"));
            this.vcfInfoById.put("END", new VcfInfo("END", VcfInfoType.String, "1", "End position of the variant described in this record"));
            this.vcfInfoById.put("H2", new VcfInfo("H2", VcfInfoType.Flag, "1", "Membership in hapmap 2"));
            this.vcfInfoById.put("H3", new VcfInfo("H3", VcfInfoType.Flag, "1", "Membership in hapmap 3"));
            this.vcfInfoById.put("MQ", new VcfInfo("MQ", VcfInfoType.Float, "1", "RMS mapping quality"));
            this.vcfInfoById.put("MQ0", new VcfInfo("MQ0", VcfInfoType.Integer, "1", "Number of MAPQ == 0 reads covering this record"));
            this.vcfInfoById.put("NS", new VcfInfo("NS", VcfInfoType.Integer, "1", "Number of samples with data"));
            this.vcfInfoById.put("SB", new VcfInfo("SB", VcfInfoType.Float, "1", "Strand bias at this position"));
            this.vcfInfoById.put("SOMATIC", new VcfInfo("SOMATIC", VcfInfoType.Flag, "1", "Indicates that the record is a somatic mutation, for cancer genomics"));
            this.vcfInfoById.put("VALIDATED", new VcfInfo("VALIDATED", VcfInfoType.Flag, "1", "Validated by follow-up experiment"));
            this.vcfInfoById.put("1000G", new VcfInfo("1000G", VcfInfoType.Flag, "1", "Membership in 1000 Genomes"));
            this.vcfInfoById.put("IMPRECISE", new VcfInfo("IMPRECISE", VcfInfoType.Flag, "0", "Imprecise structural variation"));
            this.vcfInfoById.put("NOVEL", new VcfInfo("NOVEL", VcfInfoType.Flag, "0", "Indicates a novel structural variation"));
            this.vcfInfoById.put("END", new VcfInfo("END", VcfInfoType.Integer, "1", "End position of the variant described in this record"));
            this.vcfInfoById.put("SVTYPE", new VcfInfo("SVTYPE", VcfInfoType.String, "1", "Type of structural variant"));
            this.vcfInfoById.put("SVLEN", new VcfInfo("SVLEN", VcfInfoType.Integer, ".", "Difference in length between REF and ALT alleles"));
            this.vcfInfoById.put("CIPOS", new VcfInfo("CIPOS", VcfInfoType.Integer, "2", "Confidence interval around POS for imprecise variants"));
            this.vcfInfoById.put("CIEND", new VcfInfo("CIEND", VcfInfoType.Integer, "2", "Confidence interval around END for imprecise variants"));
            this.vcfInfoById.put("HOMLEN", new VcfInfo("HOMLEN", VcfInfoType.Integer, ".", "Length of base pair identical micro-homology at event breakpoints"));
            this.vcfInfoById.put("HOMSEQ", new VcfInfo("HOMSEQ", VcfInfoType.String, ".", "Sequence of base pair identical micro-homology at event breakpoints"));
            this.vcfInfoById.put("BKPTID", new VcfInfo("BKPTID", VcfInfoType.String, ".", "ID of the assembled alternate allele in the assembly file"));
            this.vcfInfoById.put("MEINFO", new VcfInfo("MEINFO", VcfInfoType.String, "4", "Mobile element info of the form NAME,START,END,POLARITY"));
            this.vcfInfoById.put("METRANS", new VcfInfo("METRANS", VcfInfoType.String, "4", "Mobile element transduction info of the form CHR,START,END,POLARITY"));
            this.vcfInfoById.put("DGVID", new VcfInfo("DGVID", VcfInfoType.String, "1", "ID of this element in Database of Genomic Variation"));
            this.vcfInfoById.put("DBVARID", new VcfInfo("DBVARID", VcfInfoType.String, "1", "ID of this element in DBVAR"));
            this.vcfInfoById.put("DBRIPID", new VcfInfo("DBRIPID", VcfInfoType.String, "1", "ID of this element in DBRIP"));
            this.vcfInfoById.put("MATEID", new VcfInfo("MATEID", VcfInfoType.String, ".", "ID of mate breakends"));
            this.vcfInfoById.put("PARID", new VcfInfo("PARID", VcfInfoType.String, "1", "ID of partner breakend"));
            this.vcfInfoById.put("EVENT", new VcfInfo("EVENT", VcfInfoType.String, "1", "ID of event associated to breakend"));
            this.vcfInfoById.put("CILEN", new VcfInfo("CILEN", VcfInfoType.Integer, "2", "Confidence interval around the length of the inserted material between breakends"));
            this.vcfInfoById.put("DP", new VcfInfo("DP", VcfInfoType.Integer, "1", "Read Depth of segment containing breakend"));
            this.vcfInfoById.put("DPADJ", new VcfInfo("DPADJ", VcfInfoType.Integer, ".", "Read Depth of adjacency"));
            this.vcfInfoById.put("CN", new VcfInfo("CN", VcfInfoType.Integer, "1", "Copy number of segment containing breakend"));
            this.vcfInfoById.put("CNADJ", new VcfInfo("CNADJ", VcfInfoType.Integer, ".", "Copy number of adjacency"));
            this.vcfInfoById.put("CICN", new VcfInfo("CICN", VcfInfoType.Integer, "2", "Confidence interval around copy number for the segment"));
            this.vcfInfoById.put("CICNADJ", new VcfInfo("CICNADJ", VcfInfoType.Integer, ".", "Confidence interval around copy number for the adjacency"));
            this.vcfInfoById.put("EFF.EFFECT", new VcfInfo("EFF.EFFECT", VcfInfoType.String, ".", "SnpEff effect"));
            this.vcfInfoById.put("EFF.IMPACT", new VcfInfo("EFF.IMPACT", VcfInfoType.String, ".", "SnpEff impact (HIGH, MODERATE, LOW, MODIFIER)"));
            this.vcfInfoById.put("EFF.FUNCLASS", new VcfInfo("EFF.FUNCLASS", VcfInfoType.String, ".", "SnpEff functional class (NONE, SILENT, MISSENSE, NONSENSE)"));
            this.vcfInfoById.put("EFF.CODON", new VcfInfo("EFF.CODON", VcfInfoType.String, ".", "SnpEff codon change"));
            this.vcfInfoById.put("EFF.AA", new VcfInfo("EFF.AA", VcfInfoType.String, ".", "SnpEff amino acid change"));
            this.vcfInfoById.put("EFF.AA_LEN", new VcfInfo("EFF.AA_LEN", VcfInfoType.Integer, ".", "Protein length in amino acids"));
            this.vcfInfoById.put("EFF.GENE", new VcfInfo("EFF.GENE", VcfInfoType.String, ".", "SnpEff gene name"));
            this.vcfInfoById.put("EFF.BIOTYPE", new VcfInfo("EFF.BIOTYPE", VcfInfoType.String, ".", "SnpEff gene bio-type"));
            this.vcfInfoById.put("EFF.CODING", new VcfInfo("EFF.CODING", VcfInfoType.String, ".", "SnpEff gene coding (CODING, NON_CODING)"));
            this.vcfInfoById.put("EFF.TRID", new VcfInfo("EFF.TRID", VcfInfoType.String, ".", "SnpEff transcript ID"));
            this.vcfInfoById.put("EFF.EXID", new VcfInfo("EFF.EXID", VcfInfoType.String, ".", "SnpEff exon ID"));
            this.vcfInfoById.put("LOF.GENE", new VcfInfo("LOF.GENE", VcfInfoType.String, ".", "SnpEff LOF gene name"));
            this.vcfInfoById.put("LOF.GENEID", new VcfInfo("LOF.GENEID", VcfInfoType.String, ".", "SnpEff LOF gene ID"));
            this.vcfInfoById.put("LOF.NUMTR", new VcfInfo("LOF.NUMTR", VcfInfoType.Integer, ".", "SnpEff LOF number of transcripts in gene"));
            this.vcfInfoById.put("LOF.PERC", new VcfInfo("LOF.PERC", VcfInfoType.Float, ".", "SnpEff LOF percentage of transcripts in this gene that are affected"));
            this.vcfInfoById.put("NMD.GENE", new VcfInfo("NMD.GENE", VcfInfoType.String, ".", "SnpEff NMD gene name"));
            this.vcfInfoById.put("NMD.GENEID", new VcfInfo("NMD.GENEID", VcfInfoType.String, ".", "SnpEff NMD gene ID"));
            this.vcfInfoById.put("NMD.NUMTR", new VcfInfo("NMD.NUMTR", VcfInfoType.Integer, ".", "SnpEff NMD number of transcripts in gene"));
            this.vcfInfoById.put("NMD.PERC", new VcfInfo("NMD.PERC", VcfInfoType.Float, ".", "SnpEff NMD percentage of transcripts in this gene that are affected"));
            for (String line : headerLines = this.header.toString().split("\n")) {
                if (!line.startsWith("##INFO=") && !line.startsWith("##FORMAT=")) continue;
                VcfInfo vcfInfo = new VcfInfo(line);
                this.vcfInfoById.put(vcfInfo.getId(), vcfInfo);
            }
        }
    }

    public String toString() {
        if (this.header.length() <= 0) {
            return "";
        }
        char c = this.header.charAt(this.header.length() - 1);
        while (c == '\n' || c == '\r') {
            this.header.deleteCharAt(this.header.length() - 1);
            c = this.header.charAt(this.header.length() - 1);
        }
        return this.header.toString();
    }
}

