/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.binseq.DnaSequence;
import ca.mcgill.mcb.pcingola.overlap.OverlapDnaSeq;
import junit.framework.TestCase;

public class TestCaseOverlap
extends TestCase {
    void checkOverlap(String seq1, String seq2, int score, int offset) {
        DnaSequence bs1 = new DnaSequence(seq1);
        DnaSequence bs2 = new DnaSequence(seq2);
        OverlapDnaSeq obs = new OverlapDnaSeq();
        obs.setMinOverlap(1);
        obs.overlap(bs1, bs2);
        TestCaseOverlap.assertEquals((int)score, (int)obs.getBestScore());
        TestCaseOverlap.assertEquals((int)offset, (int)obs.getBestOffset());
    }

    public void test_binSeq_01() {
        this.checkOverlap("acgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgt", "acgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgt", 0, 0);
    }

    public void test_binSeq_02() {
        this.checkOverlap("acgt", "acgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgt", 0, 0);
    }

    public void test_binSeq_03() {
        this.checkOverlap("acgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgt", "acgt", 0, 0);
    }

    public void test_binSeq_04() {
        this.checkOverlap("acgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgt", "acgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgt", 0, 0);
    }

    public void test_binSeq_05() {
        this.checkOverlap("acgt", "acgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgt", 0, 0);
    }

    public void test_binSeq_06() {
        this.checkOverlap("acgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgt", "acgt", 0, 0);
    }

    public void test_binSeq_07() {
        this.checkOverlap("acgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgt", "ttttacgt", 0, 4);
    }

    public void test_binSeq_08() {
        this.checkOverlap("ttttacgt", "acgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgt", 0, -4);
    }

    public void test_binSeq_09() {
        this.checkOverlap("acgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgt", "acgttttt", 0, -60);
    }

    public void test_binSeq_10() {
        this.checkOverlap("acgttttt", "acgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgtacgt", 0, 60);
    }

    public void test_binSeq_11() {
        this.checkOverlap("", "", 0, 0);
    }

    public void test_binSeq_12() {
        this.checkOverlap("aaaaaaaaaaaaaaaa", "tttttttttttttttt", 1, 15);
    }

    public void test_binSeq_13() {
        this.checkOverlap("ttttttttttttttttttttttttttttttttaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaccccccccccccccccccccccccccccccccggggggggggggggggggggggggggggggggtttttttttttttttttttttttttttttttt", 0, -32);
    }
}

