/*
 * Decompiled with CFR 0.152.
 */
package flanagan.interpolation;

import flanagan.interpolation.CubicSpline;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;

public class CubicInterpolation {
    private int nPoints = 0;
    private double[] x = null;
    private double[] y = null;
    private double[] dydx = null;
    private boolean derivCalculated = false;
    private CubicSpline cs = null;
    private double incrX = 0.0;
    double[][] coeff = null;
    private double xx = Double.NaN;
    private double[][] weights = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {-3.0, 3.0, -2.0, -1.0}, {2.0, -2.0, 1.0, 1.0}};
    private int[] xIndices = null;
    private double xMin = 0.0;
    private double xMax = 0.0;
    private double interpolatedValue = Double.NaN;
    private double interpolatedDydx = Double.NaN;
    private boolean numerDiffFlag = true;
    private static double delta = 0.001;
    private static double potentialRoundingError = 5.0E-15;
    private static boolean roundingCheck = false;

    public CubicInterpolation(double[] x, double[] y, int numerDiffOption) {
        if (numerDiffOption == 0) {
            this.numerDiffFlag = false;
        } else if (numerDiffOption == 1) {
            this.numerDiffFlag = true;
        } else {
            throw new IllegalArgumentException("The numerical differencing option, " + numerDiffOption + ", must be 0 or 1");
        }
        this.initialize(Conv.copy(x), Conv.copy(y));
        this.calcDeriv();
        this.gridCoefficients();
    }

    public CubicInterpolation(double[] x, double[] y, double[] dydx) {
        this.initialize(Conv.copy(x), Conv.copy(y), Conv.copy(dydx));
        this.gridCoefficients();
    }

    private void initialize(double[] x, double[] y) {
        this.initialize(x, y, null, false);
    }

    private void initialize(double[] x, double[] y, double[] dydx) {
        this.initialize(x, y, dydx, true);
    }

    private void initialize(double[] x, double[] y, double[] dydx, boolean flag) {
        int i;
        int nPoints;
        int nl = 3;
        if (flag) {
            nl = 2;
        }
        if ((nPoints = x.length) != y.length) {
            throw new IllegalArgumentException("Arrays x and y-row are of different length " + nPoints + " " + y.length);
        }
        if (nPoints < nl) {
            throw new IllegalArgumentException("The data matrix must have a minimum size of " + nl + " X " + nl);
        }
        ArrayMaths am = new ArrayMaths(x);
        am = am.sort();
        this.xIndices = am.originalIndices();
        x = am.array();
        double[] hold = new double[nPoints];
        for (i = 0; i < nPoints; ++i) {
            hold[i] = y[this.xIndices[i]];
        }
        for (i = 0; i < nPoints; ++i) {
            y[i] = hold[i];
        }
        if (flag) {
            for (i = 0; i < nPoints; ++i) {
                hold[i] = dydx[this.xIndices[i]];
            }
            for (i = 0; i < nPoints; ++i) {
                dydx[i] = hold[i];
            }
        }
        for (i = 1; i < nPoints; ++i) {
            int j;
            if (x[i] != x[i - 1]) continue;
            System.out.println("x[" + this.xIndices[i] + "] and x[" + this.xIndices[i + 1] + "] are identical, " + x[i]);
            System.out.println("The y values have been averaged and one point has been deleted");
            y[i - 1] = (y[i - 1] + y[i]) / 2.0;
            for (j = i; j < nPoints - 1; ++j) {
                x[j] = x[j + 1];
                y[j] = y[j + 1];
                this.xIndices[j] = this.xIndices[j + 1];
            }
            if (flag) {
                dydx[i - 1] = (dydx[i - 1] + dydx[i]) / 2.0;
                for (j = i; j < nPoints - 1; ++j) {
                    dydx[j] = dydx[j + 1];
                }
            }
            --nPoints;
        }
        this.nPoints = nPoints;
        this.x = new double[this.nPoints];
        this.y = new double[this.nPoints];
        this.dydx = new double[this.nPoints];
        for (i = 0; i < this.nPoints; ++i) {
            this.x[i] = x[i];
            this.y[i] = y[i];
        }
        if (flag) {
            for (int j = 0; j < this.nPoints; ++j) {
                this.dydx[j] = dydx[j];
            }
            this.derivCalculated = true;
        }
        this.xMin = Fmath.minimum(this.x);
        this.xMax = Fmath.maximum(this.x);
        if (!flag && this.numerDiffFlag) {
            double minSep;
            double range = this.xMax - this.xMin;
            double averageSeparation = range / (double)this.nPoints;
            double minimumSeparation = minSep = this.x[1] - this.x[0];
            for (int i2 = 2; i2 < this.nPoints; ++i2) {
                minSep = this.x[i2] - this.x[i2 - 1];
                if (!(minSep < minimumSeparation)) continue;
                minimumSeparation = minSep;
            }
            this.incrX = range * delta;
            double defaultIncr = minimumSeparation;
            if (minimumSeparation < averageSeparation / 10.0) {
                defaultIncr = averageSeparation / 10.0;
            }
            if (this.incrX > averageSeparation) {
                this.incrX = defaultIncr;
            }
        }
    }

    private void calcDeriv() {
        if (this.numerDiffFlag) {
            int i;
            this.cs = new CubicSpline(this.x, this.y);
            double[] xjp1 = new double[this.nPoints];
            double[] xjm1 = new double[this.nPoints];
            for (i = 0; i < this.nPoints; ++i) {
                xjp1[i] = this.x[i] + this.incrX;
                if (xjp1[i] > this.x[this.nPoints - 1]) {
                    xjp1[i] = this.x[this.nPoints - 1];
                }
                xjm1[i] = this.x[i] - this.incrX;
                if (!(xjm1[i] < this.x[0])) continue;
                xjm1[i] = this.x[0];
            }
            for (i = 0; i < this.nPoints; ++i) {
                this.dydx[i] = (this.cs.interpolate(xjp1[i]) - this.cs.interpolate(xjm1[i])) / (xjp1[i] - xjm1[i]);
            }
        } else {
            int iip = 0;
            int iim = 0;
            for (int i = 0; i < this.nPoints; ++i) {
                iip = i + 1;
                if (iip >= this.nPoints) {
                    iip = this.nPoints - 1;
                }
                if ((iim = i - 1) < 0) {
                    iim = 0;
                }
                this.dydx[i] = (this.y[iip] - this.y[iim]) / (this.x[iip] - this.x[iim]);
            }
        }
        this.derivCalculated = true;
    }

    private void gridCoefficients() {
        double[] xt = new double[4];
        this.coeff = new double[this.nPoints][4];
        double d1 = 0.0;
        for (int i = 0; i < this.nPoints - 1; ++i) {
            d1 = this.x[i + 1] - this.x[i];
            xt[0] = this.y[i];
            xt[1] = this.y[i + 1];
            xt[2] = this.dydx[i] * d1;
            xt[3] = this.dydx[i + 1] * d1;
            double xh = 0.0;
            for (int k = 0; k < 4; ++k) {
                for (int kk = 0; kk < 4; ++kk) {
                    xh += this.weights[k][kk] * xt[kk];
                }
                this.coeff[i][k] = xh;
                xh = 0.0;
            }
        }
    }

    public double interpolate(double xx) {
        int i;
        if (xx < this.x[0]) {
            if (xx >= this.x[0] - potentialRoundingError) {
                xx = this.x[0];
            } else {
                throw new IllegalArgumentException(xx + " is outside the limits, " + this.x[0] + " - " + this.x[this.nPoints - 1]);
            }
        }
        if (xx > this.x[this.nPoints - 1]) {
            if (xx <= this.x[this.nPoints - 1] + potentialRoundingError) {
                xx = this.x[this.nPoints - 1];
            } else {
                throw new IllegalArgumentException(xx + " is outside the limits, " + this.x[0] + " - " + this.x[this.nPoints - 1]);
            }
        }
        this.xx = xx;
        int gridn = 0;
        int counter = 1;
        boolean test = true;
        while (test) {
            if (xx < this.x[counter]) {
                gridn = counter - 1;
                test = false;
                continue;
            }
            if (++counter < this.nPoints) continue;
            gridn = this.nPoints - 2;
            test = false;
        }
        double xNormalised = (xx - this.x[gridn]) / (this.x[gridn + 1] - this.x[gridn]);
        this.interpolatedValue = 0.0;
        for (i = 0; i < 4; ++i) {
            this.interpolatedValue += this.coeff[gridn][i] * Math.pow(xNormalised, i);
        }
        this.interpolatedDydx = 0.0;
        for (i = 1; i < 4; ++i) {
            this.interpolatedDydx += (double)i * this.coeff[gridn][i] * Math.pow(xNormalised, i - 1);
        }
        return this.interpolatedValue;
    }

    public double[] getInterpolatedValues() {
        double[] ret = new double[]{this.interpolatedValue, this.interpolatedDydx, this.xx};
        return ret;
    }

    public double[] getGridDydx() {
        double[] ret = new double[this.nPoints];
        for (int i = 0; i < this.nPoints; ++i) {
            ret[this.xIndices[i]] = this.dydx[i];
        }
        return ret;
    }

    public static void resetDelta(double delta) {
        CubicInterpolation.delta = delta;
    }

    public static void noRoundingErrorCheck() {
        roundingCheck = false;
        potentialRoundingError = 0.0;
    }

    public static void potentialRoundingError(double potentialRoundingError) {
        CubicInterpolation.potentialRoundingError = potentialRoundingError;
    }

    public double getXmin() {
        return this.xMin;
    }

    public double getXmax() {
        return this.xMax;
    }

    public double[] getLimits() {
        double[] limits = new double[]{this.xMin, this.xMax};
        return limits;
    }

    public void displayLimits() {
        System.out.println(" ");
        System.out.println("The limits to the x array are " + this.xMin + " and " + this.xMax);
        System.out.println(" ");
    }
}

