/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.VEP;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class VepFunctions {
    private static final String[] headers = new String[]{"Allele", "Gene", "Feature", "Feature_type", "Consequence", "cDNA_position", "CDS_position", "Protein_position", "Amino_acids", "Codons", "Existing_variation", "HGNC", "DISTANCE", "SIFT", "PolyPhen", "CELL_TYPE"};

    public JsonArray vepCsqToJsonList(String vepCsq) {
        JsonArray jsonArray = new JsonArray();
        if (vepCsq.contains("VEPERR")) {
            JsonObject jObj = new JsonObject();
            jObj.addProperty("VEPMessage", "VEPERRORMessage");
            jObj.addProperty("Status", "VEP failed to assign function to this variant");
            jsonArray.add((JsonElement)jObj);
        } else {
            String[] vepCsqItems;
            for (String csqItem : vepCsqItems = vepCsq.replace("CSQ=", "").split(",")) {
                jsonArray.add((JsonElement)this.vepCsqToJson(csqItem));
            }
        }
        return jsonArray;
    }

    private JsonObject vepCsqToJson(String vepCsqItem) {
        String[] split = vepCsqItem.split("\\|");
        JsonObject jsonObj = new JsonObject();
        for (int i = 0; i < Math.min(split.length, headers.length); ++i) {
            if ("".equals(split[i])) continue;
            jsonObj.addProperty(headers[i], split[i]);
        }
        boolean isSiftPresent = false;
        if (split.length > 13 && split[13].contains("(") && split[13].contains(")")) {
            isSiftPresent = true;
            Effect sift = this.parseEffect(split[13]);
            jsonObj.addProperty("SIFT_TERM", sift.term);
            jsonObj.addProperty("SIFT_Score", (Number)sift.score);
        }
        if (split.length > 14 && split[14].contains("(") && split[14].contains(")")) {
            Effect polyphen = this.parseEffect(split[14]);
            jsonObj.addProperty("PolyPhen_TERM", polyphen.term);
            jsonObj.addProperty("PolyPhen_Score", (Number)polyphen.score);
        }
        return jsonObj;
    }

    private Effect parseEffect(String effStr) {
        int idxOpenParen = effStr.indexOf("(");
        int idxCloseParen = effStr.indexOf(")");
        if (idxOpenParen == -1 || idxCloseParen == -1) {
            return null;
        }
        Effect effect = new Effect();
        effect.term = effStr.substring(0, idxOpenParen);
        effect.score = Double.parseDouble(effStr.substring(idxOpenParen + 1, idxCloseParen));
        return effect;
    }

    public JsonObject getWorstCase(JsonArray jsonArray) {
        Double worstSift = 1.0;
        Double worstPoly = Double.MAX_VALUE;
        JsonObject worstJson = new JsonObject();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject jsonObj = jsonArray.get(i).getAsJsonObject();
            JsonElement siftScore = jsonObj.get("SIFT_Score");
            JsonElement polyphenScore = jsonObj.get("PolyPhen_Score");
            if (siftScore == null || polyphenScore == null || !worstJson.entrySet().isEmpty() && (!(siftScore.getAsDouble() <= worstSift) || !(polyphenScore.getAsDouble() >= worstPoly))) continue;
            worstSift = siftScore.getAsDouble();
            worstPoly = polyphenScore.getAsDouble();
            worstJson = jsonObj;
        }
        return worstJson;
    }

    class Effect {
        public String term;
        public Double score;

        Effect() {
        }
    }
}

