/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat;

import com.tinkerpop.pipes.PipeFunction;
import edu.mayo.exec.AbnormalExitException;
import edu.mayo.exec.UnixStreamCommand;
import edu.mayo.pipes.history.History;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class AnnotateEXE
implements PipeFunction<History, History> {
    private static final Logger sLogger = Logger.getLogger(AnnotateEXE.class);
    private UnixStreamCommand mAnnotate;
    private String mEndLine;
    private boolean mWasEndLineSent = false;
    private boolean mIsEndLineInQ = false;
    private static final long RECEIVE_TIMEOUT = 10L;
    private Queue<History> mInQueue = new LinkedList<History>();
    private int mMaxLinesInFlight = 20;
    private List<History> mInFlightQ = new ArrayList<History>();

    public AnnotateEXE(String[] annotateCmd, Map<String, String> environmentProps, String END_LINE, int maxLinesInFlight) throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException {
        this.mEndLine = END_LINE;
        this.mMaxLinesInFlight = maxLinesInFlight;
        this.mAnnotate = new UnixStreamCommand(annotateCmd, environmentProps, true, false);
        this.mAnnotate.launch();
        this.mAnnotate.send("#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO");
        this.mAnnotate.send("1\t1\trs0\tG\tA\t0.0\t.\t.");
        String result = "#";
        while (result.startsWith("#")) {
            result = this.mAnnotate.receive();
        }
    }

    public History compute(History vcfLineHistory) {
        try {
            this.sendLine(vcfLineHistory);
            return this.receiveLine(vcfLineHistory);
        }
        catch (RuntimeException runtimeExc) {
            sLogger.debug((Object)"No more data.  Ending...");
            this.terminate();
            throw runtimeExc;
        }
        catch (Exception ex) {
            this.terminate();
            sLogger.error((Object)ex);
            throw new NoSuchElementException();
        }
    }

    private void sendLine(History vcfLineHistory) throws AbnormalExitException, InterruptedException {
        if (!this.mWasEndLineSent) {
            if (!this.mIsEndLineInQ) {
                this.mInQueue.add(vcfLineHistory);
                String vcfLine = vcfLineHistory.getMergedData("\t");
                this.mIsEndLineInQ = vcfLine.contains(this.mEndLine);
                sLogger.info((Object)("AnnotateEXE - added line to queue (# in input queue: " + this.mInQueue.size() + ", # in flight: " + this.mInFlightQ.size() + "): " + vcfLine));
            }
            if (this.mInFlightQ.size() < this.mMaxLinesInFlight) {
                History toSend = this.mInQueue.remove();
                String strToSend = toSend.getMergedData("\t");
                sLogger.info((Object)("AnnotateEXE sending line: (# in queue: " + this.mInQueue.size() + ", # in flight: " + this.mInFlightQ.size() + "): " + strToSend));
                this.mAnnotate.send(strToSend);
                this.mInFlightQ.add(toSend);
                if (strToSend.contains(this.mEndLine)) {
                    sLogger.debug((Object)"Hit the end line, so not sending any more lines to annotate command");
                    this.mWasEndLineSent = true;
                }
            }
        }
    }

    private History receiveLine(History vcfLineHistory) throws AbnormalExitException, IOException, InterruptedException, BrokenBarrierException, ExecutionException {
        try {
            String result = this.mAnnotate.receive(10L, TimeUnit.SECONDS);
            History h = new History(result);
            if (result.startsWith("#")) {
                return h;
            }
            if (!this.isFirst5ColsSame(this.mInFlightQ.get(0), h)) {
                this.mInFlightQ.remove(0);
            }
            sLogger.info((Object)("AnnotateEXE received line (# in flight: " + this.mInFlightQ.size() + "): " + result));
            if (result.contains(this.mEndLine)) {
                throw new NoSuchElementException("AnnotateEXE: Received the end line - no more valid data being processed by bior_annotate, so end.");
            }
            return h;
        }
        catch (TimeoutException te) {
            sLogger.warn((Object)String.format("Timeout of %s seconds reached when receiving VCF line.  Last line sent was: %s", 10L, this.mInFlightQ.size() > 0 ? (Serializable)this.mInFlightQ.get(this.mInFlightQ.size() - 1) : "(not known???)"));
            vcfLineHistory.add((Object)"\t{\"ERROR\":\"Annotate timed out\"}");
            return vcfLineHistory;
        }
    }

    private boolean isFirst5ColsSame(History h1, History h2) {
        if (h1 == null && h2 == null) {
            return true;
        }
        if (h1 == null || h2 == null) {
            return false;
        }
        return h1.size() >= 5 && h2.size() >= 5 && ((String)h1.get(0)).equals(h2.get(0)) && ((String)h1.get(1)).equals(h2.get(1)) && ((String)h1.get(2)).equals(h2.get(2)) && ((String)h1.get(3)).equals(h2.get(3)) && ((String)h1.get(4)).equals(h2.get(4));
    }

    public void terminate() {
        try {
            this.mAnnotate.terminate();
        }
        catch (Exception e) {
            sLogger.error((Object)("Error terminating AnnotateEXE pipe" + e));
        }
    }
}

