/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.transform;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class PathPipe<S>
extends AbstractPipe<S, List> {
    private final PipeFunction[] pathFunctions;

    public PathPipe(PipeFunction ... pathFunctions) {
        this.pathFunctions = pathFunctions.length == 0 ? null : pathFunctions;
    }

    @Override
    public void setStarts(Iterator<S> starts) {
        super.setStarts(starts);
        this.enablePath(true);
    }

    @Override
    public List processNextStart() {
        if (this.starts instanceof Pipe) {
            this.starts.next();
            List path = ((Pipe)this.starts).getCurrentPath();
            if (null == this.pathFunctions) {
                return path;
            }
            ArrayList closedPath = new ArrayList();
            int nextFunction = 0;
            for (Object object : path) {
                closedPath.add(this.pathFunctions[nextFunction].compute(object));
                nextFunction = (nextFunction + 1) % this.pathFunctions.length;
            }
            return closedPath;
        }
        throw new NoSuchElementException("The start of this pipe was not a pipe");
    }
}

