/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.iterators;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public class GZipFileLineIterator
implements Iterator {
    static final int BUFFER = 2048;
    GzipCompressorInputStream gzip;
    FileInputStream fis;
    BufferedReader br;
    InputStreamReader isr;
    String filename = null;
    LinkedList<String> queue = new LinkedList();
    private boolean readok = true;

    public GZipFileLineIterator(String filename) throws IOException {
        this.open(filename);
    }

    @Override
    public boolean hasNext() {
        if (this.queue.size() > 0) {
            return true;
        }
        if (!this.readok) {
            return false;
        }
        try {
            String line = this.br.readLine();
            if (line != null) {
                this.queue.add(line);
                return true;
            }
            this.readok = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public String next() {
        if (this.queue.size() < 1) {
            this.hasNext();
        }
        return this.queue.pollFirst();
    }

    @Override
    public void remove() {
    }

    public BufferedReader open(String filename) throws IOException {
        this.readok = true;
        this.filename = filename;
        this.fis = new FileInputStream(filename);
        this.gzip = new GzipCompressorInputStream((InputStream)this.fis, true);
        this.isr = new InputStreamReader((InputStream)this.gzip);
        this.br = new BufferedReader(this.isr);
        return this.br;
    }

    public void close() throws IOException {
        this.br.close();
        this.isr.close();
        this.gzip.close();
        this.fis.close();
        this.readok = false;
    }
}

