/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes;

import com.tinkerpop.pipes.AbstractPipe;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class WritePipe
extends AbstractPipe<String, String> {
    private static Logger sLogger = Logger.getLogger(WritePipe.class);
    private BufferedWriter out = null;
    private boolean mIsAppendToFile = true;
    private boolean mIsAddNewLine = false;

    public WritePipe(String filename) {
        this(filename, true, false);
    }

    public WritePipe(String filename, boolean isAppendToFile) {
        this(filename, isAppendToFile, false);
    }

    public WritePipe(String filename, boolean isAppendToFile, boolean isAddNewlines) {
        this.mIsAppendToFile = isAppendToFile;
        this.mIsAddNewLine = isAddNewlines;
        try {
            this.out = new BufferedWriter(new FileWriter(filename, this.mIsAppendToFile));
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void close() throws IOException {
        this.out.close();
    }

    protected String processNextStart() throws NoSuchElementException {
        try {
            if (!this.starts.hasNext()) {
                this.out.close();
                throw new NoSuchElementException();
            }
            String s = (String)this.starts.next();
            this.out.write(s + (this.mIsAddNewLine ? "\n" : ""));
            return s;
        }
        catch (IOException ex) {
            sLogger.error((Object)"Failed writing line to file!", (Throwable)ex);
            return null;
        }
    }
}

