#!/bin/bash
#------------------------------------------------------------------------------------------
# Assumptions:
# 1) sys.properties will be loaded and the properties contain the correct path to the chr.gbs.txt files
# 2) Tabix is installed on the local machine
# 3) BIOR_CATALOG_HOME variable has been set
#------------------------------------------------------------------------------------------
# Print each line that is executed (-x), and exit if any command fails (-e)
#set -x -e
set -e
#echo $BIOR_CATALOG_HOME
#source $BIOR_CATALOG_HOME/setupEnv.sh


#------------------------------------------------------------------------------------------
# Given a raw data files (usually this is the "genemap" file, no extension) build JSON data file (which contains position + JSON)
# (did it used to be *.gbs.txt???)
#------------------------------------------------------------------------------------------
rawDataDir=$1
targetCatalogDir=$2

echo "Build JSON from raw data files"
echo "Target directory: $targetCatalogDir"
java -cp $BIOR_CATALOG_HOME/conf:$BIOR_CATALOG_HOME/lib/* edu.mayo.bior.publishers.OMIM.LoadGenes $rawDataDir $targetCatalogDir

echo "DONE."
