#!/bin/sh

# exit if any statement returns a non-zero exit code
set -e

# check java version
REQUIRED_MINOR_VERSION=${java.minor.version}

# grab full version string from running "java -version"
VERSION=`java -Xmx64m -version 2>&1 | grep "java version" | awk '{ print substr($3, 2, length($3)-2); }'`

# parse out the minor version number
MINOR_VERSION=`echo $VERSION | cut -d . -f 2`

# check minor version, anything less than the required version is invalid
if [ $MINOR_VERSION -lt $REQUIRED_MINOR_VERSION ]; then
	echo "Invalid Java version $VERSION.  Java 1.$REQUIRED_MINOR_VERSION or higher is required."
	echo "You can check your java version by running: java -version"
	exit 1
fi

${pre.jvm}

java -Dlog4j.defaultInitOverride=true ${jvm.opts} -cp ${home.env.var}/conf:${home.env.var}/lib/* edu.mayo.cli.CommandLineApp ${command.class} $0 $@

${post.jvm}