/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.util.exec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseCommandProcess {
    protected String[] mEnvironment;
    protected String[] mCmdArray;

    public BaseCommandProcess(String command, String[] commandArgs, Map<String, String> customEnv, boolean useParentEnv) {
        this.setupEnvironment(customEnv, useParentEnv);
        this.mCmdArray = this.toCommandArray(command, commandArgs);
    }

    private void setupEnvironment(Map<String, String> customEnv, boolean useParentEnv) {
        HashMap<String, String> env = new HashMap<String, String>();
        if (useParentEnv) {
            env.putAll(System.getenv());
        }
        env.putAll(customEnv);
        this.mEnvironment = this.translateMapToStrings(env);
    }

    private String[] translateMapToStrings(Map<String, String> map) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : map.keySet()) {
            String val = map.get(key);
            list.add(key + "=" + val);
        }
        return list.toArray(new String[0]);
    }

    private String[] toCommandArray(String command, String[] arguments) {
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(command);
        for (String arg : arguments) {
            cmdList.add(arg);
        }
        return cmdList.toArray(new String[0]);
    }
}

