/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.cli;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.ibm.icu.lang.UCharacter;
import edu.mayo.cli.ArgumentDefinition;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.cli.InvalidCharactersException;
import edu.mayo.cli.InvalidDataException;
import edu.mayo.cli.InvalidNumberOfArgsException;
import edu.mayo.cli.OptionDefinition;
import edu.mayo.cli.util.StringUtils;
import edu.mayo.sage.Usage;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.xml.DOMConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineApp {
    private static Logger sLogger;
    private static final int EXIT_CODE_SUCCESS = 0;
    private static final int EXIT_CODE_ERROR = 1;
    private static final String PRP_SAGE_ENVIRONMENT = "SAGE_ENVIRONMENT";
    private static final int MAX_WIDTH = 94;
    private static final char OPTION_HELP = 'h';
    private static final char OPTION_ENABLELOG = 'l';
    private CommandLineParser mParser = new PosixParser();
    private static Gson sGson;

    public static void main(String[] args) {
        for (String arg : args) {
            if (!arg.equals("-l") && !arg.equals("--log")) continue;
            CommandLineApp.turnOnLogging();
        }
        if (args.length == 0) {
            System.err.println("Usage: java " + CommandLineApp.class.getName() + " <plugin classname> <script name> <arg1> <arg2> <arg3>...");
            System.exit(1);
        }
        String pluginClassname = args[0];
        String scriptName = args[1];
        String[] cmdArgs = Arrays.copyOfRange(args, 2, args.length);
        Properties globalProps = new Properties();
        try {
            globalProps = CommandLineApp.loadGlobalProps();
        }
        catch (IOException e) {
            sLogger.warn((Object)e.getMessage(), (Throwable)e);
        }
        CommandLineApp.setupSage(globalProps);
        String appName = CommandLineApp.getShortScriptName(scriptName);
        Options opts = null;
        List<ArgumentDefinition> argDefs = null;
        try {
            CommandPlugin plugin = CommandLineApp.loadPlugin(pluginClassname);
            opts = CommandLineApp.loadOptions(plugin);
            opts.addOption(CommandLineApp.getHelpOption());
            opts.addOption(CommandLineApp.getLogfileOption());
            argDefs = CommandLineApp.loadArgumentDefinitions(plugin);
            plugin.init(globalProps);
            CommandLineApp.validateASCII(scriptName, cmdArgs);
            CommandLineApp app = new CommandLineApp();
            app.execute(plugin, cmdArgs, opts, argDefs, scriptName);
            Usage.logger().logEnd(appName);
            System.exit(0);
        }
        catch (Throwable t) {
            boolean exitCode = true;
            Usage.logger().logError(appName, t, 1);
            try {
                CommandLineApp.processError(scriptName, cmdArgs, opts, argDefs, t);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            System.exit(1);
        }
    }

    private static Properties loadGlobalProps() throws IOException {
        Properties props = new Properties();
        InputStream inStream = ClassLoader.getSystemClassLoader().getResourceAsStream("cli/Global.properties");
        if (inStream != null) {
            sLogger.debug((Object)"Found Global.properties, loading properties...");
            props.load(inStream);
        } else {
            sLogger.warn((Object)"Global.properties not found");
        }
        return props;
    }

    private static void setupSage(Properties globalProps) {
        String env = "null";
        if (globalProps.containsKey(PRP_SAGE_ENVIRONMENT)) {
            String envStr = globalProps.getProperty(PRP_SAGE_ENVIRONMENT);
            if (envStr.equalsIgnoreCase("dev")) {
                env = "dev";
            } else if (envStr.equalsIgnoreCase("prod")) {
                env = envStr;
            }
        }
        sLogger.debug((Object)String.format("JVM system property %s=%s", "edu_mayo_bsu_sage_env", env.toString()));
        System.setProperty("edu_mayo_bsu_sage_env", env);
    }

    private static void validateASCII(String scriptName, String[] cmdArgs) throws InvalidCharactersException {
        CharsetEncoder encoder = Charset.forName("US-ASCII").newEncoder();
        StringBuilder mesg = new StringBuilder();
        ArrayList<Character> nonAsciiChars = new ArrayList<Character>();
        mesg.append(CommandLineApp.getShortScriptName(scriptName));
        mesg.append(' ');
        for (String cmdArg : cmdArgs) {
            for (char c : cmdArg.toCharArray()) {
                if (encoder.canEncode(c)) {
                    mesg.append(c);
                    continue;
                }
                mesg.append('[');
                mesg.append(c);
                mesg.append(']');
                nonAsciiChars.add(new Character(c));
            }
            mesg.append(' ');
        }
        if (nonAsciiChars.size() > 0) {
            StringWriter sWtr = new StringWriter();
            PrintWriter pWtr = new PrintWriter(sWtr);
            pWtr.println(String.format("Found non-ASCII characters.  Please correct the characters highlighted with [ ]:", new Object[0]));
            pWtr.println();
            pWtr.println('\t' + mesg.toString());
            pWtr.println();
            for (Character c : nonAsciiChars) {
                String name = UCharacter.getName((int)c.charValue());
                pWtr.println(String.format("\t[%s]  UTF-8 character \"%s\"", c.toString(), name));
            }
            pWtr.close();
            throw new InvalidCharactersException(sWtr.toString());
        }
    }

    private static List<ArgumentDefinition> loadArgumentDefinitions(CommandPlugin plugin) {
        Map<String, String> props = CommandLineApp.getProperties(plugin, "arg.");
        ArrayList<ArgumentDefinition> argDefs = new ArrayList<ArgumentDefinition>();
        TreeSet<String> keys = new TreeSet<String>(props.keySet());
        for (String key : keys) {
            String json = props.get(key);
            if (!CommandLineApp.isValidJson(json)) {
                throw new JsonSyntaxException("Argument in command help text is not valid json: " + key);
            }
            ArgumentDefinition def = (ArgumentDefinition)sGson.fromJson(json, ArgumentDefinition.class);
            argDefs.add(def);
        }
        return argDefs;
    }

    private static Options loadOptions(CommandPlugin plugin) {
        Map<String, String> props = CommandLineApp.getProperties(plugin, "flag.");
        Options opts = new Options();
        for (String key : props.keySet()) {
            String json = props.get(key);
            if (!CommandLineApp.isValidJson(json)) {
                throw new JsonSyntaxException("Flag option in command help text is not valid json: " + key);
            }
            OptionDefinition def = (OptionDefinition)sGson.fromJson(json, OptionDefinition.class);
            opts.addOption(def.toOption());
        }
        return opts;
    }

    private static boolean isValidJson(String json) {
        boolean isValidJson = false;
        try {
            JsonElement jelem = new JsonParser().parse(json);
            isValidJson = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isValidJson;
    }

    private static Map<String, String> getProperties(CommandPlugin plugin, String prefix) {
        ResourceBundle bundle = CommandLineApp.getBundle(plugin);
        HashMap<String, String> props = new HashMap<String, String>();
        for (String key : bundle.keySet()) {
            if (!key.startsWith(prefix)) continue;
            String val = bundle.getString(key);
            props.put(key, val);
        }
        return props;
    }

    private static ResourceBundle getBundle(CommandPlugin plugin) {
        return ResourceBundle.getBundle("cli." + plugin.getClass().getSimpleName(), Locale.getDefault());
    }

    private static void processError(String scriptName, String[] cmdArgs, Options opts, List<ArgumentDefinition> argDefs, Throwable t) throws IOException {
        if (t instanceof JsonSyntaxException) {
            System.err.println("Error in command properties file.");
            t.printStackTrace(System.err);
            return;
        }
        String shortScriptName = CommandLineApp.getShortScriptName(scriptName);
        String usage = CommandLineApp.getUsage(shortScriptName, opts, argDefs);
        System.err.println("Error executing " + shortScriptName);
        System.err.println();
        if (t instanceof MissingOptionException) {
            System.err.println("Usage: " + usage);
            System.err.println();
            System.err.println("The command requires the following options:");
            System.err.println();
            MissingOptionException moe = (MissingOptionException)t;
            for (String optName : moe.getMissingOptions()) {
                Option opt = opts.getOption(optName);
                String optStr = "-" + opt.getOpt() + ", --" + opt.getLongOpt();
                if (opt.hasArg()) {
                    optStr = optStr + " <" + opt.getArgName() + ">";
                }
                System.err.println(StringUtils.indent(optStr, 1));
                System.err.println(StringUtils.indent(StringUtils.wrap(opt.getDescription(), 94), 2));
                System.err.println();
            }
            System.err.println("Execute the command with -h or --help to find out more information");
            System.err.println();
        } else if (t instanceof ParseException) {
            System.err.println(t.getMessage());
            System.err.println();
            System.err.println("Execute the command with -h or --help to find out more information");
            System.err.println();
        } else if (t instanceof InvalidNumberOfArgsException) {
            InvalidNumberOfArgsException ex = (InvalidNumberOfArgsException)t;
            System.err.println("Usage: " + usage);
            System.err.println();
            System.err.println("Invalid number of argument values specified.");
            System.err.println();
            System.err.println("Arguments that are required:");
            for (ArgumentDefinition argDef : argDefs) {
                System.err.println("\t" + argDef.getName());
            }
            System.err.println();
            System.err.println("Arguments specified by user:");
            for (String actualArg : ex.getActualArgs()) {
                System.err.println("\t" + actualArg);
            }
            System.err.println();
            System.err.println("Execute the command with -h or --help to find out more information");
            System.err.println();
        } else if (t instanceof InvalidCharactersException) {
            System.err.println(t.getMessage());
        } else if (t instanceof InvalidDataException) {
            System.err.println(t.getMessage());
            System.err.println();
            String logMessage = Logger.getRootLogger().getLevel().equals((Object)Level.OFF) ? String.format("Please view the log file for details.", shortScriptName) : String.format("Please re-execute the command %s with the -l or --log option to dump the log file with details.", shortScriptName);
            System.err.println(logMessage);
            System.err.println();
        } else {
            StringBuilder debug = new StringBuilder();
            debug.append("\n");
            debug.append("ENVIRONMENT VARIABLES:\n");
            for (String name : System.getenv().keySet()) {
                String value = System.getenv().get(name);
                debug.append(String.format("\t%s=%s\n", name, value));
            }
            debug.append("\n");
            debug.append("COMMAND:\n");
            debug.append(String.format("\tScript=%s\n", scriptName));
            for (String cmdArg : cmdArgs) {
                debug.append(String.format("\tArg=%s\n", cmdArg));
            }
            sLogger.error((Object)debug.toString());
            sLogger.error((Object)t.getMessage(), t);
            System.err.println("Internal system error.");
            System.err.println();
            System.err.println("Please send the following to the development team:");
            System.err.println(String.format("\t1. Log file by running %s with -l or --log", shortScriptName));
            System.err.println("\t2. Entire command executed at the UNIX command prompt ");
            System.err.println();
        }
    }

    public void execute(CommandPlugin plugin, String[] jvmArgs, Options opts, List<ArgumentDefinition> argDefs, String scriptName) throws Exception {
        for (String arg : jvmArgs) {
            if (!arg.equals("-h") && !arg.equals("--help")) continue;
            this.printHelp(plugin, opts, argDefs, scriptName);
            return;
        }
        CommandLine line = this.mParser.parse(opts, jvmArgs);
        int expectedArgCnt = argDefs.size();
        int actualArgCnt = line.getArgs().length;
        if (actualArgCnt != expectedArgCnt) {
            throw new InvalidNumberOfArgsException(expectedArgCnt, line.getArgs());
        }
        Usage.logger().logBegin(CommandLineApp.getShortScriptName(scriptName), this.toSageMap(line));
        plugin.execute(line, opts);
    }

    private Map<String, Object> toSageMap(CommandLine line) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        block4: for (Option opt : line.getOptions()) {
            String key = "OPT_" + opt.getOpt();
            switch (opt.getArgs()) {
                case -1: 
                case 0: {
                    m.put(key, "true");
                    continue block4;
                }
                case 1: {
                    m.put(key, line.getOptionValue(opt.getOpt()));
                    continue block4;
                }
                default: {
                    StringBuilder sb = new StringBuilder();
                    for (String value : line.getOptionValues(opt.getOpt())) {
                        sb.append(value);
                        sb.append('|');
                    }
                    sb.deleteCharAt(sb.length() - 1);
                    m.put(key, sb.toString());
                }
            }
        }
        String[] args = line.getArgs();
        for (int i = 1; i <= args.length; ++i) {
            String key = "ARG_" + i;
            m.put(key, args[i - 1]);
        }
        return m;
    }

    private static Option getHelpOption() {
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"print this message");
        OptionBuilder.hasArgs((int)0);
        return OptionBuilder.create((char)'h');
    }

    private static Option getLogfileOption() {
        OptionBuilder.withLongOpt((String)"log");
        OptionBuilder.withDescription((String)"Use this option to generate the log file. By default, the log file is not generated.");
        OptionBuilder.hasArgs((int)0);
        return OptionBuilder.create((char)'l');
    }

    private void printHelp(CommandPlugin plugin, Options opts, List<ArgumentDefinition> argDefs, String scriptName) throws IOException {
        ResourceBundle bundle = CommandLineApp.getBundle(plugin);
        String shortScriptName = CommandLineApp.getShortScriptName(scriptName);
        String shortDesc = StringUtils.indent(shortScriptName + " -- " + StringUtils.wrap(bundle.getString("short.description"), 94), 1);
        String longDesc = StringUtils.indent(StringUtils.wrap(bundle.getString("long.description"), 94), 1);
        String usage = StringUtils.indent(CommandLineApp.getUsage(shortScriptName, opts, argDefs), 1);
        ArrayList<String> examples = new ArrayList<String>();
        for (String key : bundle.keySet()) {
            if (!key.startsWith("example.")) continue;
            examples.add(StringUtils.indent(StringUtils.wrap(bundle.getString(key), 94), 1));
        }
        System.out.println();
        System.out.println("NAME");
        System.out.println(shortDesc);
        System.out.println();
        System.out.println("SYNOPSIS");
        System.out.println(usage);
        System.out.println();
        System.out.println("DESCRIPTION");
        System.out.println(longDesc);
        System.out.println();
        if (argDefs.size() > 0) {
            System.out.println(StringUtils.indent("The arguments are as follows:", 1));
            System.out.println();
            for (ArgumentDefinition argDef : argDefs) {
                System.out.println(StringUtils.indent(argDef.getName(), 1));
                System.out.println(StringUtils.indent(StringUtils.wrap(argDef.getDescription(), 94), 2));
                System.out.println();
            }
        }
        if (opts.getOptions().size() > 0) {
            System.out.println(StringUtils.indent("The options are as follows:", 1));
            System.out.println();
            for (Object optObj : opts.getOptions()) {
                Option opt = (Option)optObj;
                String optStr = "-" + opt.getOpt() + ", --" + opt.getLongOpt();
                if (opt.hasArg()) {
                    optStr = optStr + " <" + opt.getArgName() + ">";
                }
                System.out.println(StringUtils.indent(optStr, 1));
                System.out.println(StringUtils.indent(StringUtils.wrap(opt.getDescription(), 94), 2));
                System.out.println();
            }
        }
        if (examples.size() > 0) {
            for (String example : examples) {
                System.out.println("EXAMPLE");
                System.out.println(example);
                System.out.println();
            }
        }
    }

    private static String getUsage(String scriptName, Options opts, List<ArgumentDefinition> argDefs) {
        StringBuilder sb = new StringBuilder();
        sb.append(scriptName);
        Iterator optItr = opts.getOptions().iterator();
        while (optItr.hasNext()) {
            sb.append(" ");
            Option opt = (Option)optItr.next();
            if (!opt.isRequired()) {
                sb.append("[");
            }
            sb.append("--" + opt.getLongOpt());
            if (opt.hasArg()) {
                sb.append(" ");
                sb.append("<" + opt.getArgName() + ">");
            }
            if (opt.isRequired()) continue;
            sb.append("]");
        }
        for (ArgumentDefinition argDef : argDefs) {
            sb.append(" ");
            sb.append(argDef.getName());
        }
        return sb.toString();
    }

    private static String getShortScriptName(String scriptName) {
        int lastSeparatorPos = scriptName.lastIndexOf(47);
        if (lastSeparatorPos != -1) {
            return scriptName.substring(lastSeparatorPos + 1);
        }
        return scriptName;
    }

    private static CommandPlugin loadPlugin(String classname) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        sLogger.info((Object)("Loading plugin: " + classname));
        Class<?> c = Class.forName(classname);
        CommandPlugin plugin = (CommandPlugin)c.newInstance();
        return plugin;
    }

    private static void turnOnLogging() {
        String resource = System.getProperty("log4j.configuration");
        if (resource == null) {
            resource = "log4j.properties";
        }
        URL url = null;
        try {
            url = new URL(resource);
        }
        catch (MalformedURLException e) {
            url = Loader.getResource((String)resource);
        }
        if (url == null) {
            return;
        }
        if (url.getPath().endsWith(".properties")) {
            PropertyConfigurator.configure((URL)url);
        } else if (url.getPath().endsWith(".xml")) {
            DOMConfigurator.configure((URL)url);
        }
    }

    static {
        Logger root = Logger.getRootLogger();
        root.setLevel(Level.OFF);
        sLogger = Logger.getLogger(CommandLineApp.class);
        sGson = new Gson();
    }
}

