/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.bioinformatics.vocab.CoreAttributes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.symbol.Location;
import org.biojavax.CrossRef;
import org.biojavax.Note;
import org.biojavax.RankedCrossRef;
import org.biojavax.RichAnnotation;
import org.biojavax.RichObjectFactory;
import org.biojavax.bio.seq.RichFeature;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.ontology.ComparableTerm;

public class BioJavaRichSequence2JSON
extends AbstractPipe<RichSequence, List<String>> {
    private String chromosome;
    private String[] featureTypes;
    public ComparableTerm geneTerm;
    public ComparableTerm synonymTerm;
    public ComparableTerm locusTerm;
    public ComparableTerm productTerm;
    public ComparableTerm proteinIDTerm;
    public ComparableTerm noteTerm;

    public BioJavaRichSequence2JSON(String chr, String[] featureTypes) {
        new RichSequence.Terms();
        this.geneTerm = RichSequence.Terms.getGeneNameTerm();
        new RichSequence.Terms();
        this.synonymTerm = RichSequence.Terms.getGeneSynonymTerm();
        this.locusTerm = RichObjectFactory.getDefaultOntology().getOrCreateTerm("locus_tag");
        this.productTerm = RichObjectFactory.getDefaultOntology().getOrCreateTerm("product");
        this.proteinIDTerm = RichObjectFactory.getDefaultOntology().getOrCreateTerm("protein_id");
        this.noteTerm = RichObjectFactory.getDefaultOntology().getOrCreateTerm("note");
        this.chromosome = chr;
        this.featureTypes = featureTypes;
    }

    protected List<String> processNextStart() throws NoSuchElementException {
        if (this.starts.hasNext()) {
            RichSequence seq = (RichSequence)this.starts.next();
            List<String> features = this.transform(seq);
            return features;
        }
        throw new NoSuchElementException();
    }

    private List<String> transform(RichSequence rs) throws NoSuchElementException {
        System.out.println("BioJavaRichSequence2ThriftGenes.transform()..");
        ArrayList<String> features = new ArrayList<String>();
        for (int i = 0; i < this.featureTypes.length; ++i) {
            List<String> extFeatures = this.extractFeaturesByType(this.featureTypes[i], rs);
            features.addAll(extFeatures);
        }
        if (features.size() < 1) {
            throw new NoSuchElementException();
        }
        return features;
    }

    private List<String> extractFeaturesByType(String type, RichSequence rs) {
        ArrayList<String> features = new ArrayList<String>();
        FeatureFilter.ByType ff = new FeatureFilter.ByType(type);
        FeatureHolder fh = rs.filter((FeatureFilter)ff);
        Iterator i = fh.features();
        while (i.hasNext()) {
            RichFeature rf = (RichFeature)i.next();
            JsonObject f = new JsonObject();
            f.addProperty(CoreAttributes._type.toString(), type);
            f.addProperty(CoreAttributes._landmark.toString(), this.chromosome);
            char featureStrand = rf.getStrand().getToken();
            if (featureStrand == '+') {
                f.addProperty(CoreAttributes._strand.toString(), "+");
            } else if (featureStrand == '-') {
                f.addProperty(CoreAttributes._strand.toString(), "-");
            } else {
                f.addProperty(CoreAttributes._strand.toString(), ".");
            }
            String subregionType = "subregions";
            JsonArray subregions = new JsonArray();
            if (type.equalsIgnoreCase("mRNA") || type.equalsIgnoreCase("transcript") || type.equalsIgnoreCase("CDS")) {
                subregionType = "exons";
            }
            String featureLocation = rf.getLocation().toString();
            f.addProperty(CoreAttributes._minBP.toString(), (Number)rf.getLocation().getMin());
            f.addProperty(CoreAttributes._maxBP.toString(), (Number)rf.getLocation().getMax());
            Location location = rf.getLocation();
            Iterator blockIterator = location.blockIterator();
            while (blockIterator.hasNext()) {
                JsonObject sregion = new JsonObject();
                Location next = (Location)blockIterator.next();
                int min = next.getMin();
                int max = next.getMax();
                sregion.addProperty("minBP", (Number)min);
                sregion.addProperty("maxBP", (Number)max);
                subregions.add((JsonElement)sregion);
            }
            if (subregions.size() > 1) {
                f.add(subregionType, (JsonElement)subregions);
            } else if (type.equalsIgnoreCase("mRNA") || type.equalsIgnoreCase("transcript") || type.equalsIgnoreCase("CDS")) {
                f.add(subregionType, (JsonElement)subregions);
            }
            RichAnnotation ra = (RichAnnotation)rf.getAnnotation();
            for (Note note : ra.getNoteSet()) {
                f.addProperty(note.getTerm().toString().replace("biojavax:", ""), note.getValue().toString());
            }
            Set rankedCrossRefs = rf.getRankedCrossRefs();
            for (RankedCrossRef next : rankedCrossRefs) {
                CrossRef crossRef = next.getCrossRef();
                f.addProperty(crossRef.getDbname(), crossRef.getAccession());
            }
            features.add(f.toString());
        }
        return features;
    }
}

