/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTools;
import org.biojava.bio.dist.IndexedCount;
import org.biojava.bio.seq.RNATools;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.CodonPref;
import org.biojava.bio.symbol.CodonPrefFilter;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleCodonPref;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.ClassTools;
import org.biojava.utils.xml.PrettyXMLWriter;
import org.biojava.utils.xml.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CodonPrefTools {
    static String JUNIT = "jUnit use only!!!!";
    public static String DROSOPHILA_MELANOGASTER_NUCLEAR = "Drosophila melanogaster";
    public static String MAN_NUCLEAR = "Homo sapiens";
    public static String MOUSE_NUCLEAR = "Mus musculus";
    public static String RAT_NUCLEAR = "Rattus norvegicus";
    public static String FUGU_NUCLEAR = "Takifugu rubripes";
    public static String WORM_NUCLEAR = "Caenorhabditis elegans";
    public static String CEREVISIAE_NUCLEAR = "Saccharomyces cerevisiae";
    public static String POMBE_NUCLEAR = "Schizosaccharomyces pombe";
    public static String ECOLI = "Escherichia coli";
    private static Map prefMap;
    private static final AtomicSymbol[] cutg;

    public static CodonPref getCodonPreference(String id) {
        return (CodonPref)prefMap.get(id);
    }

    private static void loadCodonPreferences() {
        try {
            InputStream prefStream = ClassTools.getClassLoader(CodonPrefTools.class).getResourceAsStream("org/biojava/bio/symbol/CodonPrefTables.xml");
            LoadEverythingSelector select = new LoadEverythingSelector();
            CodonPrefTools.readFromXML(prefStream, select);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FiniteAlphabet getDinucleotideAlphabet() {
        return (FiniteAlphabet)AlphabetManager.generateCrossProductAlphaFromName("(RNA x RNA)");
    }

    public static void writeToXML(CodonPref codonPref, PrintWriter writer) throws NullPointerException, IOException, IllegalSymbolException, BioException {
        PrettyXMLWriter xw = new PrettyXMLWriter(writer);
        CodonPrefTools.dumpToXML(codonPref, xw, true);
        writer.flush();
    }

    public static CodonPref readFromXML(InputStream prefStream, String name) throws BioException {
        CodonPrefFilter.ByName filter = new CodonPrefFilter.ByName(name);
        CodonPrefTools.readFromXML(prefStream, filter);
        return filter.getCodonPref();
    }

    public static CodonPref[] readFromXML(InputStream prefStream) throws BioException {
        CodonPrefFilter.AcceptAll filter = new CodonPrefFilter.AcceptAll();
        CodonPrefTools.readFromXML(prefStream, filter);
        List l = filter.getCodonPrefs();
        CodonPref[] cp = new CodonPref[l.size()];
        return l.toArray(cp);
    }

    public static void readFromXML(InputStream prefStream, CodonPrefFilter filter) throws BioException {
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = parser.parse(prefStream);
            NodeList children = doc.getDocumentElement().getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Element child;
                String name;
                Node cnode = children.item(i);
                if (!(cnode instanceof Element) || !(name = (child = (Element)cnode).getNodeName()).equals("CodonPref")) continue;
                String codonPrefId = child.getAttribute("id");
                String geneticCodeId = child.getAttribute("geneticCodeId");
                if (!filter.isRequired(codonPrefId)) continue;
                NodeList freqs = child.getChildNodes();
                IndexedCount freqCounts = new IndexedCount(RNATools.getCodonAlphabet());
                for (int j = 0; j < freqs.getLength(); ++j) {
                    Node freq = freqs.item(j);
                    if (!(freq instanceof Element)) continue;
                    Element freqElement = (Element)freq;
                    String codonString = freqElement.getAttribute("codon");
                    String freqString = freqElement.getAttribute("value");
                    SymbolList codonSL = RNATools.createRNA(codonString);
                    if (codonSL.length() != 3) {
                        throw new BioException("'" + codonString + "' is not a valid codon!");
                    }
                    AtomicSymbol codon = (AtomicSymbol)RNATools.getCodonAlphabet().getSymbol(codonSL.toList());
                    double freqValue = Double.parseDouble(freqString);
                    freqCounts.increaseCount(codon, freqValue);
                }
                Distribution freqDistribution = DistributionTools.countToDistribution(freqCounts);
                SimpleCodonPref newCodonPref = new SimpleCodonPref(geneticCodeId, freqDistribution, codonPrefId);
                filter.put(newCodonPref);
            }
        }
        catch (Exception e) {
            throw new BioException(e);
        }
    }

    public static void translateCUD(InputStream input, OutputStream output) throws IOException {
        BufferedReader rdr = new BufferedReader(new InputStreamReader(input));
        PrintWriter pw = new PrintWriter(output);
        CodonPrefFilter.EverythingToXML filter = new CodonPrefFilter.EverythingToXML(pw);
        CodonPrefTools.readFromCUD(rdr, filter);
        filter.close();
    }

    private static AtomicSymbol getCodon(String codonString) throws IllegalSymbolException {
        return (AtomicSymbol)RNATools.getCodonAlphabet().getSymbol(RNATools.createRNA(codonString).toList());
    }

    private static void loadCodonOrder() throws IllegalSymbolException {
        CodonPrefTools.cutg[0] = CodonPrefTools.getCodon("cga");
        CodonPrefTools.cutg[1] = CodonPrefTools.getCodon("cgc");
        CodonPrefTools.cutg[2] = CodonPrefTools.getCodon("cgg");
        CodonPrefTools.cutg[3] = CodonPrefTools.getCodon("cgu");
        CodonPrefTools.cutg[4] = CodonPrefTools.getCodon("aga");
        CodonPrefTools.cutg[5] = CodonPrefTools.getCodon("agg");
        CodonPrefTools.cutg[6] = CodonPrefTools.getCodon("cua");
        CodonPrefTools.cutg[7] = CodonPrefTools.getCodon("cuc");
        CodonPrefTools.cutg[8] = CodonPrefTools.getCodon("cug");
        CodonPrefTools.cutg[9] = CodonPrefTools.getCodon("cuu");
        CodonPrefTools.cutg[10] = CodonPrefTools.getCodon("uua");
        CodonPrefTools.cutg[11] = CodonPrefTools.getCodon("uug");
        CodonPrefTools.cutg[12] = CodonPrefTools.getCodon("uca");
        CodonPrefTools.cutg[13] = CodonPrefTools.getCodon("ucc");
        CodonPrefTools.cutg[14] = CodonPrefTools.getCodon("ucg");
        CodonPrefTools.cutg[15] = CodonPrefTools.getCodon("ucu");
        CodonPrefTools.cutg[16] = CodonPrefTools.getCodon("agc");
        CodonPrefTools.cutg[17] = CodonPrefTools.getCodon("agu");
        CodonPrefTools.cutg[18] = CodonPrefTools.getCodon("aca");
        CodonPrefTools.cutg[19] = CodonPrefTools.getCodon("acc");
        CodonPrefTools.cutg[20] = CodonPrefTools.getCodon("acg");
        CodonPrefTools.cutg[21] = CodonPrefTools.getCodon("acu");
        CodonPrefTools.cutg[22] = CodonPrefTools.getCodon("cca");
        CodonPrefTools.cutg[23] = CodonPrefTools.getCodon("ccc");
        CodonPrefTools.cutg[24] = CodonPrefTools.getCodon("ccg");
        CodonPrefTools.cutg[25] = CodonPrefTools.getCodon("ccu");
        CodonPrefTools.cutg[26] = CodonPrefTools.getCodon("gca");
        CodonPrefTools.cutg[27] = CodonPrefTools.getCodon("gcc");
        CodonPrefTools.cutg[28] = CodonPrefTools.getCodon("gcg");
        CodonPrefTools.cutg[29] = CodonPrefTools.getCodon("gcu");
        CodonPrefTools.cutg[30] = CodonPrefTools.getCodon("gga");
        CodonPrefTools.cutg[31] = CodonPrefTools.getCodon("ggc");
        CodonPrefTools.cutg[32] = CodonPrefTools.getCodon("ggg");
        CodonPrefTools.cutg[33] = CodonPrefTools.getCodon("ggu");
        CodonPrefTools.cutg[34] = CodonPrefTools.getCodon("gua");
        CodonPrefTools.cutg[35] = CodonPrefTools.getCodon("guc");
        CodonPrefTools.cutg[36] = CodonPrefTools.getCodon("gug");
        CodonPrefTools.cutg[37] = CodonPrefTools.getCodon("guu");
        CodonPrefTools.cutg[38] = CodonPrefTools.getCodon("aaa");
        CodonPrefTools.cutg[39] = CodonPrefTools.getCodon("aag");
        CodonPrefTools.cutg[40] = CodonPrefTools.getCodon("aac");
        CodonPrefTools.cutg[41] = CodonPrefTools.getCodon("aau");
        CodonPrefTools.cutg[42] = CodonPrefTools.getCodon("caa");
        CodonPrefTools.cutg[43] = CodonPrefTools.getCodon("cag");
        CodonPrefTools.cutg[44] = CodonPrefTools.getCodon("cac");
        CodonPrefTools.cutg[45] = CodonPrefTools.getCodon("cau");
        CodonPrefTools.cutg[46] = CodonPrefTools.getCodon("gaa");
        CodonPrefTools.cutg[47] = CodonPrefTools.getCodon("gag");
        CodonPrefTools.cutg[48] = CodonPrefTools.getCodon("gac");
        CodonPrefTools.cutg[49] = CodonPrefTools.getCodon("gau");
        CodonPrefTools.cutg[50] = CodonPrefTools.getCodon("uac");
        CodonPrefTools.cutg[51] = CodonPrefTools.getCodon("uau");
        CodonPrefTools.cutg[52] = CodonPrefTools.getCodon("ugc");
        CodonPrefTools.cutg[53] = CodonPrefTools.getCodon("ugu");
        CodonPrefTools.cutg[54] = CodonPrefTools.getCodon("uuc");
        CodonPrefTools.cutg[55] = CodonPrefTools.getCodon("uuu");
        CodonPrefTools.cutg[56] = CodonPrefTools.getCodon("aua");
        CodonPrefTools.cutg[57] = CodonPrefTools.getCodon("auc");
        CodonPrefTools.cutg[58] = CodonPrefTools.getCodon("auu");
        CodonPrefTools.cutg[59] = CodonPrefTools.getCodon("aug");
        CodonPrefTools.cutg[60] = CodonPrefTools.getCodon("ugg");
        CodonPrefTools.cutg[61] = CodonPrefTools.getCodon("uaa");
        CodonPrefTools.cutg[62] = CodonPrefTools.getCodon("uag");
        CodonPrefTools.cutg[63] = CodonPrefTools.getCodon("uga");
    }

    private static String stringifyCodon(BasisSymbol codon) throws IllegalSymbolException, BioException {
        List codonList = codon.getSymbols();
        SymbolTokenization toke = RNATools.getRNA().getTokenization("token");
        String tokenizedCodon = toke.tokenizeSymbol((Symbol)codonList.get(0)) + toke.tokenizeSymbol((Symbol)codonList.get(1)) + toke.tokenizeSymbol((Symbol)codonList.get(2));
        return tokenizedCodon;
    }

    static void dumpToXML(CodonPref codonPref, XMLWriter xw, boolean writeWrapper) throws NullPointerException, IOException, IllegalSymbolException, BioException {
        if (codonPref == null || xw == null) {
            throw new NullPointerException();
        }
        Distribution codonDist = codonPref.getFrequency();
        if (writeWrapper) {
            xw.openTag("CodonPrefs");
        }
        xw.openTag("CodonPref");
        xw.attribute("id", codonPref.getName());
        xw.attribute("geneticCodeId", codonPref.getGeneticCodeName());
        Iterator<Symbol> codonI = RNATools.getCodonAlphabet().iterator();
        while (codonI.hasNext()) {
            BasisSymbol codon = (BasisSymbol)codonI.next();
            xw.openTag("frequency");
            xw.attribute("codon", CodonPrefTools.stringifyCodon(codon));
            xw.attribute("value", Double.toString(codonDist.getWeight(codon)));
            xw.closeTag("frequency");
        }
        xw.closeTag("CodonPref");
        if (writeWrapper) {
            xw.closeTag("CodonPrefs");
        }
    }

    private static void readFromCUD(BufferedReader rdr, CodonPrefFilter filter) {
        try {
            String currLine;
            while ((currLine = rdr.readLine()) != null) {
                StringTokenizer toke = new StringTokenizer(currLine, ":");
                if (!toke.hasMoreTokens()) continue;
                String id = toke.nextToken().trim();
                currLine = rdr.readLine();
                if (currLine != null) {
                    if (!filter.isRequired(id)) continue;
                    toke = new StringTokenizer(currLine);
                    int idx = 0;
                    IndexedCount count = new IndexedCount(RNATools.getCodonAlphabet());
                    while (toke.hasMoreTokens()) {
                        if (idx > 63) continue;
                        count.increaseCount(cutg[idx], Double.parseDouble(toke.nextToken()));
                        ++idx;
                    }
                    if (idx != 64) continue;
                    Distribution codonDist = DistributionTools.countToDistribution(count);
                    SimpleCodonPref codonPref = new SimpleCodonPref("UNIVERSAL", codonDist, id);
                    filter.put(codonPref);
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
        }
        catch (IllegalSymbolException ise) {
        }
        catch (IllegalAlphabetException iae) {
        }
        catch (ChangeVetoException cve) {
        }
        catch (BioException bioException) {
            // empty catch block
        }
    }

    static {
        cutg = new AtomicSymbol[64];
        prefMap = new HashMap();
        CodonPrefTools.loadCodonPreferences();
        try {
            CodonPrefTools.loadCodonOrder();
        }
        catch (IllegalSymbolException illegalSymbolException) {
            // empty catch block
        }
    }

    private static class LoadEverythingSelector
    implements CodonPrefFilter {
        private LoadEverythingSelector() {
        }

        public boolean isRequired(String id) {
            return true;
        }

        public void put(CodonPref codonPref) {
            prefMap.put(codonPref.getName(), codonPref);
        }
    }
}

