/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.tabix;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import edu.mayo.pipes.JSON.tabix.TabixSearchPipe;
import edu.mayo.pipes.bioinformatics.vocab.ComparableObjectInterface;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.History;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;

public class TabixParentPipe
extends AbstractPipe<History, History> {
    protected History history = null;
    protected Pipe search;
    protected int qcount;
    protected boolean isFirst = true;
    protected ComparableObjectInterface comparableObject;
    protected int historyPos = -1;
    protected String validResult = "";

    public TabixParentPipe(String tabixDataFile) throws IOException {
        this.init(tabixDataFile);
    }

    public TabixParentPipe(String tabixDataFile, int historyPosition) throws IOException {
        this.historyPos = historyPosition;
        this.init(tabixDataFile);
    }

    protected void init(String tabixDataFile) throws IOException {
        this.search = new TabixSearchPipe(tabixDataFile);
        this.comparableObject = new FilterLogic();
    }

    protected History copyAppend(History history, String result) {
        History clone = (History)history.clone();
        clone.add(result);
        return clone;
    }

    protected void setup() {
        if (this.isFirst) {
            this.isFirst = false;
            if (this.historyPos > 0) {
                this.historyPos = this.historyPos - this.history.size() - 1;
            }
            this.history = (History)this.starts.next();
            this.qcount = 0;
            this.search.reset();
            this.search.setStarts(Arrays.asList((String)this.history.get(this.history.size() + this.historyPos)));
            List<ColumnMetaData> cols = History.getMetaData().getColumns();
            ColumnMetaData cmd = new ColumnMetaData(((Object)((Object)this)).getClass().getSimpleName());
            cols.add(cmd);
        }
    }

    private boolean valid(ComparableObjectInterface fl) {
        String result = (String)this.search.next();
        boolean ret = fl.same((String)this.history.get(this.history.size() + this.historyPos), result);
        this.validResult = ret ? result : "";
        return ret;
    }

    protected History processNextStart() throws NoSuchElementException {
        this.setup();
        while (true) {
            if (this.search.hasNext()) {
                if (!this.valid(this.comparableObject)) continue;
                ++this.qcount;
                return this.copyAppend(this.history, this.validResult);
            }
            if (this.qcount == 0) {
                ++this.qcount;
                return this.copyAppend(this.history, "{}");
            }
            this.history = (History)this.starts.next();
            this.search.reset();
            this.search.setStarts(Arrays.asList((String)this.history.get(this.history.size() + this.historyPos)));
            this.qcount = 0;
        }
    }

    private class FilterLogic
    implements ComparableObjectInterface {
        private FilterLogic() {
        }

        @Override
        public boolean same(String a, String b) {
            return true;
        }
    }
}

