/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.history;

import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.history.HistoryMetaData;
import edu.mayo.pipes.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class HistoryInPipe
extends AbstractPipe<String, History> {
    private int expand2NumCols = -1;
    private final String COL_DELIMITER = "\t";

    public HistoryInPipe() {
        History.clearMetaData();
        this.expand2NumCols = -1;
    }

    public HistoryInPipe(int expand2NumCols) {
        History.clearMetaData();
        this.expand2NumCols = expand2NumCols;
    }

    public void reset() {
        super.reset();
        History.clearMetaData();
    }

    protected History processNextStart() throws NoSuchElementException {
        String[] colDataArr;
        String line = (String)this.starts.next();
        History history = new History();
        if (!history.isMetaDataInitialized()) {
            ArrayList<String> headerRows = new ArrayList<String>();
            while (line.startsWith("#")) {
                headerRows.add(line);
                try {
                    line = (String)this.starts.next();
                }
                catch (NoSuchElementException e) {
                    int numCols = line.split("\t").length;
                    this.initializeMetaData(history, headerRows, numCols);
                    throw e;
                }
            }
            int numCols = line.split("\t").length;
            this.initializeMetaData(history, headerRows, numCols);
        }
        for (String colData : colDataArr = StringUtils.safeSplit(line, "\t")) {
            history.add(colData);
        }
        return history;
    }

    private void initializeMetaData(History history, List<String> headerRows, int numCols) {
        HistoryMetaData hMeta = new HistoryMetaData(headerRows);
        if (headerRows.size() > 0) {
            String colHeaderLine = headerRows.get(headerRows.size() - 1);
            colHeaderLine = colHeaderLine.substring(1);
            for (String colName : colHeaderLine.split("\t")) {
                ColumnMetaData cmd = new ColumnMetaData(colName);
                hMeta.getColumns().add(cmd);
            }
        } else {
            if (numCols != this.expand2NumCols && this.expand2NumCols != -1) {
                while (history.size() < this.expand2NumCols) {
                    history.add("");
                }
                numCols = this.expand2NumCols;
            }
            for (int i = 1; i <= numCols; ++i) {
                ColumnMetaData cmd = new ColumnMetaData("#UNKNOWN_" + i);
                hMeta.getColumns().add(cmd);
            }
        }
        history.setMetaData(hMeta);
    }
}

