/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.history;

import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.util.FieldSpecification;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class CompressPipe
extends AbstractPipe<History, History> {
    private String mDelimiter;
    private String mEscDelimiter;
    private FieldSpecification mFieldSpec;
    private List<List<String>> mBuffer = new ArrayList<List<String>>();
    private List<String> mBufferKey = null;
    private boolean mFieldsInitialized = false;
    private List<Integer> mKeyFields = new ArrayList<Integer>();
    private List<Integer> mCompressFields = new ArrayList<Integer>();
    private boolean mNoMoreData = false;

    public CompressPipe(FieldSpecification fieldSpec, String delimiter) {
        this(fieldSpec, delimiter, "\\" + delimiter);
    }

    public CompressPipe(FieldSpecification fieldSpec, String delimiter, String escapeDelimiter) {
        this.mFieldSpec = fieldSpec;
        this.mDelimiter = delimiter;
        this.mEscDelimiter = escapeDelimiter;
    }

    protected History processNextStart() throws NoSuchElementException {
        List<String> lineKey;
        List line;
        if (this.mNoMoreData) {
            throw new NoSuchElementException();
        }
        while (true) {
            try {
                line = (List)this.starts.next();
            }
            catch (NoSuchElementException e) {
                this.mNoMoreData = true;
                return this.compress(this.mBuffer);
            }
            if (!this.mFieldsInitialized) {
                this.initializeFields(line.size());
                this.mFieldsInitialized = true;
            }
            lineKey = this.getKey(line);
            if (this.mBuffer.size() != 0 && !this.hasKeyMatch(this.mBufferKey, lineKey)) break;
            if (this.mBuffer.size() == 0) {
                this.mBufferKey = lineKey;
            }
            this.mBuffer.add(line);
        }
        History compressedLine = this.compress(this.mBuffer);
        this.mBuffer.clear();
        this.mBufferKey = null;
        this.mBufferKey = lineKey;
        this.mBuffer.add(line);
        return compressedLine;
    }

    private void initializeFields(int numFields) {
        Map<FieldSpecification.FieldType, List<Integer>> m = this.mFieldSpec.getFields(numFields);
        this.mCompressFields = m.get((Object)FieldSpecification.FieldType.MATCH);
        this.mKeyFields = m.get((Object)FieldSpecification.FieldType.NON_MATCH);
    }

    private History compress(List<List<String>> lines) {
        if (lines.size() == 0) {
            return new History();
        }
        boolean[] identicalColVals = this.checkSameColumnValues(lines);
        List<String> firstLine = lines.remove(0);
        int numCols = firstLine.size();
        ArrayList<StringBuilder> builders = new ArrayList<StringBuilder>();
        for (int col = 0; col < numCols; ++col) {
            String colValue = firstLine.get(col);
            int field = col + 1;
            if (this.mCompressFields.contains(field)) {
                colValue = colValue.replace(this.mDelimiter, this.mEscDelimiter);
            }
            builders.add(new StringBuilder(colValue));
        }
        for (List<String> line : lines) {
            for (int col = 0; col < numCols; ++col) {
                StringBuilder builder = (StringBuilder)builders.get(col);
                String colValue = line.get(col);
                int field = col + 1;
                if (identicalColVals[col] || !this.mCompressFields.contains(field)) continue;
                colValue = colValue.replace(this.mDelimiter, this.mEscDelimiter);
                builder.append(this.mDelimiter);
                builder.append(colValue);
            }
        }
        History compressedLine = new History();
        for (StringBuilder builder : builders) {
            compressedLine.add(builder.toString());
        }
        return compressedLine;
    }

    private boolean[] checkSameColumnValues(List<List<String>> lines) {
        if (lines.size() == 0) {
            return new boolean[0];
        }
        int numCols = lines.get(0).size();
        boolean[] identicalColVals = new boolean[numCols];
        for (int col = 0; col < numCols; ++col) {
            boolean allIdentical = true;
            String colValue = null;
            for (List<String> line : lines) {
                if (colValue == null) {
                    colValue = line.get(col);
                    continue;
                }
                if (colValue.equals(line.get(col))) continue;
                allIdentical = false;
                break;
            }
            identicalColVals[col] = allIdentical;
        }
        return identicalColVals;
    }

    private boolean hasKeyMatch(List<String> key1, List<String> key2) {
        boolean isMatch = true;
        for (int i = 0; i < key1.size(); ++i) {
            String keyValue2;
            String keyValue1 = key1.get(i);
            if (keyValue1.equals(keyValue2 = key2.get(i))) continue;
            isMatch = false;
            break;
        }
        return isMatch;
    }

    private List<String> getKey(List<String> line) {
        ArrayList<String> key = new ArrayList<String>();
        for (int index : this.mKeyFields) {
            key.add(line.get(index - 1));
        }
        return key;
    }
}

