/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.exec;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Logger;

public class StreamGobbler
implements Runnable {
    private static final Logger sLogger = Logger.getLogger(StreamGobbler.class);
    private InputStream mInStream;
    private StringWriter mStringWriter = new StringWriter();

    public StreamGobbler(InputStream inStream) {
        this.mInStream = inStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread t = Thread.currentThread();
        InputStreamReader ir = new InputStreamReader(this.mInStream);
        BufferedReader br = new BufferedReader(ir);
        PrintWriter pw = new PrintWriter(this.mStringWriter);
        try {
            String line = br.readLine();
            while (line != null) {
                if (sLogger.isDebugEnabled()) {
                    sLogger.debug((Object)String.format("Receive data from %s: %s", t.getName(), line));
                }
                pw.println(line);
                line = br.readLine();
            }
            pw.flush();
        }
        catch (IOException e) {
            sLogger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            pw.close();
            try {
                br.close();
            }
            catch (IOException e) {
                sLogger.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                ir.close();
            }
            catch (IOException e) {
                sLogger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getContent() {
        return this.mStringWriter.toString();
    }
}

