/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.util.metadata;

import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.util.PropertiesFileUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class AddMetadataLines {
    public String getID(History h, String candidate) {
        List<String> lines = History.getMetaData().getOriginalHeader();
        HashMap<String, LinkedHashMap<String, String>> hm = new HashMap<String, LinkedHashMap<String, String>>();
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (!line.startsWith("##BIOR")) continue;
            LinkedHashMap<String, String> props = this.parseHeaderLine(line);
            hm.put(props.get(BiorMetaControlledVocabulary.ID.toString()).toString(), props);
        }
        String candidate2 = candidate;
        LinkedHashMap props = (LinkedHashMap)hm.get(candidate);
        Integer numberOfFails = 2;
        while (props != null) {
            candidate2 = candidate + "." + numberOfFails;
            props = (LinkedHashMap)hm.get((Object)((Object)BiorMetaControlledVocabulary.BIOR) + candidate2);
            Integer n = numberOfFails;
            Integer n2 = numberOfFails = Integer.valueOf(numberOfFails + 1);
        }
        return candidate2;
    }

    public LinkedHashMap<String, String> parseDatasourceProperties(String catalogPath, LinkedHashMap<String, String> attributes) throws IOException {
        PropertiesFileUtil propsUtil = !catalogPath.endsWith(".datasource.properties") ? new PropertiesFileUtil(this.getDatasourcePropsPath(catalogPath)) : new PropertiesFileUtil(catalogPath);
        String catalogShortUniqueName = propsUtil.get(BiorMetaControlledVocabulary.SHORTNAME.toString());
        String catalogSource = propsUtil.get(BiorMetaControlledVocabulary.SOURCE.toString());
        String description = propsUtil.get(BiorMetaControlledVocabulary.DESCRIPTION.toString());
        String catalogVersion = propsUtil.get(BiorMetaControlledVocabulary.VERSION.toString());
        String catalogBuild = propsUtil.get(BiorMetaControlledVocabulary.BUILD.toString());
        this.put(attributes, BiorMetaControlledVocabulary.SHORTNAME.toString(), catalogShortUniqueName);
        this.put(attributes, BiorMetaControlledVocabulary.SOURCE.toString(), catalogSource);
        this.put(attributes, BiorMetaControlledVocabulary.DESCRIPTION.toString(), description);
        this.put(attributes, BiorMetaControlledVocabulary.VERSION.toString(), catalogVersion);
        this.put(attributes, BiorMetaControlledVocabulary.BUILD.toString(), catalogBuild);
        this.put(attributes, BiorMetaControlledVocabulary.PATH.toString(), catalogPath);
        return attributes;
    }

    private void put(LinkedHashMap attributes, String key, String value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        attributes.put(key, value.replaceAll("\"", "\\\\\""));
    }

    private String getColumnsPropsPath(String catalogPath) {
        if (!catalogPath.endsWith(".columns.tsv")) {
            return this.getPropsFilePath(catalogPath, ".columns.tsv");
        }
        return catalogPath;
    }

    private String getDatasourcePropsPath(String catalogPath) {
        if (!catalogPath.endsWith(".datasource.properties")) {
            return this.getPropsFilePath(catalogPath, ".datasource.properties");
        }
        return catalogPath;
    }

    private String getPropsFilePath(String catalogPath, String propsFileExtension) {
        String CTLG_EXT = ".tsv.bgz";
        if (catalogPath.endsWith(propsFileExtension)) {
            return catalogPath;
        }
        if (catalogPath.endsWith(".tsv.bgz")) {
            return catalogPath.replace(".tsv.bgz", propsFileExtension);
        }
        return catalogPath + propsFileExtension;
    }

    public HashMap<String, ColumnMetaData> parseColumnProperties(String catalogPath) throws IOException {
        ColumnMetaData cmd = new ColumnMetaData("foo");
        HashMap<String, ColumnMetaData> descriptions = ColumnMetaData.parseColumnProperties(this.getColumnsPropsPath(catalogPath));
        return descriptions;
    }

    public History constructToTJsonLine(History h, String operation, String operationType) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        this.put(attributes, BiorMetaControlledVocabulary.ID.toString(), this.getID(h, (Object)((Object)BiorMetaControlledVocabulary.BIOR) + operationType));
        this.put(attributes, BiorMetaControlledVocabulary.OPERATION.toString(), operation);
        this.put(attributes, BiorMetaControlledVocabulary.DATATYPE.toString(), ColumnMetaData.Type.JSON.toString());
        this.put(attributes, BiorMetaControlledVocabulary.SHORTNAME.toString(), operationType);
        List<String> head = h.getMetaData().getOriginalHeader();
        if (head.size() > 0) {
            head.add(head.size() - 1, this.buildHeaderLine(attributes));
        } else {
            head.add(this.buildHeaderLine(attributes));
        }
        return h;
    }

    public String constructQueryLine(History h, String catalogPath, String operation) throws IOException {
        LinkedHashMap<String, String> temp = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        this.parseDatasourceProperties(catalogPath, temp);
        this.put(attributes, BiorMetaControlledVocabulary.ID.toString(), this.getID(h, (Object)((Object)BiorMetaControlledVocabulary.BIOR) + temp.get(BiorMetaControlledVocabulary.SHORTNAME.toString())));
        this.put(attributes, BiorMetaControlledVocabulary.OPERATION.toString(), operation);
        this.put(attributes, BiorMetaControlledVocabulary.DATATYPE.toString(), ColumnMetaData.Type.JSON.toString());
        for (String key : temp.keySet()) {
            this.put(attributes, key, temp.get(key));
        }
        List<String> head = h.getMetaData().getOriginalHeader();
        head.add(head.size() - 1, this.buildHeaderLine(attributes));
        return attributes.get(BiorMetaControlledVocabulary.ID.toString()).substring(5);
    }

    public String constructQueryLineOnNoDatasourceProperties(History h, String catalogPath, String operation) {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        String[] split = catalogPath.split("/");
        String filename = split[split.length - 1];
        String substituteShort = filename.replaceAll(".tsv.bgz", "");
        this.put(attributes, BiorMetaControlledVocabulary.ID.toString(), this.getID(h, BiorMetaControlledVocabulary.BIOR.toString() + substituteShort));
        this.put(attributes, BiorMetaControlledVocabulary.OPERATION.toString(), operation);
        this.put(attributes, BiorMetaControlledVocabulary.DATATYPE.toString(), ColumnMetaData.Type.JSON.toString());
        this.put(attributes, BiorMetaControlledVocabulary.SHORTNAME.toString(), substituteShort);
        this.put(attributes, BiorMetaControlledVocabulary.PATH.toString(), catalogPath);
        List<String> head = h.getMetaData().getOriginalHeader();
        int addline = head.size() - 1;
        if (addline == -1) {
            History.getMetaData().getOriginalHeader().add(this.buildHeaderLine(attributes));
        } else {
            head.add(head.size() - 1, this.buildHeaderLine(attributes));
        }
        return attributes.get(BiorMetaControlledVocabulary.ID.toString()).substring(5);
    }

    public String constructToolLine(History h, String datasourcepath, String columnpath, String operation) throws IOException {
        PropertiesFileUtil props = new PropertiesFileUtil(datasourcepath);
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        this.put(attributes, BiorMetaControlledVocabulary.ID.toString(), this.getID(h, (Object)((Object)BiorMetaControlledVocabulary.BIOR) + props.get(BiorMetaControlledVocabulary.SHORTNAME.toString())));
        this.put(attributes, BiorMetaControlledVocabulary.OPERATION.toString(), operation);
        this.put(attributes, BiorMetaControlledVocabulary.DATATYPE.toString(), ColumnMetaData.Type.JSON.toString());
        this.put(attributes, BiorMetaControlledVocabulary.SHORTNAME.toString(), props.get(BiorMetaControlledVocabulary.SHORTNAME.toString()));
        this.put(attributes, BiorMetaControlledVocabulary.DESCRIPTION.toString(), props.get(BiorMetaControlledVocabulary.DESCRIPTION.toString()));
        this.put(attributes, BiorMetaControlledVocabulary.VERSION.toString(), props.get(BiorMetaControlledVocabulary.VERSION.toString()));
        this.put(attributes, BiorMetaControlledVocabulary.BUILD.toString(), props.get(BiorMetaControlledVocabulary.BUILD.toString()));
        this.put(attributes, BiorMetaControlledVocabulary.DATASOURCEPROPERTIES.toString(), datasourcepath);
        this.put(attributes, BiorMetaControlledVocabulary.COLUMNPROPERTIES.toString(), columnpath);
        List<String> head = h.getMetaData().getOriginalHeader();
        head.add(head.size() - 1, this.buildHeaderLine(attributes));
        return attributes.get(BiorMetaControlledVocabulary.ID.toString()).substring(5);
    }

    public void constructAnnotateLine(History history, String catalogPath, String operation, String[] newColNamesToAdd, String[] drilledColNames) throws IOException {
        LinkedHashMap<Object, Object> datasourceProps = new LinkedHashMap();
        HashMap<Object, Object> columnsProps = new HashMap();
        boolean isColumnsPropsFileExists = false;
        boolean isDatasourcePropsFileExists = false;
        boolean bl = isDatasourcePropsFileExists = catalogPath != null && catalogPath.trim().length() > 0 && new File(this.getDatasourcePropsPath(catalogPath)).exists();
        if (isDatasourcePropsFileExists) {
            datasourceProps = this.parseDatasourceProperties(catalogPath, new LinkedHashMap<String, String>());
        }
        boolean bl2 = isColumnsPropsFileExists = catalogPath != null && catalogPath.trim().length() > 0 && new File(this.getColumnsPropsPath(catalogPath)).exists();
        if (isColumnsPropsFileExists) {
            columnsProps = this.parseColumnProperties(catalogPath);
        }
        for (int i = 0; i < newColNamesToAdd.length; ++i) {
            if (newColNamesToAdd[i] == null) continue;
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            ColumnMetaData cmd = (ColumnMetaData)columnsProps.get(drilledColNames[i]);
            this.put(attributes, BiorMetaControlledVocabulary.ID.toString(), newColNamesToAdd[i]);
            this.put(attributes, BiorMetaControlledVocabulary.OPERATION.toString(), operation);
            String datatype = "";
            if (cmd != null && isColumnsPropsFileExists) {
                datatype = cmd.type.toString();
            }
            this.put(attributes, BiorMetaControlledVocabulary.DATATYPE.toString(), datatype);
            String count = "";
            if (cmd != null && isColumnsPropsFileExists) {
                count = cmd.getCount();
            }
            this.put(attributes, BiorMetaControlledVocabulary.FIELD.toString(), drilledColNames[i]);
            this.put(attributes, BiorMetaControlledVocabulary.NUMBER.toString(), count);
            String fieldDesc = "";
            if (cmd != null && isColumnsPropsFileExists) {
                fieldDesc = cmd.getDescription();
            }
            this.put(attributes, BiorMetaControlledVocabulary.FIELDDESCRIPTION.toString(), fieldDesc);
            String shortName = isDatasourcePropsFileExists ? (String)datasourceProps.get(BiorMetaControlledVocabulary.SHORTNAME.toString()) : "";
            String source = isDatasourcePropsFileExists ? (String)datasourceProps.get(BiorMetaControlledVocabulary.SOURCE.toString()) : "";
            String version = isDatasourcePropsFileExists ? (String)datasourceProps.get(BiorMetaControlledVocabulary.VERSION.toString()) : "";
            String build = isDatasourcePropsFileExists ? (String)datasourceProps.get(BiorMetaControlledVocabulary.BUILD.toString()) : "";
            String desc = isDatasourcePropsFileExists ? (String)datasourceProps.get(BiorMetaControlledVocabulary.DESCRIPTION.toString()) : "";
            this.put(attributes, BiorMetaControlledVocabulary.SHORTNAME.toString(), shortName);
            this.put(attributes, BiorMetaControlledVocabulary.SOURCE.toString(), source);
            this.put(attributes, BiorMetaControlledVocabulary.VERSION.toString(), version);
            this.put(attributes, BiorMetaControlledVocabulary.BUILD.toString(), build);
            this.put(attributes, BiorMetaControlledVocabulary.DESCRIPTION.toString(), desc);
            this.put(attributes, BiorMetaControlledVocabulary.PATH.toString(), catalogPath);
            String biorHeaderLine = this.buildHeaderLine(attributes);
            List<String> head = History.getMetaData().getOriginalHeader();
            head.add(head.size() - 1, biorHeaderLine);
        }
    }

    public void constructAnnotateLine(History history, String dataSourcePath, String columnsDatapath, String operation, String[] newColNamesToAdd, String[] drilledColNames) throws IOException {
        LinkedHashMap<Object, Object> datasourceProps = new LinkedHashMap();
        HashMap<Object, Object> columnsProps = new HashMap();
        boolean isColumnsPropsFileExists = false;
        boolean isDatasourcePropsFileExists = false;
        boolean bl = isDatasourcePropsFileExists = dataSourcePath != null && dataSourcePath.trim().length() > 0 && new File(dataSourcePath).exists();
        if (isDatasourcePropsFileExists) {
            datasourceProps = this.parseDatasourceProperties(dataSourcePath, new LinkedHashMap<String, String>());
        }
        boolean bl2 = isColumnsPropsFileExists = columnsDatapath != null && columnsDatapath.trim().length() > 0 && new File(columnsDatapath).exists();
        if (isColumnsPropsFileExists) {
            columnsProps = this.parseColumnProperties(columnsDatapath);
        }
        for (int i = 0; i < newColNamesToAdd.length; ++i) {
            if (newColNamesToAdd[i] == null) continue;
            LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
            ColumnMetaData cmd = (ColumnMetaData)columnsProps.get(drilledColNames[i]);
            this.put(attributes, BiorMetaControlledVocabulary.ID.toString(), newColNamesToAdd[i]);
            this.put(attributes, BiorMetaControlledVocabulary.OPERATION.toString(), operation);
            String datatype = "";
            if (cmd != null && isColumnsPropsFileExists) {
                datatype = cmd.getType().name();
            }
            this.put(attributes, BiorMetaControlledVocabulary.DATATYPE.toString(), datatype);
            String number = "";
            if (cmd != null && isColumnsPropsFileExists) {
                number = cmd.getCount();
            }
            this.put(attributes, BiorMetaControlledVocabulary.FIELD.toString(), drilledColNames[i]);
            this.put(attributes, BiorMetaControlledVocabulary.NUMBER.toString(), number);
            String fieldDesc = "";
            if (cmd != null && isColumnsPropsFileExists) {
                fieldDesc = cmd.getDescription();
            }
            this.put(attributes, BiorMetaControlledVocabulary.FIELDDESCRIPTION.toString(), fieldDesc);
            String shortName = isDatasourcePropsFileExists ? (String)datasourceProps.get(BiorMetaControlledVocabulary.SHORTNAME.toString()) : "";
            String source = isDatasourcePropsFileExists ? (String)datasourceProps.get(BiorMetaControlledVocabulary.SOURCE.toString()) : "";
            String version = isDatasourcePropsFileExists ? (String)datasourceProps.get(BiorMetaControlledVocabulary.VERSION.toString()) : "";
            String build = isDatasourcePropsFileExists ? (String)datasourceProps.get(BiorMetaControlledVocabulary.BUILD.toString()) : "";
            String desc = isDatasourcePropsFileExists ? (String)datasourceProps.get(BiorMetaControlledVocabulary.DESCRIPTION.toString()) : "";
            this.put(attributes, BiorMetaControlledVocabulary.SHORTNAME.toString(), shortName);
            this.put(attributes, BiorMetaControlledVocabulary.SOURCE.toString(), source);
            this.put(attributes, BiorMetaControlledVocabulary.VERSION.toString(), version);
            this.put(attributes, BiorMetaControlledVocabulary.BUILD.toString(), build);
            this.put(attributes, BiorMetaControlledVocabulary.DESCRIPTION.toString(), desc);
            this.put(attributes, BiorMetaControlledVocabulary.PATH.toString(), dataSourcePath);
            String biorHeaderLine = this.buildHeaderLine(attributes);
            List<String> head = History.getMetaData().getOriginalHeader();
            head.add(head.size() - 1, biorHeaderLine);
        }
    }

    public int fixDrillRow(History h, int columnNumber) {
        int col = -1;
        if (columnNumber > 0) {
            col = columnNumber - h.size() - 1;
        } else if (columnNumber == 0) {
            throw new RuntimeException("You can't specify column number 0, use negative or positive numbers only!");
        }
        return col;
    }

    public String constructDrillLines(History h, String operation, int columnNumber, String[] drillPaths) {
        List<ColumnMetaData> hcol = History.getMetaData().getColumns();
        int col = this.fixDrillRow(h, columnNumber);
        ColumnMetaData cmd = hcol.get(hcol.size() + col);
        String cmeta = cmd.getColumnName();
        int pos = this.getHistoryMetadataLine4HeaderValue(cmeta);
        if (pos == -1) {
            return cmeta;
        }
        String preLine = History.getMetaData().getOriginalHeader().get(pos).toString();
        for (String path : drillPaths) {
            this.putDrillMetaLines(h, operation, preLine, path);
        }
        return cmeta.substring(5);
    }

    public LinkedHashMap<String, String> put3(HashMap<String, ColumnMetaData> properties, LinkedHashMap<String, String> attributes, String dpath) {
        if (properties != null) {
            String type = properties.get(this.fixArrayDrillPath(dpath)).getType().toString();
            String number = properties.get(this.fixArrayDrillPath(dpath)).getCount();
            String field = properties.get(this.fixArrayDrillPath(dpath)).getDescription();
            if (type != null && type.length() > 0) {
                this.put(attributes, BiorMetaControlledVocabulary.DATATYPE.toString(), type);
            }
            if (number != null && number.length() > 0) {
                this.put(attributes, BiorMetaControlledVocabulary.NUMBER.toString(), number);
            }
            if (field != null && field.length() > 0) {
                this.put(attributes, BiorMetaControlledVocabulary.FIELDDESCRIPTION.toString(), field);
            }
        }
        return attributes;
    }

    private void putDrillMetaLines(History h, String operation, String preLine, String dpath) {
        LinkedHashMap<String, String> datasourceattr = this.parseHeaderLine(preLine);
        String catalogPath = (String)((HashMap)datasourceattr).get(BiorMetaControlledVocabulary.PATH.toString());
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        this.put(attributes, BiorMetaControlledVocabulary.ID.toString(), this.getID(h, (Object)((Object)BiorMetaControlledVocabulary.BIOR) + (String)((HashMap)datasourceattr).get(BiorMetaControlledVocabulary.SHORTNAME.toString()) + "." + dpath));
        this.put(attributes, BiorMetaControlledVocabulary.OPERATION.toString(), operation);
        this.put(attributes, BiorMetaControlledVocabulary.FIELD.toString(), this.fixArrayDrillPath(dpath));
        try {
            HashMap<String, ColumnMetaData> properties;
            if (((HashMap)datasourceattr).get(BiorMetaControlledVocabulary.PATH.toString()) != null) {
                properties = this.parseColumnProperties((String)((HashMap)datasourceattr).get(BiorMetaControlledVocabulary.PATH.toString()));
                attributes = this.put3(properties, attributes, dpath);
            } else if (((HashMap)datasourceattr).get(BiorMetaControlledVocabulary.COLUMNPROPERTIES.toString()) != null) {
                properties = this.parseColumnProperties((String)((HashMap)datasourceattr).get(BiorMetaControlledVocabulary.COLUMNPROPERTIES.toString()));
                attributes = this.put3(properties, attributes, dpath);
            }
        }
        catch (IOException e) {
            this.put(attributes, BiorMetaControlledVocabulary.DATATYPE.toString(), ColumnMetaData.Type.String.toString());
            this.put(attributes, BiorMetaControlledVocabulary.NUMBER.toString(), ".");
            this.put(attributes, BiorMetaControlledVocabulary.FIELDDESCRIPTION.toString(), "");
        }
        for (String key : ((HashMap)datasourceattr).keySet()) {
            if (key.equalsIgnoreCase(BiorMetaControlledVocabulary.ID.toString()) || key.equalsIgnoreCase(BiorMetaControlledVocabulary.DATATYPE.toString()) || key.equalsIgnoreCase(BiorMetaControlledVocabulary.NUMBER.toString()) || key.equalsIgnoreCase(BiorMetaControlledVocabulary.FIELDDESCRIPTION.toString()) || key.equalsIgnoreCase(BiorMetaControlledVocabulary.OPERATION.toString()) || key.equalsIgnoreCase(BiorMetaControlledVocabulary.FIELD.toString()) || key.equalsIgnoreCase(BiorMetaControlledVocabulary.FIELDDESCRIPTION.toString())) continue;
            this.put(attributes, key, (String)((HashMap)datasourceattr).get(key));
        }
        List<String> head = h.getMetaData().getOriginalHeader();
        head.add(head.size() - 1, this.buildHeaderLine(attributes));
    }

    public String fixArrayDrillPath(String path) {
        if (path.contains("[")) {
            String ret = path.replaceAll("\\[[\\*|\\d+]\\]", "");
            return ret;
        }
        return path;
    }

    public int getHistoryMetadataLine4HeaderValue(String headerValue) {
        List<String> header = History.getMetaData().getOriginalHeader();
        int i = 0;
        for (String line : header) {
            LinkedHashMap<String, String> attr;
            if (line.startsWith("##BIOR") && (attr = this.parseHeaderLine(line)).get(BiorMetaControlledVocabulary.ID.toString()).equalsIgnoreCase(headerValue)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String buildHeaderLine(LinkedHashMap<String, String> attributes) {
        StringBuilder sb = new StringBuilder();
        sb.append("##BIOR=<");
        String delim = "";
        for (String key : attributes.keySet()) {
            String value = attributes.get(key);
            String kv = key + "=\"" + value + "\"";
            sb.append(delim).append(kv);
            delim = ",";
        }
        sb.append(">");
        return sb.toString();
    }

    public LinkedHashMap<String, String> parseHeaderLine(String line) {
        LinkedHashMap<String, String> hm = new LinkedHashMap<String, String>();
        String half = line.replaceFirst("##BIOR=<", "");
        String removeTrailingGreaterThan = half.substring(0, half.length() - 1);
        String[] split = removeTrailingGreaterThan.split(",");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            while (!split[i].endsWith("\"")) {
                sb.append(split[i]);
                sb.append(",");
                ++i;
            }
            sb.append(split[i]);
            this.parseChunk(sb.toString(), hm);
            sb = new StringBuilder();
        }
        return hm;
    }

    private void parseChunk(String s, HashMap<String, String> hm) {
        int idx = s.indexOf("=");
        if (idx < 0) {
            return;
        }
        String key = s.substring(0, idx);
        String value = s.substring(idx + 2, s.length() - 1);
        hm.put(key, value);
    }

    public static enum BiorMetaControlledVocabulary {
        BIOR("bior."),
        ID("ID"),
        OPERATION("Operation"),
        DATATYPE("DataType"),
        FIELD("Field"),
        FIELDDESCRIPTION("FieldDescription"),
        SHORTNAME("ShortUniqueName"),
        SOURCE("Source"),
        VERSION("Version"),
        BUILD("Build"),
        NUMBER("Number"),
        DESCRIPTION("Description"),
        PATH("Path"),
        COLUMNPROPERTIES("ColumnProperties"),
        DATASOURCEPROPERTIES("DataSourceProperties");

        private String aKey;

        private BiorMetaControlledVocabulary(String aKey) {
            this.aKey = aKey;
        }

        public String toString() {
            return this.aKey;
        }
    }
}

