/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.sage;

import edu.mayo.sage.Logger;
import edu.mayo.sage.NullLogger;
import edu.mayo.sage.TcpLogger;
import edu.mayo.sage.UdpLogger;

public final class LoggerBuilder {
    private static final String PROD_HOST = "bsu-sage.mayo.edu";
    private static final int DEV_UDP = 33124;
    private static final int DEV_TCP = 33123;
    private static final String DEV_HOST = "bsu-sage.mayo.edu";
    private static final int PROD_UDP = 33001;
    private static final int PROD_TCP = 33000;
    private String serverHost;
    private int serverPort;
    private String clientHost = "0.0.0.0";
    private int clientPort = 0;
    private Protocol protocol = Protocol.JSON_UDP;
    private Environment environment = Environment.DEV;

    public LoggerBuilder() {
        this.updateEnvProto();
    }

    private void updateEnvProto() {
        block0 : switch (this.environment) {
            case DEV: {
                this.serverHost = "bsu-sage.mayo.edu";
                switch (this.protocol) {
                    case JSON_UDP: {
                        this.serverPort = 33124;
                        break;
                    }
                    case JSON_TCP: {
                        this.serverPort = 33123;
                    }
                }
                break;
            }
            case PROD: {
                this.serverHost = "bsu-sage.mayo.edu";
                switch (this.protocol) {
                    case JSON_UDP: {
                        this.serverPort = 33001;
                        break block0;
                    }
                    case JSON_TCP: {
                        this.serverPort = 33000;
                    }
                }
            }
        }
    }

    public Logger logger() {
        if (this.serverHost == null) {
            return new NullLogger();
        }
        boolean reportErrors = this.environment == Environment.DEV;
        switch (this.protocol) {
            case JSON_UDP: {
                return new UdpLogger(this.serverHost, this.serverPort, this.clientHost, this.clientPort, reportErrors);
            }
            case JSON_TCP: {
                return new TcpLogger(this.serverHost, this.serverPort, this.clientHost, this.clientPort, reportErrors);
            }
        }
        return new NullLogger();
    }

    static Environment defaultEnvironment() {
        String env = System.getenv().containsKey("edu_mayo_bsu_sage_env") ? System.getenv("edu_mayo_bsu_sage_env") : System.getProperty("edu_mayo_bsu_sage_env");
        if ("dev".equalsIgnoreCase(env)) {
            return Environment.DEV;
        }
        if ("null".equalsIgnoreCase(env)) {
            return Environment.DUMMY;
        }
        return Environment.PROD;
    }

    public LoggerBuilder env(Environment environment) {
        this.environment = environment;
        this.updateEnvProto();
        return this;
    }

    public LoggerBuilder protocol(Protocol protocol) {
        this.protocol = protocol;
        this.updateEnvProto();
        return this;
    }

    public LoggerBuilder prod() {
        return this.env(Environment.PROD);
    }

    public LoggerBuilder dev() {
        return this.env(Environment.DEV);
    }

    public LoggerBuilder dummy() {
        return this.env(Environment.DUMMY);
    }

    public LoggerBuilder tcp() {
        return this.protocol(Protocol.JSON_TCP);
    }

    public LoggerBuilder udp() {
        return this.protocol(Protocol.JSON_UDP);
    }

    public LoggerBuilder clientHost(String clientHost) {
        this.clientHost = clientHost;
        return this;
    }

    public LoggerBuilder clientPort(int clientPort) {
        this.clientPort = clientPort;
        return this;
    }

    public LoggerBuilder serverHost(String serverHost) {
        this.serverHost = serverHost;
        return this;
    }

    public LoggerBuilder serverPort(int serverPort) {
        this.serverPort = serverPort;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Protocol {
        JSON_UDP,
        JSON_TCP;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Environment {
        DUMMY,
        DEV,
        PROD;

    }
}

