/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.tar;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import org.codehaus.plexus.archiver.tar.TarEntry;
import org.codehaus.plexus.archiver.tar.TarFile;
import org.codehaus.plexus.archiver.tar.TarResource;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoArchiveResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlexusIoTarFileResourceCollection
extends AbstractPlexusIoArchiveResourceCollection {
    public static final String ROLE_HINT = "tar";

    protected TarFile newTarFile(File file) {
        return new TarFile(file);
    }

    protected Iterator<PlexusIoResource> getEntries() throws IOException {
        File f = this.getFile();
        if (f == null) {
            throw new IOException("The tar archive file has not been set.");
        }
        final TarFile tarFile = this.newTarFile(f);
        final Enumeration en = tarFile.getEntries();
        return new Iterator<PlexusIoResource>(){

            @Override
            public boolean hasNext() {
                return en.hasMoreElements();
            }

            @Override
            public PlexusIoResource next() {
                TarEntry entry = (TarEntry)en.nextElement();
                return new TarResource(tarFile, entry);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removing isn't implemented.");
            }
        };
    }
}

