/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.util.test;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import edu.mayo.pipes.util.test.PipeTestUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;

public class FileCompareUtils {
    public static final String EOL = System.getProperty("line.separator");

    public static void assertFileEquals(String fileExpected, String fileActual) throws IOException {
        List linesExpected = Files.readLines((File)new File(fileExpected), (Charset)Charset.forName("UTF-8"));
        List linesActual = Files.readLines((File)new File(fileActual), (Charset)Charset.forName("UTF-8"));
        PipeTestUtils.assertListsEqual(linesExpected, linesActual);
        Assert.assertEquals((String)"There should be the same number of variants in the output as were in the input.  ", (long)Files.readLines((File)new File(fileExpected), (Charset)Charset.forName("UTF-8")).size(), (long)Files.readLines((File)new File(fileActual), (Charset)Charset.forName("UTF-8")).size());
    }

    public static void saveToFile(ArrayList<String> lines, String filePath) throws IOException {
        StringBuilder str = new StringBuilder();
        for (String line : lines) {
            str.append(line);
            str.append(EOL);
        }
        Files.write((byte[])str.toString().getBytes(), (File)new File(filePath));
    }

    public static List<String> loadFile(String filePath) throws IOException {
        return Files.readLines((File)new File(filePath), (Charset)Charsets.UTF_8);
    }
}

