/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FieldSpecification {
    private List<FieldRange> mRanges = new ArrayList<FieldRange>();
    private FieldDirection mDirection;

    public FieldSpecification(String spec) {
        this(spec, FieldDirection.LEFT_TO_RIGHT);
    }

    public FieldSpecification(String spec, FieldDirection direction) {
        this.mDirection = direction;
        for (String rangeStr : spec.split(",")) {
            FieldRange range;
            if (rangeStr.contains("-")) {
                if (rangeStr.charAt(0) == '-') {
                    range = new FieldRange();
                    range.type = Type.FIRST_TO_MTH;
                    range.mthField = new Integer(rangeStr.substring(1));
                } else if (rangeStr.charAt(rangeStr.length() - 1) == '-') {
                    range = new FieldRange();
                    range.type = Type.NTH_TO_END;
                    range.nthField = new Integer(rangeStr.substring(0, rangeStr.length() - 1));
                } else {
                    range = new FieldRange();
                    range.type = Type.NTH_TO_MTH;
                    String[] arr = rangeStr.split("-");
                    range.nthField = new Integer(arr[0]);
                    range.mthField = new Integer(arr[1]);
                }
            } else {
                range = new FieldRange();
                range.type = Type.NTH_ONLY;
                range.nthField = new Integer(rangeStr);
            }
            this.mRanges.add(range);
        }
    }

    public Map<FieldType, List<Integer>> getFields(int numFields) {
        HashMap<FieldType, List<Integer>> m = new HashMap<FieldType, List<Integer>>();
        ArrayList<Integer> matches = new ArrayList<Integer>();
        block6: for (FieldRange range : this.mRanges) {
            Integer nthField = range.nthField;
            Integer mthField = range.mthField;
            if (this.mDirection.equals((Object)FieldDirection.RIGHT_TO_LEFT)) {
                if (range.nthField != null) {
                    nthField = numFields - range.nthField + 1;
                }
                if (range.mthField != null) {
                    mthField = numFields - range.mthField + 1;
                }
            }
            switch (range.type) {
                case NTH_ONLY: {
                    matches.add(nthField);
                    break;
                }
                case FIRST_TO_MTH: {
                    int i;
                    for (i = 1; i <= mthField; ++i) {
                        matches.add(i);
                    }
                    continue block6;
                }
                case NTH_TO_END: {
                    int i;
                    for (i = nthField.intValue(); i <= numFields; ++i) {
                        matches.add(i);
                    }
                    continue block6;
                }
                case NTH_TO_MTH: {
                    int start = nthField;
                    int end = mthField;
                    if (this.mDirection.equals((Object)FieldDirection.RIGHT_TO_LEFT)) {
                        start = mthField;
                        end = nthField;
                    }
                    for (int i = start; i <= end; ++i) {
                        matches.add(i);
                    }
                    break;
                }
            }
        }
        Collections.sort(matches);
        m.put(FieldType.MATCH, matches);
        ArrayList<Integer> nonMatches = new ArrayList<Integer>();
        for (int i = 1; i <= numFields; ++i) {
            if (matches.contains(i)) continue;
            nonMatches.add(i);
        }
        Collections.sort(nonMatches);
        m.put(FieldType.NON_MATCH, nonMatches);
        return m;
    }

    class FieldRange {
        public Type type;
        public Integer nthField;
        public Integer mthField;

        FieldRange() {
        }
    }

    static enum Type {
        NTH_ONLY,
        NTH_TO_END,
        NTH_TO_MTH,
        FIRST_TO_MTH;

    }

    public static enum FieldDirection {
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT;

    }

    public static enum FieldType {
        MATCH,
        NON_MATCH;

    }
}

