/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.Instruction;
import org.biojava.utils.bytecode.Label;

class LabelInstruction
implements Instruction {
    private final Label l;
    private final byte opcode;
    private final int delta;

    LabelInstruction(byte op, Label l, int delta) {
        if (l == null) {
            throw new NullPointerException("Label can not be null");
        }
        this.opcode = op;
        this.l = l;
        this.delta = delta;
    }

    public void writeCode(CodeContext ctx) throws CodeException {
        ctx.writeByte(this.opcode);
        ctx.writeLabel(this.l);
    }

    public int stackDepth() {
        return 0;
    }

    public int stackDelta() {
        return this.delta;
    }
}

