/*
 * Decompiled with CFR 0.152.
 */
package flanagan.io;

import flanagan.circuits.Phasor;
import flanagan.complex.Complex;
import flanagan.io.FileOutput;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;

public class FileInput {
    protected String fileName = " ";
    protected String stemName = " ";
    protected String extension = " ";
    protected String pathName = " ";
    protected String dirPath = " ";
    protected String fullLine = " ";
    protected String fullLineT = " ";
    protected BufferedReader input = null;
    protected boolean testFullLine = false;
    protected boolean testFullLineT = false;
    protected boolean eof = false;
    protected boolean fileFound = true;
    protected boolean inputType = false;
    protected boolean charType = false;
    protected boolean space = true;
    protected boolean supressMessage = false;
    protected boolean wordMethod = false;
    protected String holdingWord = "HoldingWordMLPYGV";

    public FileInput() {
    }

    public FileInput(String pathName) {
        int posDot;
        this.pathName = pathName;
        int posSlash = pathName.indexOf("//");
        int posBackSlash = pathName.indexOf("\\");
        if (posSlash != -1 || posBackSlash != -1) {
            File file = new File(this.pathName);
            this.fileName = file.getName();
            this.dirPath = file.getParentFile().toString();
        }
        if ((posDot = this.fileName.indexOf(46)) == -1) {
            this.stemName = this.fileName;
        } else {
            this.stemName = this.fileName.substring(0, posDot);
            this.extension = this.fileName.substring(posDot);
        }
        try {
            this.input = new BufferedReader(new FileReader(this.pathName));
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
            this.fileFound = false;
        }
    }

    public String getPathName() {
        return this.pathName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getStemName() {
        return this.stemName;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public void removeSpaceAsDelimiter() {
        this.space = false;
    }

    public void restoreSpaceAsDelimiter() {
        this.space = true;
    }

    public final synchronized void copy(String copyFilename) {
        FileOutput fout = new FileOutput(copyFilename);
        int nLines = this.numberOfLines();
        for (int i = 0; i < nLines; ++i) {
            String cline = this.readLine();
            fout.println(cline);
        }
        fout.close();
    }

    public final synchronized double readDouble() {
        this.inputType = true;
        String word = "";
        double dd = 0.0;
        if (!this.testFullLineT) {
            this.enterLine();
        }
        word = this.nextWord();
        if (!this.eof) {
            dd = Double.parseDouble(word.trim());
        }
        return dd;
    }

    public final synchronized float readFloat() {
        this.inputType = true;
        String word = "";
        float ff = 0.0f;
        if (!this.testFullLineT) {
            this.enterLine();
        }
        word = this.nextWord();
        if (!this.eof) {
            ff = Float.parseFloat(word.trim());
        }
        return ff;
    }

    public final synchronized BigDecimal readBigDecimal() {
        this.inputType = true;
        String word = "";
        BigDecimal big = null;
        if (!this.testFullLineT) {
            this.enterLine();
        }
        word = this.nextWord();
        if (!this.eof) {
            big = new BigDecimal(word.trim());
        }
        return big;
    }

    public final synchronized int readInt() {
        this.inputType = true;
        String word = "";
        int ii = 0;
        if (!this.testFullLineT) {
            this.enterLine();
        }
        word = this.nextWord();
        if (!this.eof) {
            ii = Integer.parseInt(word.trim());
        }
        return ii;
    }

    public final synchronized long readLong() {
        this.inputType = true;
        String word = "";
        long ll = 0L;
        if (!this.testFullLineT) {
            this.enterLine();
        }
        word = this.nextWord();
        if (!this.eof) {
            ll = Long.parseLong(word.trim());
        }
        return ll;
    }

    public final synchronized BigInteger readBigInteger() {
        this.inputType = true;
        String word = "";
        BigInteger big = null;
        if (!this.testFullLineT) {
            this.enterLine();
        }
        word = this.nextWord();
        if (!this.eof) {
            big = new BigInteger(word.trim());
        }
        return big;
    }

    public final synchronized short readShort() {
        this.inputType = true;
        String word = "";
        short ss = 0;
        if (!this.testFullLineT) {
            this.enterLine();
        }
        word = this.nextWord();
        if (!this.eof) {
            ss = Short.parseShort(word.trim());
        }
        return ss;
    }

    public final synchronized byte readByte() {
        this.inputType = true;
        String word = "";
        byte bb = 0;
        if (!this.testFullLineT) {
            this.enterLine();
        }
        word = this.nextWord();
        if (!this.eof) {
            bb = Byte.parseByte(word.trim());
        }
        return bb;
    }

    public final synchronized Complex readComplex() {
        this.inputType = true;
        String word = "";
        Complex cc = null;
        if (!this.testFullLineT) {
            this.enterLine();
        }
        word = this.nextWord();
        if (!this.eof) {
            cc = Complex.parseComplex(word.trim());
        }
        return cc;
    }

    public final synchronized Phasor readPhasor() {
        this.inputType = true;
        String word = "";
        Phasor ph = null;
        if (!this.testFullLineT) {
            this.enterLine();
        }
        word = this.nextWord();
        if (!this.eof) {
            ph = Phasor.parsePhasor(word.trim());
        }
        return ph;
    }

    public final synchronized boolean readBoolean() {
        boolean retB = true;
        String retS = this.readWord();
        if (retS.equals("false") || retS.equals("FALSE")) {
            retB = false;
        } else if (retS.equals("true") || retS.equals("TRUE")) {
            retB = true;
        } else {
            throw new IllegalArgumentException("attempted input neither true nor false");
        }
        return retB;
    }

    public final synchronized String readWord() {
        this.inputType = true;
        this.wordMethod = true;
        String word = "";
        if (!this.testFullLineT) {
            this.enterLine();
        }
        if (this.fullLine.equals("")) {
            word = " ";
        } else {
            word = this.nextWord();
            if (word.equals("")) {
                word = " ";
            }
            if (word.trim().equals(this.holdingWord)) {
                word = " ";
            }
        }
        return word;
    }

    public final synchronized String readWordSaceOnly() {
        this.inputType = false;
        String word = "";
        if (!this.testFullLineT) {
            this.enterLine();
        }
        if (this.fullLine.equals("")) {
            word = "";
        } else {
            word = this.nextWord();
            if (word.equals("")) {
                word = " ";
            }
        }
        return word;
    }

    public final synchronized String readLine() {
        this.inputType = false;
        return this.readLineL();
    }

    protected final synchronized String readLineL() {
        String line = "";
        try {
            line = this.input.readLine();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        if (line == null) {
            if (!this.supressMessage) {
                System.out.println("Attempt to read beyond the end of the file");
            }
            this.eof = true;
            line = "";
        }
        return line;
    }

    public final synchronized char readChar() {
        this.inputType = true;
        this.charType = true;
        String word = "";
        char ch = ' ';
        if (!this.testFullLine) {
            this.enterLine();
        }
        if ((word = this.nextWord()).length() != 1) {
            throw new IllegalArgumentException("attempt to read more than one character into type char");
        }
        if (!this.eof) {
            ch = word.charAt(0);
        }
        return ch;
    }

    public final synchronized void close() {
        if (this.fileFound) {
            try {
                this.input.close();
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
    }

    public boolean eol() {
        boolean eol = false;
        if (!this.testFullLineT) {
            eol = true;
        }
        return eol;
    }

    public boolean eof() {
        return this.eof;
    }

    public boolean fileFound() {
        return this.fileFound;
    }

    protected final synchronized void enterLine() {
        int i = 0;
        this.fullLine = this.readLineL();
        if (this.wordMethod) {
            this.checkWordSpaces();
        }
        this.fullLineT = this.fullLine;
        if (!this.fullLine.equals("")) {
            for (i = this.fullLineT.length() - 1; this.fullLineT.charAt(i) == ' ' && i >= 0; --i) {
                this.fullLineT = this.fullLineT.substring(0, i);
            }
        }
    }

    public void checkWordSpaces() {
        int len = this.fullLine.length();
        if (this.wordMethod) {
            boolean test3 = false;
            ArrayList<Integer> al1 = new ArrayList<Integer>();
            ArrayList<Integer> al2 = new ArrayList<Integer>();
            for (int i = 0; i < len; ++i) {
                test3 = false;
                if (this.fullLine.charAt(i) == '\t') {
                    test3 = true;
                }
                if (this.fullLine.charAt(i) == ',') {
                    test3 = true;
                }
                if (this.fullLine.charAt(i) == ':') {
                    test3 = true;
                }
                if (this.fullLine.charAt(i) == ';') {
                    test3 = true;
                }
                if (!test3) continue;
                al1.add(new Integer(i));
            }
            int nal1 = al1.size();
            if (nal1 > 0) {
                boolean test4 = true;
                boolean test5 = true;
                boolean test6 = false;
                int ii = 0;
                int jj = 0;
                int kk = 0;
                while (test4) {
                    int i;
                    test5 = true;
                    test6 = false;
                    jj = (Integer)al1.get(ii);
                    if (jj == 0) {
                        test6 = true;
                    } else if (jj == len - 1) {
                        test6 = true;
                        test4 = false;
                    } else if (ii == nal1 - 1) {
                        test5 = true;
                        for (i = jj + 1; i < len; ++i) {
                            if (this.fullLine.charAt(i) != ' ') {
                                test5 = false;
                            }
                            if (!test5) break;
                        }
                        if (test5) {
                            test6 = true;
                        }
                        test4 = false;
                    } else {
                        kk = (Integer)al1.get(ii + 1);
                        test5 = true;
                        for (i = jj + 1; i < kk; ++i) {
                            if (this.fullLine.charAt(i) != ' ') {
                                test5 = false;
                            }
                            if (!test5) break;
                        }
                        if (test5) {
                            test6 = true;
                        }
                        ++ii;
                    }
                    if (test6) {
                        al2.add(new Integer(jj + 1));
                    }
                    if (ii < nal1) continue;
                    test4 = false;
                }
                int nal2 = al2.size();
                if (nal2 > 0) {
                    for (int i = nal2 - 1; i >= 0; --i) {
                        int mm = (Integer)al2.get(i);
                        if (mm >= len - 1) {
                            this.fullLine = this.fullLine + this.holdingWord;
                            continue;
                        }
                        if (mm == 1) {
                            this.fullLine = this.holdingWord + this.fullLine;
                            continue;
                        }
                        String sub1 = this.fullLine.substring(0, mm);
                        String sub2 = this.fullLine.substring(mm);
                        this.fullLine = sub1 + this.holdingWord + sub2;
                    }
                }
            }
        }
    }

    protected final synchronized String nextWord() {
        this.testFullLine = true;
        this.testFullLineT = true;
        String word = "";
        int posspa = -1;
        int postab = -1;
        int possp = -1;
        int poscom = -1;
        int poscol = -1;
        int possem = -1;
        boolean test = true;
        int len = this.fullLine.length();
        boolean test0 = true;
        boolean test1 = false;
        int pend = this.fullLine.length();
        while (test0) {
            if (this.fullLine.charAt(--pend) == ' ') {
                test1 = true;
            }
            if (this.fullLine.charAt(pend) == '\t') {
                test1 = true;
            }
            if (this.inputType) {
                if (this.fullLine.charAt(pend) == ',') {
                    test1 = true;
                }
                if (this.fullLine.charAt(pend) == ':') {
                    test1 = true;
                }
                if (this.fullLine.charAt(pend) == ';') {
                    test1 = true;
                }
            }
            if (test1) {
                this.fullLine = this.fullLine.substring(0, pend);
            } else {
                test0 = false;
            }
            test1 = false;
        }
        test0 = true;
        test1 = false;
        while (test0) {
            if (this.fullLine.charAt(0) == ' ') {
                test1 = true;
            }
            if (this.fullLine.charAt(0) == '\t') {
                test1 = true;
            }
            if (this.inputType) {
                if (this.fullLine.charAt(0) == ',') {
                    test1 = true;
                }
                if (this.fullLine.charAt(0) == ':') {
                    test1 = true;
                }
                if (this.fullLine.charAt(0) == ';') {
                    test1 = true;
                }
            }
            if (test1) {
                this.fullLine = this.fullLine.substring(1);
            } else {
                test0 = false;
            }
            test1 = false;
        }
        int lenPlus = this.fullLine.length() + 10;
        if (this.space) {
            posspa = this.fullLine.indexOf(32);
        }
        postab = this.fullLine.indexOf(9);
        int firstMin = lenPlus;
        int secondMin = lenPlus;
        int thirdMin = lenPlus;
        if (this.space) {
            firstMin = posspa == -1 && postab == -1 ? lenPlus : (posspa == -1 ? postab : (postab == -1 ? posspa : Math.min(posspa, postab)));
        } else if (postab != -1) {
            firstMin = postab;
        }
        if (this.inputType) {
            poscom = this.fullLine.indexOf(44);
            poscol = this.fullLine.indexOf(58);
            possem = this.fullLine.indexOf(59);
            secondMin = poscom == -1 && poscol == -1 ? lenPlus : (poscom == -1 ? poscol : (poscol == -1 ? poscom : Math.min(poscom, poscol)));
            thirdMin = possem == -1 ? lenPlus : possem;
            secondMin = Math.min(secondMin, thirdMin);
            firstMin = Math.min(firstMin, secondMin);
        }
        if (firstMin == lenPlus) {
            word = this.fullLine;
            this.fullLine = "";
            this.testFullLine = false;
        } else {
            word = this.fullLine.substring(0, firstMin);
            if (firstMin + 1 > this.fullLine.length()) {
                this.fullLine = "";
                this.testFullLine = false;
            } else {
                this.fullLine = this.fullLine.substring(firstMin + 1);
                if (this.fullLine.length() == 0) {
                    this.testFullLine = false;
                }
            }
        }
        if (this.testFullLineT) {
            if (!this.testFullLine) {
                this.testFullLineT = false;
                this.fullLineT = "";
            } else if (firstMin + 1 > this.fullLineT.length()) {
                this.fullLineT = "";
                this.testFullLineT = false;
            }
        }
        return word;
    }

    protected final synchronized char nextCharInString() {
        this.testFullLine = true;
        char ch = ' ';
        boolean test = true;
        ch = this.fullLine.charAt(0);
        this.fullLine = this.fullLine.substring(1);
        if (this.fullLine.length() == 0) {
            this.testFullLine = false;
        }
        if (this.testFullLineT) {
            this.fullLineT = this.fullLineT.substring(1);
            if (this.fullLineT.length() == 0) {
                this.testFullLineT = false;
            }
        }
        return ch;
    }

    public void setSupressMessageToTrue() {
        this.supressMessage = true;
    }

    public void setSupressMessageToFalse() {
        this.supressMessage = false;
    }

    public final synchronized int numberOfLines() {
        FileInput fin = new FileInput(this.pathName);
        fin.setSupressMessageToTrue();
        boolean test = true;
        int nLines = 0;
        while (test) {
            String inputLine = fin.readLineL();
            if (fin.eof) {
                test = false;
                continue;
            }
            if (nLines == Integer.MAX_VALUE) {
                System.out.println("Class FileInput; method numberOfLines; The number of lines is greater than the maximum integer value, 2147483647");
                System.out.println("-1 returned");
                nLines = -1;
                continue;
            }
            ++nLines;
        }
        fin.close();
        return nLines;
    }

    public static void deleteFile(String fileName) {
        boolean deleteDone;
        String[] dirFiles;
        boolean flag = true;
        File file0 = new File(fileName);
        if (!file0.exists()) {
            System.out.println("Method deleteFile: no file or directory of the name " + fileName + " found");
            flag = false;
        }
        if (!file0.canWrite()) {
            System.out.println("Method deleteFile: " + fileName + " is write protected and cannot be deleted");
            flag = false;
        }
        if (file0.isDirectory() && (dirFiles = file0.list()).length > 0) {
            System.out.println("Method deleteFile: " + fileName + " is a directory which is not empty; no action was taken");
            flag = false;
        }
        if (!(deleteDone = file0.delete())) {
            System.out.println("Method deleteFile: deletion of the file " + fileName + " failed");
        }
    }
}

