/*
 * Decompiled with CFR 0.152.
 */
package flanagan.circuits;

import flanagan.circuits.Impedance;
import flanagan.complex.Complex;
import flanagan.math.Fmath;
import flanagan.math.VectorMaths;
import java.io.IOException;

public class Phasor {
    private double magnitude = 0.0;
    private double phaseInDeg = 0.0;
    private double phaseInRad = 0.0;
    private Complex rectangular = new Complex(0.0, 0.0);
    private static double frequency = Double.NaN;
    private static double omega = Double.NaN;

    public Phasor() {
    }

    public Phasor(double magnitude, double phase) {
        this.magnitude = magnitude;
        this.phaseInDeg = phase;
        this.phaseInRad = Math.toRadians(phase);
        this.rectangular.polar(this.magnitude, this.phaseInRad);
    }

    public Phasor(double magnitude) {
        this.magnitude = magnitude;
        this.rectangular.polar(this.magnitude, this.phaseInRad);
    }

    public static void setFrequency(double freq) {
        if (!Fmath.isNaN(frequency)) {
            throw new IllegalArgumentException("You have already entered a value for the frequency, " + frequency + ", that differs from the one you are now attempting to enter, " + freq);
        }
        frequency = freq;
        omega = Math.PI * 2 * freq;
    }

    public static void setRadialFrequency(double omega) {
        if (!Fmath.isNaN(Phasor.omega)) {
            throw new IllegalArgumentException("You have already entered a value for the radial frequency, omega, " + Phasor.omega + ", that differs from the one you are now attempting to enter, " + omega);
        }
        Phasor.omega = omega;
        frequency = Phasor.omega / (Math.PI * 2);
    }

    public void setMagnitude(double magnitude) {
        this.magnitude = magnitude;
        this.rectangular.polar(this.magnitude, this.phaseInRad);
    }

    public void setPhaseInDegrees(double phase) {
        this.phaseInDeg = phase;
        this.phaseInRad = Math.toRadians(phase);
        this.rectangular.polar(this.magnitude, this.phaseInRad);
    }

    public void reset(double magnitude, double phaseInDegrees) {
        this.magnitude = magnitude;
        this.phaseInDeg = phaseInDegrees;
        this.phaseInRad = Math.toRadians(phaseInDegrees);
        this.rectangular.polar(this.magnitude, this.phaseInRad);
    }

    public static double getFrequency() {
        return frequency;
    }

    public static double setRadialFrequency() {
        return omega;
    }

    public double getMagnitude() {
        return this.magnitude;
    }

    public double getPhaseInDegrees() {
        return this.phaseInDeg;
    }

    public double getPhaseInRadians() {
        return this.phaseInRad;
    }

    public double getReal() {
        return this.magnitude * Math.cos(this.phaseInRad);
    }

    public double getImag() {
        return this.magnitude * Math.sin(this.phaseInRad);
    }

    public static Phasor toPhasor(Complex cc) {
        Phasor ph = new Phasor();
        ph.magnitude = cc.abs();
        ph.phaseInRad = cc.argRad();
        ph.phaseInDeg = cc.argDeg();
        ph.rectangular = cc;
        return ph;
    }

    public Complex toRectangular() {
        Complex cc = new Complex();
        cc.polar(this.magnitude, this.phaseInRad);
        return cc;
    }

    public static Complex toRectangular(Phasor ph) {
        Complex cc = new Complex();
        cc.polar(ph.magnitude, ph.phaseInRad);
        return cc;
    }

    public Complex toComplex() {
        Complex cc = new Complex();
        cc.polar(this.magnitude, this.phaseInRad);
        return cc;
    }

    public static Complex toComplex(Phasor ph) {
        Complex cc = new Complex();
        cc.polar(ph.magnitude, ph.phaseInRad);
        return cc;
    }

    public VectorMaths toVectorMaths() {
        double x = this.magnitude * Math.sin(this.phaseInRad);
        double y = this.magnitude * Math.cos(this.phaseInRad);
        VectorMaths vec = new VectorMaths(x, y);
        return vec;
    }

    public static VectorMaths toVectorMaths(Phasor ph) {
        double x = ph.magnitude * Math.sin(ph.phaseInRad);
        double y = ph.magnitude * Math.cos(ph.phaseInRad);
        VectorMaths vec = new VectorMaths(x, y);
        return vec;
    }

    public String toString() {
        return this.magnitude + "<" + this.phaseInDeg + "deg";
    }

    public static String toString(Phasor ph) {
        return ph.magnitude + "<" + ph.phaseInDeg + "deg";
    }

    public static Phasor parsePhasor(String ss) {
        int radPos;
        Phasor ph = new Phasor();
        int anglePos = (ss = ss.trim()).indexOf(60);
        if (anglePos == -1 && (anglePos = ss.indexOf(76)) == -1) {
            throw new IllegalArgumentException("no angle symbol, <, in the string, ss");
        }
        int degPos = ss.indexOf(100);
        if (degPos == -1) {
            degPos = ss.indexOf(68);
        }
        if ((radPos = ss.indexOf(114)) == -1) {
            degPos = ss.indexOf(82);
        }
        String mag = ss.substring(0, anglePos);
        ph.magnitude = Double.parseDouble(mag);
        String phas = null;
        if (degPos != -1) {
            phas = ss.substring(anglePos + 1, degPos);
            ph.phaseInDeg = Double.parseDouble(mag);
            ph.phaseInRad = Math.toRadians(ph.phaseInDeg);
        }
        if (degPos == -1 && radPos == -1) {
            phas = ss.substring(anglePos + 1);
            ph.phaseInDeg = Double.parseDouble(phas);
            ph.phaseInRad = Math.toRadians(ph.phaseInDeg);
        }
        if (radPos != -1) {
            phas = ss.substring(anglePos + 1, radPos);
            ph.phaseInRad = Double.parseDouble(phas);
            ph.phaseInDeg = Math.toDegrees(ph.phaseInRad);
        }
        ph.rectangular.polar(ph.magnitude, ph.phaseInRad);
        return ph;
    }

    public static Phasor valueOf(String ss) {
        return Phasor.parsePhasor(ss);
    }

    public static final synchronized Phasor readPhasor(String prompt) {
        int ch = 32;
        String phstring = "";
        boolean done = false;
        System.out.print(prompt + " ");
        System.out.flush();
        while (!done) {
            try {
                ch = System.in.read();
                if (ch < 0 || (char)ch == '\n') {
                    done = true;
                    continue;
                }
                phstring = phstring + (char)ch;
            }
            catch (IOException e) {
                done = true;
            }
        }
        return Phasor.parsePhasor(phstring);
    }

    public static final synchronized Phasor readPhasor(String prompt, String dflt) {
        int ch = 32;
        String phstring = "";
        boolean done = false;
        System.out.print(prompt + " [default value = " + dflt + "]  ");
        System.out.flush();
        int i = 0;
        while (!done) {
            try {
                ch = System.in.read();
                if (ch < 0 || (char)ch == '\n' || (char)ch == '\r') {
                    if (i == 0) {
                        phstring = dflt;
                        if ((char)ch == '\r') {
                            ch = System.in.read();
                        }
                    }
                    done = true;
                    continue;
                }
                phstring = phstring + (char)ch;
                ++i;
            }
            catch (IOException e) {
                done = true;
            }
        }
        return Phasor.parsePhasor(phstring);
    }

    public static final synchronized Phasor readPhasor(String prompt, Phasor dflt) {
        int ch = 32;
        String phstring = "";
        boolean done = false;
        System.out.print(prompt + " [default value = " + dflt + "]  ");
        System.out.flush();
        int i = 0;
        while (!done) {
            try {
                ch = System.in.read();
                if (ch < 0 || (char)ch == '\n' || (char)ch == '\r') {
                    if (i == 0) {
                        if ((char)ch == '\r') {
                            ch = System.in.read();
                        }
                        return dflt;
                    }
                    done = true;
                    continue;
                }
                phstring = phstring + (char)ch;
                ++i;
            }
            catch (IOException e) {
                done = true;
            }
        }
        return Phasor.parsePhasor(phstring);
    }

    public static final synchronized Phasor readPhasor() {
        int ch = 32;
        String phstring = "";
        boolean done = false;
        System.out.print(" ");
        System.out.flush();
        while (!done) {
            try {
                ch = System.in.read();
                if (ch < 0 || (char)ch == '\n') {
                    done = true;
                    continue;
                }
                phstring = phstring + (char)ch;
            }
            catch (IOException e) {
                done = true;
            }
        }
        return Phasor.parsePhasor(phstring);
    }

    public void println(String message) {
        System.out.println(message + " " + this.toString());
    }

    public void println() {
        System.out.println(" " + this.toString());
    }

    public void print(String message) {
        System.out.print(message + " " + this.toString());
    }

    public void print() {
        System.out.print(" " + this.toString());
    }

    public static void println(String message, Phasor[] aa) {
        System.out.println(message);
        for (int i = 0; i < aa.length; ++i) {
            System.out.println(aa[i].toString() + "  ");
        }
    }

    public static void println(Phasor[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.println(aa[i].toString() + "  ");
        }
    }

    public static void print(String message, Phasor[] aa) {
        System.out.print(message + " ");
        for (int i = 0; i < aa.length; ++i) {
            System.out.print(aa[i].toString() + "   ");
        }
        System.out.println();
    }

    public static void print(Phasor[] aa) {
        for (int i = 0; i < aa.length; ++i) {
            System.out.print(aa[i].toString() + "  ");
        }
        System.out.println();
    }

    public Phasor truncate(int prec) {
        if (prec < 0) {
            return this;
        }
        double xMa = this.magnitude;
        double xPd = this.phaseInDeg;
        double xPr = this.phaseInRad;
        Complex xRect = this.rectangular;
        Phasor y = new Phasor();
        y.magnitude = Fmath.truncate(xMa, prec);
        y.phaseInDeg = Fmath.truncate(xPd, prec);
        y.phaseInRad = Fmath.truncate(xPr, prec);
        y.rectangular = Complex.truncate(xRect, prec);
        return y;
    }

    public static Phasor truncate(Phasor ph, int prec) {
        if (prec < 0) {
            return ph;
        }
        double xMa = ph.magnitude;
        double xPd = ph.phaseInDeg;
        double xPr = ph.phaseInRad;
        Complex xRect = ph.rectangular;
        Phasor y = new Phasor();
        y.magnitude = Fmath.truncate(xMa, prec);
        y.phaseInDeg = Fmath.truncate(xPd, prec);
        y.phaseInRad = Fmath.truncate(xPr, prec);
        y.rectangular = Complex.truncate(xRect, prec);
        return y;
    }

    public int hashCode() {
        long lmagnt = Double.doubleToLongBits(this.magnitude);
        long lphase = Double.doubleToLongBits(this.phaseInDeg);
        int hmagnt = (int)(lmagnt ^ lmagnt >>> 32);
        int hphase = (int)(lphase ^ lphase >>> 32);
        return 6 * (hmagnt / 10) + 4 * (hphase / 10);
    }

    public static Phasor[] oneDarray(int n) {
        Phasor[] a = new Phasor[n];
        Phasor b = new Phasor();
        b.reset(1.0, 0.0);
        for (int i = 0; i < n; ++i) {
            a[i] = b;
        }
        return a;
    }

    public static Phasor[] oneDarray(int n, double a, double b) {
        Phasor[] phArray = new Phasor[n];
        Phasor ph = new Phasor();
        ph.reset(a, b);
        for (int i = 0; i < n; ++i) {
            phArray[i] = ph;
        }
        return phArray;
    }

    public static Phasor[] oneDarray(int n, Phasor constant) {
        Phasor[] ph = new Phasor[n];
        for (int i = 0; i < n; ++i) {
            ph[i] = constant.copy();
        }
        return ph;
    }

    public static Phasor[][] twoDarray(int n, int m) {
        Phasor[][] phArray = new Phasor[n][m];
        Phasor ph = new Phasor();
        ph.reset(1.0, 0.0);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                phArray[i][j] = ph;
            }
        }
        return phArray;
    }

    public static Phasor[][] twoDarray(int n, int m, double a, double b) {
        Phasor[][] phArray = new Phasor[n][m];
        Phasor ph = new Phasor();
        ph.reset(a, b);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                phArray[i][j] = ph;
            }
        }
        return phArray;
    }

    public static Phasor[][] twoDarray(int n, int m, Phasor constant) {
        Phasor[][] phArray = new Phasor[n][m];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                phArray[i][j] = constant.copy();
            }
        }
        return phArray;
    }

    public static Phasor[][][] threeDarray(int n, int m, int l) {
        Phasor[][][] phArray = new Phasor[n][m][l];
        Phasor ph = new Phasor();
        ph.reset(1.0, 0.0);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                for (int k = 0; k < l; ++k) {
                    phArray[i][j][k] = ph;
                }
            }
        }
        return phArray;
    }

    public static Phasor[][][] threeDarray(int n, int m, int l, double a, double b) {
        Phasor[][][] phArray = new Phasor[n][m][l];
        Phasor ph = new Phasor();
        ph.reset(a, b);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                for (int k = 0; k < l; ++k) {
                    phArray[i][j][k] = ph;
                }
            }
        }
        return phArray;
    }

    public static Phasor[][][] threeDarray(int n, int m, int l, Phasor constant) {
        Phasor[][][] phArray = new Phasor[n][m][l];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                for (int k = 0; k < l; ++k) {
                    phArray[i][j][k] = constant.copy();
                }
            }
        }
        return phArray;
    }

    public Phasor copy() {
        if (this == null) {
            return null;
        }
        Phasor b = new Phasor();
        b.magnitude = this.magnitude;
        b.phaseInDeg = this.phaseInDeg;
        b.phaseInRad = this.phaseInRad;
        return b;
    }

    public static Phasor copy(Phasor ph) {
        if (ph == null) {
            return null;
        }
        Phasor b = new Phasor();
        b.magnitude = ph.magnitude;
        b.phaseInDeg = ph.phaseInDeg;
        b.phaseInRad = ph.phaseInRad;
        return b;
    }

    public static Phasor[] copy(Phasor[] a) {
        if (a == null) {
            return null;
        }
        int n = a.length;
        Phasor[] b = Phasor.oneDarray(n);
        for (int i = 0; i < n; ++i) {
            b[i] = a[i].copy();
        }
        return b;
    }

    public static Phasor[][] copy(Phasor[][] a) {
        if (a == null) {
            return null;
        }
        int n = a.length;
        int m = a[0].length;
        Phasor[][] b = Phasor.twoDarray(n, m);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                b[i][j] = a[i][j].copy();
            }
        }
        return b;
    }

    public static Phasor[][][] copy(Phasor[][][] a) {
        if (a == null) {
            return null;
        }
        int n = a.length;
        int m = a[0].length;
        int l = a[0][0].length;
        Phasor[][][] b = Phasor.threeDarray(n, m, l);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                for (int k = 0; k < l; ++k) {
                    b[i][j][k] = a[i][j][k].copy();
                }
            }
        }
        return b;
    }

    public Object clone() {
        Phasor ret = null;
        if (this != null) {
            Phasor b = new Phasor();
            b.magnitude = this.magnitude;
            b.phaseInDeg = this.phaseInDeg;
            b.phaseInRad = this.phaseInRad;
            ret = b;
        }
        return ret;
    }

    public Phasor plus(Phasor ph) {
        Complex com1 = this.toRectangular();
        Complex com2 = ph.toRectangular();
        Complex com3 = com1.plus(com2);
        return Phasor.toPhasor(com3);
    }

    public Phasor plus(Complex com1) {
        Phasor ph = new Phasor();
        Complex com2 = this.toRectangular();
        Complex com3 = com1.plus(com2);
        return Phasor.toPhasor(com3);
    }

    public void plusEquals(Phasor ph1) {
        Complex com1 = this.toRectangular();
        Complex com2 = ph1.toRectangular();
        Complex com3 = com1.plus(com2);
        Phasor ph2 = Phasor.toPhasor(com3);
        this.magnitude = ph2.magnitude;
        this.phaseInDeg = ph2.phaseInDeg;
        this.phaseInRad = ph2.phaseInRad;
    }

    public void plusEquals(Complex com1) {
        Complex com2 = this.toRectangular();
        Complex com3 = com1.plus(com2);
        Phasor ph2 = Phasor.toPhasor(com3);
        this.magnitude += ph2.magnitude;
        this.phaseInDeg += ph2.phaseInDeg;
        this.phaseInRad += ph2.phaseInRad;
    }

    public Phasor minus(Phasor ph) {
        Complex com1 = this.toRectangular();
        Complex com2 = ph.toRectangular();
        Complex com3 = com1.minus(com2);
        return Phasor.toPhasor(com3);
    }

    public Phasor minus(Complex com1) {
        Phasor ph = new Phasor();
        Complex com2 = this.toRectangular();
        Complex com3 = com1.minus(com2);
        return Phasor.toPhasor(com3);
    }

    public void minusEquals(Phasor ph1) {
        Complex com1 = this.toRectangular();
        Complex com2 = ph1.toRectangular();
        Complex com3 = com1.plus(com2);
        Phasor ph2 = Phasor.toPhasor(com3);
        this.magnitude = ph2.magnitude;
        this.phaseInDeg = ph2.phaseInDeg;
        this.phaseInRad = ph2.phaseInRad;
    }

    public void minusEquals(Complex com1) {
        Complex com2 = this.toRectangular();
        Complex com3 = com1.plus(com2);
        Phasor ph2 = Phasor.toPhasor(com3);
        this.magnitude = ph2.magnitude;
        this.phaseInDeg = ph2.phaseInDeg;
        this.phaseInRad = ph2.phaseInRad;
    }

    public Phasor times(Phasor ph1) {
        Phasor ph2 = new Phasor();
        double mag = this.magnitude * ph1.magnitude;
        double pha = this.phaseInDeg + ph1.phaseInDeg;
        ph2.reset(mag, pha);
        return ph2;
    }

    public Phasor times(Complex com1) {
        Phasor ph1 = Phasor.toPhasor(com1);
        Phasor ph2 = new Phasor();
        double mag = this.magnitude * ph1.magnitude;
        double pha = this.phaseInDeg + ph1.phaseInDeg;
        ph2.reset(mag, pha);
        return ph2;
    }

    public Phasor times(double constant) {
        Phasor ph2 = new Phasor();
        double mag = this.magnitude * constant;
        double pha = this.phaseInDeg;
        ph2.reset(mag, pha);
        return ph2;
    }

    public Phasor times(int constant) {
        Phasor ph2 = new Phasor();
        double mag = this.magnitude * (double)constant;
        double pha = this.phaseInDeg;
        ph2.reset(mag, pha);
        return ph2;
    }

    public Phasor timesExpOmegaTime(double omega, double time) {
        if (!Fmath.isNaN(Phasor.omega)) {
            throw new IllegalArgumentException("You have already entered a value for the radial frequency, omega, " + Phasor.omega + ", that differs from the one you are now attempting to enter, " + omega);
        }
        Phasor.omega = omega;
        frequency = Phasor.omega / (Math.PI * 2);
        Phasor ph2 = new Phasor();
        ph2.reset(this.magnitude, this.phaseInDeg + Math.toDegrees(omega * time));
        return ph2;
    }

    public Phasor timesExpTwoPiFreqTime(double frequency, double time) {
        if (!Fmath.isNaN(Phasor.frequency)) {
            throw new IllegalArgumentException("You have already entered a value for the frequency, " + Phasor.frequency + ", that differs from the one you are now attempting to enter, " + frequency);
        }
        Phasor.frequency = frequency;
        omega = Phasor.frequency * 2.0 * Math.PI;
        Phasor ph2 = new Phasor();
        ph2.reset(this.magnitude, this.phaseInDeg + Math.toDegrees(Math.PI * 2 * frequency * time));
        return ph2;
    }

    public void timesEquals(Phasor ph1) {
        this.magnitude *= ph1.magnitude;
        this.phaseInDeg += ph1.phaseInDeg;
        this.phaseInRad += ph1.phaseInRad;
    }

    public void timesEquals(Complex com1) {
        Phasor ph1 = Phasor.toPhasor(com1);
        this.magnitude *= ph1.magnitude;
        this.phaseInDeg += ph1.phaseInDeg;
        this.phaseInRad += ph1.phaseInRad;
    }

    public void timesEquals(double constant) {
        this.magnitude *= constant;
    }

    public void timesEquals(int constant) {
        this.magnitude *= (double)constant;
    }

    public void timesEqualsOmegaTime(double omega, double time) {
        if (!Fmath.isNaN(Phasor.omega)) {
            throw new IllegalArgumentException("You have already entered a value for radial frequency, omega, " + Phasor.omega + ", that differs from the one you are now attempting to enter, " + omega);
        }
        Phasor.omega = omega;
        frequency = Phasor.omega / (Math.PI * 2);
        this.phaseInRad += omega * time;
        this.phaseInDeg = Math.toDegrees(this.phaseInRad);
    }

    public void timesEqualsTwoPiFreqTime(double frequency, double time) {
        if (!Fmath.isNaN(Phasor.frequency)) {
            throw new IllegalArgumentException("You have already entered a value for the frequency, " + Phasor.frequency + ", that differs from the one you are now attempting to enter, " + frequency);
        }
        Phasor.frequency = frequency;
        omega = Phasor.frequency * 2.0 * Math.PI;
        this.phaseInRad += Math.PI * 2 * frequency * time;
        this.phaseInDeg = Math.toDegrees(this.phaseInRad);
    }

    public Phasor over(Phasor ph1) {
        Phasor ph2 = new Phasor();
        double mag = this.magnitude / ph1.magnitude;
        double pha = this.phaseInDeg - ph1.phaseInDeg;
        ph2.reset(mag, pha);
        return ph2;
    }

    public Phasor over(Complex com1) {
        Phasor ph1 = Phasor.toPhasor(com1);
        Phasor ph2 = new Phasor();
        double mag = this.magnitude / ph1.magnitude;
        double pha = this.phaseInDeg - ph1.phaseInDeg;
        ph2.reset(mag, pha);
        return ph2;
    }

    public Phasor over(double constant) {
        Phasor ph2 = new Phasor();
        double mag = this.magnitude / constant;
        double pha = this.phaseInDeg;
        ph2.reset(mag, pha);
        return ph2;
    }

    public Phasor over(int constant) {
        Phasor ph2 = new Phasor();
        double mag = this.magnitude / (double)constant;
        double pha = this.phaseInDeg;
        ph2.reset(mag, pha);
        return ph2;
    }

    public void overEquals(Phasor ph1) {
        this.magnitude /= ph1.magnitude;
        this.phaseInDeg -= ph1.phaseInDeg;
        this.phaseInRad -= ph1.phaseInRad;
    }

    public void overEquals(Complex com1) {
        Phasor ph1 = Phasor.toPhasor(com1);
        this.magnitude /= ph1.magnitude;
        this.phaseInDeg -= ph1.phaseInDeg;
        this.phaseInRad -= ph1.phaseInRad;
    }

    public void overEquals(double constant) {
        this.magnitude /= constant;
    }

    public void overEquals(int constant) {
        this.magnitude /= (double)constant;
    }

    public double abs() {
        return Math.abs(this.magnitude);
    }

    public double argInRadians() {
        return this.phaseInRad;
    }

    public double argInDegrees() {
        return this.phaseInDeg;
    }

    public Phasor negate() {
        Phasor ph = new Phasor();
        ph.reset(-this.magnitude, this.phaseInDeg);
        return ph;
    }

    public Phasor conjugate() {
        Phasor ph = new Phasor();
        ph.reset(this.magnitude, -this.phaseInDeg);
        return ph;
    }

    public Phasor inverse() {
        Phasor ph = new Phasor();
        ph.reset(1.0 / this.magnitude, -this.phaseInDeg);
        return ph;
    }

    public static Phasor sqrt(Phasor ph1) {
        Phasor ph2 = new Phasor();
        ph2.reset(Math.sqrt(ph1.magnitude), ph1.phaseInDeg / 2.0);
        return ph2;
    }

    public static Phasor nthRoot(Phasor ph1, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The root, " + n + ", must be greater than zero");
        }
        Phasor ph2 = new Phasor();
        ph2.reset(Math.pow(ph1.magnitude, 1.0 / (double)n), ph1.phaseInDeg / (double)n);
        return ph2;
    }

    public static Phasor square(Phasor ph1) {
        Phasor ph2 = new Phasor();
        ph2.reset(Fmath.square(ph1.magnitude), 2.0 * ph1.phaseInDeg);
        return ph2;
    }

    public static Phasor pow(Phasor ph1, int n) {
        Phasor ph2 = new Phasor();
        ph2.reset(Math.pow(ph1.magnitude, n), (double)n * ph1.phaseInDeg);
        return ph2;
    }

    public static Phasor pow(Phasor ph1, double n) {
        Phasor ph2 = new Phasor();
        ph2.reset(Math.pow(ph1.magnitude, n), n * ph1.phaseInDeg);
        return ph2;
    }

    public static Phasor pow(Phasor ph1, Complex n) {
        Complex com1 = ph1.toRectangular();
        Complex com2 = Complex.pow(com1, n);
        Phasor ph2 = Phasor.toPhasor(com2);
        return ph2;
    }

    public static Phasor pow(Phasor ph1, Phasor n) {
        Complex com1 = ph1.toRectangular();
        Complex comn = n.toRectangular();
        Complex com2 = Complex.pow(com1, comn);
        Phasor ph2 = Phasor.toPhasor(com2);
        return ph2;
    }

    public static Phasor exp(Phasor ph1) {
        Complex com = ph1.toRectangular();
        com = Complex.exp(com);
        Phasor ph2 = Phasor.toPhasor(com);
        return ph2;
    }

    public static Phasor log(Phasor ph1) {
        Complex com = new Complex(Math.log(ph1.magnitude), ph1.phaseInDeg);
        Phasor ph2 = Phasor.toPhasor(com);
        return ph2;
    }

    public Phasor sin(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Math.sin(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.sin(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor cos(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Math.cos(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.cos(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor tan(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Math.tan(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.tan(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor cot(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Fmath.cot(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.cot(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor sec(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Fmath.sec(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.sec(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor csc(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Fmath.csc(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.csc(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor exsec(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Fmath.exsec(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.exsec(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor vers(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Fmath.vers(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.vers(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor covers(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Fmath.covers(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.covers(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor hav(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Fmath.hav(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.hav(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor sinh(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Fmath.sinh(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.sinh(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor cosh(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Fmath.cosh(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.cosh(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor sech(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Fmath.sech(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.sech(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor csch(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Fmath.csch(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.csch(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor asin(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Math.asin(ph1.getMagnitude()), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.asin(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor acos(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Math.acos(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.acos(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor atan(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Math.atan(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.atan(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor acot(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Fmath.acot(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.acot(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor asec(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Fmath.asec(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.asec(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor acsc(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Fmath.acsc(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.acsc(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor aexsec(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Fmath.aexsec(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.aexsec(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor avers(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Fmath.avers(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.avers(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor acovers(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Fmath.acovers(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.acovers(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor ahav(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Fmath.ahav(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.ahav(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor asinh(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Fmath.asinh(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.asinh(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor acosh(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Fmath.acosh(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.acosh(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor asech(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Fmath.asech(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.asech(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public Phasor acsch(Phasor ph1) {
        Phasor ph2 = new Phasor();
        if (ph1.phaseInDeg == 0.0) {
            ph2.reset(Fmath.acsch(ph1.magnitude), 0.0);
        } else {
            Complex com = ph1.toRectangular();
            com = Complex.acsch(com);
            ph2 = Phasor.toPhasor(com);
        }
        return ph2;
    }

    public boolean isReal() {
        boolean test = false;
        if (Math.abs(this.phaseInDeg) == 0.0) {
            test = true;
        }
        return test;
    }

    public boolean isZero() {
        boolean test = false;
        if (Math.abs(this.magnitude) == 0.0 || this.phaseInDeg == Double.NEGATIVE_INFINITY) {
            test = true;
        }
        return test;
    }

    public boolean isPlusInfinity() {
        boolean test = false;
        if (this.magnitude == Double.POSITIVE_INFINITY || this.phaseInDeg == Double.POSITIVE_INFINITY) {
            test = true;
        }
        return test;
    }

    public boolean isMinusInfinity() {
        boolean test = false;
        if (this.magnitude == Double.NEGATIVE_INFINITY) {
            test = true;
        }
        return test;
    }

    public boolean isNaN() {
        boolean test = false;
        if (this.magnitude != this.magnitude || this.phaseInDeg != this.phaseInDeg) {
            test = true;
        }
        return test;
    }

    public boolean equals(Phasor a) {
        boolean test = false;
        if (this.isNaN() && a.isNaN()) {
            test = true;
        } else if (this.magnitude == a.magnitude && this.phaseInDeg == a.phaseInDeg) {
            test = true;
        }
        return test;
    }

    public boolean equalsWithinLimits(Phasor a, double fract) {
        boolean test = false;
        double mt = this.magnitude;
        double ma = a.magnitude;
        double pt = this.phaseInDeg;
        double pa = a.phaseInDeg;
        double mdn = 0.0;
        double pdn = 0.0;
        double mtest = 0.0;
        double ptest = 0.0;
        if (mt == 0.0 && pt == 0.0 && ma == 0.0 && pa == 0.0) {
            test = true;
        }
        if (!test) {
            mdn = Math.abs(mt);
            if (Math.abs(ma) > mdn) {
                mdn = Math.abs(ma);
            }
            mtest = mdn == 0.0 ? 0.0 : Math.abs(ma - mt) / mdn;
            pdn = Math.abs(pt);
            if (Math.abs(pa) > pdn) {
                pdn = Math.abs(pa);
            }
            ptest = pdn == 0.0 ? 0.0 : Math.abs(pa - pt) / pdn;
            if (mtest < fract && ptest < fract) {
                test = true;
            }
        }
        return test;
    }

    public static Phasor zero() {
        Phasor ph = new Phasor();
        ph.magnitude = 0.0;
        ph.phaseInDeg = 0.0;
        ph.phaseInRad = 0.0;
        ph.rectangular.polar(ph.magnitude, ph.phaseInRad);
        return ph;
    }

    public static Phasor plusOne() {
        Phasor ph = new Phasor();
        ph.magnitude = 1.0;
        ph.phaseInDeg = 0.0;
        ph.phaseInRad = 0.0;
        ph.rectangular.polar(ph.magnitude, ph.phaseInRad);
        return ph;
    }

    public static Phasor minusOne() {
        Phasor ph = new Phasor();
        ph.magnitude = -1.0;
        ph.phaseInDeg = 0.0;
        ph.phaseInRad = 0.0;
        ph.rectangular.polar(ph.magnitude, ph.phaseInRad);
        return ph;
    }

    public static Phasor magnitudeZeroPhase(double mag) {
        Phasor ph = new Phasor();
        ph.magnitude = mag;
        ph.phaseInDeg = 0.0;
        ph.phaseInRad = 0.0;
        ph.rectangular.polar(ph.magnitude, ph.phaseInRad);
        return ph;
    }

    public static Phasor plusInfinity() {
        Phasor ph = new Phasor();
        ph.magnitude = Double.POSITIVE_INFINITY;
        ph.phaseInDeg = 0.0;
        ph.phaseInRad = 0.0;
        ph.rectangular = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        return ph;
    }

    public static Phasor minusInfinity() {
        Phasor ph = new Phasor();
        ph.magnitude = Double.NEGATIVE_INFINITY;
        ph.phaseInDeg = 0.0;
        ph.phaseInRad = 0.0;
        ph.rectangular = new Complex(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        return ph;
    }

    public static Phasor resistancePhasor(double resistance) {
        Phasor ph = new Phasor(resistance);
        return ph;
    }

    public static Phasor inductancePhasor(double inductance, double frequency) {
        if (!Fmath.isNaN(Phasor.frequency)) {
            throw new IllegalArgumentException("You have already entered a value for the frequency, " + Phasor.frequency + ", that differs from the one you are now attempting to enter, " + frequency);
        }
        Phasor.frequency = frequency;
        omega = Phasor.frequency * 2.0 * Math.PI;
        Complex com = Impedance.inductanceImpedance(inductance, omega);
        Phasor ph = new Phasor();
        return Phasor.toPhasor(com);
    }

    public static Phasor capacitancePhasor(double capacitance, double frequency) {
        if (!Fmath.isNaN(Phasor.frequency)) {
            throw new IllegalArgumentException("You have already entered a value for the frequency, " + Phasor.frequency + ", that differs from the one you are now attempting to enter, " + frequency);
        }
        Phasor.frequency = frequency;
        omega = Phasor.frequency * 2.0 * Math.PI;
        Complex com = Impedance.capacitanceImpedance(capacitance, omega);
        Phasor ph = new Phasor();
        return Phasor.toPhasor(com);
    }

    public static Phasor infiniteWarburgPhasor(double sigma, double frequency) {
        if (!Fmath.isNaN(Phasor.frequency)) {
            throw new IllegalArgumentException("You have already entered a value for the frequency, " + Phasor.frequency + ", that differs from the one you are now attempting to enter, " + frequency);
        }
        Phasor.frequency = frequency;
        omega = Phasor.frequency * 2.0 * Math.PI;
        Complex com = Impedance.infiniteWarburgImpedance(sigma, omega);
        Phasor ph = new Phasor();
        return Phasor.toPhasor(com);
    }

    public static Phasor finiteWarburgPhasor(double sigma, double delta, double frequency) {
        if (!Fmath.isNaN(Phasor.frequency)) {
            throw new IllegalArgumentException("You have already entered a value for the frequency, " + Phasor.frequency + ", that differs from the one you are now attempting to enter, " + frequency);
        }
        Phasor.frequency = frequency;
        omega = Phasor.frequency * 2.0 * Math.PI;
        Complex com = Impedance.finiteWarburgImpedance(sigma, delta, omega);
        Phasor ph = new Phasor();
        return Phasor.toPhasor(com);
    }

    public static Phasor constantPhaseElementPhasor(double sigma, double alpha, double frequency) {
        if (!Fmath.isNaN(Phasor.frequency)) {
            throw new IllegalArgumentException("You have already entered a value for the frequency, " + Phasor.frequency + ", that differs from the one you are now attempting to enter, " + frequency);
        }
        Phasor.frequency = frequency;
        omega = Phasor.frequency * 2.0 * Math.PI;
        Complex com = Impedance.constantPhaseElementImpedance(sigma, alpha, omega);
        Phasor ph = new Phasor();
        return Phasor.toPhasor(com);
    }
}

