/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.vcf;

import ca.mcgill.mcb.pcingola.fileIterator.NeedlemanWunsch;
import ca.mcgill.mcb.pcingola.fileIterator.VcfFileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.vcf.VcfEffect;
import ca.mcgill.mcb.pcingola.vcf.VcfGenotype;
import ca.mcgill.mcb.pcingola.vcf.VcfInfo;
import ca.mcgill.mcb.pcingola.vcf.VcfInfoType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class VcfEntry
extends Marker
implements Iterable<VcfGenotype> {
    private static final long serialVersionUID = 4226374412681243433L;
    String line;
    int lineNum;
    VcfFileIterator vcfFileIterator;
    String chromosomeName;
    String ref;
    String[] alts;
    Double quality;
    String filterPass;
    String infoStr = "";
    HashMap<String, String> info;
    String format;
    ArrayList<VcfGenotype> vcfGenotypes = null;
    SeqChange.ChangeType changeType;
    String[] genotypeFields;
    String genotypeFieldsStr;

    public VcfEntry(VcfFileIterator vcfFileIterator, Marker parent, String chromosomeName, int start, String id, String ref, String altsStr, double quality, String filterPass, String infoStr, String format) {
        super(parent, start, start + ref.length(), 1, id);
        this.chromosomeName = chromosomeName;
        this.ref = ref;
        this.parseAlts(altsStr);
        this.quality = quality;
        this.filterPass = filterPass;
        this.infoStr = infoStr;
        this.parseInfo();
        this.format = format;
    }

    public VcfEntry(VcfFileIterator vcfFileIterator, String line, int lineNum, boolean parseNow) {
        super(null, 0, 0, 1, "");
        this.vcfFileIterator = vcfFileIterator;
        this.lineNum = lineNum;
        this.line = line;
        if (parseNow) {
            this.parse();
        }
    }

    public void addFormat(String formatName) {
        if (this.format == null) {
            this.format = "";
        }
        if (this.format.indexOf(formatName) >= 0) {
            throw new RuntimeException("Format field '" + formatName + "' already exists!");
        }
        this.format = this.format + (this.format.endsWith(":") ? "" : ":") + formatName;
    }

    public void addGenotype(String vcfGenotypeStr) {
        if (this.vcfGenotypes == null) {
            this.vcfGenotypes = new ArrayList();
        }
        if (this.format == null) {
            this.format = "";
        }
        this.vcfGenotypes.add(new VcfGenotype(this, this.format, vcfGenotypeStr));
    }

    public void addInfo(String addInfoStr) {
        this.addInfo(addInfoStr, true);
    }

    protected void addInfo(String addInfoStr, boolean invalidateCache) {
        if (this.infoStr == null || this.infoStr.isEmpty()) {
            this.infoStr = addInfoStr;
        } else {
            if (!this.infoStr.endsWith(";")) {
                this.infoStr = this.infoStr + ";";
            }
            this.infoStr = this.infoStr + addInfoStr;
        }
        if (invalidateCache) {
            addInfoStr = null;
        }
    }

    public void addInfo(String name, String value) {
        if (value != null && (value.indexOf(32) >= 0 || value.indexOf(59) >= 0 || value.indexOf(61) >= 0 || value.indexOf(9) >= 0 || value.indexOf(10) >= 0)) {
            throw new RuntimeException("No white-space, semi-colons, or equals-signs are permitted in INFO field. Name:\"" + name + "\" Value:\"" + value + "\"");
        }
        String addInfoStr = name + (value != null ? "=" + value : "");
        if (this.info != null) {
            this.info.put(name, value);
        }
        this.addInfo(addInfoStr, false);
    }

    public Boolean calcHetero() {
        if (this.genotypeFieldsStr == null) {
            return this.isHeterozygous();
        }
        Boolean isHetero = null;
        if (this.genotypeFields == null) {
            int countFields = 0;
            for (int fromIndex = 0; fromIndex >= 0 && countFields < 1; ++countFields, ++fromIndex) {
                fromIndex = this.genotypeFieldsStr.indexOf(9, fromIndex);
            }
            if (countFields == 1) {
                this.parseGenotypes();
            }
        }
        if (this.genotypeFields != null && this.genotypeFields.length == 1) {
            isHetero = this.getVcfGenotype(0).isHeterozygous();
        }
        return isHetero;
    }

    SeqChange createSeqChange(Chromosome chromo, int start, String reference, String alt, int strand, String id, double quality, int coverage) {
        if (alt.isEmpty()) {
            return new SeqChange(chromo, start, reference, reference, strand, id, quality, coverage);
        }
        if ((alt = alt.toUpperCase()).startsWith("<DEL")) {
            int end = start + reference.length() - 1;
            if (this.getInfo("END") != null && (end = (int)this.getInfoInt("END")) < start) {
                throw new RuntimeException("INFO field 'END' is before varaint's 'POS'\n\tEND : " + end + "\n\tPOS : " + start);
            }
            int size = end - start + 1;
            char[] change = new char[size];
            for (int i = 0; i < change.length; ++i) {
                change[i] = reference.length() > i ? (int)reference.charAt(i) : 78;
            }
            String ch = "-" + new String(change);
            return new SeqChange(chromo, start, reference, ch, strand, id, quality, coverage);
        }
        if (reference.length() == alt.length()) {
            int startDiff = Integer.MAX_VALUE;
            String ch = "";
            String ref = "";
            for (int i = 0; i < reference.length(); ++i) {
                if (reference.charAt(i) == alt.charAt(i)) continue;
                ref = ref + reference.charAt(i);
                ch = ch + alt.charAt(i);
                startDiff = Math.min(startDiff, i);
            }
            return new SeqChange(chromo, start + startDiff, ref, ch, strand, id, quality, coverage);
        }
        if (reference.length() > alt.length()) {
            NeedlemanWunsch nw = new NeedlemanWunsch(alt, reference);
            nw.align();
            int startDiff = nw.getOffset();
            String ref = "*";
            String ch = nw.getAlignment();
            if (!ch.startsWith("-")) {
                throw new RuntimeException("Deletion '" + ch + "' does not start with '-'. This should never happen!");
            }
            return new SeqChange(chromo, start + startDiff, ref, ch, strand, id, quality, coverage);
        }
        if (reference.length() < alt.length()) {
            NeedlemanWunsch nw = new NeedlemanWunsch(alt, reference);
            nw.align();
            int startDiff = nw.getOffset();
            String ch = nw.getAlignment();
            String ref = "*";
            if (!ch.startsWith("+")) {
                throw new RuntimeException("Insertion '" + ch + "' does not start with '+'. This should never happen!");
            }
            return new SeqChange(chromo, start + startDiff, ref, ch, strand, id, quality, coverage);
        }
        throw new RuntimeException("Unsupported VCF change type '" + reference + "' => '" + alt + "'\nVcfEntry: " + this);
    }

    public String[] getAlts() {
        return this.alts;
    }

    public String getAltsStr() {
        String altsStr = "";
        for (String alt : this.alts) {
            altsStr = altsStr + alt + " ";
        }
        return altsStr.trim().replace(' ', ',');
    }

    public SeqChange.ChangeType getChangeType() {
        return this.changeType;
    }

    @Override
    public String getChromosomeNameOri() {
        return this.chromosomeName;
    }

    public String getFilterPass() {
        return this.filterPass;
    }

    public String getFormat() {
        return this.format;
    }

    public String getInfo(String key) {
        if (this.info == null) {
            this.parseInfo();
        }
        return this.info.get(key);
    }

    public boolean getInfoFlag(String key) {
        if (this.info == null) {
            this.parseInfo();
        }
        return this.info.containsKey(key);
    }

    public double getInfoFloat(String key) {
        if (this.info == null) {
            this.parseInfo();
        }
        return Gpr.parseDoubleSafe(this.info.get(key));
    }

    public long getInfoInt(String key) {
        if (this.info == null) {
            this.parseInfo();
        }
        return Gpr.parseLongSafe(this.info.get(key));
    }

    public Set<String> getInfoKeys(String key) {
        if (this.info == null) {
            this.parseInfo();
        }
        return this.info.keySet();
    }

    public String getInfoStr() {
        return this.infoStr;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public double getQuality() {
        return this.quality != null ? this.quality : 0.0;
    }

    public String getRef() {
        return this.ref;
    }

    public VcfFileIterator getVcfFileIterator() {
        return this.vcfFileIterator;
    }

    public VcfGenotype getVcfGenotype(int index) {
        if (this.vcfGenotypes == null) {
            this.parseGenotypes();
        }
        return this.vcfGenotypes.get(index);
    }

    public List<VcfGenotype> getVcfGenotypes() {
        if (this.vcfGenotypes == null) {
            this.parseGenotypes();
        }
        return this.vcfGenotypes;
    }

    public VcfInfoType getVcfInfoType(String id) {
        VcfInfo vcfInfo = this.vcfFileIterator.getVcfHeader().getVcfInfo(id);
        if (vcfInfo == null) {
            return null;
        }
        return vcfInfo.getVcfInfoType();
    }

    public boolean hasField(String filedName) {
        return this.vcfFileIterator.getVcfHeader().getVcfInfo(filedName) != null;
    }

    public boolean isDel() {
        return this.changeType == SeqChange.ChangeType.DEL;
    }

    public boolean isFilterPass() {
        return this.filterPass.equals("PASS");
    }

    public boolean isHeterozygous() {
        return this.alts.length > 1;
    }

    public boolean isHomozygous() {
        return this.alts.length == 1;
    }

    public boolean isInDel() {
        return this.changeType == SeqChange.ChangeType.INS || this.changeType == SeqChange.ChangeType.DEL;
    }

    public boolean isIns() {
        return this.changeType == SeqChange.ChangeType.INS;
    }

    public boolean isInterval() {
        return this.changeType == SeqChange.ChangeType.Interval;
    }

    public boolean isMixedInDel() {
        return this.changeType == SeqChange.ChangeType.MIXED;
    }

    public boolean isMnp() {
        return this.changeType == SeqChange.ChangeType.MNP;
    }

    @Override
    protected boolean isShowWarningIfParentDoesNotInclude() {
        return false;
    }

    public boolean isSnp() {
        return this.changeType == SeqChange.ChangeType.SNP;
    }

    public boolean isVariant() {
        for (String alt : this.alts) {
            if (alt.isEmpty() || alt.equals(".") || this.ref.equals(alt)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<VcfGenotype> iterator() {
        if (this.vcfGenotypes == null) {
            this.parseGenotypes();
        }
        return this.vcfGenotypes.iterator();
    }

    public void parse() {
        String[] fields = this.line.split("\t", 10);
        if (fields.length >= 4) {
            this.chromosomeName = fields[0].trim();
            Chromosome chromo = this.vcfFileIterator.getChromosome(this.chromosomeName);
            this.parent = chromo;
            this.vcfFileIterator.sanityCheckChromo(this.chromosomeName, chromo);
            this.start = this.vcfFileIterator.parsePosition(this.vcfFileIterator.readField(fields, 1));
            this.id = this.vcfFileIterator.readField(fields, 2);
            this.ref = this.vcfFileIterator.readField(fields, 3).toUpperCase();
            this.end = this.start + this.ref.length();
            this.strand = 1;
            String altsStr = this.vcfFileIterator.readField(fields, 4).toUpperCase();
            this.parseAlts(altsStr);
            String qStr = this.vcfFileIterator.readField(fields, 5);
            this.quality = !qStr.isEmpty() ? Double.valueOf(Gpr.parseDoubleSafe(qStr)) : null;
            this.filterPass = this.vcfFileIterator.readField(fields, 6);
            this.infoStr = this.vcfFileIterator.readField(fields, 7);
            this.info = null;
            this.format = null;
            if (fields.length > 8) {
                this.format = this.vcfFileIterator.readField(fields, 8);
            }
            if (fields.length > 9) {
                this.genotypeFieldsStr = fields[9];
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseAlts(String altsStr) {
        if (altsStr.length() == 1) {
            if (altsStr.equals("A") || altsStr.equals("C") || altsStr.equals("G") || altsStr.equals("T") || altsStr.equals(".")) {
                this.alts = new String[1];
                this.alts[0] = altsStr;
            } else if (altsStr.equals("N")) {
                this.alts = new String[4];
                this.alts[0] = "A";
                this.alts[1] = "C";
                this.alts[2] = "G";
                this.alts[3] = "T";
            } else if (altsStr.equals("B")) {
                this.alts = new String[3];
                this.alts[0] = "C";
                this.alts[1] = "G";
                this.alts[2] = "T";
            } else if (altsStr.equals("D")) {
                this.alts = new String[3];
                this.alts[0] = "A";
                this.alts[1] = "G";
                this.alts[2] = "T";
            } else if (altsStr.equals("H")) {
                this.alts = new String[3];
                this.alts[0] = "A";
                this.alts[1] = "C";
                this.alts[2] = "T";
            } else if (altsStr.equals("V")) {
                this.alts = new String[3];
                this.alts[0] = "A";
                this.alts[1] = "C";
                this.alts[2] = "G";
            } else if (altsStr.equals("M")) {
                this.alts = new String[2];
                this.alts[0] = "A";
                this.alts[1] = "C";
            } else if (altsStr.equals("R")) {
                this.alts = new String[2];
                this.alts[0] = "A";
                this.alts[1] = "G";
            } else if (altsStr.equals("W")) {
                this.alts = new String[2];
                this.alts[0] = "A";
                this.alts[1] = "T";
            } else if (altsStr.equals("S")) {
                this.alts = new String[2];
                this.alts[0] = "C";
                this.alts[1] = "G";
            } else if (altsStr.equals("Y")) {
                this.alts = new String[2];
                this.alts[0] = "C";
                this.alts[1] = "T";
            } else if (altsStr.equals("K")) {
                this.alts = new String[2];
                this.alts[0] = "G";
                this.alts[1] = "T";
            } else {
                if (!altsStr.equals(".")) throw new RuntimeException("WARNING: Unkown IUB code for SNP '" + altsStr + "'");
                this.alts = new String[1];
                this.alts[0] = this.ref;
            }
        } else {
            this.alts = altsStr.split(",");
        }
        int maxAltLen = Integer.MIN_VALUE;
        int minAltLen = Integer.MAX_VALUE;
        for (int i = 0; i < this.alts.length; ++i) {
            maxAltLen = Math.max(maxAltLen, this.alts[i].length());
            minAltLen = Math.min(minAltLen, this.alts[i].length());
        }
        this.changeType = this.ref.length() == maxAltLen && this.ref.length() == minAltLen ? (this.ref.length() == 1 ? SeqChange.ChangeType.SNP : SeqChange.ChangeType.MNP) : (this.ref.length() > minAltLen ? SeqChange.ChangeType.DEL : (this.ref.length() < maxAltLen ? SeqChange.ChangeType.INS : SeqChange.ChangeType.MIXED));
    }

    public List<VcfEffect> parseEffects(VcfEffect.FormatVersion formatVersion) {
        String[] effs;
        String effStr = this.getInfo("EFF");
        ArrayList<VcfEffect> effList = new ArrayList<VcfEffect>();
        if (effStr == null) {
            return effList;
        }
        for (String eff : effs = effStr.split(",")) {
            VcfEffect veff = new VcfEffect(eff, formatVersion);
            effList.add(veff);
        }
        return effList;
    }

    void parseGenotypes() {
        this.vcfGenotypes = new ArrayList();
        if (this.genotypeFieldsStr == null) {
            return;
        }
        this.genotypeFields = this.genotypeFieldsStr.split("\t");
        for (int i = 0; i < this.genotypeFields.length; ++i) {
            String gen = this.genotypeFields[i];
            if (gen.equals(".")) {
                gen = "";
            }
            this.addGenotype(gen);
        }
    }

    void parseInfo() {
        this.info = new HashMap();
        for (String inf : this.infoStr.split(";")) {
            String[] vp = inf.split("=");
            if (vp.length > 1) {
                this.info.put(vp[0], vp[1]);
                continue;
            }
            this.info.put(vp[0], "true");
        }
    }

    public List<SeqChange> seqChanges() {
        LinkedList<SeqChange> list = new LinkedList<SeqChange>();
        int coverage = Gpr.parseIntSafe(this.getInfo("DP"));
        Boolean isHetero = this.calcHetero();
        for (String alt : this.alts) {
            Chromosome chr = (Chromosome)this.parent;
            SeqChange seqChange = this.createSeqChange(chr, this.start, this.ref, alt, this.strand, this.id, this.getQuality(), coverage);
            seqChange.setHeterozygous(isHetero);
            list.add(seqChange);
        }
        return list;
    }

    public void setFilterPass(String filterPass) {
        this.filterPass = filterPass;
    }

    public void setGenotypeStr(String genotypeFieldsStr) {
        this.genotypeFieldsStr = genotypeFieldsStr;
    }

    public void setLineNum(int lineNum) {
        this.lineNum = lineNum;
    }

    @Override
    public String toString() {
        String chr;
        boolean deleteLastTab = true;
        String string = chr = this.chromosomeName != null ? this.chromosomeName : null;
        chr = this.chromosomeName != null ? this.chromosomeName : (this.parent != null ? this.parent.getId() : ".");
        StringBuilder sb = new StringBuilder(chr + "\t" + (this.start + 1) + "\t" + (this.id.isEmpty() ? "." : this.id) + "\t" + this.ref + "\t");
        for (int i = 0; i < this.alts.length; ++i) {
            String altStr = this.alts[i].isEmpty() ? "." : this.alts[i];
            sb.append(altStr + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("\t" + (this.quality != null ? this.quality + "" : "."));
        sb.append("\t" + (this.filterPass.isEmpty() ? "." : this.filterPass));
        sb.append("\t" + (this.infoStr.isEmpty() ? "." : this.infoStr));
        sb.append("\t");
        if (this.format != null) {
            sb.append((this.format.isEmpty() ? "." : this.format) + "\t");
            if (this.vcfGenotypes != null && !this.vcfGenotypes.isEmpty()) {
                for (VcfGenotype vg : this.vcfGenotypes) {
                    sb.append(vg + "\t");
                }
            } else if (this.genotypeFieldsStr != null) {
                sb.append(this.genotypeFieldsStr);
                deleteLastTab = false;
            }
        }
        if (deleteLastTab) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

