/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryRefSeq;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestCasesRefSeq
extends TestCase {
    public SnpEffectPredictor buildAndCompare(String genome, String refSeqFile, String fastaFile, String resultFile) {
        String expectedResult = Gpr.readFile(resultFile).trim();
        Config config = new Config(genome, "snpEff.config");
        SnpEffPredictorFactoryRefSeq factory = new SnpEffPredictorFactoryRefSeq(config);
        factory.setFileName(refSeqFile);
        if (fastaFile != null) {
            factory.setFastaFile(fastaFile);
        } else {
            factory.setReadSequences(false);
        }
        SnpEffectPredictor sep = factory.create();
        String result = this.show(sep.getGenome()).trim();
        System.out.println(result);
        Assert.assertEquals((String)Gpr.noSpaces(expectedResult), (String)Gpr.noSpaces(result));
        return sep;
    }

    String show(Genome genome) {
        StringBuilder sb = new StringBuilder();
        sb.append(genome.getVersion() + "\n");
        for (Chromosome chr : genome) {
            sb.append(chr + "\n");
        }
        ArrayList<Gene> genes = new ArrayList<Gene>();
        for (Gene gene : genome.getGenes()) {
            genes.add(gene);
        }
        for (Gene gene : genes) {
            for (Transcript tr : gene.sortedStrand()) {
                tr.setProteinCoding(false);
            }
            sb.append(gene);
            for (Transcript tr : gene.sortedStrand()) {
                sb.append("\t\tCDS '" + tr.getId() + "': " + tr.cds() + "\n");
            }
        }
        return sb.toString();
    }

    public void test_01() {
        String genome = "hg19";
        String refSeqFile = "tests/hg19_refSeq_OR4F16.txt";
        String fastaFile = null;
        String resultFile = "tests/hg19_refSeq_OR4F16.dump.txt";
        SnpEffectPredictor sep = this.buildAndCompare(genome, refSeqFile, fastaFile, resultFile);
        sep.buildForest();
        SeqChange seqChange = new SeqChange(sep.getGenome().getChromosome("1"), 521603, "A", "G", 1, "", 1.0, 1);
        List<ChangeEffect> effs = sep.seqChangeEffect(seqChange);
        for (ChangeEffect eff : effs) {
            System.out.println("\t" + eff);
            Assert.assertEquals((Object)((Object)eff.getEffectType()), (Object)((Object)ChangeEffect.EffectType.INTERGENIC));
        }
    }
}

