/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.commandLine;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Intron;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.commandLine.SnpEff;
import ca.mcgill.mcb.pcingola.stats.CountByKey;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.samtools.AbstractBAMFileIndex;
import net.sf.samtools.BAMIndexMetaData;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;

public class SnpEffCmdCountReads
extends SnpEff {
    public static int SHOW_EVERY = 10000;
    public static boolean debug = true;
    List<String> samFileNames = new ArrayList<String>();
    ArrayList<CountByKey<Marker>> countReadsByFile = new ArrayList();
    ArrayList<CountByKey<Marker>> countBasesByFile = new ArrayList();
    SnpEffectPredictor snpEffectPredictor;
    boolean verbose = false;

    int countTotalReads(String samFileName) {
        try {
            if (this.verbose) {
                Timer.showStdErr("Counting reads on file: " + samFileName);
            }
            SAMFileReader samReader = new SAMFileReader(new File(samFileName));
            AbstractBAMFileIndex index = (AbstractBAMFileIndex)samReader.getIndex();
            int count = 0;
            for (int i = 0; i < index.getNumberOfReferences(); ++i) {
                BAMIndexMetaData meta = index.getMetaData(i);
                count += meta.getAlignedRecordCount();
            }
            samReader.close();
            if (this.verbose) {
                Timer.showStdErr("Total " + count + " reads.");
            }
            return count;
        }
        catch (Exception e) {
            System.err.println("ERROR! BAM file not indexed?");
            return -1;
        }
    }

    String idChain(Marker marker) {
        StringBuilder sb = new StringBuilder();
        block5: for (Marker m = marker; m != null && !(m instanceof Chromosome) && !(m instanceof Genome); m = m.getParent()) {
            switch (m.getType()) {
                case EXON: {
                    if (sb.length() > 0) {
                        sb.append(";");
                    }
                    sb.append("exon_" + ((Exon)m).getRank());
                    continue block5;
                }
                case INTRON: {
                    if (sb.length() > 0) {
                        sb.append(";");
                    }
                    sb.append("intron_" + ((Intron)m).getRank());
                    continue block5;
                }
                case CHROMOSOME: 
                case INTERGENIC: 
                case GENE: 
                case TRANSCRIPT: {
                    if (sb.length() > 0) {
                        sb.append(";");
                    }
                    sb.append(m.getId());
                    continue block5;
                }
            }
        }
        if (sb.length() <= 0) {
            sb.append(marker.getId());
        }
        sb.insert(0, marker.getClass().getSimpleName() + "\t");
        return sb.toString();
    }

    @Override
    public void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-v")) {
                this.verbose = true;
                continue;
            }
            if (this.genomeVer == null || this.genomeVer.isEmpty()) {
                this.genomeVer = args[i];
                continue;
            }
            this.samFileNames.add(args[i]);
        }
        if (this.genomeVer == null || this.genomeVer.isEmpty()) {
            this.usage("Missing genome version");
        }
        if (this.samFileNames.size() < 1) {
            this.usage("Missing SAM/BAM file/s");
        }
    }

    public void print() {
        System.out.print("chr\tstart\tend\ttype\tIDs");
        for (int j = 0; j < this.countReadsByFile.size(); ++j) {
            System.out.print("\tReads:" + this.samFileNames.get(j) + "\tBases:" + this.samFileNames.get(j));
        }
        System.out.print("\n");
        HashSet<Marker> keys = new HashSet<Marker>();
        for (CountByKey<Marker> cbt : this.countReadsByFile) {
            keys.addAll(cbt.keySet());
        }
        ArrayList<Marker> keysSorted = new ArrayList<Marker>(keys.size());
        keysSorted.addAll(keys);
        Collections.sort(keysSorted);
        for (Marker key : keysSorted) {
            System.out.print(key.getChromosomeName() + "\t" + (key.getStart() + 1) + "\t" + (key.getEnd() + 1) + "\t" + this.idChain(key));
            for (int idx = 0; idx < this.countReadsByFile.size(); ++idx) {
                System.out.print("\t" + this.countReadsByFile.get(idx).get(key) + "\t" + this.countBasesByFile.get(idx).get(key));
            }
            System.out.print("\n");
        }
        System.out.print("\n");
    }

    @Override
    public boolean run() {
        if (this.verbose) {
            Timer.showStdErr("Reading configuration file '" + this.configFile + "'");
        }
        this.config = new Config(this.genomeVer, this.configFile);
        if (this.verbose) {
            Timer.showStdErr("done");
        }
        if (this.verbose) {
            Timer.showStdErr("Reading database for genome '" + this.genomeVer + "'");
        }
        this.config.loadSnpEffectPredictor();
        if (this.verbose) {
            Timer.showStdErr("done");
        }
        if (this.verbose) {
            Timer.showStdErr("Building interval forest");
        }
        this.snpEffectPredictor = this.config.getSnpEffectPredictor();
        this.snpEffectPredictor.buildForest();
        if (this.verbose) {
            Timer.showStdErr("done");
        }
        this.runCountIntervals();
        this.print();
        return true;
    }

    void runCountIntervals() {
        Genome genome = this.config.getGenome();
        for (String samFileName : this.samFileNames) {
            try {
                if (this.verbose) {
                    Timer.showStdErr("Reading reads file '" + samFileName + "'");
                }
                CountByKey<Marker> countReads = new CountByKey<Marker>();
                CountByKey<Marker> countBases = new CountByKey<Marker>();
                int readNum = 1;
                SAMFileReader sam = new SAMFileReader(new File(samFileName));
                for (SAMRecord samRecord : sam) {
                    try {
                        Chromosome chr;
                        if (!samRecord.getReadUnmappedFlag() && (chr = genome.getChromosome(samRecord.getReferenceName())) != null) {
                            Marker read = new Marker(chr, samRecord.getAlignmentStart(), samRecord.getAlignmentEnd(), 1, "");
                            Set<Marker> regions = this.snpEffectPredictor.regionsMarkers(read);
                            for (Marker m : regions) {
                                countReads.inc(m);
                                countBases.inc(m, m.intersectSize(read));
                            }
                        }
                        if (this.verbose) {
                            Gpr.showMark(readNum, SHOW_EVERY);
                        }
                        ++readNum;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                sam.close();
                this.countReadsByFile.add(countReads);
                this.countBasesByFile.add(countBases);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!this.verbose) continue;
            System.err.println("");
            Timer.showStdErr("Finished reding file " + samFileName);
        }
        if (this.verbose) {
            Timer.showStdErr("Done.");
        }
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version SnpEff 3.1h (build 2012-12-04), by Pablo Cingolani");
        System.err.println("Usage: snpEff countReads [-v] genome readsFile_1 readsFile_2 ...  readsFile_N");
        System.err.println("\treadsFile : A file contianing the reads. Either BAM or SAM format.");
        System.exit(-1);
    }
}

