/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

public class NeedlemanWunschOverlap {
    String alignment;
    char[] a;
    char[] b;
    int[][] score;
    int besti = -1;
    int bestj = -1;
    int alignmentScore = -1;
    int scoreMatch = 1;
    int scoreMissmatch = -5;
    int scoreGap = -2;

    public NeedlemanWunschOverlap(String a, String b) {
        this.score = new int[a.length() + 1][b.length() + 1];
        this.a = a.toCharArray();
        this.b = b.toCharArray();
    }

    public String align() {
        this.calcAlignmentScore();
        return this.calcAlignment();
    }

    int bestScore() {
        this.alignmentScore = Integer.MIN_VALUE;
        int maxj = this.b.length;
        int maxi = this.a.length;
        for (int i = 1; i <= this.a.length; ++i) {
            if (this.alignmentScore >= this.score[i][maxj]) continue;
            this.alignmentScore = this.score[i][maxj];
            this.besti = i;
            this.bestj = maxj;
        }
        for (int j = 1; j <= this.b.length; ++j) {
            if (this.alignmentScore >= this.score[maxi][j]) continue;
            this.alignmentScore = this.score[maxi][j];
            this.bestj = j;
            this.besti = maxi;
        }
        return this.alignmentScore;
    }

    public String calcAlignment() {
        int h;
        int maxLen = Math.max(this.a.length, this.b.length);
        char[] alignmentA = new char[maxLen];
        char[] match = new char[maxLen];
        char[] alignmentB = new char[maxLen];
        int i = this.besti;
        int j = this.bestj;
        for (h = maxLen - 1; i > 0 && j > 0 && h >= 0; --h) {
            int s = this.score[i][j];
            int scorediag = this.score[i - 1][j - 1];
            int scoreup = this.score[i][j - 1];
            int scoreleft = this.score[i - 1][j];
            if (s == scoreup + this.scoreGap) {
                alignmentA[h] = 45;
                alignmentB[h] = this.b[j - 1];
                match[h] = 45;
                --j;
                continue;
            }
            if (s == scoreleft + this.scoreGap) {
                alignmentA[h] = this.a[i - 1];
                alignmentB[h] = 45;
                match[h] = 45;
                --i;
                continue;
            }
            if (s == scorediag + this.simmilarity(i, j)) {
                alignmentA[h] = this.a[i - 1];
                alignmentB[h] = this.b[j - 1];
                match[h] = this.a[i - 1] == this.b[j - 1] ? 124 : 42;
                --i;
                --j;
                continue;
            }
            throw new RuntimeException("This should never happen!");
        }
        while (i > 0 && h >= 0) {
            alignmentA[h] = this.a[i - 1];
            alignmentB[h] = 45;
            match[h] = 45;
            --i;
            --h;
        }
        while (j > 0 && h >= 0) {
            alignmentA[h] = 45;
            alignmentB[h] = this.b[j - 1];
            match[h] = 45;
            --j;
            --h;
        }
        while (h >= 0) {
            alignmentB[h] = 32;
            alignmentA[h] = 32;
            match[h] = 32;
            --h;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(new String(alignmentA).trim());
        sb.append("\n");
        sb.append(new String(match).trim());
        sb.append("\n");
        sb.append(new String(alignmentB).trim());
        sb.append("\n");
        this.alignment = sb.toString();
        return this.alignment;
    }

    public int calcAlignmentScore() {
        int i;
        for (i = 0; i <= this.a.length; ++i) {
            this.score[i][0] = 0;
        }
        for (int j = 0; j <= this.b.length; ++j) {
            this.score[0][j] = 0;
        }
        for (i = 1; i <= this.a.length; ++i) {
            for (int j = 1; j <= this.b.length; ++j) {
                int s;
                int match = this.score[i - 1][j - 1] + this.simmilarity(i, j);
                int del = this.score[i - 1][j] + this.scoreGap;
                int ins = this.score[i][j - 1] + this.scoreGap;
                this.score[i][j] = s = Math.max(match, Math.max(del, ins));
            }
        }
        return this.bestScore();
    }

    public int getAligmentScore() {
        return this.alignmentScore;
    }

    public String getAlignment() {
        return this.alignment;
    }

    public void setDeletion(int deletion) {
        this.scoreGap = deletion;
    }

    public void setMatch(int match) {
        this.scoreMatch = match;
    }

    public void setMissMatch(int missMatch) {
        this.scoreMissmatch = missMatch;
    }

    void setScore(int i, int j, int val) {
        this.score[i][j] = val;
    }

    int simmilarity(int i, int j) {
        if (this.a[i - 1] != this.b[j - 1]) {
            return this.scoreMissmatch;
        }
        return this.scoreMatch;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%4s|", ""));
        for (int j = 0; j <= this.b.length; ++j) {
            sb.append(String.format("%4s|", j > 0 ? Character.valueOf(this.b[j - 1]) : ""));
        }
        sb.append("\n");
        for (int i = 0; i <= this.a.length; ++i) {
            sb.append(String.format("%4s|", i > 0 ? Character.valueOf(this.a[i - 1]) : ""));
            for (int j = 0; j <= this.b.length; ++j) {
                sb.append(String.format("%4d|", this.score[i][j]));
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

