/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola;

import ca.mcgill.mcb.pcingola.fastq.Fastq;
import ca.mcgill.mcb.pcingola.fileIterator.FastqFileIterator;
import ca.mcgill.mcb.pcingola.fileIterator.LineFileIterator;
import ca.mcgill.mcb.pcingola.fileIterator.NeedlemanWunschOverlap;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.util.HashMap;

public class ZzzPacBIo {
    String fastq;
    String putativeOverlaps;
    HashMap<String, String> seqByName;

    public static void main(String[] args) {
        String fastq = Gpr.HOME + "/scyth/pacbio/SCYTH-8Kb_0.38nM_bind-1-2_G02_1.fastq";
        String putativeOverlaps = Gpr.HOME + "/scyth/pacbio/SCYTH-8Kb_0.38nM_bind-1-2_G02_1.subreads.100.sort.filter.overlaps.txt";
        NeedlemanWunschOverlap nwo = new NeedlemanWunschOverlap("ACGT", "AC");
        String res = nwo.align();
        System.out.println("RESULT:\n" + res);
        System.out.println(nwo);
        nwo = new NeedlemanWunschOverlap("CGGCTTATAGAAGAAGGGCTGGTGTCT", "CTGGTGTCTGCCGCGAATGAGAGCATGG");
        res = nwo.align();
        System.out.println("RESULT:\n" + res);
        System.out.println(nwo);
        nwo = new NeedlemanWunschOverlap("CTGGTGTCTGCCGCGAATGAGAGCATGG", "CGGCTTATAGAAGAAGGGCTGGTGTCT");
        res = nwo.align();
        System.out.println("RESULT:\n" + res);
        System.out.println(nwo);
        ZzzPacBIo zzz = new ZzzPacBIo(fastq, putativeOverlaps);
        zzz.readSeqs();
        zzz.readOverlaps();
    }

    public ZzzPacBIo(String fastq, String putativeOverlaps) {
        this.fastq = fastq;
        this.putativeOverlaps = putativeOverlaps;
        this.seqByName = new HashMap();
    }

    int overlap(String readName1, String readName2, boolean rwc) {
        NeedlemanWunschOverlap nwo;
        int score;
        Timer.showStdErr("Align :" + readName1 + " , " + readName2);
        String seq1 = this.seqByName.get(readName1);
        String seq2 = this.seqByName.get(readName2);
        if (rwc) {
            seq2 = GprSeq.reverseWc(seq2);
        }
        if ((score = (nwo = new NeedlemanWunschOverlap(seq1, seq2)).calcAlignmentScore()) > 90) {
            System.out.println("MATCH:" + score + "\n" + nwo.calcAlignment());
        }
        return score;
    }

    void readOverlaps() {
        Timer.showStdErr("Reading overlaps file: " + this.putativeOverlaps);
        LineFileIterator lfi = new LineFileIterator(this.putativeOverlaps);
        for (String line : lfi) {
            String[] fields = line.split("\t");
            String readName1 = fields[0];
            System.out.println(line);
            System.out.println(readName1);
            for (int i = 1; i < fields.length; ++i) {
                String[] sf = fields[i].split(";");
                String readName2 = sf[0];
                sf = sf[1].split("/");
                int positiveMaps = Gpr.parseIntSafe(sf[0]);
                int negativeMaps = sf.length > 1 ? Gpr.parseIntSafe(sf[1]) : 0;
                int scorePos = 0;
                int scoreNeg = 0;
                if (positiveMaps > 0) {
                    scorePos = this.overlap(readName1, readName2, false);
                }
                if (negativeMaps > 0) {
                    scoreNeg = this.overlap(readName1, readName2, true);
                }
                System.out.println("\t" + readName2 + "\t" + positiveMaps + "\t" + negativeMaps + "\t" + scorePos + "\t" + scoreNeg);
            }
        }
    }

    void readSeqs() {
        Timer.showStdErr("Reading seuqnece (FASTQ) file: " + this.fastq);
        FastqFileIterator fqfi = new FastqFileIterator(this.fastq);
        for (Fastq fq : fqfi) {
            String name = fq.getDescription().substring(1);
            this.seqByName.put(name, fq.getSequence());
        }
        Timer.showStdErr("done. Sequences: " + this.seqByName.size());
    }
}

