/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class BiorProperties {
    private static final String BIOR_PROP = "BIOR_PROP";
    private static String file = null;
    private Properties prop = null;
    private static Logger sLogger = Logger.getLogger(BiorProperties.class);

    public static void setFile(String f) {
        file = f;
    }

    public BiorProperties() throws IOException {
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(file);
            this.prop = new Properties();
            this.prop.load(inStream);
        }
        catch (IOException ex) {
            sLogger.error((Object)("Error loading properties file: " + file), (Throwable)ex);
            throw ex;
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException ex) {
                sLogger.error((Object)("Error closing properties file: " + file), (Throwable)ex);
                throw ex;
            }
        }
    }

    public String get(Key key) {
        return this.prop.getProperty(key.toString());
    }

    public String get(String key) {
        return this.prop.getProperty(key);
    }

    public Set<String> keySet() {
        return this.prop.stringPropertyNames();
    }

    static {
        String DEFAULT_PROP_FILE_NAME = "bior.properties";
        if (System.getenv(BIOR_PROP) != null) {
            file = System.getenv(BIOR_PROP);
        } else if (new File(System.getenv("HOME") + "/" + "bior.properties").exists()) {
            file = System.getenv("HOME") + "/" + "bior.properties";
        } else if (System.getProperty(BIOR_PROP) != null) {
            file = System.getProperty(BIOR_PROP);
        } else if (new File(System.getenv("user.dir") + "/" + "bior.properties").exists()) {
            file = System.getProperty("user.dir") + "/conf/" + "bior.properties";
        } else if (BiorProperties.class.getClassLoader().getResource("bior.properties") != null) {
            URL url = BiorProperties.class.getClassLoader().getResource("bior.properties");
            file = url.getFile();
        }
        sLogger.info((Object)("using " + file + " for " + "bior.properties"));
    }

    public static enum Key {
        SnpEffJar,
        SnpEffConfig,
        BiorVepPerl,
        BiorVep,
        BiorVepCache,
        fileBase,
        genesFile,
        hgncFile,
        hgncIndexFile,
        hgncEnsemblGeneIndexFile,
        omimFile,
        omimIndexFile,
        dbsnpFile,
        dbsnpClinvarFile,
        cosmicFile,
        blacklistedFile,
        conservationFile,
        enhancerFile,
        tfbsFile,
        tssFile,
        uniqueFile,
        repeatFile,
        regulationFile,
        mirBaseFile,
        bgiFile,
        espFile,
        hapMapFile,
        kGenomeFile;

    }
}

