/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.history;

import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.util.FieldSpecification;
import edu.mayo.pipes.util.metadata.Metadata;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class CompressPipe
extends AbstractPipe<History, History> {
    private String mDelimiter;
    private String mEscDelimiter;
    private FieldSpecification mFieldSpec;
    private List<List<String>> mBuffer = new ArrayList<List<String>>();
    private List<String> mBufferKey = null;
    private boolean mFieldsInitialized = false;
    private List<Integer> mKeyFields = new ArrayList<Integer>();
    private List<Integer> mCompressFields = new ArrayList<Integer>();
    private boolean mNoMoreData = false;
    private boolean mSetCompression;

    public CompressPipe(FieldSpecification fieldSpec, String delimiter) {
        this(fieldSpec, delimiter, "\\" + delimiter, false);
    }

    public CompressPipe(FieldSpecification fieldSpec, String delimiter, String escapeDelimiter, boolean useSetCompression) {
        this.mFieldSpec = fieldSpec;
        this.mDelimiter = delimiter;
        this.mEscDelimiter = escapeDelimiter;
        this.mSetCompression = useSetCompression;
    }

    protected History processNextStart() throws NoSuchElementException {
        List<String> lineKey;
        List line;
        if (this.mNoMoreData) {
            throw new NoSuchElementException();
        }
        while (true) {
            try {
                line = (List)this.starts.next();
            }
            catch (NoSuchElementException e) {
                this.mNoMoreData = true;
                return this.compress(this.mBuffer);
            }
            if (!this.mFieldsInitialized) {
                this.initializeFields(line.size());
                this.mFieldsInitialized = true;
            }
            lineKey = this.getKey(line);
            if (this.mBuffer.size() != 0 && !this.hasKeyMatch(this.mBufferKey, lineKey)) break;
            if (this.mBuffer.size() == 0) {
                this.mBufferKey = lineKey;
            }
            this.mBuffer.add(line);
        }
        History compressedLine = this.compress(this.mBuffer);
        this.mBuffer.clear();
        this.mBufferKey = null;
        this.mBufferKey = lineKey;
        this.mBuffer.add(line);
        return compressedLine;
    }

    private void initializeFields(int numFields) {
        Map<FieldSpecification.FieldType, List<Integer>> m = this.mFieldSpec.getFields(numFields);
        this.mCompressFields = m.get((Object)FieldSpecification.FieldType.MATCH);
        this.mKeyFields = m.get((Object)FieldSpecification.FieldType.NON_MATCH);
    }

    private History compress(List<List<String>> lines) {
        int col;
        if (lines.size() == 0) {
            return new History();
        }
        int numCols = lines.get(0).size();
        boolean[] identicalColVals = this.checkSameColumnValues(lines);
        ArrayList singleRow = new ArrayList();
        for (int col2 = 0; col2 < numCols; ++col2) {
            singleRow.add(new ArrayList());
        }
        int[] periodCnt = new int[numCols];
        for (List<String> line : lines) {
            for (int col3 = 0; col3 < numCols; ++col3) {
                int field = col3 + 1;
                if (((List)singleRow.get(col3)).size() != 0 && !this.mCompressFields.contains(field)) continue;
                String colValue = line.get(col3);
                if (this.mSetCompression && ((List)singleRow.get(col3)).contains(colValue)) continue;
                if (colValue.equals(".")) {
                    int n = col3;
                    periodCnt[n] = periodCnt[n] + 1;
                }
                ((List)singleRow.get(col3)).add(colValue);
            }
        }
        ArrayList<StringBuilder> builders = new ArrayList<StringBuilder>();
        for (col = 0; col < numCols; ++col) {
            builders.add(new StringBuilder());
        }
        for (col = 0; col < numCols; ++col) {
            int field = col + 1;
            StringBuilder builder = (StringBuilder)builders.get(col);
            if (this.mCompressFields.contains(field)) {
                boolean ignorePeriods = false;
                if (this.mSetCompression && periodCnt[col] > 0) {
                    ignorePeriods = true;
                }
                if (identicalColVals[col] && ignorePeriods) {
                    String value = (String)((List)singleRow.get(col)).get(0);
                    value = value.replace(this.mDelimiter, this.mEscDelimiter);
                    builder.append(value);
                    continue;
                }
                for (String value : (List)singleRow.get(col)) {
                    if (ignorePeriods && value.equals(".")) continue;
                    value = value.replace(this.mDelimiter, this.mEscDelimiter);
                    builder.append(value);
                    builder.append(this.mDelimiter);
                }
                builder.deleteCharAt(builder.length() - 1);
                continue;
            }
            String value = (String)((List)singleRow.get(col)).get(0);
            value = value.replace(this.mDelimiter, this.mEscDelimiter);
            builder.append(value);
        }
        History compressedLine = new History();
        for (StringBuilder builder : builders) {
            compressedLine.add(builder.toString());
        }
        return compressedLine;
    }

    private boolean[] checkSameColumnValues(List<List<String>> lines) {
        if (lines.size() == 0) {
            return new boolean[0];
        }
        int numCols = lines.get(0).size();
        boolean[] identicalColVals = new boolean[numCols];
        for (int col = 0; col < numCols; ++col) {
            boolean allIdentical = true;
            String colValue = null;
            for (List<String> line : lines) {
                if (colValue == null) {
                    colValue = line.get(col);
                    continue;
                }
                if (colValue.equals(line.get(col))) continue;
                allIdentical = false;
                break;
            }
            identicalColVals[col] = allIdentical;
        }
        return identicalColVals;
    }

    private boolean hasKeyMatch(List<String> key1, List<String> key2) {
        boolean isMatch = true;
        for (int i = 0; i < key1.size(); ++i) {
            String keyValue2;
            String keyValue1 = key1.get(i);
            if (keyValue1.equals(keyValue2 = key2.get(i))) continue;
            isMatch = false;
            break;
        }
        return isMatch;
    }

    private List<String> getKey(List<String> line) {
        ArrayList<String> key = new ArrayList<String>();
        for (int index : this.mKeyFields) {
            key.add(line.get(index - 1));
        }
        return key;
    }

    public Metadata getMetadata() {
        return new Metadata(this.mDelimiter, this.mEscDelimiter, this.mFieldSpec);
    }
}

