/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.tabix;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import edu.mayo.pipes.JSON.tabix.TabixSearchPipe;
import edu.mayo.pipes.bioinformatics.vocab.ComparableObjectInterface;
import edu.mayo.pipes.exceptions.InvalidPipeInputException;
import edu.mayo.pipes.history.History;
import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class TabixParentPipe
extends AbstractPipe<History, History> {
    protected History history = null;
    protected TabixSearchPipe search;
    protected int qcount;
    protected boolean isFirst = true;
    protected ComparableObjectInterface comparableObject;
    protected int historyPos = -1;
    protected String validResult = "";

    public TabixParentPipe(String tabixDataFile) throws IOException {
        this.init(tabixDataFile);
    }

    public TabixParentPipe(String tabixDataFile, int historyPosition) throws IOException {
        this.historyPos = historyPosition;
        this.init(tabixDataFile);
    }

    protected void init(String tabixDataFile) throws IOException {
        this.search = new TabixSearchPipe(tabixDataFile);
        this.comparableObject = new FilterLogic();
    }

    protected History copyAppend(History history, String result) {
        History clone = (History)history.clone();
        clone.add(result);
        return clone;
    }

    protected void setup() {
        if (this.isFirst) {
            this.isFirst = false;
            this.history = (History)this.starts.next();
            if (this.historyPos > 0) {
                this.historyPos = this.historyPos - this.history.size() - 1;
            } else if (this.historyPos == 0) {
                throw new InvalidPipeInputException("Invalid Column input", (Pipe)this);
            }
            this.qcount = 0;
            this.search.reset();
            this.search.setStarts(Arrays.asList((String)this.history.get(this.history.size() + this.historyPos)));
        }
    }

    private boolean valid(ComparableObjectInterface fl) {
        String result = (String)this.search.next();
        boolean isSame = fl.same((String)this.history.get(this.history.size() + this.historyPos), result);
        this.validResult = isSame ? result : "";
        return isSame;
    }

    protected History processNextStart() throws NoSuchElementException {
        this.setup();
        while (true) {
            History newHist;
            if (this.search.hasNext()) {
                if (!this.valid(this.comparableObject)) continue;
                ++this.qcount;
                newHist = this.copyAppend(this.history, this.validResult);
                return newHist;
            }
            if (this.qcount == 0) {
                ++this.qcount;
                newHist = this.copyAppend(this.history, "{}");
                return newHist;
            }
            this.history = (History)this.starts.next();
            this.search.reset();
            String jsonWithPosInfo = (String)this.history.get(this.history.size() + this.historyPos);
            this.search.setStarts(Arrays.asList(jsonWithPosInfo));
            this.qcount = 0;
        }
    }

    private class FilterLogic
    implements ComparableObjectInterface {
        private FilterLogic() {
        }

        @Override
        public boolean same(String a, String b) {
            return true;
        }
    }
}

