/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.sideeffect;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.sideeffect.SideEffectPipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GroupByPipe<S, K, V>
extends AbstractPipe<S, S>
implements SideEffectPipe<S, Map<K, List<V>>> {
    protected Map<K, List<V>> byMap;
    protected final PipeFunction<S, K> keyFunction;
    protected final PipeFunction<S, V> valueFunction;

    public GroupByPipe(Map<K, List<V>> byMap, PipeFunction<S, K> keyFunction, PipeFunction<S, V> valueFunction) {
        this.byMap = byMap;
        this.keyFunction = keyFunction;
        this.valueFunction = valueFunction;
    }

    public GroupByPipe(PipeFunction<S, K> keyFunction, PipeFunction<S, V> valueFunction) {
        this(new HashMap(), keyFunction, valueFunction);
    }

    @Override
    protected S processNextStart() {
        Object s = this.starts.next();
        K key = this.getKey(s);
        V value = this.getValue(s);
        List<V> list = this.byMap.get(key);
        if (null == list) {
            list = new ArrayList<V>();
            this.addValue(value, list);
            this.byMap.put(key, list);
        } else {
            this.addValue(value, list);
        }
        return (S)s;
    }

    @Override
    public Map<K, List<V>> getSideEffect() {
        return this.byMap;
    }

    public void addValue(V value, List values) {
        if (value instanceof Pipe) {
            for (Object o : (Pipe)value) {
                values.add(o);
            }
        } else {
            values.add(value);
        }
    }

    private K getKey(S start) {
        if (null == this.keyFunction) {
            return (K)start;
        }
        return this.keyFunction.compute(start);
    }

    private V getValue(S start) {
        if (null == this.valueFunction) {
            return (V)start;
        }
        return this.valueFunction.compute(start);
    }

    @Override
    public void reset() {
        this.byMap = new HashMap<K, List<V>>();
        super.reset();
    }
}

