/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.tabix;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.JSON.tabix.TabixReader;
import edu.mayo.pipes.bioinformatics.vocab.CoreAttributes;
import edu.mayo.pipes.exceptions.InvalidPipeInputException;
import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;

public class TabixSearchPipe
extends AbstractPipe<String, String> {
    private TabixReader tr;
    private int jsonpos = 3;
    private JsonPath landmarkPath;
    private JsonPath minBPPath;
    private JsonPath maxBPPath;
    private int extendminbp = 0;
    private int extendmaxbp = 0;
    String snpJsonIn = null;
    TabixReader.Iterator records = null;

    public TabixSearchPipe(String tabixDataFile) throws IOException {
        this.init(tabixDataFile);
    }

    public TabixSearchPipe(String tabixDataFile, int minBPExtend, int maxBPExtend) throws IOException {
        this.init(tabixDataFile);
        this.extendmaxbp = maxBPExtend;
        this.extendminbp = minBPExtend;
    }

    public TabixSearchPipe(String tabixDataFile, int jsonpos) throws IOException {
        this.init(tabixDataFile);
        this.jsonpos = jsonpos;
    }

    private void init(String tabixDataFile) throws IOException {
        if (!new File(tabixDataFile).isFile()) {
            System.err.println("File is not valid: " + tabixDataFile);
            throw new IOException("TabixSearchPipe init(tabixDataFile) requires tabixDataFile to be a valid file. \nFile: " + tabixDataFile);
        }
        this.tr = new TabixReader(tabixDataFile);
        this.landmarkPath = JsonPath.compile((String)CoreAttributes._landmark.toString(), (Filter[])new Filter[0]);
        this.minBPPath = JsonPath.compile((String)CoreAttributes._minBP.toString(), (Filter[])new Filter[0]);
        this.maxBPPath = JsonPath.compile((String)CoreAttributes._maxBP.toString(), (Filter[])new Filter[0]);
    }

    public String format(String s) throws InvalidPipeInputException {
        String[] split = s.split("\t");
        return split[this.jsonpos];
    }

    protected String processNextStart() throws NoSuchElementException {
        try {
            String record = null;
            this.requery();
            if (this.records == null) {
                this.snpJsonIn = null;
                throw new NoSuchElementException("There were no tabix search results to match the variant, or chromosome not found in tabix index.");
            }
            record = this.records.next();
            if (record != null) {
                return this.format(record);
            }
            this.records = null;
            this.snpJsonIn = null;
            this.requery();
            record = this.records.next();
            if (record != null) {
                return this.format(record);
            }
            throw new NoSuchElementException();
        }
        catch (Exception e) {
            this.records = null;
            this.snpJsonIn = null;
            throw new NoSuchElementException();
        }
    }

    public TabixReader.Iterator query(String json) throws IOException {
        String maxBP;
        String minBP;
        if (json.equalsIgnoreCase("{}")) {
            return null;
        }
        Object o = this.landmarkPath.read(json);
        if (o == null) {
            return null;
        }
        String landmark = o.toString();
        o = this.minBPPath.read(json);
        if (o != null) {
            minBP = o.toString();
            if (this.extendminbp != 0) {
                int t = Integer.parseInt(minBP);
                minBP = String.valueOf(t - this.extendminbp);
                if (t - this.extendminbp < 0) {
                    minBP = "0";
                }
            }
        } else {
            return null;
        }
        o = this.maxBPPath.read(json);
        if (o != null) {
            maxBP = o.toString();
            if (this.extendmaxbp != 0) {
                int t = Integer.parseInt(maxBP);
                maxBP = String.valueOf(t + this.extendmaxbp);
            }
        } else {
            return null;
        }
        this.records = this.tquery(landmark + ":" + minBP + "-" + maxBP);
        return this.records;
    }

    private void requery() throws NoSuchElementException, IOException {
        if (this.records == null) {
            if (this.snpJsonIn == null) {
                if (this.starts.hasNext()) {
                    this.snpJsonIn = (String)this.starts.next();
                } else {
                    throw new NoSuchElementException();
                }
            }
            this.records = this.query(this.snpJsonIn);
        }
    }

    public TabixReader.Iterator tquery(String chrMinMaxQuery) throws IOException {
        TabixReader.Iterator records = this.tr.query(chrMinMaxQuery);
        return records;
    }
}

