/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.bioinformatics;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import edu.mayo.pipes.bioinformatics.vocab.CoreAttributes;
import edu.mayo.pipes.bioinformatics.vocab.Type;
import edu.mayo.pipes.exceptions.InvalidPipeInputException;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.util.GenomicObjectUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class VCF2VariantPipe
extends AbstractPipe<History, History> {
    private static final Logger sLogger = Logger.getLogger(VCF2VariantPipe.class);
    private static final int COL_CHROM = 0;
    private static final int COL_POS = 1;
    private static final int COL_ID = 2;
    private static final int COL_REF = 3;
    private static final int COL_ALT = 4;
    private static final int COL_QUAL = 5;
    private static final int COL_FILTER = 6;
    private static final int COL_INFO = 7;
    private static final int COL_FORMAT = 8;
    private static final String[] COL_HEADERS = new String[]{"CHROM", "POS", "ID", "REF", "ALT", "QUAL", "FILTER", "INFO"};
    private static final String NUMBER_SUPPORTING_SAMPLES = "NUMBER_SAMPLES";
    private final String mRegexStr = ".+ID=([^,]+).+Number=([^,]+).+Type=(Integer|Float|Flag|Character|String).+Description=([^,]+).+";
    private static final int REGEX_GRP_ID = 1;
    private static final int REGEX_GRP_NUM = 2;
    private static final int REGEX_GRP_TYPE = 3;
    private static final int REGEX_DESCRIPTION = 4;
    private Pattern mRegexPattern = Pattern.compile(".+ID=([^,]+).+Number=([^,]+).+Type=(Integer|Float|Flag|Character|String).+Description=([^,]+).+");
    private Map<String, InfoFieldMeta> mFieldMap = new HashMap<String, InfoFieldMeta>();
    private HashMap<String, Integer> sampleKeys = new HashMap();
    private HashMap<String, Boolean> formatKeys = new HashMap();
    private boolean isHeaderProcessed = false;
    private int mDataLineNumber = 0;
    private boolean processSamples = false;
    public boolean firstSample = true;

    public VCF2VariantPipe() {
    }

    public VCF2VariantPipe(boolean includeSamples) {
        this.processSamples = true;
    }

    private void processHeader(List<String> headerLines) {
        for (String row : headerLines) {
            Matcher m = this.mRegexPattern.matcher(row);
            if (!m.find()) continue;
            InfoFieldMeta meta = new InfoFieldMeta();
            meta.id = m.group(1);
            meta.type = INFO_TYPE.fromString(m.group(3));
            try {
                meta.number = Integer.parseInt(m.group(2));
            }
            catch (NumberFormatException nfe) {
                meta.number = null;
            }
            meta.desc = m.group(4).replaceAll("\"", "");
            this.mFieldMap.put(meta.id, meta);
        }
    }

    protected History processNextStart() throws NoSuchElementException, InvalidPipeInputException {
        History history = (History)this.starts.next();
        ++this.mDataLineNumber;
        if (!this.isHeaderProcessed) {
            this.processHeader(History.getMetaData().getOriginalHeader());
            ColumnMetaData cmd = new ColumnMetaData(((Object)((Object)this)).getClass().getSimpleName());
            History.getMetaData().getColumns().add(cmd);
            this.isHeaderProcessed = true;
        }
        if (history.size() < COL_HEADERS.length) {
            int requiredColCount = COL_HEADERS.length;
            int actualColCount = history.size();
            StringBuilder sb = new StringBuilder();
            sb.append("Invalid VCF data line at data line # %s.\n");
            sb.append("The VCF format requires %s fixed fields per data line, but found only %s field(s).\n");
            sb.append("Make sure the VCF file has the necessary %s VCF fields delimited by TAB characters.\n");
            sb.append("Invalid VCF line content: \"%s\"");
            String errorMesg = String.format(sb.toString(), String.valueOf(this.mDataLineNumber), requiredColCount, actualColCount, requiredColCount, history.getMergedData("\t"));
            throw new InvalidPipeInputException(errorMesg, (Pipe)this);
        }
        String json = this.buildJSON(history);
        history.add(json);
        return history;
    }

    private String buildJSON(List<String> history) {
        JsonObject root = new JsonObject();
        root.addProperty(COL_HEADERS[0], history.get(0).trim());
        root.addProperty(COL_HEADERS[1], history.get(1).trim());
        root.addProperty(COL_HEADERS[2], history.get(2).trim());
        root.addProperty(COL_HEADERS[3], history.get(3).trim());
        root.addProperty(COL_HEADERS[4], history.get(4).trim());
        root.addProperty(COL_HEADERS[5], history.get(5).trim());
        root.addProperty(COL_HEADERS[6], history.get(6).trim());
        JsonObject info = this.buildInfoJSON(history.get(7).trim());
        root.add(COL_HEADERS[7], (JsonElement)info);
        this.addCoreAttributes(root, history);
        if (this.processSamples) {
            try {
                this.addSamples(root, history);
            }
            catch (ParseException ex) {
                sLogger.log(Priority.ERROR, (Object)ex);
            }
        }
        return root.toString();
    }

    private JsonObject buildInfoJSON(String infoCol) {
        InfoFieldMeta defaultMeta = new InfoFieldMeta();
        defaultMeta.id = "not_defined";
        defaultMeta.number = 1;
        defaultMeta.type = INFO_TYPE.String;
        JsonObject info = new JsonObject();
        for (String field : infoCol.split(";")) {
            if (field.indexOf(61) != -1) {
                int firstEq = field.indexOf(61);
                String id = field.substring(0, firstEq);
                String value = field.substring(firstEq + 1);
                InfoFieldMeta meta = defaultMeta;
                if (this.mFieldMap.containsKey(id)) {
                    meta = this.mFieldMap.get(id);
                }
                if (meta.number == null || meta.number > 1) {
                    JsonArray arr = new JsonArray();
                    block11: for (String s : value.split(",")) {
                        switch (meta.type) {
                            case Integer: {
                                if (this.isMissingValue(s)) continue block11;
                                arr.add((JsonElement)new JsonPrimitive((Number)Integer.parseInt(s.trim())));
                                continue block11;
                            }
                            case Float: {
                                if (this.isMissingValue(s)) continue block11;
                                arr.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(Float.parseFloat(s.trim()))));
                                continue block11;
                            }
                            case Character: 
                            case String: {
                                arr.add((JsonElement)new JsonPrimitive(s));
                            }
                        }
                    }
                    if (arr.size() <= 0) continue;
                    info.add(id, (JsonElement)arr);
                    continue;
                }
                if (meta.number != 1) continue;
                switch (meta.type) {
                    case Integer: {
                        if (this.isMissingValue(value)) break;
                        info.addProperty(id, (Number)Integer.parseInt(value.trim()));
                        break;
                    }
                    case Float: {
                        if (this.isMissingValue(value)) break;
                        info.addProperty(id, (Number)Float.valueOf(Float.parseFloat(value.trim())));
                        break;
                    }
                    case Character: 
                    case String: {
                        info.addProperty(id, value);
                    }
                }
                continue;
            }
            if (field.length() <= 0) continue;
            info.addProperty(field, Boolean.valueOf(true));
        }
        return info;
    }

    private void addCoreAttributes(JsonObject root, List<String> history) {
        String accID = history.get(2).trim();
        root.addProperty(CoreAttributes._id.toString(), accID);
        root.addProperty(CoreAttributes._type.toString(), Type.VARIANT.toString());
        String chr = GenomicObjectUtils.computechr(history.get(0).trim());
        root.addProperty(CoreAttributes._landmark.toString(), chr);
        String refAllele = history.get(3).trim();
        root.addProperty(CoreAttributes._refAllele.toString(), refAllele);
        JsonArray altAlleles = new JsonArray();
        for (String allele : this.al(history.get(4).trim())) {
            altAlleles.add((JsonElement)new JsonPrimitive(allele));
        }
        root.add(CoreAttributes._altAlleles.toString(), (JsonElement)altAlleles);
        if (history.get(1) != null) {
            String pos = history.get(1).trim();
            int minBP = new Integer(pos);
            int maxBP = new Integer(minBP + history.get(3).trim().length() - 1);
            root.addProperty(CoreAttributes._minBP.toString(), (Number)minBP);
            root.addProperty(CoreAttributes._maxBP.toString(), (Number)maxBP);
        }
    }

    private String[] al(String raw) {
        ArrayList<String> finalList = new ArrayList<String>();
        if (raw.contains(",")) {
            String[] split = raw.split(",");
            for (int i = 0; i < split.length; ++i) {
                finalList.add(split[i]);
            }
        } else {
            finalList.add(raw);
        }
        return finalList.toArray(new String[0]);
    }

    private boolean isMissingValue(String value) {
        String trimVal = value.trim();
        return trimVal.equals(".");
    }

    private void addSamples(JsonObject root, List<String> history) throws ParseException {
        String[] tokens;
        if (this.firstSample) {
            String format = History.getMetaData().getColumns().get(8).getColumnName();
            if (!format.contains("FORMAT")) {
                return;
            }
            this.firstSample = false;
        }
        for (String tok : tokens = history.get(8).split(":")) {
            this.formatKeys.put(tok, true);
        }
        JsonArray samples = new JsonArray();
        for (int i = 9; i < history.size(); ++i) {
            String col = History.getMetaData().getColumns().get(i).getColumnName();
            this.parseSample(history.get(i), samples, col, tokens);
            this.sampleKeys.put(col, i + 1);
        }
        root.add("samples", (JsonElement)samples);
    }

    private int findGT(String[] t) {
        return this.findT(t, "GT");
    }

    private int findPL(String[] t) {
        return this.findT(t, "PL");
    }

    private int findAD(String[] t) {
        return this.findT(t, "AD");
    }

    private int findT(String[] t, String tok) {
        for (int i = 0; i < t.length; ++i) {
            if (!t[i].equalsIgnoreCase(tok)) continue;
            return i;
        }
        return -1;
    }

    public boolean sampleHasVariant(String genotype) {
        String s1 = genotype.replaceAll("\\.", "");
        String s2 = s1.replaceAll("0", "");
        String s3 = s2.replaceAll("\\|", "");
        String s4 = s3.replaceAll("/", "");
        return s4.length() > 0;
    }

    public static boolean isNumeric(String str) {
        return str.matches("-?\\d+(\\.\\d+)?");
    }

    public void parseSample(String sampleID, JsonArray samples, String sampleName, String[] tokens) throws ParseException {
        String[] split = sampleID.split(":");
        if (split.length > tokens.length) {
            throw new ParseException("VCF2VariantPipe.parseSample: the number of tokens in the format field (" + tokens.length + ") and the number of tokens in the sample (" + split.length + ") do not agree. \nFORMAT:" + Arrays.toString(tokens) + "\nSAMPLE: " + sampleID + "\n", 0);
        }
        int GTPosition = this.findGT(tokens);
        JsonObject genotype = new JsonObject();
        for (int i = 0; i < split.length; ++i) {
            if (split[i].contains(",")) {
                String[] arr = split[i].split(",");
                JsonArray jarr = new JsonArray();
                ArrayList<Double> values = new ArrayList<Double>();
                for (int j = 0; j < arr.length; ++j) {
                    if (VCF2VariantPipe.isNumeric(arr[j])) {
                        double d = Double.parseDouble(arr[j].trim());
                        jarr.add((JsonElement)new JsonPrimitive((Number)d));
                        values.add(d);
                        continue;
                    }
                    jarr.add((JsonElement)new JsonPrimitive(arr[j]));
                }
                genotype.add(tokens[i], (JsonElement)jarr);
                if (tokens[i].equals("PL")) {
                    genotype = this.addMaxMinPL(genotype, values);
                }
                if (!tokens[i].equals("AD")) continue;
                genotype = this.addMinMaxAD(genotype, values);
                continue;
            }
            if (VCF2VariantPipe.isNumeric(split[i])) {
                genotype.addProperty(tokens[i], (Number)Double.parseDouble(split[i]));
                continue;
            }
            genotype.addProperty(tokens[i], split[i]);
        }
        if (GTPosition > -1 && this.sampleHasVariant(split[GTPosition])) {
            genotype.addProperty("GenotypePositive", (Number)1);
        }
        genotype.addProperty("sampleID", sampleName);
        samples.add((JsonElement)genotype);
    }

    public JsonObject addMaxMinPL(JsonObject genotype, ArrayList<Double> values) {
        double minPL = Double.MAX_VALUE;
        double maxPL = -1.7976931348623157E308;
        for (int i = 0; i < values.size(); ++i) {
            Double d = values.get(i);
            if (d > maxPL) {
                maxPL = d;
            }
            if (!(d < minPL)) continue;
            minPL = d;
        }
        genotype.addProperty("maxPL", (Number)maxPL);
        genotype.addProperty("minPL", (Number)minPL);
        return genotype;
    }

    public JsonObject addMinMaxAD(JsonObject genotype, ArrayList<Double> values) {
        double maxAD = -1.7976931348623157E308;
        double minAD = Double.MAX_VALUE;
        for (int i = 1; i < values.size(); ++i) {
            Double d = values.get(i);
            if (d > maxAD) {
                maxAD = d;
            }
            if (!(d < minAD)) continue;
            minAD = d;
        }
        genotype.addProperty("maxAD", (Number)maxAD);
        genotype.addProperty("minAD", (Number)minAD);
        return genotype;
    }

    public Map<String, InfoFieldMeta> getmFieldMap() {
        return this.mFieldMap;
    }

    public HashMap<String, Integer> getSampleKeys() {
        return this.sampleKeys;
    }

    public HashMap<String, Boolean> getFormatKeys() {
        return this.formatKeys;
    }

    public JsonObject getJSONMetadata() {
        JsonObject json = new JsonObject();
        JsonObject info = new JsonObject();
        JsonObject format = new JsonObject();
        JsonObject samples = new JsonObject();
        for (String key : this.mFieldMap.keySet()) {
            InfoFieldMeta value = this.mFieldMap.get(key);
            JsonObject meta = new JsonObject();
            meta.addProperty("number", (Number)value.number);
            meta.addProperty("type", value.type.toString());
            meta.addProperty("Description", value.desc);
            info.add(key, (JsonElement)meta);
        }
        for (String key : this.formatKeys.keySet()) {
            format.addProperty(key, (Number)1);
        }
        for (String key : this.sampleKeys.keySet()) {
            samples.addProperty(key, (Number)this.sampleKeys.get(key));
        }
        json.add("INFO", (JsonElement)info);
        json.add("FORMAT", (JsonElement)format);
        json.add("SAMPLES", (JsonElement)samples);
        return json;
    }

    class InfoFieldMeta {
        String id;
        String desc;
        Integer number;
        INFO_TYPE type;

        InfoFieldMeta() {
        }
    }

    private static enum INFO_TYPE {
        Integer,
        Float,
        Flag,
        Character,
        String;


        public static INFO_TYPE fromString(String s) {
            if (s.equals(Integer.toString())) {
                return Integer;
            }
            if (s.equals(Float.toString())) {
                return Float;
            }
            if (s.equals(Flag.toString())) {
                return Flag;
            }
            if (s.equals(Character.toString())) {
                return Character;
            }
            if (s.equals(String.toString())) {
                return String;
            }
            throw new RuntimeException("Invalid VCF 4.0 type: " + s);
        }
    }
}

