/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.bioinformatics.tools;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.pipes.SplitPipe;
import edu.mayo.pipes.UNIX.CatPipe;
import edu.mayo.pipes.util.ProcessHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;

public class ToolPipe
extends AbstractPipe<List<String>, List<String>> {
    protected String command = "perl variant_effect_predictor.pl --offline --config config.txt -i example.vcf ";
    protected String tempDir = "/tmp/";
    protected String inputFileFlag = "-i";
    protected String outputFileFlag = "-o";
    protected String outfile = "";
    protected String inputfile = "";
    protected int maxbuffer = 10;
    protected LinkedList<List<String>> outqueue = new LinkedList();
    Pipe loadoutput = new Pipeline(new Pipe[]{new CatPipe(), new SplitPipe("\t")});

    public ToolPipe(String tempdir) {
        this.tempDir = tempdir;
        this.inputfile = this.getUniqueFileName(".in");
        this.outfile = this.getUniqueFileName(".out");
    }

    public String getUniqueFileName(String suffix) {
        UUID idOne = UUID.randomUUID();
        String filename = this.tempDir + idOne.toString() + suffix;
        System.out.println(filename);
        return filename;
    }

    public void makeInputFile() throws IOException {
        FileWriter fstream = new FileWriter(this.inputfile, false);
        BufferedWriter f = new BufferedWriter(fstream);
        for (int i = 0; i < this.maxbuffer && this.starts.hasNext(); ++i) {
            List next = (List)this.starts.next();
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < next.size(); ++j) {
                if (j > 0 && j < next.size()) {
                    sb.append("\t");
                }
                sb.append((String)next.get(j));
            }
            sb.append("\n");
            f.write(sb.toString());
        }
        f.close();
    }

    public void close() {
        try {
            File f1 = new File(this.outfile);
            f1.delete();
            File f2 = new File(this.inputfile);
            f2.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exec(String cmd, StringBuffer stdout, StringBuffer stderr) throws IOException, InterruptedException {
        System.out.println("Running Command: " + cmd);
        ProcessHandler.runCommand(cmd, stdout, stderr);
    }

    public void exec(String cmd) throws IOException, InterruptedException {
        ProcessHandler.runCommand(cmd);
    }

    public LinkedList loadfile(String filename) {
        this.loadoutput.reset();
        this.loadoutput.setStarts(Arrays.asList(filename));
        while (this.loadoutput.hasNext()) {
            this.outqueue.add((List)this.loadoutput.next());
        }
        return this.outqueue;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getInputFileFlag() {
        return this.inputFileFlag;
    }

    public void setInputFileFlag(String inputFileFlag) {
        this.inputFileFlag = inputFileFlag;
    }

    public String getInputfile() {
        return this.inputfile;
    }

    public void setInputfile(String inputfile) {
        this.inputfile = inputfile;
    }

    public Pipe getLoadoutput() {
        return this.loadoutput;
    }

    public void setLoadoutput(Pipe loadoutput) {
        this.loadoutput = loadoutput;
    }

    public int getMaxbuffer() {
        return this.maxbuffer;
    }

    public void setMaxbuffer(int maxbuffer) {
        this.maxbuffer = maxbuffer;
    }

    public String getOutfile() {
        return this.outfile;
    }

    public void setOutfile(String outfile) {
        this.outfile = outfile;
    }

    public String getOutputFileFlag() {
        return this.outputFileFlag;
    }

    public void setOutputFileFlag(String outputFileFlag) {
        this.outputFileFlag = outputFileFlag;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    protected List<String> processNextStart() throws NoSuchElementException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

