/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Random;
import org.apache.log4j.Logger;

public class ProcessHandler {
    private static Long pid = null;
    private static Logger sLogger = Logger.getLogger(ProcessHandler.class);

    public static int runCommand(String command) throws IOException, InterruptedException {
        return ProcessHandler.runCommand(command, null, null);
    }

    public static int runCommand(String command, StringBuffer stdOut) throws IOException, InterruptedException {
        return ProcessHandler.runCommand(command, stdOut, null);
    }

    public static int runCommand(String command, StringBuffer stdOut, StringBuffer stdErr) throws IOException, InterruptedException {
        return ProcessHandler.runCommand((Object)command, stdOut, stdErr);
    }

    public static int runCommand(String[] command) throws IOException, InterruptedException {
        return ProcessHandler.runCommand(command, null, null);
    }

    public static int runCommand(String[] command, StringBuffer stdOut) throws IOException, InterruptedException {
        return ProcessHandler.runCommand(command, stdOut, null);
    }

    public static int runCommand(String[] command, StringBuffer stdOut, StringBuffer stdErr) throws IOException, InterruptedException {
        return ProcessHandler.runCommand((Object)command, stdOut, stdErr);
    }

    private static int runCommand(Object command, StringBuffer stdOut, StringBuffer stdErr) throws IOException, InterruptedException {
        Process proc = null;
        if (stdOut == null) {
            stdOut = new StringBuffer();
        }
        if (stdErr == null) {
            stdErr = new StringBuffer();
        }
        try {
            int retVal;
            if (command instanceof String) {
                proc = Runtime.getRuntime().exec((String)command);
            } else if (command instanceof String[]) {
                proc = Runtime.getRuntime().exec((String[])command);
            }
            InputStream is = proc.getInputStream();
            StreamGobbler stdOutThread = new StreamGobbler(is, stdOut);
            stdOutThread.start();
            InputStream es = proc.getErrorStream();
            StreamGobbler stdErrThread = new StreamGobbler(es, stdErr);
            stdErrThread.start();
            stdOutThread.join();
            stdErrThread.join();
            int n = retVal = proc.waitFor();
            return n;
        }
        catch (RuntimeException re) {
            sLogger.error((Object)("runCommand failed on command " + command), (Throwable)re);
            throw re;
        }
        catch (IOException ioe) {
            sLogger.error((Object)("runCommand failed on command " + command), (Throwable)ioe);
            throw ioe;
        }
        catch (InterruptedException ie) {
            sLogger.error((Object)("runCommand failed on command " + command), (Throwable)ie);
            throw ie;
        }
        finally {
            if (proc != null) {
                try {
                    proc.getOutputStream().close();
                    proc.getInputStream().close();
                    proc.getErrorStream().close();
                    proc.destroy();
                }
                catch (IOException ioe) {
                    sLogger.error((Object)"Error closing process streams", (Throwable)ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getPid() {
        if (pid == null) {
            Process p = null;
            try {
                String[] cmd = new String[]{"/bin/bash", "-c", "echo $PPID"};
                p = Runtime.getRuntime().exec(cmd);
                InputStreamReader isr = new InputStreamReader(p.getInputStream());
                BufferedReader br = new BufferedReader(isr);
                pid = new Long(br.readLine());
            }
            catch (Exception ire) {
            }
            finally {
                if (p != null) {
                    try {
                        p.getOutputStream().close();
                        p.getInputStream().close();
                        p.getErrorStream().close();
                        p.destroy();
                    }
                    catch (IOException ioe) {
                        sLogger.error((Object)"Error closing process streams.", (Throwable)ioe);
                    }
                }
            }
            if (pid == null) {
                Random generator = new Random();
                pid = new Long(generator.nextLong());
                sLogger.error((Object)("Error trying to get PID.  Using random number (" + pid + ") instead."));
            }
        }
        return pid;
    }

    public static String readline(StringBuffer sb) {
        if (sb.length() < 1) {
            return null;
        }
        int pos = sb.indexOf("\n");
        if (pos <= 0) {
            return null;
        }
        String line = sb.substring(0, pos);
        sb.delete(0, pos + 1);
        return line;
    }

    private static class StreamGobbler
    extends Thread {
        InputStream is;
        StringBuffer buffer;

        public StreamGobbler(InputStream is, StringBuffer buffer) {
            this.is = is;
            this.buffer = buffer;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    this.buffer.append(line + "\n");
                }
                br.close();
                Object var2_3 = null;
            }
            catch (IOException ioe) {
                sLogger.error((Object)"Problem reading stdout or stdin from process.", (Throwable)ioe);
            }
        }
    }
}

