/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.util.exec;

import edu.mayo.pipes.util.exec.BaseCommandProcess;
import edu.mayo.pipes.util.exec.ProcessOutput;
import edu.mayo.pipes.util.exec.StreamGobbler;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class StreamingCommandProcess
extends BaseCommandProcess {
    private static final Logger sLogger = Logger.getLogger(StreamingCommandProcess.class);
    private Process mProcess;
    private Thread mStderrThread;
    private StreamGobbler mStderrGobbler;
    private Thread mStdoutThread;
    private StreamGobbler mStdoutGobbler;
    private PrintWriter mStdinWriter;

    public StreamingCommandProcess(String command, String[] commandArgs, Map<String, String> customEnv, boolean useParentEnv) {
        super(command, commandArgs, customEnv, useParentEnv);
    }

    public void start() throws IOException {
        this.mProcess = Runtime.getRuntime().exec(this.mCmdArray, this.mEnvironment);
        this.mStdinWriter = new PrintWriter(new OutputStreamWriter(this.mProcess.getOutputStream()));
        this.mStdoutGobbler = new StreamGobbler(this.mProcess.getInputStream());
        this.mStdoutThread = new Thread(this.mStdoutGobbler);
        this.mStdoutThread.start();
        sLogger.debug((Object)String.format("%s will consume STDOUT", this.mStdoutThread.getName()));
        this.mStderrGobbler = new StreamGobbler(this.mProcess.getErrorStream());
        this.mStderrThread = new Thread(this.mStderrGobbler);
        this.mStderrThread.start();
        sLogger.debug((Object)String.format("%s will consume STDERR", this.mStderrThread.getName()));
    }

    public void send(List<String> dataLines) {
        for (String line : dataLines) {
            this.mStdinWriter.println(line);
            this.mStdinWriter.flush();
        }
    }

    public List<String> receive() throws IOException {
        sLogger.debug((Object)String.format("Getting gobbled data.", new Object[0]));
        return this.mStdoutGobbler.getData();
    }

    public ProcessOutput close() throws InterruptedException, UnsupportedEncodingException {
        sLogger.debug((Object)"Closing stream to STDIN for child process.");
        this.mStdinWriter.close();
        int exitCode = this.mProcess.waitFor();
        sLogger.debug((Object)String.format("Process done with exit code %s", exitCode));
        sLogger.debug((Object)"Waiting for STDOUT and STDOUT gobbler threads to complete.");
        this.mStderrThread.join();
        this.mStdoutThread.join();
        StringBuilder sb = new StringBuilder();
        for (String line : this.mStderrGobbler.getData()) {
            sb.append(line);
            sb.append(System.getProperty("line.separator"));
        }
        String stderr = sb.toString();
        ProcessOutput output = new ProcessOutput();
        output.exitCode = exitCode;
        output.stderr = stderr;
        return output;
    }
}

