/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.JSON.lookup;

import com.tinkerpop.pipes.AbstractPipe;
import com.tinkerpop.pipes.Pipe;
import edu.mayo.pipes.JSON.lookup.lookupUtils.IndexUtils;
import edu.mayo.pipes.bioinformatics.vocab.ComparableObjectInterface;
import edu.mayo.pipes.exceptions.InvalidPipeInputException;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.util.index.FindIndex;
import edu.mayo.pipes.util.index.H2Connection;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LookupPipe
extends AbstractPipe<History, History> {
    private IndexUtils mUtils = new IndexUtils();
    private Connection mDbConn;
    protected History mHistory = null;
    protected int mQcount;
    protected boolean mIsFirst = true;
    protected ComparableObjectInterface mComparableObject;
    protected int mHistoryPos = -1;
    private File mBgzipFile;
    private int mJsonpos = 3;
    private FindIndex mFindIndex;
    private boolean mIsKeyAnInteger = false;
    private LinkedList<Long> mPosqueue = new LinkedList();
    private int drillColumn = -1;

    public LookupPipe(String catalogFile, String indexFile) {
        this(catalogFile, indexFile, -1, false);
    }

    public LookupPipe(String catalogFile, String indexFile, int drillColumn) {
        this(catalogFile, indexFile, drillColumn, false);
    }

    public LookupPipe(String catalogFile, String indexFile, int drillColumn, boolean isKeyCaseSensitive) {
        this.mBgzipFile = new File(catalogFile);
        H2Connection h2DbConn = new H2Connection(indexFile, false);
        this.mDbConn = h2DbConn.getConn();
        this.mUtils = new IndexUtils(this.mBgzipFile);
        this.mIsKeyAnInteger = IndexUtils.isKeyAnInteger(this.mDbConn);
        this.mFindIndex = new FindIndex(this.mDbConn, isKeyCaseSensitive);
        this.drillColumn = drillColumn;
    }

    public List<String> getIDs(List<History> hs, int col) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < hs.size(); ++i) {
            History h = hs.get(i);
            ids.add((String)h.get(col));
        }
        return ids;
    }

    protected void setup() {
        if (this.mIsFirst) {
            this.mIsFirst = false;
            this.mHistory = (History)this.starts.next();
            if (this.drillColumn > 0) {
                int size = this.mHistory.size();
                this.drillColumn = this.drillColumn - this.mHistory.size() - 1;
            } else if (this.drillColumn == 0) {
                throw new InvalidPipeInputException("Invalid Column input", (Pipe)this);
            }
            if (this.mHistory.size() == 1) {
                this.drillColumn = -1;
            }
            this.mQcount = 0;
            String id = (String)this.mHistory.get(this.mHistory.size() + this.drillColumn);
            if (this.validateIdToFind(id)) {
                try {
                    this.mPosqueue = this.mFindIndex.find(id);
                }
                catch (SQLException ex) {
                    Logger.getLogger((String)LookupPipe.class.getName()).log((Priority)Level.ERROR, null, (Throwable)ex);
                }
            }
            List<ColumnMetaData> cols = History.getMetaData().getColumns();
            ColumnMetaData cmd = new ColumnMetaData(((Object)((Object)this)).getClass().getSimpleName());
            cols.add(cmd);
        }
    }

    public History processNextStart() throws NoSuchElementException {
        this.setup();
        while (true) {
            if (this.mPosqueue.size() > 0) {
                ++this.mQcount;
                Long next = this.mPosqueue.poll();
                String json = "{}";
                try {
                    String line = this.mUtils.getBgzipLineByPosition(next);
                    if (line.length() > 2) {
                        String[] split = line.split("\t");
                        json = split[this.mJsonpos];
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger((String)LookupPipe.class.getName()).log((Priority)Level.ERROR, null, (Throwable)ex);
                }
                return this.copyAppend(this.mHistory, json);
            }
            if (this.mQcount == 0) {
                ++this.mQcount;
                return this.copyAppend(this.mHistory, "{}");
            }
            this.mHistory = (History)this.starts.next();
            this.mPosqueue = new LinkedList();
            String id = (String)this.mHistory.get(this.mHistory.size() + this.drillColumn);
            if (this.validateIdToFind(id)) {
                try {
                    this.mPosqueue = this.mFindIndex.find(id);
                }
                catch (SQLException ex) {
                    Logger.getLogger((String)LookupPipe.class.getName()).log((Priority)Level.ERROR, null, (Throwable)ex);
                }
            }
            this.mQcount = 0;
        }
    }

    private boolean validateIdToFind(String idToFind) {
        boolean result = false;
        if (idToFind != null && !idToFind.equals(".") && !idToFind.equals("")) {
            result = true;
        }
        return result;
    }

    protected History copyAppend(History history, String result) {
        History clone = (History)history.clone();
        clone.add(result);
        return clone;
    }

    public int getJsonpos() {
        return this.mJsonpos;
    }

    public void setJsonpos(int jsonpos) {
        this.mJsonpos = jsonpos;
    }
}

