/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.util;

import edu.mayo.pipes.bioinformatics.vocab.Undefined;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GenomicObjectUtils {
    public static final String DELIMTOKEN = ";#__#;";

    public static char getStrand(String s) {
        if (s.contains("+")) {
            return '+';
        }
        if (s.contains("-")) {
            return '-';
        }
        return '.';
    }

    public static String stringifyList(List<String> l) {
        Collections.sort(l);
        StringBuilder sb = new StringBuilder();
        for (String ele : l) {
            sb.append(ele);
            sb.append(DELIMTOKEN);
        }
        return sb.toString();
    }

    public static List<String> listifyString(String s) {
        return Arrays.asList(s.split(DELIMTOKEN));
    }

    public static char computeStrandFromNumbers(int strand) {
        return GenomicObjectUtils.computeStrandFromNumbers(new Integer(strand));
    }

    public static char computeStrandFromNumbers(String strand) {
        if (strand.equalsIgnoreCase("-1")) {
            return '-';
        }
        if (strand.equalsIgnoreCase("-1")) {
            return '+';
        }
        return '.';
    }

    public static String computechr(String raw) {
        if (raw.contains("X") || raw.contains("x") || raw.contains("23")) {
            return "X";
        }
        if (raw.contains("Y") || raw.contains("y") || raw.contains("24")) {
            return "Y";
        }
        if (raw.contains("M") || raw.contains("m") || raw.contains("25")) {
            return "M";
        }
        if (raw.contains("22")) {
            return "22";
        }
        if (raw.contains("21")) {
            return "21";
        }
        if (raw.contains("20")) {
            return "20";
        }
        if (raw.contains("19")) {
            return "19";
        }
        if (raw.contains("18")) {
            return "18";
        }
        if (raw.contains("17")) {
            return "17";
        }
        if (raw.contains("16")) {
            return "16";
        }
        if (raw.contains("15")) {
            return "15";
        }
        if (raw.contains("14")) {
            return "14";
        }
        if (raw.contains("13")) {
            return "13";
        }
        if (raw.contains("12")) {
            return "12";
        }
        if (raw.contains("11")) {
            return "11";
        }
        if (raw.contains("10")) {
            return "10";
        }
        if (raw.contains("9")) {
            return "9";
        }
        if (raw.contains("8")) {
            return "8";
        }
        if (raw.contains("7")) {
            return "7";
        }
        if (raw.contains("6")) {
            return "6";
        }
        if (raw.contains("5")) {
            return "5";
        }
        if (raw.contains("4")) {
            return "4";
        }
        if (raw.contains("3")) {
            return "3";
        }
        if (raw.contains("2")) {
            return "2";
        }
        if (raw.contains("1")) {
            return "1";
        }
        return Undefined.UNKNOWN.toString();
    }
}

