/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.bioinformatics.sequence;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.JSON.tabix.TabixReader;
import edu.mayo.pipes.JSON.tabix.TabixSearchPipe;
import edu.mayo.pipes.bioinformatics.vocab.CoreAttributes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class Bed2SequencePipe
extends AbstractPipe<ArrayList<String>, ArrayList<String>> {
    TabixSearchPipe mTabixSearch;
    private int mMaxBpCol = 0;
    private boolean mIsUseJsonCol = false;
    private JsonPath mChromJsonPath;
    private JsonPath mMinBpJsonPath;
    private JsonPath mMaxBpJsonPath;
    int start = 0;
    int end = 0;
    String result = "";
    TabixReader.Iterator records;

    public Bed2SequencePipe(String tabixDataFile) throws IOException {
        this.mTabixSearch = new TabixSearchPipe(tabixDataFile);
    }

    public Bed2SequencePipe(String tabixDataFile, int column) throws IOException {
        this.mTabixSearch = new TabixSearchPipe(tabixDataFile);
        this.mMaxBpCol = column;
    }

    public Bed2SequencePipe(String tabixDataFile, boolean isUseJson) throws IOException {
        this.mTabixSearch = new TabixSearchPipe(tabixDataFile);
        this.mMaxBpCol = 0;
        this.mIsUseJsonCol = isUseJson;
        this.mChromJsonPath = JsonPath.compile((String)CoreAttributes._landmark.toString(), (Filter[])new Filter[0]);
        this.mMinBpJsonPath = JsonPath.compile((String)CoreAttributes._minBP.toString(), (Filter[])new Filter[0]);
        this.mMaxBpJsonPath = JsonPath.compile((String)CoreAttributes._maxBP.toString(), (Filter[])new Filter[0]);
    }

    public ArrayList<String> processNextStart() throws NoSuchElementException {
        try {
            ArrayList history = (ArrayList)this.starts.next();
            String tabixQuery = this.getTabixQueryString(history);
            String subsequence = this.getSequence(tabixQuery);
            history.add(subsequence);
            return history;
        }
        catch (IOException ex) {
            throw new NoSuchElementException();
        }
    }

    private String getSequence(String tabixQuery) throws NumberFormatException, IOException {
        StringBuilder subsequence = new StringBuilder();
        this.records = this.mTabixSearch.tquery(tabixQuery);
        if (this.records == null) {
            return ".";
        }
        String rec = null;
        boolean isFirst = true;
        int seqEndPos = 0;
        while ((rec = this.records.next()) != null) {
            String[] split = rec.split("\t");
            String seq = split[3];
            if (isFirst) {
                int numToTrimOffFront = this.getMin(tabixQuery) - Integer.parseInt(split[1]);
                seq = seq.substring(numToTrimOffFront);
                isFirst = false;
            }
            subsequence.append(seq);
            seqEndPos = Integer.parseInt(split[2]);
        }
        int numToTrimOffEnd = seqEndPos - this.getMax(tabixQuery);
        return subsequence.substring(0, subsequence.length() - numToTrimOffEnd);
    }

    private String getTabixQueryString(ArrayList<String> history) {
        String query = "";
        if (this.mIsUseJsonCol) {
            String lastCol = history.get(history.size() - 1);
            String chr = (String)this.mChromJsonPath.read(lastCol);
            int min = (Integer)this.mMinBpJsonPath.read(lastCol);
            int max = (Integer)this.mMaxBpJsonPath.read(lastCol);
            query = chr + ":" + min + "-" + max;
        } else {
            String chr = history.get(history.size() - 3 + this.mMaxBpCol);
            String min = history.get(history.size() - 2 + this.mMaxBpCol);
            String max = history.get(history.size() - 1 + this.mMaxBpCol);
            query = chr + ":" + min + "-" + max;
        }
        return query;
    }

    private int getMin(String query) {
        return Integer.parseInt(query.substring(query.indexOf(":") + 1, query.indexOf("-")));
    }

    private int getMax(String query) {
        return Integer.parseInt(query.substring(query.indexOf("-") + 1));
    }
}

