/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.cli.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="build_scripts", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class BuildScriptsPlugin
extends AbstractMojo {
    @Parameter(required=true)
    private String envHomeVariable;
    @Parameter(defaultValue="6")
    private Integer minorJavaVersion;
    @Parameter
    private String jvmOpts;
    @Parameter(defaultValue="src/main/resources/cli")
    private File cmdPropsDir;
    @Parameter(defaultValue="/build/template.sh")
    private String classpathToScriptTemplate;
    @Parameter(required=true, defaultValue="${project.build.directory}/scripts")
    private File scriptsOutputDir;
    @Parameter(required=true, defaultValue="${basedir}/src/main/scripts")
    private File customScriptsDir;
    @Parameter
    private String preJvm;
    @Parameter
    private String postJvm;

    public void execute() throws MojoExecutionException {
        this.buildScripts();
    }

    private void buildScripts() throws MojoExecutionException {
        InputStream inStream = BuildScriptsPlugin.class.getResourceAsStream(this.classpathToScriptTemplate);
        if (inStream == null) {
            throw new MojoExecutionException(String.format("Can't locate script template on classpath: %s", this.classpathToScriptTemplate));
        }
        if (!this.scriptsOutputDir.exists()) {
            this.getLog().info((CharSequence)String.format("Making script output directory: %s", this.scriptsOutputDir));
            this.scriptsOutputDir.mkdirs();
        }
        try {
            String template = IOUtils.toString((InputStream)inStream);
            for (File propFile : this.getCommandPropertyFiles(this.cmdPropsDir)) {
                this.buildScript(propFile, template);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void buildScript(File cmdPropFile, String cmdTemplate) throws FileNotFoundException, IOException {
        File customScript;
        Properties props = new Properties();
        props.load(new FileReader(cmdPropFile));
        String commandClass = props.getProperty("command.class");
        String commandName = props.getProperty("command.name");
        if (this.customScriptsDir.exists() && (customScript = new File(this.customScriptsDir, commandName)).exists()) {
            this.getLog().info((CharSequence)String.format("Detected a custom script %s", customScript.getAbsoluteFile()));
            this.getLog().info((CharSequence)String.format("Script %s will not be generated.", commandName));
            return;
        }
        String scriptContent = new String(cmdTemplate);
        scriptContent = scriptContent.replace("${command.class}", commandClass);
        scriptContent = scriptContent.replace("${home.env.var}", this.envHomeVariable);
        scriptContent = scriptContent.replace("${java.minor.version}", this.minorJavaVersion.toString());
        scriptContent = scriptContent.replace("${jvm.opts}", this.getPropertyValue(props, "jvm.opts", this.jvmOpts));
        scriptContent = scriptContent.replace("${pre.jvm}", this.getPropertyValue(props, "pre.jvm", this.preJvm));
        scriptContent = scriptContent.replace("${post.jvm}", this.getPropertyValue(props, "post.jvm", this.postJvm));
        File script = new File(this.scriptsOutputDir, commandName);
        FileUtils.write((File)script, (CharSequence)scriptContent);
        script.setExecutable(true, false);
        this.getLog().info((CharSequence)String.format("Built script %s", script.getAbsolutePath()));
    }

    private String getPropertyValue(Properties cmdProps, String cmdPropName, String globalDefault) {
        String value = "";
        if (cmdProps.containsKey(cmdPropName)) {
            value = cmdProps.getProperty(cmdPropName);
        } else if (globalDefault != null) {
            value = globalDefault;
        }
        value = value.trim();
        return value;
    }

    private File[] getCommandPropertyFiles(File folder) throws MojoExecutionException {
        if (!folder.exists()) {
            String mesg = String.format("Invalid command properties directory: %s", folder.getAbsolutePath());
            throw new MojoExecutionException(mesg);
        }
        ArrayList<File> list = new ArrayList<File>();
        for (File f : folder.listFiles()) {
            if (!f.isFile() || !f.getName().endsWith(".properties") || f.getName().equals("Global.properties")) continue;
            list.add(f);
        }
        return list.toArray(new File[0]);
    }
}

