/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.control.BlackBox;

public class SecondOrder
extends BlackBox {
    private double aConst = 1.0;
    private double bConst = 1.0;
    private double cConst = 1.0;
    private double dConst = 1.0;
    private double omegaN = 1.0;
    private double zeta = 1.0;
    private double kConst = 1.0;
    private double sigma = 1.0;

    public SecondOrder() {
        super("SecondOrder");
        super.setSnumer(new ComplexPoly(1.0));
        super.setSdenom(new ComplexPoly(1.0, 1.0, 1.0));
        this.sNumerDeg = 0;
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public SecondOrder(double aa, double bb, double cc, double dd) {
        super("SecondOrder");
        this.aConst = aa;
        this.bConst = bb;
        this.cConst = cc;
        this.dConst = dd;
        if (this.cConst > 0.0) {
            this.standardForm();
        }
        super.setSnumer(new ComplexPoly(this.dConst));
        super.setSdenom(new ComplexPoly(this.cConst, this.bConst, this.aConst));
        super.setZtransformMethod(1);
        super.addDeadTimeExtras();
    }

    public void setCoeff(double aa, double bb, double cc, double dd) {
        this.aConst = aa;
        this.bConst = bb;
        this.cConst = cc;
        this.dConst = dd;
        if (this.cConst > 0.0) {
            this.standardForm();
        }
        Complex[] num = Complex.oneDarray(1);
        num[0].reset(this.dConst, 0.0);
        this.sNumer.resetPoly(num);
        Complex[] den = Complex.oneDarray(3);
        den[0].reset(this.cConst, 0.0);
        den[1].reset(this.bConst, 0.0);
        den[2].reset(this.aConst, 0.0);
        this.sDenom.resetPoly(den);
        this.fixedName = "Second Order Process";
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    private void standardForm() {
        this.omegaN = Math.sqrt(this.cConst / this.aConst);
        this.zeta = this.bConst / (2.0 * this.aConst * this.omegaN);
        this.kConst = this.dConst / this.cConst;
        this.sigma = this.zeta * this.omegaN;
    }

    public void setA(double aa) {
        this.aConst = aa;
        Complex co = new Complex(this.aConst, 0.0);
        this.sDenom.resetCoeff(2, co);
        if (this.cConst > 0.0) {
            this.standardForm();
        }
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setB(double bb) {
        this.bConst = bb;
        Complex co = new Complex(this.bConst, 0.0);
        this.sDenom.resetCoeff(1, co);
        if (this.cConst > 0.0) {
            this.standardForm();
        }
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setC(double cc) {
        this.cConst = cc;
        Complex co = new Complex(this.cConst, 0.0);
        this.sDenom.resetCoeff(0, co);
        if (this.cConst > 0.0) {
            this.standardForm();
        }
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setD(double dd) {
        this.dConst = dd;
        Complex co = new Complex(this.dConst, 0.0);
        this.sNumer.resetCoeff(0, co);
        if (this.cConst > 0.0) {
            this.standardForm();
        }
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setStandardForm(double zet, double omega, double kk) {
        if (omega <= 0.0) {
            throw new IllegalArgumentException("zero or negative natural frequency");
        }
        if (zet < 0.0) {
            throw new IllegalArgumentException("negative damping ratio");
        }
        this.zeta = zet;
        this.omegaN = omega;
        this.kConst = kk;
        this.sigma = this.omegaN * this.zeta;
        this.reverseStandard();
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setZeta(double zet) {
        if (zet < 0.0) {
            throw new IllegalArgumentException("negative damping ratio");
        }
        this.zeta = zet;
        this.sigma = this.omegaN * this.zeta;
        this.reverseStandard();
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setOmegaN(double omega) {
        if (omega <= 0.0) {
            throw new IllegalArgumentException("zero or negative natural frequency");
        }
        this.omegaN = omega;
        this.sigma = this.omegaN * this.zeta;
        this.reverseStandard();
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    public void setK(double kk) {
        this.kConst = kk;
        this.reverseStandard();
        this.calcPolesZerosS();
        super.addDeadTimeExtras();
    }

    private void reverseStandard() {
        this.aConst = this.omegaN * this.omegaN;
        this.bConst = 2.0 * this.zeta * this.omegaN;
        this.cConst = 1.0;
        this.dConst = this.kConst * this.aConst;
        Complex[] num = Complex.oneDarray(1);
        num[0].reset(this.dConst, 0.0);
        this.sNumer.resetPoly(num);
        Complex[] den = Complex.oneDarray(3);
        den[0].reset(this.cConst, 0.0);
        den[1].reset(this.bConst, 0.0);
        den[2].reset(this.aConst, 0.0);
        this.sDenom.resetPoly(den);
    }

    public double getA() {
        return this.aConst;
    }

    public double getB() {
        return this.bConst;
    }

    public double getC() {
        return this.cConst;
    }

    public double getD() {
        return this.dConst;
    }

    public double getOmegaN() {
        return this.omegaN;
    }

    public double getZeta() {
        return this.zeta;
    }

    public double getK() {
        return this.kConst;
    }

    public double getAttenuation() {
        return this.sigma;
    }

    @Override
    public Complex getOutputS(Complex sValue, Complex iinput) {
        this.sValue = sValue;
        this.inputS = iinput;
        return this.getOutputS();
    }

    @Override
    public Complex getOutputS() {
        Complex num = Complex.plusOne();
        num = num.times(this.dConst);
        Complex den = new Complex();
        den = this.sValue.times(this.sValue.times(this.aConst));
        den = den.plus(this.sValue.times(this.aConst));
        den = den.plus(this.cConst);
        Complex term = new Complex();
        term = num.over(den);
        this.outputS = term.times(this.inputS);
        if (this.deadTime != 0.0) {
            this.outputS = this.outputS.times(Complex.exp(this.sValue.times(-this.deadTime)));
        }
        return this.outputS;
    }

    @Override
    public void zTransform() {
        if (this.deltaT == 0.0) {
            System.out.println("z-transform attempted in SecondOrder with a zero sampling period");
        }
        if (this.ztransMethod == 0) {
            this.mapstozAdHoc();
        } else {
            Complex[] ncoef = null;
            Complex[] dcoef = null;
            double bT = this.bConst * this.deltaT;
            double t2 = this.deltaT * this.deltaT;
            double cT2 = this.cConst * t2;
            double dT2 = this.dConst * t2;
            switch (this.integMethod) {
                case 0: {
                    ncoef = Complex.oneDarray(3);
                    ncoef[0].reset(dT2 / 4.0, 0.0);
                    ncoef[1].reset(dT2 / 2.0, 0.0);
                    ncoef[2].reset(dT2 / 4.0, 0.0);
                    this.zNumer = new ComplexPoly(2);
                    this.zNumer.resetPoly(ncoef);
                    this.zNumerDeg = 2;
                    dcoef = Complex.oneDarray(3);
                    dcoef[0].reset(this.aConst - bT + cT2 / 4.0, 0.0);
                    dcoef[1].reset(-2.0 * this.aConst + bT + cT2 / 2.0, 0.0);
                    dcoef[2].reset(this.aConst + cT2 / 4.0, 0.0);
                    this.zDenom = new ComplexPoly(2);
                    this.zDenom.resetPoly(dcoef);
                    this.zDenomDeg = 2;
                    this.zZeros = this.zNumer.roots();
                    this.zPoles = this.zDenom.roots();
                    break;
                }
                case 1: {
                    ncoef = Complex.oneDarray(3);
                    ncoef[0].reset(0.0, 0.0);
                    ncoef[1].reset(0.0, 0.0);
                    ncoef[2].reset(dT2, 0.0);
                    this.zNumer = new ComplexPoly(2);
                    this.zNumer.resetPoly(ncoef);
                    this.zNumerDeg = 2;
                    dcoef = Complex.oneDarray(3);
                    dcoef[0].reset(this.aConst - bT, 0.0);
                    dcoef[1].reset(-2.0 * this.aConst, 0.0);
                    dcoef[2].reset(this.aConst + bT + cT2, 0.0);
                    this.zDenom = new ComplexPoly(2);
                    this.zDenom.resetPoly(dcoef);
                    this.zDenomDeg = 2;
                    this.zPoles = this.zDenom.roots();
                    this.zZeros = Complex.oneDarray(2);
                    this.zZeros[0].reset(0.0, 0.0);
                    this.zZeros[1].reset(0.0, 0.0);
                    break;
                }
                case 2: {
                    ncoef = Complex.oneDarray(3);
                    ncoef[0].reset(0.0, 0.0);
                    ncoef[1].reset(0.0, 0.0);
                    ncoef[2].reset(dT2, 0.0);
                    this.zNumer = new ComplexPoly(2);
                    this.zNumer.resetPoly(ncoef);
                    this.zNumerDeg = 2;
                    dcoef = Complex.oneDarray(3);
                    dcoef[0].reset(this.aConst - bT + cT2, 0.0);
                    dcoef[1].reset(-2.0 * this.aConst + bT, 0.0);
                    dcoef[2].reset(this.aConst, 0.0);
                    this.zDenom = new ComplexPoly(2);
                    this.zDenom.resetPoly(dcoef);
                    this.zDenomDeg = 2;
                    this.zPoles = this.zDenom.roots();
                    this.zZeros = Complex.oneDarray(2);
                    this.zZeros[0].reset(0.0, 0.0);
                    this.zZeros[1].reset(0.0, 0.0);
                    break;
                }
                default: {
                    System.out.println("Integration method option in SecondOrder must be 0,1 or 2");
                    System.out.println("It was set at " + this.integMethod);
                    System.out.println("z-transform not performed");
                }
            }
        }
    }

    @Override
    public void zTransform(double deltaT) {
        super.setDeltaT(deltaT);
        super.deadTimeWarning("zTransform");
        this.zTransform();
    }

    public double calcOutputT(double ttime, double inp) {
        return super.getCurrentOutputT(ttime, inp);
    }

    public double calcOutputT() {
        return super.getCurrentOutputT();
    }

    public Complex[] getSzeros() {
        System.out.println("This standard second order process (class SecondOrder) has no s-domain zeros");
        return null;
    }

    @Override
    public SecondOrder copy() {
        if (this == null) {
            return null;
        }
        SecondOrder bb = new SecondOrder();
        this.copyBBvariables(bb);
        bb.aConst = this.aConst;
        bb.bConst = this.bConst;
        bb.cConst = this.cConst;
        bb.dConst = this.dConst;
        bb.omegaN = this.omegaN;
        bb.zeta = this.zeta;
        bb.kConst = this.kConst;
        bb.sigma = this.sigma;
        return bb;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

