/*
 * Decompiled with CFR 0.152.
 */
package flanagan.control;

import flanagan.complex.Complex;
import flanagan.complex.ComplexPoly;
import flanagan.control.AtoD;
import flanagan.control.BlackBox;
import flanagan.math.Conv;

public class DtoA
extends BlackBox {
    private int nBits = 0;
    private long maximumDecimal = 0L;
    private double vRef = 0.0;
    private int[] vBinary = null;
    private boolean trueDtoA = true;
    private double outputVoltage = 0.0;
    private double voltageInput = 0.0;
    private String binaryInput = "";
    private long decimalInput = 0L;
    private boolean inputSet = false;

    public DtoA(int nBits, double vRef) {
        super("DtoA");
        super.setSnumer(new ComplexPoly(1.0));
        super.setSdenom(new ComplexPoly(1.0));
        super.setZtransformMethod(1);
        this.nBits = nBits;
        this.vBinary = new int[nBits + 1];
        this.maximumDecimal = (long)Math.pow(2.0, this.nBits) - 1L;
        this.vRef = vRef;
        this.trueDtoA = true;
    }

    public DtoA() {
        super("DtoA");
        this.trueDtoA = false;
        this.sNumerDeg = 0;
        this.sDenomDeg = 0;
        super.setSnumer(new ComplexPoly(1.0));
        super.setSdenom(new ComplexPoly(1.0));
        super.setZtransformMethod(1);
    }

    public boolean getTrueDtoAoption() {
        if (this.trueDtoA) {
            System.out.println("This instance of DtoA is a true simulation of an ADC");
            System.out.println("getTrueDtoAoption has returned 'true'");
        } else {
            System.out.println("This instance of DtoA is not a true simulation of an ADC");
            System.out.println("It is simple an 'D to A marker'");
            System.out.println("getTrueDtoAoption has returned 'false'");
        }
        return this.trueDtoA;
    }

    public void setInput(String input) {
        this.binaryInput = input.trim();
        int len = this.binaryInput.length();
        if (len > this.nBits + 1) {
            throw new IllegalArgumentException("length of input String is greater than the DAC bit number plus one");
        }
        if (len < this.nBits + 1) {
            System.out.println("Class - DtoA;  method - setInput(String)");
            System.out.println("The input String is less than DAC number of bits plus one");
            System.out.println("String assumed to represent a postive unsigned binary number");
            System.out.println("unfilled bits assigned zeros");
            for (int i = len; i < this.nBits + 1; ++i) {
                this.binaryInput = '0' + this.binaryInput;
            }
            len = this.nBits + 1;
        }
        int ii = 0;
        int jj = 0;
        int c = 32;
        for (int i = len - 1; i >= 0; --i) {
            c = this.binaryInput.charAt(i);
            if (c == 49) {
                ii = 1;
            } else if (c == 48) {
                ii = 0;
            } else {
                throw new IllegalArgumentException("String input must be '0's or '1's");
            }
            jj = len - i - 1;
            this.vBinary[jj] = ii;
        }
        long sign = 1L;
        int[] vPosBinary = Conv.copy(this.vBinary);
        if (this.vBinary[len - 1] == 1) {
            sign = -1L;
            vPosBinary = DtoA.negateNegativeBinary(vPosBinary);
        }
        this.decimalInput = DtoA.binaryToDecimal(vPosBinary);
        if (sign == -1L) {
            this.decimalInput = -this.decimalInput;
        }
        this.outputVoltage = (double)this.decimalInput * this.vRef / (double)(this.maximumDecimal + 1L);
        this.inputSet = true;
    }

    public void setInput(int[] input) {
        int i;
        int len = input.length;
        if (len > this.nBits + 1) {
            throw new IllegalArgumentException("length of input array is greater than the DAC bit number plus  one");
        }
        for (i = 0; i < len; ++i) {
            this.vBinary[i] = input[i];
        }
        if (len < this.nBits + 1) {
            System.out.println("Class - DtoA;  method - setInput(String)");
            System.out.println("The input array is less than DAC number of bits plus one");
            System.out.println("Array assumed to represent a postive unsigned binary number");
            System.out.println("unfilled bits assigned zeros");
            for (i = len; i < this.nBits + 1; ++i) {
                this.vBinary[i] = 0;
            }
            len = this.nBits + 1;
        }
        this.binaryInput = "";
        for (i = this.nBits; i >= 0; --i) {
            this.binaryInput = this.binaryInput + this.vBinary[i];
        }
        long sign = 1L;
        int[] vPosBinary = Conv.copy(this.vBinary);
        if (this.vBinary[len - 1] == 1) {
            sign = -1L;
            vPosBinary = DtoA.negateNegativeBinary(this.vBinary);
        }
        this.decimalInput = DtoA.binaryToDecimal(vPosBinary);
        if (sign == -1L) {
            this.decimalInput = -this.decimalInput;
        }
        this.outputVoltage = (double)this.decimalInput * this.vRef / (double)(this.maximumDecimal + 1L);
        this.inputSet = true;
    }

    public void setInput(long input) {
        if (Math.abs(input) > this.maximumDecimal) {
            throw new IllegalArgumentException("abs(input), " + input + ", is greater than the maximum decimal representation, " + this.maximumDecimal + ", allowed by the set number of bits, " + this.nBits);
        }
        this.decimalInput = input;
        this.outputVoltage = (double)input * this.vRef / (double)(this.maximumDecimal + 1L);
        long dec = this.decimalInput;
        int sign = 1;
        if (dec < 0L) {
            sign = -1;
            dec = -dec;
        }
        for (int i = 0; i < this.nBits + 1; ++i) {
            this.vBinary[i] = 0;
        }
        boolean test = true;
        int ii = 0;
        while (test) {
            this.vBinary[ii] = (int)(dec % 2L);
            ++ii;
            if ((dec /= 2L) != 0L) continue;
            test = false;
        }
        if ((long)sign == -1L) {
            this.vBinary = AtoD.negateBinary(this.vBinary);
        }
        this.binaryInput = "";
        for (int i = this.nBits; i >= 0; --i) {
            this.binaryInput = this.binaryInput + this.vBinary[i];
        }
        this.inputSet = true;
    }

    public void setInput(double input) {
        if (this.trueDtoA) {
            if (Math.abs(input) > this.vRef) {
                throw new IllegalArgumentException("The input voltage in this simulation of a DAC must be less than nor equal to the reference voltage\nIf you choose the constructor without an argument list, i.e. an instance of DtoA that is simply a DAC marker\nyou may imput any voltage and the output will be made equal to that voltage");
            }
            this.voltageInput = input;
            AtoD adc = new AtoD(this.nBits, this.vRef);
            adc.setInput(input);
            this.decimalInput = adc.decimalOutput();
            this.binaryInput = adc.binaryOutput();
            this.vBinary = adc.binaryArray();
        } else {
            this.outputVoltage = input;
        }
        this.sNumer.resetCoeff(0, new Complex(this.outputVoltage / this.voltageInput, 0.0));
        this.inputSet = true;
    }

    private static long binaryToDecimal(int[] binary) {
        long decimal = 0L;
        for (int i = 0; i < binary.length; ++i) {
            decimal += (long)(Math.pow(2.0, i) * (double)binary[i]);
        }
        return decimal;
    }

    private static int[] negateNegativeBinary(int[] binary) {
        int i;
        int nBin = binary.length;
        int[] negate = new int[nBin];
        int[] minusOne = new int[nBin];
        for (i = 0; i < nBin; ++i) {
            minusOne[i] = 1;
            negate[i] = 0;
        }
        negate = DtoA.addBinary(negate, minusOne);
        for (i = 0; i < nBin; ++i) {
            if (binary[i] != 0) continue;
            negate[i] = 1;
        }
        return negate;
    }

    private static int[] addBinary(int[] aa, int[] bb) {
        int n = aa.length;
        int m = bb.length;
        int lenMax = n;
        int lenMin = m;
        if (m > n) {
            lenMax = m;
            lenMin = n;
        }
        int[] addition = new int[lenMax];
        int carry = 0;
        int sum = 0;
        block6: for (int i = 0; i < lenMin; ++i) {
            sum = aa[i] + bb[i] + carry;
            switch (sum) {
                case 0: {
                    addition[i] = 0;
                    carry = 0;
                    continue block6;
                }
                case 1: {
                    addition[i] = 1;
                    carry = 0;
                    continue block6;
                }
                case 2: {
                    addition[i] = 0;
                    carry = 1;
                    continue block6;
                }
                case 3: {
                    addition[i] = 1;
                    carry = 1;
                }
            }
        }
        return addition;
    }

    public double getOutput() {
        if (!this.inputSet) {
            throw new IllegalArgumentException("No input has been entered");
        }
        return this.outputVoltage;
    }

    public long getDecimalInput() {
        if (!this.inputSet) {
            throw new IllegalArgumentException("No input has been entered");
        }
        if (!this.trueDtoA) {
            System.out.println("Class - DtoA;  method - getDecimalInput");
            System.out.println("This instance of DtoA is not a true simulation of an DAC");
            System.out.println("It is simple an 'D to A marker'");
            System.out.println("getDecimalInput has returned 0L");
            this.decimalInput = 0L;
        }
        return this.decimalInput;
    }

    public String getBinaryInput() {
        if (!this.inputSet) {
            throw new IllegalArgumentException("No input has been entered");
        }
        if (!this.trueDtoA) {
            System.out.println("Class - DtoA;  method - getBinaryInput");
            System.out.println("This instance of DtoA is not a true simulation of an DAC");
            System.out.println("It is simple an 'D to A marker'");
            System.out.println("getBinaryInput has returned null");
            this.binaryInput = null;
        }
        return this.binaryInput;
    }

    public int[] getBinaryArray() {
        if (!this.inputSet) {
            throw new IllegalArgumentException("No input has been entered");
        }
        if (!this.trueDtoA) {
            System.out.println("Class - DtoA;  method - getBinaryInput");
            System.out.println("This instance of DtoA is not a true simulation of an DAC");
            System.out.println("It is simple an 'D to A marker'");
            System.out.println("getBinaryArray has returned null");
            this.vBinary = null;
        }
        return this.vBinary;
    }

    @Override
    public DtoA copy() {
        if (this == null) {
            return null;
        }
        DtoA bb = new DtoA();
        this.copyBBvariables(bb);
        bb.nBits = this.nBits;
        bb.maximumDecimal = this.maximumDecimal;
        bb.vRef = this.vRef;
        bb.vBinary = Conv.copy(this.vBinary);
        bb.trueDtoA = this.trueDtoA;
        bb.outputVoltage = this.outputVoltage;
        bb.voltageInput = this.voltageInput;
        bb.binaryInput = this.binaryInput;
        bb.decimalInput = this.decimalInput;
        bb.inputSet = this.inputSet;
        return bb;
    }

    @Override
    public Object clone() {
        return this.copy();
    }
}

